/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom.glue;

import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueAuxiliary;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueCharacters;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueElement;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueInstruction;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.XMLAttrComparator;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.XMLBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

class GlueSerializer {
    private static final XMLAttrComparator attrComparator = new XMLAttrComparator();
    private final GlueDocument document;

    public GlueSerializer(GlueDocument document) {
        assert (document.getRootElement() != null);
        this.document = document;
    }

    public String toString() {
        XMLBuffer result = new XMLBuffer();
        result.addLineSeparator();
        result.addLineSeparator();
        Class<?> lastAuxiliaryClass = null;
        for (GlueAuxiliary auxiliary : this.document.getHeader()) {
            if (lastAuxiliaryClass != null && lastAuxiliaryClass != auxiliary.getClass()) {
                result.addLineSeparator();
            }
            this.serializeAuxiliary(auxiliary, result);
            result.addLineSeparator();
            lastAuxiliaryClass = auxiliary.getClass();
        }
        if (lastAuxiliaryClass != null) {
            result.addLineSeparator();
        }
        this.serializeElement(this.document.getRootElement(), result);
        result.addLineSeparator();
        return result.toString();
    }

    private void serializeElement(GlueElement element, XMLBuffer xmlBuffer) {
        for (GlueAuxiliary auxiliary : element.getFront()) {
            this.serializeAuxiliary(auxiliary, xmlBuffer);
        }
        xmlBuffer.beginElement(element.getTagName());
        this.serializeAttributes(element, xmlBuffer);
        if (element.getChildren().isEmpty()) {
            for (GlueAuxiliary auxiliary : element.getContent()) {
                this.serializeAuxiliary(auxiliary, xmlBuffer);
            }
        } else {
            for (GlueElement child : element.getChildren()) {
                this.serializeElement(child, xmlBuffer);
            }
            for (GlueAuxiliary auxiliary : element.getTail()) {
                this.serializeAuxiliary(auxiliary, xmlBuffer);
            }
        }
        xmlBuffer.endElement();
    }

    private void serializeAuxiliary(GlueAuxiliary auxiliary, XMLBuffer xmlBuffer) {
        if (auxiliary instanceof GlueCharacters) {
            GlueCharacters characters = (GlueCharacters)auxiliary;
            switch (characters.getType()) {
                case TEXT: {
                    xmlBuffer.addText(characters.getData());
                    break;
                }
                case COMMENT: {
                    xmlBuffer.addComment(characters.getData());
                    break;
                }
                default: {
                    assert (false);
                    {
                        break;
                    }
                }
            }
        } else {
            assert (auxiliary instanceof GlueInstruction);
            GlueInstruction instruction = (GlueInstruction)auxiliary;
            xmlBuffer.addProcessingInstruction(instruction.getTarget(), instruction.getData());
        }
    }

    private void serializeAttributes(GlueElement element, XMLBuffer xmlBuffer) {
        Map<String, String> attributes = element.getAttributes();
        ArrayList<AbstractMap.SimpleEntry<String, String>> attrNames = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attrNames.add(new AbstractMap.SimpleEntry<String, String>(entry.getKey(), entry.getValue()));
        }
        Collections.sort(attrNames, attrComparator);
        for (Map.Entry<String, String> entry : attrNames) {
            xmlBuffer.addAttribute(entry.getKey(), entry.getValue());
        }
    }
}

