/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom.glue;

import java.util.ArrayList;
import java.util.List;

class XMLBuffer {
    private final StringBuffer buffer = new StringBuffer();
    private final List<String> elementStack = new ArrayList<String>();
    private boolean tagOpened;

    public XMLBuffer() {
        this.clear();
    }

    public final void clear() {
        this.elementStack.clear();
        this.tagOpened = false;
        this.buffer.delete(0, this.buffer.length());
        this.buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    public void addProcessingInstruction(String target, String content) {
        assert (target != null);
        assert (content != null);
        assert (this.elementStack.isEmpty());
        assert (!this.tagOpened);
        this.buffer.append("<?");
        this.buffer.append(target);
        this.buffer.append(' ');
        this.buffer.append(content);
        this.buffer.append("?>");
    }

    public void beginElement(String elementName) {
        assert (elementName != null);
        if (this.tagOpened) {
            this.buffer.append(">");
        }
        this.buffer.append('<');
        this.buffer.append(elementName);
        this.elementStack.add(elementName);
        this.tagOpened = true;
    }

    public void addAttribute(String attributeName, String attributeValue) {
        assert (attributeName != null);
        assert (attributeValue != null);
        assert (this.tagOpened);
        this.buffer.append(' ');
        this.buffer.append(attributeName);
        this.buffer.append("=\"");
        this.buffer.append(this.encodeToAttributeValue(attributeValue));
        this.buffer.append('\"');
    }

    public void endElement() {
        assert (!this.elementStack.isEmpty());
        String elementName = this.elementStack.get(this.elementStack.size() - 1);
        this.elementStack.remove(this.elementStack.size() - 1);
        if (this.tagOpened) {
            this.buffer.append(" />");
            this.tagOpened = false;
        } else {
            this.buffer.append("</");
            this.buffer.append(elementName);
            this.buffer.append(">");
        }
    }

    public void addText(String text) {
        if (this.tagOpened) {
            this.buffer.append(">");
            this.tagOpened = false;
        }
        this.buffer.append(text);
    }

    public void addComment(String comment) {
        assert (!this.tagOpened);
        this.buffer.append("<!--");
        this.buffer.append(comment);
        this.buffer.append("-->");
    }

    public void addLineSeparator() {
        if (this.tagOpened) {
            this.buffer.append(">");
            this.tagOpened = false;
        }
        this.buffer.append('\n');
    }

    public String toString() {
        assert (this.elementStack.isEmpty());
        return this.buffer.toString();
    }

    private String encodeToAttributeValue(String s) {
        StringBuffer result = new StringBuffer();
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        result.append("&#");
                        result.append((int)c);
                        result.append(';');
                        continue block6;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }
}

