/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom.sampledata;

import com.oracle.javafx.scenebuilder.kit.fxom.sampledata.AbstractSampleData;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.chart.AreaChart;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.BubbleChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.ScatterChart;
import javafx.scene.chart.StackedAreaChart;
import javafx.scene.chart.StackedBarChart;
import javafx.scene.chart.XYChart;

class XYChartSampleData
extends AbstractSampleData {
    private final List<XYChart.Series<Object, Object>> samples = new ArrayList<XYChart.Series<Object, Object>>();
    private final List<String> categories = new ArrayList<String>();
    private Class<?> sampleXAxisClass;
    private Class<?> sampleYAxisClass;

    XYChartSampleData() {
    }

    public static boolean isKnownXYChart(Object obj) {
        Class<?> objClass;
        boolean result = obj instanceof XYChart ? (objClass = obj.getClass()) == BarChart.class || objClass == AreaChart.class || objClass == BubbleChart.class || objClass == LineChart.class || objClass == ScatterChart.class || objClass == StackedBarChart.class || objClass == StackedAreaChart.class : false;
        return result;
    }

    @Override
    public void applyTo(Object sceneGraphObject) {
        CategoryAxis axis;
        assert (sceneGraphObject instanceof XYChart);
        XYChart xyChart = (XYChart)sceneGraphObject;
        this.updateSamples(xyChart);
        xyChart.getData().clear();
        xyChart.getData().addAll(this.samples);
        if (xyChart.getXAxis().getClass() == CategoryAxis.class) {
            axis = (CategoryAxis)xyChart.getXAxis();
            axis.getCategories().setAll(this.categories);
        }
        if (xyChart.getYAxis().getClass() == CategoryAxis.class) {
            axis = (CategoryAxis)xyChart.getYAxis();
            axis.getCategories().setAll(this.categories);
        }
    }

    @Override
    public void removeFrom(Object sceneGraphObject) {
        CategoryAxis axis;
        assert (sceneGraphObject instanceof XYChart);
        XYChart xyChart = (XYChart)sceneGraphObject;
        xyChart.getData().clear();
        if (xyChart.getXAxis().getClass() == CategoryAxis.class) {
            axis = (CategoryAxis)xyChart.getXAxis();
            axis.getCategories().clear();
        }
        if (xyChart.getYAxis().getClass() == CategoryAxis.class) {
            axis = (CategoryAxis)xyChart.getYAxis();
            axis.getCategories().clear();
        }
    }

    private void updateSamples(XYChart<?, ?> xyChart) {
        Class<?> xAxisClass = xyChart.getXAxis().getClass();
        Class<?> yAxisClass = xyChart.getYAxis().getClass();
        if (xAxisClass != this.sampleXAxisClass || yAxisClass != this.sampleYAxisClass) {
            this.sampleXAxisClass = xAxisClass;
            this.sampleYAxisClass = yAxisClass;
            for (int i = 0; i < 3; ++i) {
                XYChart.Series serie = new XYChart.Series();
                for (int j = 0; j < 10; ++j) {
                    Object xValue = this.makeValue(this.sampleXAxisClass, i);
                    Object yValue = this.makeValue(this.sampleYAxisClass, i);
                    XYChart.Data data = new XYChart.Data(xValue, yValue);
                    serie.getData().add((Object)data);
                }
                this.samples.add((XYChart.Series<Object, Object>)serie);
            }
            this.categories.clear();
            if (this.sampleXAxisClass == CategoryAxis.class || this.sampleYAxisClass == CategoryAxis.class) {
                for (int j = 0; j < 10; ++j) {
                    this.categories.add(String.valueOf(2000 + j));
                }
            }
        }
    }

    private Object makeValue(Class<?> axisClass, int index) {
        Object result;
        if (axisClass == NumberAxis.class) {
            result = Math.random() * 100.0;
        } else if (axisClass == CategoryAxis.class) {
            result = String.valueOf(2000 + index);
        } else {
            assert (false) : "Unexpected Axis subclass" + axisClass;
            result = String.valueOf(index);
        }
        return result;
    }
}

