/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.library;

import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.images.ImageUtils;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.library.BuiltinSectionComparator;
import com.oracle.javafx.scenebuilder.kit.library.Library;
import com.oracle.javafx.scenebuilder.kit.library.LibraryItem;
import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import javafx.embed.swing.SwingNode;
import javafx.scene.AmbientLight;
import javafx.scene.Group;
import javafx.scene.ParallelCamera;
import javafx.scene.PerspectiveCamera;
import javafx.scene.PointLight;
import javafx.scene.SubScene;
import javafx.scene.canvas.Canvas;
import javafx.scene.chart.AreaChart;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.BubbleChart;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.PieChart;
import javafx.scene.chart.ScatterChart;
import javafx.scene.chart.StackedAreaChart;
import javafx.scene.chart.StackedBarChart;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.RadioButton;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.TreeView;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.media.MediaView;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.Box;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.QuadCurve;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Sphere;
import javafx.scene.shape.VLineTo;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.scene.web.HTMLEditor;
import javafx.scene.web.WebView;

public class BuiltinLibrary
extends Library {
    public static final String TAG_CONTAINERS = "Containers";
    public static final String TAG_CONTROLS = "Controls";
    public static final String TAG_MENU = "Menu";
    public static final String TAG_MISCELLANEOUS = "Miscellaneous";
    public static final String TAG_SHAPES = "Shapes";
    public static final String TAG_CHARTS = "Charts";
    public static final String TAG_3D = "3D";
    private static BuiltinLibrary library = null;
    private final BuiltinSectionComparator sectionComparator = new BuiltinSectionComparator();
    private static final String FX8_QUALIFIER = " (FX8)";
    private static final String EMPTY_QUALIFIER = " " + I18N.getString("label.qualifier.empty");
    private static final String HORIZONTAL_QUALIFIER = " " + I18N.getString("label.qualifier.horizontal");
    private static final String VERTICAL_QUALIFIER = " " + I18N.getString("label.qualifier.vertical");

    public static synchronized BuiltinLibrary getLibrary() {
        if (library == null) {
            library = new BuiltinLibrary();
        }
        return library;
    }

    public static String getFX8Qualifier() {
        return FX8_QUALIFIER;
    }

    public static String getEmptyQualifier() {
        return EMPTY_QUALIFIER;
    }

    @Override
    public Comparator<String> getSectionComparator() {
        return this.sectionComparator;
    }

    public static void main(String[] args) {
        BuiltinLibrary.getLibrary();
    }

    private BuiltinLibrary() {
        this.addCustomizedItem(Accordion.class, TAG_CONTAINERS);
        this.addCustomizedItem(Accordion.class, TAG_CONTAINERS, "AccordionEmpty", "Accordion", EMPTY_QUALIFIER);
        this.addRegionItem200x200(AnchorPane.class, TAG_CONTAINERS);
        this.addRegionItem200x200(BorderPane.class, TAG_CONTAINERS);
        this.addRegionItem200x200(FlowPane.class, TAG_CONTAINERS);
        this.addCustomizedItem(GridPane.class, TAG_CONTAINERS);
        this.addRegionItem200x100(HBox.class, TAG_CONTAINERS);
        this.addRegionItem200x200(Pane.class, TAG_CONTAINERS);
        this.addCustomizedItem(ScrollPane.class, TAG_CONTAINERS);
        this.addRegionItem200x200(ScrollPane.class, TAG_CONTAINERS, EMPTY_QUALIFIER);
        this.addCustomizedItem(SplitPane.class, TAG_CONTAINERS, "SplitPaneH", "SplitPane-h", HORIZONTAL_QUALIFIER);
        this.addCustomizedItem(SplitPane.class, TAG_CONTAINERS, "SplitPaneV", "SplitPane-v", VERTICAL_QUALIFIER);
        this.addRegionItem200x200(SplitPane.class, TAG_CONTAINERS, EMPTY_QUALIFIER, "SplitPane-h");
        this.addRegionItem200x150(StackPane.class, TAG_CONTAINERS);
        this.addCustomizedItem(Tab.class, TAG_CONTAINERS);
        this.addCustomizedItem(TabPane.class, TAG_CONTAINERS);
        this.addCustomizedItem(TabPane.class, TAG_CONTAINERS, "TabPaneEmpty", "TabPane", EMPTY_QUALIFIER);
        this.addRegionItem200x200(TextFlow.class, TAG_CONTAINERS, FX8_QUALIFIER);
        this.addRegionItem200x200(TilePane.class, TAG_CONTAINERS);
        this.addCustomizedItem(TitledPane.class, TAG_CONTAINERS);
        this.addRegionItem200x200(TitledPane.class, TAG_CONTAINERS, EMPTY_QUALIFIER);
        this.addCustomizedItem(ToolBar.class, TAG_CONTAINERS);
        this.addRegionItem100x200(VBox.class, TAG_CONTAINERS);
        this.addCustomizedItem(Button.class, TAG_CONTROLS);
        this.addCustomizedItem(CheckBox.class, TAG_CONTROLS);
        this.addCustomizedItem(ChoiceBox.class, TAG_CONTROLS);
        this.addDefaultItem(ColorPicker.class, TAG_CONTROLS, new String[0]);
        this.addCustomizedItem(ComboBox.class, TAG_CONTROLS);
        this.addDefaultItem(DatePicker.class, TAG_CONTROLS, FX8_QUALIFIER);
        this.addCustomizedItem(HTMLEditor.class, TAG_CONTROLS);
        this.addCustomizedItem(Hyperlink.class, TAG_CONTROLS);
        this.addCustomizedItem(ImageView.class, TAG_CONTROLS);
        this.addCustomizedItem(Label.class, TAG_CONTROLS);
        this.addRegionItem200x200(ListView.class, TAG_CONTROLS);
        this.addCustomizedItem(MediaView.class, TAG_CONTROLS);
        this.addCustomizedItem(MenuBar.class, TAG_CONTROLS);
        this.addCustomizedItem(MenuButton.class, TAG_CONTROLS);
        this.addRegionItem200x200(Pagination.class, TAG_CONTROLS);
        this.addDefaultItem(PasswordField.class, TAG_CONTROLS, new String[0]);
        this.addCustomizedItem(ProgressBar.class, TAG_CONTROLS);
        this.addCustomizedItem(ProgressIndicator.class, TAG_CONTROLS);
        this.addCustomizedItem(RadioButton.class, TAG_CONTROLS);
        this.addCustomizedItem(ScrollBar.class, TAG_CONTROLS, "ScrollBarH", "ScrollBar-h", HORIZONTAL_QUALIFIER);
        this.addCustomizedItem(ScrollBar.class, TAG_CONTROLS, "ScrollBarV", "ScrollBar-v", VERTICAL_QUALIFIER);
        this.addCustomizedItem(Separator.class, TAG_CONTROLS, "SeparatorH", "Separator-h", HORIZONTAL_QUALIFIER);
        this.addCustomizedItem(Separator.class, TAG_CONTROLS, "SeparatorV", "Separator-v", VERTICAL_QUALIFIER);
        this.addCustomizedItem(Slider.class, TAG_CONTROLS, "SliderH", "Slider-h", HORIZONTAL_QUALIFIER);
        this.addCustomizedItem(Slider.class, TAG_CONTROLS, "SliderV", "Slider-v", VERTICAL_QUALIFIER);
        this.addCustomizedItem(SplitMenuButton.class, TAG_CONTROLS);
        this.addCustomizedItem(TableColumn.class, TAG_CONTROLS);
        this.addCustomizedItem(TableView.class, TAG_CONTROLS);
        this.addRegionItem200x200(TextArea.class, TAG_CONTROLS);
        this.addDefaultItem(TextField.class, TAG_CONTROLS, new String[0]);
        this.addCustomizedItem(ToggleButton.class, TAG_CONTROLS);
        this.addCustomizedItem(TreeTableColumn.class, TAG_CONTROLS, FX8_QUALIFIER);
        this.addCustomizedItem(TreeTableView.class, TAG_CONTROLS, FX8_QUALIFIER);
        this.addRegionItem200x200(TreeView.class, TAG_CONTROLS);
        this.addCustomizedItem(WebView.class, TAG_CONTROLS);
        this.addCustomizedItem(CheckMenuItem.class, TAG_MENU);
        this.addCustomizedItem(ContextMenu.class, TAG_MENU);
        this.addCustomizedItem(CustomMenuItem.class, TAG_MENU);
        this.addCustomizedItem(Menu.class, TAG_MENU);
        this.addCustomizedItem(MenuItem.class, TAG_MENU);
        this.addCustomizedItem(RadioMenuItem.class, TAG_MENU);
        this.addCustomizedItem(SeparatorMenuItem.class, TAG_MENU);
        this.addCustomizedItem(Canvas.class, TAG_MISCELLANEOUS);
        this.addDefaultItem(Group.class, TAG_MISCELLANEOUS, new String[0]);
        this.addRegionItem200x200(Region.class, TAG_MISCELLANEOUS);
        this.addCustomizedItem(SubScene.class, TAG_MISCELLANEOUS, FX8_QUALIFIER);
        this.addDefaultItem(SwingNode.class, TAG_MISCELLANEOUS, FX8_QUALIFIER);
        this.addCustomizedItem(Tooltip.class, TAG_MISCELLANEOUS);
        this.addCustomizedItem(Arc.class, TAG_SHAPES);
        this.addDefaultItem(ArcTo.class, TAG_SHAPES, new String[0]);
        this.addDefaultItem(Box.class, TAG_SHAPES, FX8_QUALIFIER);
        this.addCustomizedItem(Circle.class, TAG_SHAPES);
        this.addDefaultItem(ClosePath.class, TAG_SHAPES, new String[0]);
        this.addCustomizedItem(CubicCurve.class, TAG_SHAPES);
        this.addDefaultItem(CubicCurveTo.class, TAG_SHAPES, new String[0]);
        this.addCustomizedItem(Cylinder.class, TAG_SHAPES, FX8_QUALIFIER);
        this.addCustomizedItem(Ellipse.class, TAG_SHAPES);
        this.addDefaultItem(HLineTo.class, TAG_SHAPES, new String[0]);
        this.addCustomizedItem(Line.class, TAG_SHAPES);
        this.addDefaultItem(LineTo.class, TAG_SHAPES, new String[0]);
        this.addDefaultItem(MeshView.class, TAG_SHAPES, FX8_QUALIFIER);
        this.addDefaultItem(MoveTo.class, TAG_SHAPES, new String[0]);
        this.addCustomizedItem(Path.class, TAG_SHAPES);
        this.addCustomizedItem(Polygon.class, TAG_SHAPES);
        this.addCustomizedItem(Polyline.class, TAG_SHAPES);
        this.addCustomizedItem(QuadCurve.class, TAG_SHAPES);
        this.addDefaultItem(QuadCurveTo.class, TAG_SHAPES, new String[0]);
        this.addCustomizedItem(Rectangle.class, TAG_SHAPES);
        this.addCustomizedItem(Sphere.class, TAG_SHAPES, FX8_QUALIFIER);
        this.addCustomizedItem(SVGPath.class, TAG_SHAPES);
        this.addCustomizedItem(Text.class, TAG_SHAPES);
        this.addDefaultItem(VLineTo.class, TAG_SHAPES, new String[0]);
        this.addCustomizedItem(AreaChart.class, TAG_CHARTS);
        this.addCustomizedItem(BarChart.class, TAG_CHARTS);
        this.addCustomizedItem(BubbleChart.class, TAG_CHARTS);
        this.addCustomizedItem(LineChart.class, TAG_CHARTS);
        this.addDefaultItem(PieChart.class, TAG_CHARTS, new String[0]);
        this.addCustomizedItem(ScatterChart.class, TAG_CHARTS);
        this.addCustomizedItem(StackedAreaChart.class, TAG_CHARTS);
        this.addCustomizedItem(StackedBarChart.class, TAG_CHARTS);
        this.addCustomizedItem(AmbientLight.class, TAG_3D, FX8_QUALIFIER);
        this.addDefaultItem(ParallelCamera.class, TAG_3D, FX8_QUALIFIER);
        this.addDefaultItem(PerspectiveCamera.class, TAG_3D, FX8_QUALIFIER);
        this.addCustomizedItem(PointLight.class, TAG_3D, FX8_QUALIFIER);
    }

    private void addDefaultItem(Class<?> componentClass, String section, String ... qualifiers) {
        String name;
        String nameWithQualifier = name = componentClass.getSimpleName();
        if (qualifiers.length > 0) {
            nameWithQualifier = nameWithQualifier + qualifiers[0];
        }
        String fxmlText = BuiltinLibrary.makeFxmlText(componentClass);
        this.addItem(nameWithQualifier, fxmlText, section, name);
    }

    private void addRegionItem200x200(Class<? extends Region> componentClass, String section) {
        this.addRegionItem200x200(componentClass, section, null);
    }

    private void addRegionItem200x200(Class<? extends Region> componentClass, String section, String qualifier) {
        this.addRegionItem200x200(componentClass, section, qualifier, null);
    }

    private void addRegionItem200x200(Class<? extends Region> componentClass, String section, String qualifier, String iconName) {
        String name;
        String nameWithQualifier = name = componentClass.getSimpleName();
        if (qualifier != null) {
            nameWithQualifier = nameWithQualifier + qualifier;
        }
        String fxmlText = BuiltinLibrary.makeRegionFxmlText(componentClass, 200.0, 200.0);
        String theIconName = name;
        if (iconName != null) {
            theIconName = iconName;
        }
        this.addItem(nameWithQualifier, fxmlText, section, theIconName);
    }

    private void addRegionItem200x100(Class<? extends Region> componentClass, String section) {
        String name = componentClass.getSimpleName();
        String fxmlText = BuiltinLibrary.makeRegionFxmlText(componentClass, 200.0, 100.0);
        this.addItem(name, fxmlText, section, name);
    }

    private void addRegionItem200x150(Class<? extends Region> componentClass, String section) {
        String name = componentClass.getSimpleName();
        String fxmlText = BuiltinLibrary.makeRegionFxmlText(componentClass, 200.0, 150.0);
        this.addItem(name, fxmlText, section, name);
    }

    private void addRegionItem100x200(Class<? extends Region> componentClass, String section) {
        String name = componentClass.getSimpleName();
        String fxmlText = BuiltinLibrary.makeRegionFxmlText(componentClass, 100.0, 200.0);
        this.addItem(name, fxmlText, section, name);
    }

    private void addCustomizedItem(Class<?> componentClass, String section) {
        this.addCustomizedItem(componentClass, section, null);
    }

    private void addCustomizedItem(Class<?> componentClass, String section, String qualifier) {
        String name = componentClass.getSimpleName();
        this.addCustomizedItem(componentClass, section, name, name, qualifier);
    }

    private void addCustomizedItem(Class<?> componentClass, String section, String fxmlBaseName, String iconName, String qualifier) {
        String nameWithQualifier = componentClass.getSimpleName();
        if (qualifier != null) {
            nameWithQualifier = nameWithQualifier + qualifier;
        }
        String fxmlText = this.readCustomizedFxmlText(fxmlBaseName);
        assert (fxmlText != null);
        this.addItem(nameWithQualifier, fxmlText, section, iconName);
    }

    private void addItem(String name, String fxmlText, String section, String iconName) {
        URL iconURL = ImageUtils.getNodeIconURL(iconName + ".png");
        LibraryItem item = new LibraryItem(name, section, fxmlText, iconURL, this);
        this.itemsProperty.add((Object)item);
    }

    private static String makeFxmlText(Class<?> componentClass) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<?import ");
        sb.append(componentClass.getCanonicalName());
        sb.append("?>");
        sb.append("<");
        sb.append(componentClass.getSimpleName());
        sb.append("/>\n");
        return sb.toString();
    }

    private static String makeRegionFxmlText(Class<? extends Region> componentClass, double pw, double ph) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<?import ");
        sb.append(componentClass.getCanonicalName());
        sb.append("?>");
        sb.append("<");
        sb.append(componentClass.getSimpleName());
        if (pw != -1.0) {
            sb.append(" prefWidth=\"");
            sb.append(pw);
            sb.append("\"");
        }
        if (ph != -1.0) {
            sb.append(" prefHeight=\"");
            sb.append(ph);
            sb.append("\"");
        }
        sb.append(" />\n");
        return sb.toString();
    }

    private String readCustomizedFxmlText(String fxmlBaseName) {
        String result;
        StringBuilder fxmlPath = new StringBuilder();
        fxmlPath.append("builtin/");
        fxmlPath.append(fxmlBaseName);
        fxmlPath.append(".fxml");
        URL fxmlURL = BuiltinLibrary.class.getResource(fxmlPath.toString());
        assert (fxmlURL != null) : "fxmlBaseName=" + fxmlBaseName;
        try {
            result = FXOMDocument.readContentFromURL(fxmlURL);
        }
        catch (IOException x) {
            throw new IllegalStateException("Bug in " + this.getClass().getSimpleName(), x);
        }
        return result;
    }
}

