/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.library.user;

import com.oracle.javafx.scenebuilder.kit.library.BuiltinSectionComparator;
import com.oracle.javafx.scenebuilder.kit.library.Library;
import com.oracle.javafx.scenebuilder.kit.library.LibraryItem;
import com.oracle.javafx.scenebuilder.kit.library.user.LibraryFolderWatcher;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class UserLibrary
extends Library {
    public static final String TAG_USER_DEFINED = "Custom";
    private final String path;
    private final BuiltinSectionComparator sectionComparator = new BuiltinSectionComparator();
    private final ObservableList<JarReport> jarReports = FXCollections.observableArrayList();
    private final ObservableList<JarReport> previousJarReports = FXCollections.observableArrayList();
    private final SimpleIntegerProperty explorationCountProperty = new SimpleIntegerProperty();
    private final SimpleObjectProperty<Date> explorationDateProperty = new SimpleObjectProperty();
    private State state = State.READY;
    private Exception exception;
    private LibraryFolderWatcher watcher;
    private Thread watcherThread;
    private final String filterFileName = "filter.txt";

    public UserLibrary(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public ObservableList<JarReport> getJarReports() {
        return this.jarReports;
    }

    public ObservableList<JarReport> getPreviousJarReports() {
        return this.previousJarReports;
    }

    public synchronized State getState() {
        return this.state;
    }

    public synchronized void startWatching() {
        assert (this.state == State.READY);
        if (this.state == State.READY) {
            assert (this.watcher == null);
            assert (this.watcherThread == null);
            this.watcher = new LibraryFolderWatcher(this);
            this.watcherThread = new Thread(this.watcher);
            this.watcherThread.setName(this.watcher.getClass().getSimpleName() + "(" + this.path + ")");
            this.watcherThread.setDaemon(true);
            this.watcherThread.start();
            this.state = State.WATCHING;
        }
    }

    public synchronized void stopWatching() {
        assert (this.state == State.WATCHING);
        if (this.state == State.WATCHING) {
            assert (this.watcher != null);
            assert (this.watcherThread != null);
            assert (this.exception == null);
            this.watcherThread.interrupt();
            try {
                this.watcherThread.join();
            }
            catch (InterruptedException x) {
                x.printStackTrace();
            }
            finally {
                this.watcher = null;
                this.watcherThread = null;
                this.state = State.READY;
                this.changeClassLoader(null);
                this.previousJarReports.clear();
            }
        }
    }

    public int getExplorationCount() {
        return this.explorationCountProperty.get();
    }

    public ReadOnlyIntegerProperty explorationCountProperty() {
        return this.explorationCountProperty;
    }

    public Object getExplorationDate() {
        return this.explorationDateProperty.get();
    }

    public ReadOnlyObjectProperty<Date> explorationDateProperty() {
        return this.explorationDateProperty;
    }

    public void setFilter(List<String> classnames) throws FileNotFoundException, IOException {
        if (classnames != null && classnames.size() > 0) {
            File filterFile = new File(this.getFilterFileName());
            TreeSet<String> allClassnames = new TreeSet<String>();
            for (String classname : classnames) {
                allClassnames.add(classname);
            }
            Path filterFilePath = Paths.get(this.getPath(), "filter.txt");
            Path formerFilterFilePath = Paths.get(this.getPath(), "filter.txt.tmp");
            Files.deleteIfExists(formerFilterFilePath);
            try {
                if (Files.exists(filterFilePath, new LinkOption[0])) {
                    Files.move(filterFilePath, formerFilterFilePath, StandardCopyOption.ATOMIC_MOVE);
                }
                Files.createFile(filterFilePath, new FileAttribute[0]);
                try (PrintWriter writer = new PrintWriter(filterFile, "UTF-8");){
                    for (String classname : allClassnames) {
                        writer.write(classname + "\n");
                    }
                }
                if (Files.exists(formerFilterFilePath, new LinkOption[0])) {
                    Files.delete(formerFilterFilePath);
                }
            }
            catch (IOException ioe) {
                if (Files.exists(formerFilterFilePath, new LinkOption[0])) {
                    Files.move(formerFilterFilePath, filterFilePath, StandardCopyOption.ATOMIC_MOVE);
                }
                throw ioe;
            }
        }
    }

    public List<String> getFilter() throws FileNotFoundException, IOException {
        ArrayList<String> res = new ArrayList<String>();
        File filterFile = new File(this.getFilterFileName());
        if (filterFile.exists()) {
            try (LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(filterFile), "UTF-8"));){
                String line;
                while ((line = reader.readLine()) != null) {
                    res.add(line);
                }
            }
        }
        return res;
    }

    String getFilterFileName() {
        return this.getPath() + File.separator + "filter.txt";
    }

    void updateJarReports(final Collection<JarReport> newJarReports) {
        if (Platform.isFxApplicationThread()) {
            this.previousJarReports.setAll(this.jarReports);
            this.jarReports.setAll(newJarReports);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UserLibrary.this.previousJarReports.setAll((Collection)UserLibrary.this.jarReports);
                    UserLibrary.this.jarReports.setAll(newJarReports);
                }
            });
        }
    }

    void setItems(final Collection<LibraryItem> items) {
        if (Platform.isFxApplicationThread()) {
            this.itemsProperty.setAll(items);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UserLibrary.this.itemsProperty.setAll(items);
                }
            });
        }
    }

    void addItems(final Collection<LibraryItem> items) {
        if (Platform.isFxApplicationThread()) {
            this.itemsProperty.addAll(items);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UserLibrary.this.itemsProperty.addAll(items);
                }
            });
        }
    }

    void updateClassLoader(final ClassLoader newClassLoader) {
        if (Platform.isFxApplicationThread()) {
            this.changeClassLoader(newClassLoader);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UserLibrary.this.changeClassLoader(newClassLoader);
                }
            });
        }
    }

    void updateExplorationCount(final int count) {
        if (Platform.isFxApplicationThread()) {
            this.explorationCountProperty.set(count);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UserLibrary.this.explorationCountProperty.set(count);
                }
            });
        }
    }

    void updateExplorationDate(final Date date) {
        if (Platform.isFxApplicationThread()) {
            this.explorationDateProperty.set((Object)date);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UserLibrary.this.explorationDateProperty.set((Object)date);
                }
            });
        }
    }

    @Override
    public Comparator<String> getSectionComparator() {
        return this.sectionComparator;
    }

    private void changeClassLoader(ClassLoader newClassLoader) {
        assert (Platform.isFxApplicationThread());
        ClassLoader classLoader = (ClassLoader)this.classLoaderProperty.get();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            try {
                urlClassLoader.close();
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
        this.classLoaderProperty.set((Object)newClassLoader);
    }

    public static void main(String[] args) throws Exception {
        String path = "/Users/elp/Desktop/MyLib";
        UserLibrary lib = new UserLibrary("/Users/elp/Desktop/MyLib");
        lib.startWatching();
        System.out.println("Starting to watch for 20 s");
        Thread.sleep(20000L);
        System.out.println("Stopping to watch for 20 s");
        lib.stopWatching();
        Thread.sleep(20000L);
        System.out.println("Exiting");
    }

    public static enum State {
        READY,
        WATCHING;

    }
}

