/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.library.util;

import com.oracle.javafx.scenebuilder.kit.library.util.JarReport;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReportEntry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javafx.fxml.FXMLLoader;

public class JarExplorer {
    private final Path jar;

    public JarExplorer(Path jar) {
        assert (jar != null);
        assert (jar.isAbsolute());
        this.jar = jar;
    }

    public JarReport explore(ClassLoader classLoader) throws IOException {
        JarReport result = new JarReport(this.jar);
        try (JarFile jarFile = new JarFile(this.jar.toFile());){
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                result.getEntries().add(this.exploreEntry(entry, classLoader));
            }
        }
        return result;
    }

    public static String makeFxmlText(Class<?> klass) {
        StringBuilder result = new StringBuilder();
        result.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        result.append("<?import ");
        result.append(klass.getCanonicalName());
        result.append("?>");
        result.append("<");
        result.append(klass.getSimpleName());
        result.append("/>\n");
        return result.toString();
    }

    public static Object instantiateWithFXMLLoader(Class<?> klass, ClassLoader classLoader) throws IOException {
        Object result;
        String fxmlText = JarExplorer.makeFxmlText(klass);
        byte[] fxmlBytes = fxmlText.getBytes(Charset.forName("UTF-8"));
        FXMLLoader fxmlLoader = new FXMLLoader();
        try {
            fxmlLoader.setClassLoader(classLoader);
            result = fxmlLoader.load((InputStream)new ByteArrayInputStream(fxmlBytes));
        }
        catch (IOException x) {
            throw x;
        }
        catch (Error | RuntimeException x) {
            throw new IOException(x);
        }
        return result;
    }

    private JarReportEntry exploreEntry(JarEntry entry, ClassLoader classLoader) {
        Throwable entryException;
        Class<?> entryClass;
        JarReportEntry.Status status;
        if (entry.isDirectory()) {
            status = JarReportEntry.Status.IGNORED;
            entryClass = null;
            entryException = null;
        } else {
            String className = this.makeClassName(entry.getName());
            if (className == null || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("javafx.") || className.startsWith("com.oracle.javafx.scenebuilder.") || className.startsWith("com.javafx.")) {
                status = JarReportEntry.Status.IGNORED;
                entryClass = null;
                entryException = null;
            } else {
                try {
                    entryClass = classLoader.loadClass(className);
                    try {
                        JarExplorer.instantiateWithFXMLLoader(entryClass, classLoader);
                        status = JarReportEntry.Status.OK;
                        entryException = null;
                    }
                    catch (IOException | RuntimeException x) {
                        status = JarReportEntry.Status.CANNOT_INSTANTIATE;
                        entryException = x;
                    }
                }
                catch (ClassNotFoundException | Error x) {
                    status = JarReportEntry.Status.CANNOT_LOAD;
                    entryClass = null;
                    entryException = x;
                }
            }
        }
        return new JarReportEntry(entry.getName(), status, entryException, entryClass);
    }

    private String makeClassName(String entryName) {
        String result;
        if (!entryName.endsWith(".class")) {
            result = null;
        } else if (entryName.contains("$")) {
            result = null;
        } else {
            int endIndex = entryName.length() - 6;
            result = entryName.substring(0, endIndex).replace("/", ".");
        }
        return result;
    }
}

