/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.klass;

import com.oracle.javafx.scenebuilder.kit.metadata.klass.ClassMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.PropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javafx.scene.Group;
import javafx.scene.control.Accordion;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuButton;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Path;

public class ComponentClassMetadata
extends ClassMetadata {
    private final Set<PropertyMetadata> properties = new HashSet<PropertyMetadata>();
    private final boolean freeChildPositioning;
    private final ComponentClassMetadata parentMetadata;
    private static final PropertyName columnsName = new PropertyName("columns");
    private static final PropertyName elementsName = new PropertyName("elements");
    private static final PropertyName itemsName = new PropertyName("items");
    private static final PropertyName menusName = new PropertyName("menus");
    private static final PropertyName panesName = new PropertyName("panes");
    private static final PropertyName tabsName = new PropertyName("tabs");
    private static final PropertyName childrenName = new PropertyName("children");

    public ComponentClassMetadata(Class<?> klass, ComponentClassMetadata parentMetadata) {
        super(klass);
        this.parentMetadata = parentMetadata;
        this.freeChildPositioning = false;
    }

    public Set<PropertyMetadata> getProperties() {
        return this.properties;
    }

    public PropertyName getSubComponentProperty() {
        PropertyName result = null;
        Class<?> componentClass = this.getKlass();
        if (componentClass == BorderPane.class) {
            result = null;
        } else {
            while (result == null && componentClass != null) {
                result = ComponentClassMetadata.getSubComponentProperty(componentClass);
                componentClass = componentClass.getSuperclass();
            }
        }
        return result;
    }

    public boolean isFreeChildPositioning() {
        return this.freeChildPositioning;
    }

    public ComponentClassMetadata getParentMetadata() {
        return this.parentMetadata;
    }

    public PropertyMetadata lookupProperty(PropertyName propertyName) {
        PropertyMetadata result = null;
        assert (propertyName != null);
        Iterator<PropertyMetadata> it = this.properties.iterator();
        while (result == null && it.hasNext()) {
            PropertyMetadata pm = it.next();
            if (!pm.getName().equals(propertyName)) continue;
            result = pm;
        }
        return result;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    private static PropertyName getSubComponentProperty(Class<?> componentClass) {
        assert (componentClass != BorderPane.class);
        PropertyName result = componentClass == Accordion.class ? panesName : (componentClass == ContextMenu.class ? itemsName : (componentClass == Menu.class ? itemsName : (componentClass == MenuBar.class ? menusName : (componentClass == MenuButton.class ? itemsName : (componentClass == Path.class ? elementsName : (componentClass == SplitMenuButton.class ? itemsName : (componentClass == SplitPane.class ? itemsName : (componentClass == TableColumn.class ? columnsName : (componentClass == TableView.class ? columnsName : (componentClass == TabPane.class ? tabsName : (componentClass == ToolBar.class ? itemsName : (componentClass == TreeTableColumn.class ? columnsName : (componentClass == TreeTableView.class ? columnsName : (componentClass == Group.class ? childrenName : (componentClass == Pane.class ? childrenName : null)))))))))))))));
        return result;
    }
}

