/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value.list;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.SingleValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public abstract class ListValuePropertyMetadata<T>
extends ValuePropertyMetadata {
    private final Class<T> itemClass;
    private final SingleValuePropertyMetadata<T> itemMetadata;
    private final List<T> defaultValue;

    public ListValuePropertyMetadata(PropertyName name, Class<T> itemClass, SingleValuePropertyMetadata<T> itemMetadata, boolean readWrite, List<T> defaultValue, InspectorPath inspectorPath) {
        super(name, readWrite, inspectorPath);
        this.itemClass = itemClass;
        this.defaultValue = defaultValue;
        this.itemMetadata = itemMetadata;
    }

    public Class<T> getItemClass() {
        return this.itemClass;
    }

    public List<T> getDefaultValue() {
        return this.defaultValue;
    }

    public List<T> getValue(FXOMInstance fxomInstance) {
        List<Object> result;
        if (this.isReadWrite()) {
            FXOMProperty fxomProperty = fxomInstance.getProperties().get(this.getName());
            if (fxomProperty == null) {
                result = this.defaultValue;
            } else if (fxomProperty instanceof FXOMPropertyT) {
                FXOMPropertyT fxomPropertyT = (FXOMPropertyT)fxomProperty;
                PrefixedValue pv = new PrefixedValue(fxomPropertyT.getValue());
                result = pv.isBindingExpression() ? this.getDefaultValue() : this.makeValueFromString(fxomPropertyT.getValue());
            } else if (fxomProperty instanceof FXOMPropertyC) {
                FXOMPropertyC fxomPropertyC = (FXOMPropertyC)fxomProperty;
                result = new ArrayList();
                for (FXOMObject itemFxomObject : fxomPropertyC.getValues()) {
                    if (itemFxomObject instanceof FXOMInstance) {
                        FXOMInstance itemFxomInstance = (FXOMInstance)itemFxomObject;
                        result.add(this.itemMetadata.makeValueFromFxomInstance(itemFxomInstance));
                        continue;
                    }
                    assert (false);
                }
            } else {
                assert (false);
                result = this.defaultValue;
            }
        } else {
            List items = (List)this.getName().getValue(fxomInstance.getSceneGraphObject());
            result = new ArrayList();
            for (Object item : items) {
                result.add(this.getItemClass().cast(item));
            }
        }
        return result;
    }

    public void setValue(FXOMInstance fxomInstance, List<T> value) {
        assert (this.isReadWrite());
        FXOMProperty fxomProperty = fxomInstance.getProperties().get(this.getName());
        if (Objects.equals(value, this.getDefaultValueObject()) || value.isEmpty()) {
            if (fxomProperty != null) {
                fxomProperty.removeFromParentInstance();
            }
        } else {
            FXOMProperty newProperty;
            FXOMDocument fxomDocument = fxomInstance.getFxomDocument();
            if (this.canMakeStringFromValue(value)) {
                String valueString = this.makeStringFromValue(value);
                newProperty = new FXOMPropertyT(fxomDocument, this.getName(), valueString);
            } else {
                ArrayList<FXOMObject> items = new ArrayList<FXOMObject>();
                for (T i : value) {
                    items.add(this.itemMetadata.makeFxomInstanceFromValue(i, fxomDocument));
                }
                newProperty = new FXOMPropertyC(fxomDocument, this.getName(), items);
            }
            FXOMNodes.updateProperty(fxomInstance, newProperty);
        }
    }

    protected boolean canMakeStringFromValue(List<T> value) {
        T i;
        boolean result = true;
        Iterator<T> iterator = value.iterator();
        while (iterator.hasNext() && (result = this.itemMetadata.canMakeStringFromValue(i = iterator.next()))) {
        }
        return result;
    }

    protected String makeStringFromValue(List<T> value) {
        assert (this.canMakeStringFromValue(value));
        StringBuilder result = new StringBuilder();
        for (T item : value) {
            if (result.length() >= 1) {
                result.append(",");
                result.append(' ');
            }
            result.append(this.itemMetadata.makeStringFromValue(item));
        }
        return result.toString();
    }

    protected List<T> makeValueFromString(String string) {
        List result;
        String[] items = string.split(",");
        if (items.length == 0) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList();
            for (String itemString : items) {
                result.add(this.itemMetadata.makeValueFromString(itemString));
            }
        }
        return result;
    }

    @Override
    public Class<?> getValueClass() {
        return List.class;
    }

    @Override
    public Object getDefaultValueObject() {
        return this.defaultValue;
    }

    @Override
    public Object getValueObject(FXOMInstance fxomInstance) {
        return this.getValue(fxomInstance);
    }

    @Override
    public void setValueObject(FXOMInstance fxomInstance, Object valueObject) {
        assert (valueObject instanceof List);
        this.setValue(fxomInstance, this.castItemList((List)valueObject));
    }

    private List<T> castItemList(List<?> valueObject) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object itemValueObject : valueObject) {
            result.add(this.getItemClass().cast(itemValueObject));
        }
        return result;
    }
}

