/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value.list;

import com.oracle.javafx.scenebuilder.kit.metadata.property.value.StringPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.list.ListValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;

public class StringListPropertyMetadata
extends ListValuePropertyMetadata<String> {
    private static final StringPropertyMetadata itemMetadata = new StringPropertyMetadata(new PropertyName("unused"), true, null, InspectorPath.UNUSED, true);

    public StringListPropertyMetadata(PropertyName name, boolean readWrite, List<String> defaultValue, InspectorPath inspectorPath) {
        super(name, String.class, itemMetadata, readWrite, defaultValue, inspectorPath);
    }

    public static List<String> splitValue(String listValue) {
        ArrayList<String> result = new ArrayList<String>();
        String[] values = listValue.split(",");
        int count = values.length;
        for (int i = 0; i < count; ++i) {
            result.add(values[i]);
        }
        return result;
    }

    public static String assembleValue(List<String> valueItems) {
        StringBuilder result = new StringBuilder();
        for (String s : valueItems) {
            assert (s.indexOf(",") == -1);
            if (result.length() >= 1) {
                result.append(",");
            }
            result.append(s);
        }
        return result.toString();
    }

    @Override
    protected boolean canMakeStringFromValue(List<String> value) {
        return value.size() == 1;
    }

    @Override
    protected String makeStringFromValue(List<String> value) {
        assert (this.canMakeStringFromValue(value));
        return value.get(0);
    }

    @Override
    protected List<String> makeValueFromString(String string) {
        return StringListPropertyMetadata.splitValue(string);
    }
}

