/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.util;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMArchive;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.List;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;

public class ClipboardEncoder {
    static final DataFormat SB_DATA_FORMAT = new DataFormat(new String[]{"com.oracle.javafx.scenebuilder2/internal"});
    static final DataFormat FXML_DATA_FORMAT = new DataFormat(new String[]{"com.oracle.javafx/fxml"});
    private final List<FXOMObject> fxomObjects;

    public ClipboardEncoder(List<FXOMObject> fxomObjects) {
        assert (fxomObjects != null);
        this.fxomObjects = fxomObjects;
    }

    public boolean isEncodable() {
        boolean result = this.fxomObjects.isEmpty() ? false : FXOMArchive.isArchivable(this.fxomObjects);
        return result;
    }

    public ClipboardContent makeEncoding() {
        ImageView imageView;
        assert (this.isEncodable());
        ClipboardContent result = new ClipboardContent();
        FXOMArchive fxomArchive = new FXOMArchive(this.fxomObjects);
        result.put((Object)SB_DATA_FORMAT, (Object)new FXOMArchive(this.fxomObjects));
        FXOMArchive.Entry entry0 = fxomArchive.getEntries().get(0);
        result.put((Object)FXML_DATA_FORMAT, (Object)entry0.getFxmlText());
        result.put((Object)DataFormat.PLAIN_TEXT, (Object)entry0.getFxmlText());
        FXOMObject fxomObject0 = this.fxomObjects.get(0);
        if (fxomObject0.getSceneGraphObject() instanceof ImageView && (imageView = (ImageView)fxomObject0.getSceneGraphObject()).getImage() != null) {
            result.put((Object)DataFormat.IMAGE, (Object)imageView.getImage());
        }
        return result;
    }
}

