/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.util;

import com.oracle.javafx.scenebuilder.kit.editor.images.ImageUtils;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.klass.ComponentClassMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ComponentPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Orientation;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Labeled;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Separator;
import javafx.scene.control.Slider;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.image.Image;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;

public class DesignHierarchyMask {
    private static final PropertyName graphicName = new PropertyName("graphic");
    private static final PropertyName contentName = new PropertyName("content");
    private static final PropertyName topName = new PropertyName("top");
    private static final PropertyName bottomName = new PropertyName("bottom");
    private static final PropertyName leftName = new PropertyName("left");
    private static final PropertyName rightName = new PropertyName("right");
    private static final PropertyName centerName = new PropertyName("center");
    private static final PropertyName xAxisName = new PropertyName("XAxis");
    private static final PropertyName yAxisName = new PropertyName("YAxis");
    private static final PropertyName placeholderName = new PropertyName("placeholder");
    private static final PropertyName tooltipName = new PropertyName("tooltip");
    private static final PropertyName contextMenuName = new PropertyName("contextMenu");
    private static final PropertyName clipName = new PropertyName("clip");
    private static final PropertyName treeColumnName = new PropertyName("treeColumn");
    private final FXOMObject fxomObject;
    private Map<PropertyName, ComponentPropertyMetadata> propertyMetadataMap;

    public DesignHierarchyMask(FXOMObject fxomObject) {
        assert (fxomObject != null);
        this.fxomObject = fxomObject;
    }

    public FXOMObject getFxomObject() {
        return this.fxomObject;
    }

    public FXOMObject getParentFXOMObject() {
        return this.fxomObject.getParentObject();
    }

    public boolean isFxNode() {
        return this.fxomObject.getSceneGraphObject() instanceof Node;
    }

    public FXOMObject getClosestFxNode() {
        FXOMObject result = this.fxomObject;
        DesignHierarchyMask mask = this;
        while (result != null && !mask.isFxNode()) {
            result = mask.getParentFXOMObject();
            mask = result == null ? null : new DesignHierarchyMask(result);
        }
        return result;
    }

    public URL getClassNameIconURL() {
        URL url;
        Object sceneGraphObject = this.fxomObject instanceof FXOMIntrinsic ? ((FXOMIntrinsic)this.fxomObject).getSourceSceneGraphObject() : this.fxomObject.getSceneGraphObject();
        if (sceneGraphObject == null) {
            return null;
        }
        if (sceneGraphObject instanceof Separator) {
            Separator obj = (Separator)sceneGraphObject;
            url = Orientation.HORIZONTAL.equals((Object)obj.getOrientation()) ? ImageUtils.getNodeIconURL("Separator-h.png") : ImageUtils.getNodeIconURL("Separator-v.png");
        } else if (sceneGraphObject instanceof ScrollBar) {
            ScrollBar obj = (ScrollBar)sceneGraphObject;
            url = Orientation.HORIZONTAL.equals((Object)obj.getOrientation()) ? ImageUtils.getNodeIconURL("ScrollBar-h.png") : ImageUtils.getNodeIconURL("ScrollBar-v.png");
        } else if (sceneGraphObject instanceof Slider) {
            Slider obj = (Slider)sceneGraphObject;
            url = Orientation.HORIZONTAL.equals((Object)obj.getOrientation()) ? ImageUtils.getNodeIconURL("Slider-h.png") : ImageUtils.getNodeIconURL("Slider-v.png");
        } else if (sceneGraphObject instanceof SplitPane) {
            SplitPane obj = (SplitPane)sceneGraphObject;
            url = Orientation.HORIZONTAL.equals((Object)obj.getOrientation()) ? ImageUtils.getNodeIconURL("SplitPane-h.png") : ImageUtils.getNodeIconURL("SplitPane-v.png");
        } else {
            String className = sceneGraphObject.getClass().getSimpleName();
            url = ImageUtils.getNodeIconURL(className + ".png");
        }
        return url;
    }

    public Image getClassNameIcon() {
        URL resource = this.getClassNameIconURL();
        return ImageUtils.getImage(resource);
    }

    public String getClassNameInfo() {
        String classNameInfo;
        Object sceneGraphObject;
        String prefix = "";
        String suffix = "";
        if (this.fxomObject instanceof FXOMIntrinsic) {
            FXOMIntrinsic fxomIntrinsic = (FXOMIntrinsic)this.fxomObject;
            sceneGraphObject = fxomIntrinsic.getSourceSceneGraphObject();
            if (fxomIntrinsic.getType() == FXOMIntrinsic.Type.FX_INCLUDE) {
                prefix = prefix + "FXML ";
            }
        } else {
            sceneGraphObject = this.fxomObject.getSceneGraphObject();
        }
        if (sceneGraphObject == null) {
            classNameInfo = prefix + this.fxomObject.getGlueElement().getTagName() + suffix;
        } else {
            if (sceneGraphObject instanceof Node) {
                Object parentSceneGraphObject;
                FXOMObject parentFxomObject;
                Node node = (Node)sceneGraphObject;
                if (node instanceof GridPane) {
                    int columnsSize = this.getColumnsSize();
                    int rowsSize = this.getRowsSize();
                    suffix = suffix + " (" + columnsSize + " x " + rowsSize + ")";
                }
                if ((parentFxomObject = this.fxomObject.getParentObject()) != null && (parentSceneGraphObject = parentFxomObject.getSceneGraphObject()) instanceof GridPane) {
                    int columnIndex = this.getColumnIndex();
                    int rowIndex = this.getRowIndex();
                    suffix = suffix + " (" + columnIndex + ", " + rowIndex + ")";
                }
            }
            classNameInfo = prefix + sceneGraphObject.getClass().getSimpleName() + suffix;
        }
        return classNameInfo;
    }

    public String getDescription() {
        if (this.hasDescription()) {
            PropertyName propertyName = this.getPropertyNameForDescription();
            assert (propertyName != null);
            assert (this.fxomObject instanceof FXOMInstance);
            FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
            ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(fxomInstance, propertyName);
            Object description = vpm.getValueInSceneGraphObject(fxomInstance);
            return description == null ? null : description.toString();
        }
        return null;
    }

    public String getSingleLineDescription() {
        String result = this.getDescription();
        if (result != null && DesignHierarchyMask.containsLineFeed(result)) {
            result = result.substring(0, result.indexOf("\n")) + "...";
        }
        return result;
    }

    public Object getNodeIdValue() {
        Object result = null;
        if (this.fxomObject instanceof FXOMInstance) {
            FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
            PropertyName propertyName = new PropertyName("id");
            ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(fxomInstance, propertyName);
            result = vpm.getValueObject(fxomInstance);
        }
        return result;
    }

    public String getNodeId() {
        Object value = this.getNodeIdValue();
        String result = null;
        if (value != null) {
            result = value.toString();
        }
        return result;
    }

    public String getFxId() {
        String result = null;
        if (this.fxomObject instanceof FXOMInstance) {
            FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
            String fxId = fxomInstance.getFxId();
            result = fxId == null ? "" : fxId;
        }
        return result;
    }

    public boolean hasDescription() {
        Object sceneGraphObject = this.fxomObject.getSceneGraphObject();
        if (sceneGraphObject == null) {
            return false;
        }
        return sceneGraphObject instanceof ComboBox || sceneGraphObject instanceof Labeled || sceneGraphObject instanceof Menu || sceneGraphObject instanceof MenuItem || sceneGraphObject instanceof Tab || sceneGraphObject instanceof TableColumn || sceneGraphObject instanceof Text || sceneGraphObject instanceof TextInputControl || sceneGraphObject instanceof TitledPane || sceneGraphObject instanceof Tooltip || sceneGraphObject instanceof TreeTableColumn;
    }

    public boolean isResourceKey() {
        if (this.hasDescription()) {
            PropertyName propertyName = this.getPropertyNameForDescription();
            assert (propertyName != null);
            assert (this.fxomObject instanceof FXOMInstance);
            FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
            ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(fxomInstance, propertyName);
            Object description = vpm.getValueObject(fxomInstance);
            PrefixedValue pv = new PrefixedValue(description.toString());
            return pv.isResourceKey();
        }
        return false;
    }

    public boolean isFreeChildPositioning() {
        boolean result = false;
        if (this.fxomObject instanceof FXOMInstance) {
            FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
            Class<?> componentClass = fxomInstance.getDeclaredClass();
            result = componentClass == AnchorPane.class || componentClass == Group.class || componentClass == Pane.class;
        }
        return result;
    }

    public boolean isAcceptingAccessory(Accessory accessory) {
        PropertyName propertyName = this.getPropertyNameForAccessory(accessory);
        Class<?> valueClass = DesignHierarchyMask.getClassForAccessory(accessory);
        return this.isAcceptingProperty(propertyName, valueClass);
    }

    public boolean isAcceptingAccessory(Accessory accessory, FXOMObject fxomObject) {
        Object sceneGraphObject = fxomObject instanceof FXOMIntrinsic ? ((FXOMIntrinsic)fxomObject).getSourceSceneGraphObject() : fxomObject.getSceneGraphObject();
        Class<?> accessoryClass = DesignHierarchyMask.getClassForAccessory(accessory);
        return this.isAcceptingAccessory(accessory) && accessoryClass.isInstance(sceneGraphObject);
    }

    public static Class<?> getClassForAccessory(Accessory accessory) {
        Class<Node> result;
        switch (accessory) {
            case GRAPHIC: 
            case TOP: 
            case BOTTOM: 
            case LEFT: 
            case RIGHT: 
            case CENTER: 
            case PLACEHOLDER: 
            case CLIP: 
            case CONTENT: {
                result = Node.class;
                break;
            }
            case XAXIS: 
            case YAXIS: {
                result = Axis.class;
                break;
            }
            case TOOLTIP: {
                result = Tooltip.class;
                break;
            }
            case CONTEXT_MENU: {
                result = ContextMenu.class;
                break;
            }
            case TREE_COLUMN: {
                result = TreeTableColumn.class;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected accessory " + (Object)((Object)accessory));
            }
        }
        return result;
    }

    public FXOMObject getAccessory(Accessory accessory) {
        FXOMObject result;
        assert (this.isAcceptingAccessory(accessory));
        assert (this.fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        PropertyName propertyName = this.getPropertyNameForAccessory(accessory);
        FXOMProperty fxomProperty = fxomInstance.getProperties().get(propertyName);
        if (fxomProperty instanceof FXOMPropertyC) {
            FXOMPropertyC fxomPropertyC = (FXOMPropertyC)fxomProperty;
            assert (fxomPropertyC.getValues().size() >= 1) : "accessory=" + (Object)((Object)accessory);
            result = fxomPropertyC.getValues().get(0);
        } else {
            result = null;
        }
        return result;
    }

    public boolean isAcceptingSubComponent() {
        PropertyName propertyName = this.getSubComponentPropertyName();
        return propertyName != null;
    }

    public boolean isAcceptingSubComponent(FXOMObject obj) {
        boolean result;
        assert (obj != null);
        PropertyName propertyName = this.getSubComponentPropertyName();
        if (propertyName == null) {
            result = false;
        } else {
            this.queryPropertyMetadata();
            ComponentPropertyMetadata subComponentMetadata = this.propertyMetadataMap.get(propertyName);
            assert (subComponentMetadata != null);
            Class<?> subComponentClass = subComponentMetadata.getClassMetadata().getKlass();
            Object sceneGraphObject = obj instanceof FXOMIntrinsic ? ((FXOMIntrinsic)obj).getSourceSceneGraphObject() : obj.getSceneGraphObject();
            result = subComponentClass.isInstance(sceneGraphObject);
        }
        return result;
    }

    public boolean isAcceptingSubComponent(Collection<FXOMObject> fxomObjects) {
        PropertyName propertyName = this.getSubComponentPropertyName();
        if (propertyName != null) {
            this.queryPropertyMetadata();
            ComponentPropertyMetadata subComponentMetadata = this.propertyMetadataMap.get(propertyName);
            assert (subComponentMetadata != null);
            Class<?> subComponentClass = subComponentMetadata.getClassMetadata().getKlass();
            for (FXOMObject obj : fxomObjects) {
                Object sceneGraphObject;
                if (obj instanceof FXOMIntrinsic) {
                    FXOMIntrinsic intrinsicObj = (FXOMIntrinsic)obj;
                    sceneGraphObject = intrinsicObj.getSourceSceneGraphObject();
                } else {
                    sceneGraphObject = obj.getSceneGraphObject();
                }
                if (subComponentClass.isInstance(sceneGraphObject)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public PropertyName getSubComponentPropertyName() {
        PropertyName result;
        Object sceneGraphObject = this.fxomObject.getSceneGraphObject();
        if (this.fxomObject instanceof FXOMCollection) {
            result = null;
        } else if (sceneGraphObject == null) {
            result = null;
        } else {
            Class<?> componentClass = sceneGraphObject.getClass();
            ComponentClassMetadata componentClassMedadata = Metadata.getMetadata().queryComponentMetadata(componentClass);
            assert (componentClassMedadata != null);
            result = componentClassMedadata.getSubComponentProperty();
        }
        return result;
    }

    public int getSubComponentCount() {
        PropertyName name = this.getSubComponentPropertyName();
        return name == null ? 0 : this.getSubComponents().size();
    }

    public FXOMObject getSubComponentAtIndex(int i) {
        assert (0 <= i);
        assert (i < this.getSubComponentCount());
        assert (this.getSubComponentPropertyName() != null);
        return this.getSubComponents().get(i);
    }

    public List<FXOMObject> getSubComponents() {
        assert (this.getSubComponentPropertyName() != null);
        assert (this.fxomObject instanceof FXOMInstance);
        PropertyName subComponentPropertyName = this.getSubComponentPropertyName();
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        FXOMProperty fxomProperty = fxomInstance.getProperties().get(subComponentPropertyName);
        List<FXOMObject> result = fxomProperty instanceof FXOMPropertyC ? ((FXOMPropertyC)fxomProperty).getValues() : Collections.emptyList();
        return result;
    }

    public PropertyName getPropertyNameForDescription() {
        Object sceneGraphObject = this.fxomObject.getSceneGraphObject();
        if (sceneGraphObject == null) {
            return null;
        }
        PropertyName propertyName = null;
        if (sceneGraphObject instanceof ComboBox) {
            propertyName = new PropertyName("promptText");
        } else if (sceneGraphObject instanceof Labeled || sceneGraphObject instanceof Menu || sceneGraphObject instanceof MenuItem || sceneGraphObject instanceof Tab || sceneGraphObject instanceof TableColumn || sceneGraphObject instanceof TextInputControl || sceneGraphObject instanceof TitledPane || sceneGraphObject instanceof Text || sceneGraphObject instanceof Tooltip || sceneGraphObject instanceof TreeTableColumn) {
            propertyName = new PropertyName("text");
        }
        return propertyName;
    }

    public PropertyName getPropertyNameForAccessory(Accessory accessory) {
        PropertyName result;
        switch (accessory) {
            case GRAPHIC: {
                result = graphicName;
                break;
            }
            case CONTENT: {
                result = contentName;
                break;
            }
            case TOP: {
                result = topName;
                break;
            }
            case BOTTOM: {
                result = bottomName;
                break;
            }
            case LEFT: {
                result = leftName;
                break;
            }
            case RIGHT: {
                result = rightName;
                break;
            }
            case CENTER: {
                result = centerName;
                break;
            }
            case XAXIS: {
                result = xAxisName;
                break;
            }
            case YAXIS: {
                result = yAxisName;
                break;
            }
            case PLACEHOLDER: {
                result = placeholderName;
                break;
            }
            case TOOLTIP: {
                result = tooltipName;
                break;
            }
            case CONTEXT_MENU: {
                result = contextMenuName;
                break;
            }
            case CLIP: {
                result = clipName;
                break;
            }
            case TREE_COLUMN: {
                result = treeColumnName;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected accessory " + (Object)((Object)accessory));
            }
        }
        return result;
    }

    private boolean isAcceptingProperty(PropertyName propertyName, Class<?> valueClass) {
        this.queryPropertyMetadata();
        ComponentPropertyMetadata cpm = this.propertyMetadataMap.get(propertyName);
        boolean result = cpm == null ? false : valueClass.isAssignableFrom(cpm.getClassMetadata().getKlass());
        return result;
    }

    public FXOMPropertyC getAccessoryProperty(Accessory accessory) {
        assert (this.getPropertyNameForAccessory(accessory) != null);
        assert (this.fxomObject instanceof FXOMInstance);
        PropertyName accessoryPropertyName = this.getPropertyNameForAccessory(accessory);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        FXOMProperty result = fxomInstance.getProperties().get(accessoryPropertyName);
        assert (result == null || result instanceof FXOMPropertyC);
        return (FXOMPropertyC)result;
    }

    private void queryPropertyMetadata() {
        if (this.propertyMetadataMap == null) {
            FXOMInstance fxomInstance;
            this.propertyMetadataMap = new HashMap<PropertyName, ComponentPropertyMetadata>();
            if (this.fxomObject instanceof FXOMInstance && (fxomInstance = (FXOMInstance)this.fxomObject).getSceneGraphObject() != null) {
                Class<?> componentClass = fxomInstance.getSceneGraphObject().getClass();
                for (ComponentPropertyMetadata cpm : Metadata.getMetadata().queryComponentProperties(componentClass)) {
                    this.propertyMetadataMap.put(cpm.getName(), cpm);
                }
            }
        }
        assert (this.propertyMetadataMap != null);
    }

    public int getColumnsConstraintsSize() {
        int result;
        assert (this.fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        assert (fxomInstance.getSceneGraphObject() instanceof GridPane);
        PropertyName propertyName = new PropertyName("columnConstraints");
        FXOMProperty fxomProperty = fxomInstance.getProperties().get(propertyName);
        if (fxomProperty == null) {
            result = 0;
        } else {
            assert (fxomProperty instanceof FXOMPropertyC);
            FXOMPropertyC fxomPropertyC = (FXOMPropertyC)fxomProperty;
            result = fxomPropertyC.getValues().size();
        }
        return result;
    }

    public int getRowsConstraintsSize() {
        int result;
        assert (this.fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        assert (fxomInstance.getSceneGraphObject() instanceof GridPane);
        PropertyName propertyName = new PropertyName("rowConstraints");
        FXOMProperty fxomProperty = fxomInstance.getProperties().get(propertyName);
        if (fxomProperty == null) {
            result = 0;
        } else {
            assert (fxomProperty instanceof FXOMPropertyC);
            FXOMPropertyC fxomPropertyC = (FXOMPropertyC)fxomProperty;
            result = fxomPropertyC.getValues().size();
        }
        return result;
    }

    public int getColumnsSize() {
        assert (this.fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        assert (fxomInstance.getSceneGraphObject() instanceof GridPane);
        int constraintsSize = this.getColumnsConstraintsSize();
        int maxColumnIndex = -1;
        int count = this.getSubComponentCount();
        for (int i = 0; i < count; ++i) {
            DesignHierarchyMask childMask;
            FXOMObject childObject = this.getSubComponentAtIndex(i);
            if (childObject.getSceneGraphObject() == null || maxColumnIndex >= (childMask = new DesignHierarchyMask(childObject)).getColumnIndex()) continue;
            maxColumnIndex = childMask.getColumnIndex();
        }
        return Math.max(constraintsSize, maxColumnIndex + 1);
    }

    public int getRowsSize() {
        assert (this.fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        assert (fxomInstance.getSceneGraphObject() instanceof GridPane);
        int constraintsSize = this.getRowsConstraintsSize();
        int maxRowIndex = -1;
        int count = this.getSubComponentCount();
        for (int i = 0; i < count; ++i) {
            DesignHierarchyMask childMask;
            FXOMObject childObject = this.getSubComponentAtIndex(i);
            if (childObject.getSceneGraphObject() == null || maxRowIndex >= (childMask = new DesignHierarchyMask(childObject)).getRowIndex()) continue;
            maxRowIndex = childMask.getRowIndex();
        }
        return Math.max(constraintsSize, maxRowIndex + 1);
    }

    public List<FXOMObject> getColumnContentAtIndex(int index) {
        assert (0 <= index);
        assert (this.fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        assert (fxomInstance.getSceneGraphObject() instanceof GridPane);
        ArrayList<FXOMObject> result = new ArrayList<FXOMObject>();
        int count = this.getSubComponentCount();
        for (int i = 0; i < count; ++i) {
            FXOMObject childObject = this.getSubComponentAtIndex(i);
            DesignHierarchyMask childMask = new DesignHierarchyMask(childObject);
            if (childMask.getColumnIndex() != index) continue;
            result.add(childObject);
        }
        return result;
    }

    public List<FXOMObject> getRowContentAtIndex(int index) {
        assert (0 <= index);
        assert (this.fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        assert (fxomInstance.getSceneGraphObject() instanceof GridPane);
        ArrayList<FXOMObject> result = new ArrayList<FXOMObject>();
        int count = this.getSubComponentCount();
        for (int i = 0; i < count; ++i) {
            FXOMObject childObject = this.getSubComponentAtIndex(i);
            DesignHierarchyMask childMask = new DesignHierarchyMask(childObject);
            if (childMask.getRowIndex() != index) continue;
            result.add(childObject);
        }
        return result;
    }

    public FXOMObject getColumnConstraintsAtIndex(int index) {
        assert (0 <= index);
        assert (this.fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        assert (fxomInstance.getSceneGraphObject() instanceof GridPane);
        FXOMObject result = null;
        PropertyName propertyName = new PropertyName("columnConstraints");
        FXOMProperty constraintsProperty = fxomInstance.getProperties().get(propertyName);
        if (constraintsProperty != null) {
            assert (constraintsProperty instanceof FXOMPropertyC);
            List<FXOMObject> constraintsValues = ((FXOMPropertyC)constraintsProperty).getValues();
            if (index < constraintsValues.size()) {
                result = constraintsValues.get(index);
            }
        }
        return result;
    }

    public FXOMObject getRowConstraintsAtIndex(int index) {
        assert (0 <= index);
        assert (this.fxomObject instanceof FXOMInstance);
        FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
        assert (fxomInstance.getSceneGraphObject() instanceof GridPane);
        FXOMObject result = null;
        PropertyName propertyName = new PropertyName("rowConstraints");
        FXOMProperty constraintsProperty = fxomInstance.getProperties().get(propertyName);
        if (constraintsProperty != null) {
            assert (constraintsProperty instanceof FXOMPropertyC);
            List<FXOMObject> constraintsValues = ((FXOMPropertyC)constraintsProperty).getValues();
            if (index < constraintsValues.size()) {
                result = constraintsValues.get(index);
            }
        }
        return result;
    }

    public int getColumnIndex() {
        int result;
        if (this.fxomObject instanceof FXOMInstance) {
            assert (this.fxomObject.getSceneGraphObject() != null);
            FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
            FXOMObject parentFxomObject = fxomInstance.getParentObject();
            assert (parentFxomObject.getSceneGraphObject() instanceof GridPane);
            PropertyName propertyName = new PropertyName("columnIndex", GridPane.class);
            ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(fxomInstance, propertyName);
            Object value = vpm.getValueObject(fxomInstance);
            if (value == null) {
                result = 0;
            } else {
                assert (value instanceof Integer);
                result = (Integer)value;
            }
        } else {
            result = 0;
        }
        return result;
    }

    public int getRowIndex() {
        int result;
        if (this.fxomObject instanceof FXOMInstance) {
            assert (this.fxomObject.getSceneGraphObject() != null);
            FXOMInstance fxomInstance = (FXOMInstance)this.fxomObject;
            FXOMObject parentFxomObject = fxomInstance.getParentObject();
            assert (parentFxomObject.getSceneGraphObject() instanceof GridPane);
            PropertyName propertyName = new PropertyName("rowIndex", GridPane.class);
            ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(fxomInstance, propertyName);
            Object value = vpm.getValueObject(fxomInstance);
            if (value == null) {
                result = 0;
            } else {
                assert (value instanceof Integer);
                result = (Integer)value;
            }
        } else {
            result = 0;
        }
        return result;
    }

    public static boolean containsLineFeed(String str) {
        if (str == null) {
            return false;
        }
        return str.contains("\n");
    }

    public boolean needResizeWhenTopElement() {
        return (this.isAcceptingSubComponent() || this.isAcceptingAccessory(Accessory.CONTENT) || this.isAcceptingAccessory(Accessory.CENTER) || this.isAcceptingAccessory(Accessory.TOP) || this.isAcceptingAccessory(Accessory.RIGHT) || this.isAcceptingAccessory(Accessory.BOTTOM) || this.isAcceptingAccessory(Accessory.LEFT)) && !(this.fxomObject.getSceneGraphObject() instanceof MenuButton) && !(this.fxomObject.getSceneGraphObject() instanceof MenuBar) && !(this.fxomObject.getSceneGraphObject() instanceof ToolBar);
    }

    public static enum Accessory {
        PLACEHOLDER,
        TOOLTIP,
        CONTEXT_MENU,
        CLIP,
        GRAPHIC,
        CONTENT,
        TOP,
        BOTTOM,
        LEFT,
        RIGHT,
        CENTER,
        XAXIS,
        YAXIS,
        TREE_COLUMN;

    }
}

