/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import com.sun.javafx.css.CompoundSelector;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.SimpleSelector;
import com.sun.javafx.css.Style;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.parser.CSSParser;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javafx.beans.property.ReadOnlyProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.Parent;

public class CssInternal {
    private static final URL caspianThemeUrl = Deprecation.getCaspianStylesheetURL();
    private static final URL caspianHighContrastThemeUrl = Deprecation.getCaspianHighContrastStylesheetURL();
    private static final URL caspianEmbeddedThemeUrl = Deprecation.getCaspianEmbeddedStylesheetURL();
    private static final URL caspianEmbeddedQVGAThemeUrl = Deprecation.getCaspianEmbeddedQVGAStylesheetURL();
    private static final URL modenaThemeUrl = Deprecation.getModenaStylesheetURL();
    private static final URL modenaTouchThemeUrl = Deprecation.getModenaTouchStylesheetURL();
    private static final URL modenaHighContrastBlackonwhiteThemeUrl = Deprecation.getModenaHighContrastBlackonwhiteStylesheetURL();
    private static final URL modenaHighContrastWhiteonblackThemeUrl = Deprecation.getModenaHighContrastWhiteonblackStylesheetURL();
    private static final URL modenaHighContrastYellowonblackThemeUrl = Deprecation.getModenaHighContrastYellowonblackStylesheetURL();
    private static final URL[] themeUrls = new URL[]{caspianThemeUrl, caspianHighContrastThemeUrl, caspianEmbeddedThemeUrl, caspianEmbeddedQVGAThemeUrl, modenaThemeUrl, modenaTouchThemeUrl, modenaHighContrastBlackonwhiteThemeUrl, modenaHighContrastWhiteonblackThemeUrl, modenaHighContrastYellowonblackThemeUrl};

    public static boolean isThemeStyle(Style style) {
        return CssInternal.isThemeRule(style.getDeclaration().getRule());
    }

    public static boolean isCaspianTheme(Style style) {
        return style.getDeclaration().getRule().getStylesheet().getUrl().equals(caspianThemeUrl.toString());
    }

    public static boolean isModenaTheme(Style style) {
        return style.getDeclaration().getRule().getStylesheet().getUrl().equals(modenaThemeUrl.toString());
    }

    public static String getThemeDisplayName(Style style) {
        String themeName = "";
        String url = style.getDeclaration().getRule().getStylesheet().getUrl();
        if (url.contains("modena")) {
            themeName = themeName + "modena/";
        } else if (url.contains("caspian")) {
            themeName = themeName + "caspian/";
        }
        File file = new File(url);
        themeName = themeName + file.getName().replace(".bss", ".css");
        if (themeName.endsWith("modena.css")) {
            themeName = "modena.css";
        } else if (themeName.endsWith("caspian.css")) {
            themeName = "caspian.css";
        }
        return themeName;
    }

    public static boolean isThemeRule(Rule rule) {
        if (rule.getOrigin() == StyleOrigin.AUTHOR) {
            String stylePath = rule.getStylesheet().getUrl();
            assert (stylePath != null);
            for (URL themeUrl : themeUrls) {
                if (!stylePath.equals(themeUrl.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isThemeClass(EditorPlatform.Theme theme, String styleClass) {
        return CssInternal.getThemeStyleClasses(theme).contains(styleClass);
    }

    public static List<String> getThemeStyleClasses(EditorPlatform.Theme theme) {
        List<URL> themeStyleSheets = EditorPlatform.getThemeStylesheetURLs(theme);
        themeStyleSheets.add(EditorPlatform.getPlatformThemeStylesheetURL());
        HashSet<String> themeClasses = new HashSet<String>();
        for (URL themeStyleSheet : themeStyleSheets) {
            themeClasses.addAll(CssInternal.getStyleClasses(Deprecation.getThemeTextStylesheet(themeStyleSheet)));
        }
        return new ArrayList<String>(themeClasses);
    }

    public static String getStyleSheet(Map<String, String> styleClassMap, String styleClass) {
        return styleClassMap.get(styleClass);
    }

    public static List<String> getStyleClasses(EditorController editorController, Set<FXOMInstance> instances) {
        return new ArrayList<String>(CssInternal.getStyleClassesMap(editorController, instances).keySet());
    }

    public static Map<String, String> getStyleClassesMap(EditorController editorController, Set<FXOMInstance> instances) {
        HashMap<String, String> classesMap = new HashMap<String, String>();
        Object fxRoot = null;
        for (FXOMInstance instance : instances) {
            if (fxRoot == null) {
                fxRoot = instance.getFxomDocument().getSceneGraphRoot();
            }
            Object fxObject = instance.getSceneGraphObject();
            classesMap.putAll(CssInternal.getFxObjectClassesMap(fxObject, fxRoot));
        }
        ObservableList<File> sceneStyleSheets = editorController.getSceneStyleSheets();
        if (sceneStyleSheets != null) {
            for (File stylesheet : sceneStyleSheets) {
                try {
                    URL stylesheetUrl = stylesheet.toURI().toURL();
                    for (String styleClass : CssInternal.getStyleClasses(stylesheetUrl)) {
                        classesMap.put(styleClass, stylesheetUrl.toExternalForm());
                    }
                }
                catch (MalformedURLException ex) {
                    return classesMap;
                }
            }
        }
        return classesMap;
    }

    private static Map<String, String> getFxObjectClassesMap(Object fxObject, Object fxRoot) {
        HashMap<String, String> classesMap = new HashMap<String, String>();
        classesMap.putAll(CssInternal.getSingleFxObjectClassesMap(fxObject));
        if (!(fxObject instanceof Node)) {
            return classesMap;
        }
        Node node = (Node)fxObject;
        if (node == fxRoot) {
            return classesMap;
        }
        while (node.getParent() != null) {
            node = node.getParent();
            classesMap.putAll(CssInternal.getSingleFxObjectClassesMap(node));
            if (node != fxRoot) continue;
            break;
        }
        return classesMap;
    }

    private static Map<String, String> getSingleFxObjectClassesMap(Object fxObject) {
        HashMap<String, String> classesMap = new HashMap<String, String>();
        if (fxObject instanceof Parent) {
            ObservableList stylesheets = ((Parent)fxObject).getStylesheets();
            for (String stylesheet : stylesheets) {
                try {
                    for (String styleClass : CssInternal.getStyleClasses(new URL(stylesheet))) {
                        classesMap.put(styleClass, stylesheet);
                    }
                }
                catch (MalformedURLException ex) {
                    return classesMap;
                }
            }
        }
        return classesMap;
    }

    private static Set<String> getStyleClasses(URL url) {
        Stylesheet s;
        HashSet<String> styleClasses = new HashSet<String>();
        try {
            s = CSSParser.getInstance().parse(url);
        }
        catch (IOException ex) {
            System.out.println("Warning: Invalid Stylesheet " + url);
            return styleClasses;
        }
        if (s == null) {
            return styleClasses;
        }
        for (Rule r : s.getRules()) {
            for (Selector ss : r.getSelectors()) {
                if (ss instanceof SimpleSelector) {
                    SimpleSelector simple = (SimpleSelector)ss;
                    styleClasses.addAll(simple.getStyleClasses());
                    continue;
                }
                if (!(ss instanceof CompoundSelector)) continue;
                CompoundSelector cs = (CompoundSelector)ss;
                for (Selector selector : cs.getSelectors()) {
                    if (!(selector instanceof SimpleSelector)) continue;
                    SimpleSelector simple = (SimpleSelector)selector;
                    styleClasses.addAll(simple.getStyleClasses());
                }
            }
        }
        return styleClasses;
    }

    public static List<String> getCssProperties(Set<Class<?>> classes) {
        TreeSet<String> cssProperties = new TreeSet<String>();
        for (Class<?> clazz : classes) {
            Object metadatas;
            block5: {
                if (!Node.class.isAssignableFrom(clazz)) continue;
                metadatas = null;
                try {
                    metadatas = clazz.getMethod("getClassCssMetaData", new Class[0]).invoke(null, (Object[])null);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            for (CssMetaData metadata : (List)metadatas) {
                cssProperties.add(metadata.getProperty());
                if (metadata.getSubProperties() == null) continue;
                for (CssMetaData subMetadata : metadata.getSubProperties()) {
                    cssProperties.add(subMetadata.getProperty());
                }
            }
        }
        return new ArrayList<String>(cssProperties);
    }

    public static CssPropAuthorInfo getCssInfo(Object fxObject, ValuePropertyMetadata prop) {
        CssPropAuthorInfo info = null;
        Node node = null;
        if (fxObject instanceof Node) {
            node = (Node)fxObject;
        } else {
            Styleable styleable;
            Styleable styleable2 = styleable = fxObject instanceof Styleable ? (Styleable)fxObject : null;
            if (styleable != null) {
                node = Deprecation.getNode(styleable);
            }
        }
        if (node != null) {
            info = CssInternal.getCssInfoForNode(node, prop);
        }
        return info;
    }

    private static CssPropAuthorInfo getCssInfoForNode(Node node, ValuePropertyMetadata prop) {
        Map<StyleableProperty, List<Style>> map = CssInternal.collectCssState(node);
        for (Map.Entry<StyleableProperty, List<Style>> entry : map.entrySet()) {
            StyleableProperty beanProp = entry.getKey();
            ArrayList styles = new ArrayList(entry.getValue());
            String name = CssInternal.getBeanPropertyName(beanProp);
            if (!name.equals(prop.getName().getName()) || !name.equals(prop.getName().getName())) continue;
            StyleOrigin origin = beanProp.getStyleOrigin();
            if (origin == null || origin.equals((Object)StyleOrigin.USER) || origin.equals((Object)StyleOrigin.USER_AGENT)) {
                return null;
            }
            CssMetaData styleable = beanProp.getCssMetaData();
            CssPropAuthorInfo info = null;
            for (Style style : styles) {
                Rule rule = style.getDeclaration().getRule();
                assert (rule != null);
                StyleOrigin o = rule.getOrigin();
                if (o == null) {
                    return null;
                }
                if ((!o.equals((Object)StyleOrigin.AUTHOR) || CssInternal.isThemeStyle(style)) && !o.equals((Object)StyleOrigin.INLINE)) continue;
                if (info == null) {
                    info = new CssPropAuthorInfo(prop, beanProp, styleable);
                }
                info.getStyles().add(style);
            }
            return info;
        }
        return null;
    }

    public static boolean isCssRuled(Object fxObject, ValuePropertyMetadata prop) {
        return CssInternal.getCssInfo(fxObject, prop) != null;
    }

    public static String getBeanPropertyName(StyleableProperty<?> val) {
        String property = null;
        if (val instanceof ReadOnlyProperty) {
            property = ((ReadOnlyProperty)val).getName();
        }
        return property;
    }

    public static void attachMapToNode(Node node) {
        HashMap smap = new HashMap();
        Deprecation.setStyleMap(node, FXCollections.observableMap(smap));
    }

    public static void detachMapToNode(Node node) {
        Deprecation.setStyleMap(node, null);
    }

    public static Map<StyleableProperty, List<Style>> collectCssState(Node node) {
        CssInternal.attachMapToNode(node);
        node.applyCss();
        HashMap<StyleableProperty, List<Style>> ret = new HashMap<StyleableProperty, List<Style>>();
        ret.putAll((Map<StyleableProperty, List<Style>>)Deprecation.getStyleMap(node));
        CssInternal.detachMapToNode(node);
        return ret;
    }

    public static StyleOrigin getOrigin(Style style) {
        if (style == null || style.getDeclaration() == null) {
            return null;
        }
        return CssInternal.getOrigin(style.getDeclaration().getRule());
    }

    public static StyleOrigin getOrigin(Rule rule) {
        if (rule == null) {
            return null;
        }
        if (CssInternal.isThemeRule(rule)) {
            return StyleOrigin.USER_AGENT;
        }
        return rule.getOrigin();
    }

    public static String getThemeDisplayName(String url) {
        String themeName = "";
        if (url.contains("modena")) {
            themeName = themeName + "modena/";
        } else if (url.contains("caspian")) {
            themeName = themeName + "caspian/";
        }
        File file = new File(url);
        themeName = themeName + file.getName().replace(".bss", ".css");
        if (themeName.endsWith("modena.css")) {
            themeName = "modena.css";
        } else if (themeName.endsWith("caspian.css")) {
            themeName = "caspian.css";
        }
        return themeName;
    }

    public static class CssPropAuthorInfo {
        private final ValuePropertyMetadata prop;
        private final CssMetaData<?, ?> styleable;
        private final StyleableProperty<?> value;
        private final Object val;
        private final List<Style> styles = new ArrayList<Style>();

        public CssPropAuthorInfo(ValuePropertyMetadata prop, StyleableProperty<?> value, CssMetaData<?, ?> styleable) {
            this(prop, value, styleable, null);
        }

        private CssPropAuthorInfo(ValuePropertyMetadata prop, StyleableProperty<?> value, CssMetaData<?, ?> styleable, Object val) {
            this.prop = prop;
            this.styleable = styleable;
            this.value = value;
            this.val = val;
        }

        public CssPropAuthorInfo(StyleableProperty<?> val, CssMetaData<?, ?> styleable, Object value) {
            this(null, val, styleable, value);
        }

        public StyleOrigin getOrigin() {
            return this.value.getStyleOrigin();
        }

        public URL getMainUrl() {
            if (this.getStyles().isEmpty()) {
                return null;
            }
            Rule rule = this.getStyles().get(0).getDeclaration().getRule();
            if (rule == null) {
                return null;
            }
            try {
                return new URL(rule.getStylesheet().getUrl());
            }
            catch (MalformedURLException ex) {
                System.out.println(ex.getMessage() + " " + ex);
                return null;
            }
        }

        public List<Style> getStyles() {
            return this.styles;
        }

        public Object getFxValue() {
            return this.val != null ? this.val : this.value.getValue();
        }

        public boolean isInline() {
            StyleOrigin o = this.getOrigin();
            return o != null && o.equals((Object)StyleOrigin.INLINE);
        }

        public ValuePropertyMetadata getProp() {
            return this.prop;
        }

        public CssMetaData<?, ?> getCssProp() {
            return this.styleable;
        }
    }
}

