/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util;

import com.sun.glass.ui.Application;
import com.sun.javafx.css.Style;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.fxml.LoadListener;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.scene.control.skin.MenuBarSkin;
import com.sun.javafx.scene.input.PickResultChooser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javafx.collections.ObservableMap;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PopupControl;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.image.Image;
import javafx.scene.layout.GridPane;

public class Deprecation {
    private Deprecation() {
        assert (false);
    }

    public static Group createGroupWithNullParentStylesheets() {
        return new Group(){

            public List<String> impl_getAllParentStylesheets() {
                return null;
            }
        };
    }

    public static void setStyleMap(Node node, ObservableMap<StyleableProperty<?>, List<Style>> map) {
        node.impl_setStyleMap(map);
    }

    public static ObservableMap<StyleableProperty<?>, List<Style>> getStyleMap(Node node) {
        return node.impl_getStyleMap();
    }

    public static void reapplyCSS(Scene scene) {
        assert (scene != null);
        StyleManager.getInstance().forget(scene);
        scene.getRoot().impl_reapplyCSS();
    }

    public static Node getNode(Styleable styleable) {
        try {
            if (styleable instanceof MenuItem) {
                return ((MenuItem)styleable).impl_styleableGetNode();
            }
            if (styleable instanceof PopupControl) {
                return ((PopupControl)styleable).impl_styleableGetNode();
            }
            if (styleable instanceof TableColumn) {
                return ((TableColumn)styleable).impl_styleableGetNode();
            }
            if (styleable instanceof TreeTableColumn) {
                return ((TreeTableColumn)styleable).impl_styleableGetNode();
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }

    public static List<Style> getMatchingStyles(CssMetaData cssMetaData, Styleable styleable) {
        return Node.impl_getMatchingStyles((CssMetaData)cssMetaData, (Styleable)styleable);
    }

    public static String getUrl(Image image) {
        return image.impl_getUrl();
    }

    public static void setStaticLoad(FXMLLoader loader, boolean staticLoad) {
        loader.impl_setStaticLoad(staticLoad);
    }

    public static void setLoadListener(FXMLLoader loader, LoadListener loadListener) {
        loader.impl_setLoadListener(loadListener);
    }

    public static Node pick(Node node, double sceneX, double sceneY) {
        Point2D p = node.sceneToLocal(sceneX, sceneY);
        PickRay pickRay = new PickRay(p.getX(), p.getY(), 1.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        PickResultChooser prc = new PickResultChooser();
        node.impl_pickNode(pickRay, prc);
        return prc.getIntersectedNode();
    }

    public static void setDefaultSystemMenuBar(MenuBar menuBar) {
        MenuBarSkin.setDefaultSystemMenuBar((MenuBar)menuBar);
    }

    public static void setPlatformEventHandler(Application.EventHandler eventHandler) {
        Application.GetApplication().setEventHandler(eventHandler);
    }

    public static Application.EventHandler getPlatformEventHandler() {
        return Application.GetApplication().getEventHandler();
    }

    public static int getGridPaneColumnCount(GridPane gridPane) {
        return gridPane.impl_getColumnCount();
    }

    public static int getGridPaneRowCount(GridPane gridPane) {
        return gridPane.impl_getRowCount();
    }

    public static Bounds getGridPaneCellBounds(GridPane gridPane, int c, int r) {
        return gridPane.impl_getCellBounds(c, r);
    }

    public static void setTableColumnReordable(TableColumn tableColumn, boolean reordable) {
        tableColumn.impl_setReorderable(reordable);
    }

    public static Group makeStylingIsolationGroupA() {
        Group result = new Group(){

            public List<String> impl_getAllParentStylesheets() {
                return null;
            }
        };
        return result;
    }

    public static Group makeStylingIsolationGroupB() {
        Group result = new Group(){

            public Styleable getStyleableParent() {
                return null;
            }
        };
        result.getStyleClass().add((Object)"root");
        result.getStylesheets().add((Object)Deprecation.getModenaStylesheetURL().toString());
        return result;
    }

    public static URL getCaspianStylesheetURL() {
        String resourceName = "com/sun/javafx/scene/control/skin/caspian/caspian.bss";
        return ClassLoader.getSystemResource("com/sun/javafx/scene/control/skin/caspian/caspian.bss");
    }

    public static URL getCaspianHighContrastStylesheetURL() {
        String resourceName = "com/sun/javafx/scene/control/skin/caspian/highcontrast.bss";
        return ClassLoader.getSystemResource("com/sun/javafx/scene/control/skin/caspian/highcontrast.bss");
    }

    public static URL getCaspianEmbeddedStylesheetURL() {
        String resourceName = "com/sun/javafx/scene/control/skin/caspian/embedded.bss";
        return ClassLoader.getSystemResource("com/sun/javafx/scene/control/skin/caspian/embedded.bss");
    }

    public static URL getCaspianEmbeddedQVGAStylesheetURL() {
        String resourceName = "com/sun/javafx/scene/control/skin/caspian/embedded-qvga.bss";
        return ClassLoader.getSystemResource("com/sun/javafx/scene/control/skin/caspian/embedded-qvga.bss");
    }

    public static URL getModenaStylesheetURL() {
        String resourceName = "com/sun/javafx/scene/control/skin/modena/modena.bss";
        return ClassLoader.getSystemResource("com/sun/javafx/scene/control/skin/modena/modena.bss");
    }

    public static URL getModenaTouchStylesheetURL() {
        String resourceName = "com/sun/javafx/scene/control/skin/modena/touch.bss";
        return ClassLoader.getSystemResource("com/sun/javafx/scene/control/skin/modena/touch.bss");
    }

    public static URL getModenaHighContrastBlackonwhiteStylesheetURL() {
        String resourceName = "com/sun/javafx/scene/control/skin/modena/blackOnWhite.css";
        return ClassLoader.getSystemResource("com/sun/javafx/scene/control/skin/modena/blackOnWhite.css");
    }

    public static URL getModenaHighContrastWhiteonblackStylesheetURL() {
        String resourceName = "com/sun/javafx/scene/control/skin/modena/whiteOnBlack.css";
        return ClassLoader.getSystemResource("com/sun/javafx/scene/control/skin/modena/whiteOnBlack.css");
    }

    public static URL getModenaHighContrastYellowonblackStylesheetURL() {
        String resourceName = "com/sun/javafx/scene/control/skin/modena/yellowOnBlack.css";
        return ClassLoader.getSystemResource("com/sun/javafx/scene/control/skin/modena/yellowOnBlack.css");
    }

    public static URL getThemeTextStylesheet(URL binaryStylesheetUrl) {
        String binaryCssUrlStr = binaryStylesheetUrl.toExternalForm();
        String textCssUrlStr = binaryCssUrlStr.replaceAll(".bss", ".css");
        try {
            return new URL(textCssUrlStr);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public static JavaFXBuilderFactory newJavaFXBuilderFactory(ClassLoader classLoader) {
        return new JavaFXBuilderFactory(classLoader, false);
    }
}

