/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.effectpicker;

import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPathItem;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPickerController;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.ToggleGroup;
import javafx.scene.effect.Blend;
import javafx.scene.effect.Effect;

public class BlendPathItem
extends EffectPathItem {
    private final RadioMenuItem topMenuItem = new RadioMenuItem("TopInput");
    private final RadioMenuItem bottomMenuItem = new RadioMenuItem("BottomInput");
    private final ToggleGroup inputToggleGroup = new ToggleGroup();
    private EffectPathItem topInputPathItem;
    private EffectPathItem bottomInputPathItem;

    public BlendPathItem(EffectPickerController epc, Effect effect, EffectPathItem hostPathItem) {
        super(epc, effect, hostPathItem);
        assert (effect instanceof Blend);
        this.initialize();
    }

    @Override
    EffectPathItem getSelectedInputPathItem() {
        if (this.topMenuItem.isSelected()) {
            return this.topInputPathItem;
        }
        assert (this.bottomMenuItem.isSelected());
        return this.bottomInputPathItem;
    }

    @Override
    void setSelectedInputEffect(Effect input) {
        if (this.topMenuItem.isSelected()) {
            this.setTopInput(input);
        } else {
            assert (this.bottomMenuItem.isSelected());
            this.setBottomInput(input);
        }
    }

    void setTopInputPathItem(EffectPathItem epi) {
        this.topInputPathItem = epi;
    }

    void setBottomInputPathItem(EffectPathItem epi) {
        this.bottomInputPathItem = epi;
    }

    Effect getTopInput() {
        return ((Blend)this.effect).getTopInput();
    }

    void setTopInput(Effect input) {
        ((Blend)this.effect).setTopInput(input);
    }

    Effect getBottomInput() {
        return ((Blend)this.effect).getBottomInput();
    }

    void setBottomInput(Effect input) {
        ((Blend)this.effect).setBottomInput(input);
    }

    private void initialize() {
        Menu inputMenu = new Menu("Select Input");
        this.topMenuItem.setToggleGroup(this.inputToggleGroup);
        this.topMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                BlendPathItem.this.toggle_button.setText(BlendPathItem.this.getSimpleName() + " (TopInput)");
                BlendPathItem.this.effectPickerController.updateUI(BlendPathItem.this);
            }
        });
        this.bottomMenuItem.setToggleGroup(this.inputToggleGroup);
        this.bottomMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                BlendPathItem.this.toggle_button.setText(BlendPathItem.this.getSimpleName() + " (BottomInput)");
                BlendPathItem.this.effectPickerController.updateUI(BlendPathItem.this);
            }
        });
        inputMenu.getItems().addAll((Object[])new MenuItem[]{this.topMenuItem, this.bottomMenuItem});
        this.menu_button.getItems().add(0, (Object)inputMenu);
        this.menu_button.getItems().add(1, (Object)new SeparatorMenuItem());
        this.toggle_button.setText(this.getSimpleName() + " (TopInput)");
        this.topMenuItem.setSelected(true);
        this.bottomMenuItem.setSelected(false);
    }
}

