/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.effectpicker;

import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPickerController;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.LightingPathItem;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.Utils;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;

public abstract class EffectPathItem
extends HBox {
    @FXML
    protected ImageView image_view;
    @FXML
    protected MenuButton menu_button;
    @FXML
    protected ToggleButton toggle_button;
    @FXML
    protected Tooltip tool_tip;
    @FXML
    public MenuItem delete_menuitem;
    @FXML
    public MenuItem delete_input_menuitem;
    @FXML
    public Menu replace_input_menu;
    protected final Effect effect;
    protected final EffectPathItem parentPahItem;
    protected final EffectPickerController effectPickerController;

    public EffectPathItem(EffectPickerController epc, Effect effect, EffectPathItem parentPahItem) {
        assert (epc != null);
        assert (effect != null);
        this.effectPickerController = epc;
        this.parentPahItem = parentPahItem;
        this.effect = effect;
        this.initialize();
    }

    public Effect getValue() {
        return this.effect;
    }

    ToggleButton getToggleButton() {
        return this.toggle_button;
    }

    abstract EffectPathItem getSelectedInputPathItem();

    Effect getSelectedInputEffect() {
        return this.getSelectedInputPathItem() == null ? null : this.getSelectedInputPathItem().getValue();
    }

    abstract void setSelectedInputEffect(Effect var1);

    String getSimpleName() {
        return this.effect.getClass().getSimpleName();
    }

    @FXML
    void deleteEffect(ActionEvent event) {
        if (this.parentPahItem != null) {
            Effect inputEffect = this.getSelectedInputEffect();
            this.parentPahItem.setSelectedInputEffect(inputEffect);
        } else {
            this.effectPickerController.setRootEffectProperty(null);
        }
        this.effectPickerController.incrementRevision();
        this.effectPickerController.updateUI();
    }

    @FXML
    void deleteEffectInput(ActionEvent event) {
        this.setSelectedInputEffect(null);
        this.effectPickerController.incrementRevision();
        this.effectPickerController.updateUI();
    }

    @FXML
    void replaceEffect(ActionEvent event) {
        MenuItem menuItem = (MenuItem)event.getSource();
        String text = menuItem.getText();
        Effect newEffect = Utils.newInstance(text);
        Effect inputEffect = this.getSelectedInputEffect();
        Utils.setDefaultInput(newEffect, inputEffect);
        if (this.parentPahItem != null) {
            this.parentPahItem.setSelectedInputEffect(newEffect);
        } else {
            this.effectPickerController.setRootEffectProperty(newEffect);
        }
        this.effectPickerController.incrementRevision();
        this.effectPickerController.updateUI();
    }

    @FXML
    void replaceEffectInput(ActionEvent event) {
        MenuItem menuItem = (MenuItem)event.getSource();
        String text = menuItem.getText();
        Effect newEffect = Utils.newInstance(text);
        this.setSelectedInputEffect(newEffect);
        this.effectPickerController.incrementRevision();
        this.effectPickerController.updateUI();
    }

    @FXML
    void selectEffect(ActionEvent event) {
        this.effectPickerController.selectEffectPathItem(this);
    }

    private void initialize() {
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(EffectPathItem.class.getResource("EffectPathItem.fxml"));
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        try {
            loader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(EffectPathItem.class.getName()).log(Level.SEVERE, null, ex);
        }
        assert (this.image_view != null);
        assert (this.menu_button != null);
        assert (this.toggle_button != null);
        assert (this.tool_tip != null);
        assert (this.delete_menuitem != null);
        assert (this.delete_input_menuitem != null);
        assert (this.replace_input_menu != null);
        ToggleGroup toggleGroup = this.effectPickerController.getEffectToggleGroup();
        this.toggle_button.setToggleGroup(toggleGroup);
        this.toggle_button.setText(this.getSimpleName());
        URL url = EffectPathItem.class.getResource("images/" + this.effect.getClass().getSimpleName() + ".png");
        Image img = new Image(url.toExternalForm());
        this.image_view.setImage(img);
        this.menu_button.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    if (EffectPathItem.this instanceof LightingPathItem) {
                        EffectPathItem.this.delete_input_menuitem.setDisable(true);
                    } else {
                        EffectPathItem.this.delete_input_menuitem.setDisable(false);
                    }
                    if (EffectPathItem.this.parentPahItem instanceof LightingPathItem) {
                        EffectPathItem.this.delete_menuitem.setDisable(true);
                    } else {
                        EffectPathItem.this.delete_menuitem.setDisable(false);
                    }
                }
            }
        });
    }
}

