/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.effectpicker;

import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPickerController;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.Utils;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.PaintPicker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.effect.Blend;
import javafx.scene.effect.Bloom;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.ColorInput;
import javafx.scene.effect.DisplacementMap;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.effect.Glow;
import javafx.scene.effect.ImageInput;
import javafx.scene.effect.InnerShadow;
import javafx.scene.effect.Lighting;
import javafx.scene.effect.MotionBlur;
import javafx.scene.effect.PerspectiveTransform;
import javafx.scene.effect.Reflection;
import javafx.scene.effect.SepiaTone;
import javafx.scene.effect.Shadow;
import javafx.scene.layout.Pane;

public class EffectPicker
extends Pane {
    private final EffectPickerController controller;
    private static List<Class<? extends Effect>> effectClasses;

    public static synchronized Collection<Class<? extends Effect>> getEffectClasses() {
        if (effectClasses == null) {
            effectClasses = new ArrayList<Class<? extends Effect>>();
            effectClasses.add(Blend.class);
            effectClasses.add(Bloom.class);
            effectClasses.add(BoxBlur.class);
            effectClasses.add(ColorAdjust.class);
            effectClasses.add(ColorInput.class);
            effectClasses.add(DisplacementMap.class);
            effectClasses.add(DropShadow.class);
            effectClasses.add(GaussianBlur.class);
            effectClasses.add(Glow.class);
            effectClasses.add(ImageInput.class);
            effectClasses.add(InnerShadow.class);
            effectClasses.add(Lighting.class);
            effectClasses.add(MotionBlur.class);
            effectClasses.add(PerspectiveTransform.class);
            effectClasses.add(Reflection.class);
            effectClasses.add(SepiaTone.class);
            effectClasses.add(Shadow.class);
            effectClasses = Collections.unmodifiableList(effectClasses);
        }
        return effectClasses;
    }

    public EffectPicker(Delegate epd, PaintPicker.Delegate ppd) {
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(EffectPicker.class.getResource("EffectPicker.fxml"));
        try {
            Object rootObject = loader.load();
            assert (rootObject instanceof Node);
            Node rootNode = (Node)rootObject;
            this.getChildren().add((Object)rootNode);
            Object ctl = loader.getController();
            assert (ctl instanceof EffectPickerController);
            this.controller = (EffectPickerController)ctl;
            this.controller.setEffectPickerDelegate(epd);
            this.controller.setPaintPickerDelegate(ppd);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public final ObjectProperty<Effect> rootEffectProperty() {
        return this.controller.rootEffectProperty();
    }

    public final void setRootEffectProperty(Effect value) {
        this.controller.setRootEffectProperty(value);
        this.controller.updateUI();
    }

    public final Effect getRootEffectProperty() {
        return this.controller.getRootEffectProperty();
    }

    public ReadOnlyIntegerProperty revisionProperty() {
        return this.controller.revisionProperty();
    }

    public final ReadOnlyBooleanProperty liveUpdateProperty() {
        return this.controller.liveUpdateProperty();
    }

    public boolean isLiveUpdate() {
        return this.controller.isLiveUpdate();
    }

    public String getEffectPath() {
        return this.controller.getEffectPath();
    }

    public List<MenuItem> getMenuItems() {
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        for (final Class<? extends Effect> clazz : EffectPicker.getEffectClasses()) {
            MenuItem mi = new MenuItem(clazz.getSimpleName());
            mi.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    Effect effect = Utils.newInstance(clazz);
                    EffectPicker.this.setRootEffectProperty(effect);
                    EffectPicker.this.controller.incrementRevision();
                }
            });
            menuItems.add(mi);
        }
        return menuItems;
    }

    public static interface Delegate {
        public void handleError(String var1, Object ... var2);
    }
}

