/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.effectpicker;

import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.BlendPathItem;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.ColorInputPathItem;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPathItem;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPicker;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.ImageInputPathItem;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.LightingPathItem;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.SingleInputPathItem;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.editors.CheckBoxControl;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.editors.DoubleTextFieldControl;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.editors.EnumControl;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.editors.ImageControl;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.editors.LightControl;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.editors.SliderControl;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.PaintPicker;
import java.net.URL;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.effect.Blend;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.Bloom;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.ColorInput;
import javafx.scene.effect.DisplacementMap;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.effect.Glow;
import javafx.scene.effect.ImageInput;
import javafx.scene.effect.InnerShadow;
import javafx.scene.effect.Lighting;
import javafx.scene.effect.MotionBlur;
import javafx.scene.effect.PerspectiveTransform;
import javafx.scene.effect.Reflection;
import javafx.scene.effect.SepiaTone;
import javafx.scene.effect.Shadow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class EffectPickerController {
    @FXML
    private VBox root_vbox;
    @FXML
    private VBox props_vbox;
    @FXML
    private HBox effects_path_hbox;
    private final ToggleGroup effectToggleGroup = new ToggleGroup();
    private final Image selectionChevronImage;
    private EffectPicker.Delegate effectPickerDelegate;
    private PaintPicker.Delegate paintPickerDelegate;
    private final ObjectProperty<Effect> rootEffect = new SimpleObjectProperty();
    private final SimpleIntegerProperty revision = new SimpleIntegerProperty();
    private final BooleanProperty liveUpdate = new SimpleBooleanProperty();

    public EffectPickerController() {
        URL selectionChevronURL = EffectPickerController.class.getResource("images/selection-chevron.png");
        assert (selectionChevronURL != null);
        this.selectionChevronImage = new Image(selectionChevronURL.toExternalForm());
    }

    public final ObjectProperty<Effect> rootEffectProperty() {
        return this.rootEffect;
    }

    public final Effect getRootEffectProperty() {
        return (Effect)this.rootEffect.get();
    }

    public final void setRootEffectProperty(Effect value) {
        this.rootEffect.setValue((Object)value);
    }

    public ReadOnlyIntegerProperty revisionProperty() {
        return this.revision;
    }

    public final BooleanProperty liveUpdateProperty() {
        return this.liveUpdate;
    }

    public boolean isLiveUpdate() {
        return this.liveUpdate.get();
    }

    public void setLiveUpdate(boolean value) {
        this.liveUpdate.setValue(Boolean.valueOf(value));
    }

    public EffectPicker.Delegate getEffectPickerDelegate() {
        return this.effectPickerDelegate;
    }

    void setEffectPickerDelegate(EffectPicker.Delegate delegate) {
        this.effectPickerDelegate = delegate;
    }

    public PaintPicker.Delegate getPaintPickerDelegate() {
        return this.paintPickerDelegate;
    }

    void setPaintPickerDelegate(PaintPicker.Delegate delegate) {
        this.paintPickerDelegate = delegate;
    }

    public void updateUI() {
        this.effects_path_hbox.getChildren().clear();
        if (this.getRootEffectProperty() != null) {
            EffectPathItem rootEffectPathItem = this.makeEffectPathItem(this.getRootEffectProperty(), null);
            assert (rootEffectPathItem != null);
            EffectPathItem epi = rootEffectPathItem;
            while (epi != null) {
                this.effects_path_hbox.getChildren().add((Object)epi);
                if (epi.getSelectedInputPathItem() != null) {
                    ImageView img = new ImageView(this.selectionChevronImage);
                    this.effects_path_hbox.getChildren().add((Object)img);
                    epi = epi.getSelectedInputPathItem();
                    continue;
                }
                epi = null;
            }
            this.selectEffectPathItem(rootEffectPathItem);
        }
    }

    public void updateUI(EffectPathItem effectPathItem) {
        assert (effectPathItem != null);
        int index = this.effects_path_hbox.getChildren().indexOf((Object)effectPathItem);
        if (index + 1 < this.effects_path_hbox.getChildren().size()) {
            this.effects_path_hbox.getChildren().remove(index + 1, this.effects_path_hbox.getChildren().size());
        }
        EffectPathItem epi = effectPathItem.getSelectedInputPathItem();
        while (epi != null) {
            this.effects_path_hbox.getChildren().add((Object)epi);
            if (epi.getSelectedInputPathItem() != null) {
                ImageView img = new ImageView(this.selectionChevronImage);
                this.effects_path_hbox.getChildren().add((Object)img);
                epi = epi.getSelectedInputPathItem();
                continue;
            }
            epi = null;
        }
    }

    public ToggleGroup getEffectToggleGroup() {
        return this.effectToggleGroup;
    }

    public String getEffectPath() {
        EffectPathItem rootEffectPathItem = this.makeEffectPathItem(this.getRootEffectProperty(), null);
        if (rootEffectPathItem == null) {
            return "+";
        }
        StringBuilder sb = new StringBuilder();
        EffectPathItem epi = rootEffectPathItem;
        while (epi != null) {
            sb.append(epi.getSimpleName());
            if (epi.getSelectedInputPathItem() != null) {
                sb.append(", ");
                epi = epi.getSelectedInputPathItem();
                continue;
            }
            epi = null;
        }
        return sb.toString();
    }

    @FXML
    void initialize() {
        assert (this.root_vbox != null);
        assert (this.effects_path_hbox != null);
        assert (this.props_vbox != null);
    }

    public void incrementRevision() {
        this.revision.set(this.revision.get() + 1);
    }

    private EffectPathItem makeEffectPathItem(Effect effect, EffectPathItem hostPathItem) {
        if (effect == null) {
            return null;
        }
        EffectPathItem epi = effect instanceof Blend ? this.makeBlendPathItem(effect, hostPathItem) : (effect instanceof ColorInput ? this.makeColorInputPathItem(effect, hostPathItem) : (effect instanceof ImageInput ? this.makeImageInputPathItem(effect, hostPathItem) : (effect instanceof Lighting ? this.makeLightingPathItem(effect, hostPathItem) : this.makeSingleInputPathItem(effect, hostPathItem))));
        return epi;
    }

    private EffectPathItem makeBlendPathItem(Effect effect, EffectPathItem hostPathItem) {
        assert (effect != null);
        BlendPathItem epi = new BlendPathItem(this, effect, hostPathItem);
        Effect topInput = epi.getTopInput();
        EffectPathItem topInputPathItem = topInput == null ? null : this.makeEffectPathItem(topInput, epi);
        epi.setTopInputPathItem(topInputPathItem);
        Effect bottomInput = epi.getBottomInput();
        EffectPathItem bottomInputPathItem = bottomInput == null ? null : this.makeEffectPathItem(bottomInput, epi);
        epi.setBottomInputPathItem(bottomInputPathItem);
        return epi;
    }

    private EffectPathItem makeColorInputPathItem(Effect effect, EffectPathItem hostPathItem) {
        assert (effect != null);
        ColorInputPathItem epi = new ColorInputPathItem(this, effect, hostPathItem);
        return epi;
    }

    private EffectPathItem makeImageInputPathItem(Effect effect, EffectPathItem hostPathItem) {
        assert (effect != null);
        ImageInputPathItem epi = new ImageInputPathItem(this, effect, hostPathItem);
        return epi;
    }

    private EffectPathItem makeLightingPathItem(Effect effect, EffectPathItem hostPathItem) {
        assert (effect != null);
        LightingPathItem epi = new LightingPathItem(this, effect, hostPathItem);
        Effect bumpInput = epi.getBumpInput();
        EffectPathItem bumpInputPathItem = bumpInput == null ? null : this.makeEffectPathItem(bumpInput, epi);
        epi.setBumpInputPathItem(bumpInputPathItem);
        Effect contentInput = epi.getContentInput();
        EffectPathItem contentInputPathItem = contentInput == null ? null : this.makeEffectPathItem(contentInput, epi);
        epi.setContentInputPathItem(contentInputPathItem);
        return epi;
    }

    private EffectPathItem makeSingleInputPathItem(Effect effect, EffectPathItem hostPathItem) {
        assert (effect != null);
        SingleInputPathItem epi = new SingleInputPathItem(this, effect, hostPathItem);
        Effect input = epi.getInput();
        EffectPathItem inputPathItem = input == null ? null : this.makeEffectPathItem(input, epi);
        epi.setInputPathItem(inputPathItem);
        return epi;
    }

    public void selectEffectPathItem(EffectPathItem epi) {
        assert (epi != null);
        ToggleButton tb = epi.getToggleButton();
        Effect effect = epi.getValue();
        tb.setSelected(true);
        this.props_vbox.getChildren().clear();
        if (effect != null) {
            this.makeEffectUI(effect);
        }
    }

    private void makeEffectUI(Effect effect) {
        if (effect instanceof Blend) {
            this.makeBlendUI(effect);
        } else if (effect instanceof Bloom) {
            this.makeBloomUI(effect);
        } else if (effect instanceof BoxBlur) {
            this.makeBoxBlurUI(effect);
        } else if (effect instanceof ColorAdjust) {
            this.makeColorAdjustUI(effect);
        } else if (effect instanceof ColorInput) {
            this.makeColorInputUI(effect);
        } else if (effect instanceof DisplacementMap) {
            this.makeDisplacementMapUI(effect);
        } else if (effect instanceof DropShadow) {
            this.makeDropShadowUI(effect);
        } else if (effect instanceof GaussianBlur) {
            this.makeGaussianBlurUI(effect);
        } else if (effect instanceof Glow) {
            this.makeGlowUI(effect);
        } else if (effect instanceof ImageInput) {
            this.makeImageInputUI(effect);
        } else if (effect instanceof InnerShadow) {
            this.makeInnerShadowUI(effect);
        } else if (effect instanceof Lighting) {
            this.makeLightingUI(effect);
        } else if (effect instanceof MotionBlur) {
            this.makeMotionBlurUI(effect);
        } else if (effect instanceof PerspectiveTransform) {
            this.makePerspectiveTransformUI(effect);
        } else if (effect instanceof Reflection) {
            this.makeReflectionUI(effect);
        } else if (effect instanceof SepiaTone) {
            this.makeSepiaToneUI(effect);
        } else {
            assert (effect instanceof Shadow);
            this.makeShadowUI(effect);
        }
    }

    private void makeBlendUI(Effect effect) {
        assert (effect instanceof Blend);
        Blend blend = (Blend)effect;
        VBox vBox = new VBox(8.0);
        EnumControl<BlendMode> modeEditor = new EnumControl<BlendMode>(this, "mode", BlendMode.values(), blend.getMode());
        blend.modeProperty().bind(modeEditor.valueProperty());
        vBox.getChildren().add(modeEditor);
        SliderControl opacityEditor = new SliderControl(this, "opacity", 0.0, 1.0, blend.getOpacity(), 0.1, false);
        blend.opacityProperty().bind((ObservableValue)opacityEditor.valueProperty());
        vBox.getChildren().add((Object)opacityEditor);
        this.props_vbox.getChildren().add((Object)vBox);
    }

    private void makeBloomUI(Effect effect) {
        assert (effect instanceof Bloom);
        Bloom bloom = (Bloom)effect;
        VBox vBox = new VBox(8.0);
        SliderControl thresholdEditor = new SliderControl(this, "threshold", 0.0, 1.0, bloom.getThreshold(), 0.1, false);
        bloom.thresholdProperty().bind((ObservableValue)thresholdEditor.valueProperty());
        vBox.getChildren().add((Object)thresholdEditor);
        this.props_vbox.getChildren().add((Object)vBox);
    }

    private void makeBoxBlurUI(Effect effect) {
        assert (effect instanceof BoxBlur);
        BoxBlur boxBlur = (BoxBlur)effect;
        VBox vBox = new VBox(8.0);
        SliderControl widthEditor = new SliderControl(this, "width", 0.0, 255.0, boxBlur.getWidth(), 1.0, false);
        boxBlur.widthProperty().bind((ObservableValue)widthEditor.valueProperty());
        vBox.getChildren().add((Object)widthEditor);
        SliderControl heightEditor = new SliderControl(this, "height", 0.0, 255.0, boxBlur.getHeight(), 1.0, false);
        boxBlur.heightProperty().bind((ObservableValue)heightEditor.valueProperty());
        vBox.getChildren().add((Object)heightEditor);
        SliderControl iterationsEditor = new SliderControl(this, "iterations", 0.0, 3.0, boxBlur.getIterations(), 1.0, true);
        Slider slider = iterationsEditor.getSlider();
        slider.setBlockIncrement(1.0);
        slider.setMajorTickUnit(1.0);
        slider.setMinorTickCount(0);
        slider.setSnapToTicks(true);
        slider.setShowTickMarks(true);
        boxBlur.iterationsProperty().bind((ObservableValue)iterationsEditor.valueProperty());
        vBox.getChildren().add((Object)iterationsEditor);
        this.props_vbox.getChildren().add((Object)vBox);
    }

    private void makeColorAdjustUI(Effect effect) {
        assert (effect instanceof ColorAdjust);
        ColorAdjust colorAdjust = (ColorAdjust)effect;
        VBox vBox = new VBox(8.0);
        SliderControl brightnessEditor = new SliderControl(this, "brightness", -1.0, 1.0, colorAdjust.getBrightness(), 0.1, false);
        colorAdjust.brightnessProperty().bind((ObservableValue)brightnessEditor.valueProperty());
        vBox.getChildren().add((Object)brightnessEditor);
        SliderControl contrastEditor = new SliderControl(this, "contrast", -1.0, 1.0, colorAdjust.getContrast(), 0.1, false);
        colorAdjust.contrastProperty().bind((ObservableValue)contrastEditor.valueProperty());
        vBox.getChildren().add((Object)contrastEditor);
        SliderControl hueEditor = new SliderControl(this, "hue", -1.0, 1.0, colorAdjust.getHue(), 0.1, false);
        colorAdjust.hueProperty().bind((ObservableValue)hueEditor.valueProperty());
        vBox.getChildren().add((Object)hueEditor);
        SliderControl saturationEditor = new SliderControl(this, "saturation", -1.0, 1.0, colorAdjust.getSaturation(), 0.1, false);
        colorAdjust.saturationProperty().bind((ObservableValue)saturationEditor.valueProperty());
        vBox.getChildren().add((Object)saturationEditor);
        this.props_vbox.getChildren().add((Object)vBox);
    }

    private void makeColorInputUI(Effect effect) {
        assert (effect instanceof ColorInput);
        ColorInput colorInput = (ColorInput)effect;
        VBox vBox = new VBox(8.0);
        SliderControl widthEditor = new SliderControl(this, "width", 0.0, 255.0, colorInput.getWidth(), 1.0, false);
        colorInput.widthProperty().bind((ObservableValue)widthEditor.valueProperty());
        vBox.getChildren().add((Object)widthEditor);
        SliderControl heightEditor = new SliderControl(this, "height", 0.0, 255.0, colorInput.getHeight(), 1.0, false);
        colorInput.heightProperty().bind((ObservableValue)heightEditor.valueProperty());
        vBox.getChildren().add((Object)heightEditor);
        DoubleTextFieldControl xEditor = new DoubleTextFieldControl(this, "x", -10.0, 10.0, colorInput.getX(), 1.0);
        colorInput.xProperty().bind((ObservableValue)xEditor.valueProperty());
        vBox.getChildren().add((Object)xEditor);
        DoubleTextFieldControl yEditor = new DoubleTextFieldControl(this, "y", -10.0, 10.0, colorInput.getY(), 1.0);
        colorInput.yProperty().bind((ObservableValue)yEditor.valueProperty());
        vBox.getChildren().add((Object)yEditor);
        PaintPicker colorPicker = new PaintPicker(this.paintPickerDelegate);
        colorPicker.setPaintProperty(colorInput.getPaint());
        colorPicker.paintProperty().addListener((ChangeListener)new PaintChangeListener(this, colorInput));
        colorPicker.liveUpdateProperty().addListener((ChangeListener)new PaintPickerLiveUpdateListener(colorPicker, this));
        vBox.getChildren().add((Object)colorPicker);
        this.props_vbox.getChildren().add((Object)vBox);
    }

    private void makeDisplacementMapUI(Effect effect) {
        assert (effect instanceof DisplacementMap);
        DisplacementMap displacementMap = (DisplacementMap)effect;
        VBox vBox = new VBox(8.0);
        DoubleTextFieldControl offsetXEditor = new DoubleTextFieldControl(this, "offsetX", -10.0, 10.0, displacementMap.getOffsetX(), 1.0);
        displacementMap.offsetXProperty().bind((ObservableValue)offsetXEditor.valueProperty());
        vBox.getChildren().add((Object)offsetXEditor);
        DoubleTextFieldControl offsetYEditor = new DoubleTextFieldControl(this, "offsetY", -10.0, 10.0, displacementMap.getOffsetY(), 1.0);
        displacementMap.offsetYProperty().bind((ObservableValue)offsetYEditor.valueProperty());
        vBox.getChildren().add((Object)offsetYEditor);
        DoubleTextFieldControl scaleXEditor = new DoubleTextFieldControl(this, "scaleX", -10.0, 10.0, displacementMap.getScaleX(), 1.0);
        displacementMap.scaleXProperty().bind((ObservableValue)scaleXEditor.valueProperty());
        vBox.getChildren().add((Object)scaleXEditor);
        DoubleTextFieldControl scaleYEditor = new DoubleTextFieldControl(this, "scaleY", -10.0, 10.0, displacementMap.getScaleY(), 1.0);
        displacementMap.scaleYProperty().bind((ObservableValue)scaleYEditor.valueProperty());
        vBox.getChildren().add((Object)scaleYEditor);
        CheckBoxControl wrapEditor = new CheckBoxControl(this, "wrap", displacementMap.isWrap());
        displacementMap.wrapProperty().bind((ObservableValue)wrapEditor.valueProperty());
        vBox.getChildren().add((Object)wrapEditor);
        this.props_vbox.getChildren().add((Object)vBox);
    }

    private void makeDropShadowUI(Effect effect) {
        assert (effect instanceof DropShadow);
        DropShadow dropShadow = (DropShadow)effect;
        VBox vBox = new VBox(8.0);
        EnumControl<BlurType> blurTypeEditor = new EnumControl<BlurType>(this, "blurType", BlurType.values(), dropShadow.getBlurType());
        dropShadow.blurTypeProperty().bind(blurTypeEditor.valueProperty());
        vBox.getChildren().add(blurTypeEditor);
        SliderControl widthEditor = new SliderControl(this, "width", 0.0, 255.0, dropShadow.getWidth(), 1.0, false);
        dropShadow.widthProperty().bind((ObservableValue)widthEditor.valueProperty());
        vBox.getChildren().add((Object)widthEditor);
        SliderControl heightEditor = new SliderControl(this, "height", 0.0, 255.0, dropShadow.getHeight(), 1.0, false);
        dropShadow.heightProperty().bind((ObservableValue)heightEditor.valueProperty());
        vBox.getChildren().add((Object)heightEditor);
        SliderControl radiusEditor = new SliderControl(this, "radius", 0.0, 127.0, dropShadow.getRadius(), 1.0, false);
        dropShadow.radiusProperty().bind((ObservableValue)radiusEditor.valueProperty());
        vBox.getChildren().add((Object)radiusEditor);
        DoubleTextFieldControl offsetXEditor = new DoubleTextFieldControl(this, "offsetX", -10.0, 10.0, dropShadow.getOffsetX(), 1.0);
        dropShadow.offsetXProperty().bind((ObservableValue)offsetXEditor.valueProperty());
        vBox.getChildren().add((Object)offsetXEditor);
        DoubleTextFieldControl offsetYEditor = new DoubleTextFieldControl(this, "offsetY", -10.0, 10.0, dropShadow.getOffsetY(), 1.0);
        dropShadow.offsetYProperty().bind((ObservableValue)offsetYEditor.valueProperty());
        vBox.getChildren().add((Object)offsetYEditor);
        SliderControl spreadEditor = new SliderControl(this, "spread", 0.0, 1.0, dropShadow.getSpread(), 0.1, false);
        dropShadow.spreadProperty().bind((ObservableValue)spreadEditor.valueProperty());
        vBox.getChildren().add((Object)spreadEditor);
        PaintPicker colorPicker = new PaintPicker(this.paintPickerDelegate, PaintPicker.Mode.COLOR);
        colorPicker.setPaintProperty((Paint)dropShadow.getColor());
        colorPicker.paintProperty().addListener((ChangeListener)new ColorChangeListener(this, (Effect)dropShadow));
        colorPicker.liveUpdateProperty().addListener((ChangeListener)new PaintPickerLiveUpdateListener(colorPicker, this));
        vBox.getChildren().add((Object)colorPicker);
        this.props_vbox.getChildren().add((Object)vBox);
    }

    private void makeGaussianBlurUI(Effect effect) {
        assert (effect instanceof GaussianBlur);
        GaussianBlur gaussianBlur = (GaussianBlur)effect;
        VBox vBox = new VBox(8.0);
        SliderControl radiusEditor = new SliderControl(this, "radius", 0.0, 63.0, gaussianBlur.getRadius(), 0.1, false);
        gaussianBlur.radiusProperty().bind((ObservableValue)radiusEditor.valueProperty());
        vBox.getChildren().add((Object)radiusEditor);
        this.props_vbox.getChildren().add((Object)vBox);
    }

    private void makeGlowUI(Effect effect) {
        assert (effect instanceof Glow);
        Glow glow = (Glow)effect;
        VBox vBox = new VBox(8.0);
        SliderControl levelEditor = new SliderControl(this, "level", 0.0, 1.0, glow.getLevel(), 0.1, false);
        glow.levelProperty().bind((ObservableValue)levelEditor.valueProperty());
        vBox.getChildren().add((Object)levelEditor);
        this.props_vbox.getChildren().add((Object)vBox);
    }

    private void makeImageInputUI(Effect effect) {
        assert (effect instanceof ImageInput);
        ImageInput imageInput = (ImageInput)effect;
        VBox vBox = new VBox(8.0);
        DoubleTextFieldControl xEditor = new DoubleTextFieldControl(this, "x", -10.0, 10.0, imageInput.getX(), 1.0);
        imageInput.xProperty().bind((ObservableValue)xEditor.valueProperty());
        vBox.getChildren().add((Object)xEditor);
        DoubleTextFieldControl yEditor = new DoubleTextFieldControl(this, "y", -10.0, 10.0, imageInput.getY(), 1.0);
        imageInput.yProperty().bind((ObservableValue)yEditor.valueProperty());
        vBox.getChildren().add((Object)yEditor);
        ImageControl imageEditor = new ImageControl(this, "source", imageInput.getSource());
        imageInput.sourceProperty().bind(imageEditor.valueProperty());
        vBox.getChildren().add((Object)imageEditor);
        this.props_vbox.getChildren().add((Object)vBox);
    }

    private void makeInnerShadowUI(Effect effect) {
        assert (effect instanceof InnerShadow);
        InnerShadow innerShadow = (InnerShadow)effect;
        VBox vBox = new VBox(8.0);
        EnumControl<BlurType> blurTypeEditor = new EnumControl<BlurType>(this, "blurType", BlurType.values(), innerShadow.getBlurType());
        innerShadow.blurTypeProperty().bind(blurTypeEditor.valueProperty());
        vBox.getChildren().add(blurTypeEditor);
        SliderControl chokeEditor = new SliderControl(this, "choke", 0.0, 1.0, innerShadow.getChoke(), 0.1, false);
        innerShadow.chokeProperty().bind((ObservableValue)chokeEditor.valueProperty());
        vBox.getChildren().add((Object)chokeEditor);
        SliderControl widthEditor = new SliderControl(this, "width", 0.0, 255.0, innerShadow.getWidth(), 1.0, false);
        innerShadow.widthProperty().bind((ObservableValue)widthEditor.valueProperty());
        vBox.getChildren().add((Object)widthEditor);
        SliderControl heightEditor = new SliderControl(this, "height", 0.0, 255.0, innerShadow.getHeight(), 1.0, false);
        innerShadow.heightProperty().bind((ObservableValue)heightEditor.valueProperty());
        vBox.getChildren().add((Object)heightEditor);
        SliderControl radiusEditor = new SliderControl(this, "radius", 0.0, 127.0, innerShadow.getRadius(), 1.0, false);
        innerShadow.radiusProperty().bind((ObservableValue)radiusEditor.valueProperty());
        vBox.getChildren().add((Object)radiusEditor);
        DoubleTextFieldControl offsetXEditor = new DoubleTextFieldControl(this, "offsetX", -10.0, 10.0, innerShadow.getOffsetX(), 1.0);
        innerShadow.offsetXProperty().bind((ObservableValue)offsetXEditor.valueProperty());
        vBox.getChildren().add((Object)offsetXEditor);
        DoubleTextFieldControl offsetYEditor = new DoubleTextFieldControl(this, "offsetY", -10.0, 10.0, innerShadow.getOffsetY(), 1.0);
        innerShadow.offsetYProperty().bind((ObservableValue)offsetYEditor.valueProperty());
        vBox.getChildren().add((Object)offsetYEditor);
        PaintPicker colorPicker = new PaintPicker(this.paintPickerDelegate, PaintPicker.Mode.COLOR);
        colorPicker.setPaintProperty((Paint)innerShadow.getColor());
        colorPicker.paintProperty().addListener((ChangeListener)new ColorChangeListener(this, (Effect)innerShadow));
        colorPicker.liveUpdateProperty().addListener((ChangeListener)new PaintPickerLiveUpdateListener(colorPicker, this));
        vBox.getChildren().add((Object)colorPicker);
        this.props_vbox.getChildren().add((Object)vBox);
    }

    private void makeLightingUI(Effect effect) {
        assert (effect instanceof Lighting);
        Lighting lighting = (Lighting)effect;
        VBox vBox = new VBox(8.0);
        SliderControl diffuseConstantEditor = new SliderControl(this, "diffuseConstant", 0.0, 2.0, lighting.getDiffuseConstant(), 1.0, false);
        lighting.diffuseConstantProperty().bind((ObservableValue)diffuseConstantEditor.valueProperty());
        vBox.getChildren().add((Object)diffuseConstantEditor);
        SliderControl specularConstantEditor = new SliderControl(this, "specularConstant", 0.0, 2.0, lighting.getSpecularConstant(), 1.0, false);
        lighting.specularConstantProperty().bind((ObservableValue)specularConstantEditor.valueProperty());
        vBox.getChildren().add((Object)specularConstantEditor);
        SliderControl specularExponentEditor = new SliderControl(this, "specularExponent", 0.0, 40.0, lighting.getSpecularExponent(), 1.0, false);
        lighting.specularExponentProperty().bind((ObservableValue)specularExponentEditor.valueProperty());
        vBox.getChildren().add((Object)specularExponentEditor);
        SliderControl surfaceScaleEditor = new SliderControl(this, "surfaceScale", 0.0, 10.0, lighting.getSurfaceScale(), 1.0, false);
        lighting.surfaceScaleProperty().bind((ObservableValue)surfaceScaleEditor.valueProperty());
        vBox.getChildren().add((Object)surfaceScaleEditor);
        LightControl lightControl = new LightControl(this, "light", lighting.getLight());
        lighting.lightProperty().bind(lightControl.valueProperty());
        lightControl.liveUpdateProperty().addListener((ChangeListener)new LightControlLiveUpdateListener(lightControl, this));
        vBox.getChildren().add((Object)lightControl);
        this.props_vbox.getChildren().add((Object)vBox);
    }

    private void makeMotionBlurUI(Effect effect) {
        assert (effect instanceof MotionBlur);
        MotionBlur motionBlur = (MotionBlur)effect;
        VBox vBox = new VBox(8.0);
        SliderControl angleEditor = new SliderControl(this, "angle", 0.0, 360.0, motionBlur.getAngle(), 1.0, false);
        motionBlur.angleProperty().bind((ObservableValue)angleEditor.valueProperty());
        vBox.getChildren().add((Object)angleEditor);
        SliderControl radiusEditor = new SliderControl(this, "radius", 0.0, 63.0, motionBlur.getRadius(), 1.0, false);
        motionBlur.radiusProperty().bind((ObservableValue)radiusEditor.valueProperty());
        vBox.getChildren().add((Object)radiusEditor);
        this.props_vbox.getChildren().add((Object)vBox);
    }

    private void makePerspectiveTransformUI(Effect effect) {
        assert (effect instanceof PerspectiveTransform);
        PerspectiveTransform perspectiveTransform = (PerspectiveTransform)effect;
        VBox vBox = new VBox(8.0);
        DoubleTextFieldControl llxEditor = new DoubleTextFieldControl(this, "llx", -10.0, 10.0, perspectiveTransform.getLlx(), 1.0);
        perspectiveTransform.llxProperty().bind((ObservableValue)llxEditor.valueProperty());
        vBox.getChildren().add((Object)llxEditor);
        DoubleTextFieldControl llyEditor = new DoubleTextFieldControl(this, "lly", -10.0, 10.0, perspectiveTransform.getLly(), 1.0);
        perspectiveTransform.llyProperty().bind((ObservableValue)llyEditor.valueProperty());
        vBox.getChildren().add((Object)llyEditor);
        DoubleTextFieldControl lrxEditor = new DoubleTextFieldControl(this, "lrx", -10.0, 10.0, perspectiveTransform.getLrx(), 1.0);
        perspectiveTransform.lrxProperty().bind((ObservableValue)lrxEditor.valueProperty());
        vBox.getChildren().add((Object)lrxEditor);
        DoubleTextFieldControl lryEditor = new DoubleTextFieldControl(this, "lry", -10.0, 10.0, perspectiveTransform.getLry(), 1.0);
        perspectiveTransform.lryProperty().bind((ObservableValue)lryEditor.valueProperty());
        vBox.getChildren().add((Object)lryEditor);
        DoubleTextFieldControl ulxEditor = new DoubleTextFieldControl(this, "ulx", -10.0, 10.0, perspectiveTransform.getUlx(), 1.0);
        perspectiveTransform.ulxProperty().bind((ObservableValue)ulxEditor.valueProperty());
        vBox.getChildren().add((Object)ulxEditor);
        DoubleTextFieldControl ulyEditor = new DoubleTextFieldControl(this, "uly", -10.0, 10.0, perspectiveTransform.getUly(), 1.0);
        perspectiveTransform.ulyProperty().bind((ObservableValue)ulyEditor.valueProperty());
        vBox.getChildren().add((Object)ulyEditor);
        DoubleTextFieldControl urxEditor = new DoubleTextFieldControl(this, "urx", -10.0, 10.0, perspectiveTransform.getUrx(), 1.0);
        perspectiveTransform.urxProperty().bind((ObservableValue)urxEditor.valueProperty());
        vBox.getChildren().add((Object)urxEditor);
        DoubleTextFieldControl uryEditor = new DoubleTextFieldControl(this, "ury", -10.0, 10.0, perspectiveTransform.getUry(), 1.0);
        perspectiveTransform.uryProperty().bind((ObservableValue)uryEditor.valueProperty());
        vBox.getChildren().add((Object)uryEditor);
        this.props_vbox.getChildren().add((Object)vBox);
    }

    private void makeReflectionUI(Effect effect) {
        assert (effect instanceof Reflection);
        Reflection reflection = (Reflection)effect;
        VBox vBox = new VBox(8.0);
        SliderControl bottomOpacityEditor = new SliderControl(this, "bottomOpacity", 0.0, 1.0, reflection.getBottomOpacity(), 0.1, false);
        reflection.bottomOpacityProperty().bind((ObservableValue)bottomOpacityEditor.valueProperty());
        vBox.getChildren().add((Object)bottomOpacityEditor);
        SliderControl topOpacityEditor = new SliderControl(this, "topOpacity", 0.0, 1.0, reflection.getTopOpacity(), 0.1, false);
        reflection.topOpacityProperty().bind((ObservableValue)topOpacityEditor.valueProperty());
        vBox.getChildren().add((Object)topOpacityEditor);
        DoubleTextFieldControl topOffsetEditor = new DoubleTextFieldControl(this, "topOffset", -10.0, 10.0, reflection.getTopOffset(), 1.0);
        reflection.topOffsetProperty().bind((ObservableValue)topOffsetEditor.valueProperty());
        vBox.getChildren().add((Object)topOffsetEditor);
        SliderControl fractionEditor = new SliderControl(this, "fraction", 0.0, 1.0, reflection.getFraction(), 0.1, false);
        reflection.fractionProperty().bind((ObservableValue)fractionEditor.valueProperty());
        vBox.getChildren().add((Object)fractionEditor);
        this.props_vbox.getChildren().add((Object)vBox);
    }

    private void makeSepiaToneUI(Effect effect) {
        assert (effect instanceof SepiaTone);
        SepiaTone sepiaTone = (SepiaTone)effect;
        VBox vBox = new VBox(8.0);
        SliderControl levelEditor = new SliderControl(this, "level", 0.0, 1.0, sepiaTone.getLevel(), 0.1, false);
        sepiaTone.levelProperty().bind((ObservableValue)levelEditor.valueProperty());
        vBox.getChildren().add((Object)levelEditor);
        this.props_vbox.getChildren().add((Object)vBox);
    }

    private void makeShadowUI(Effect effect) {
        assert (effect instanceof Shadow);
        Shadow shadow = (Shadow)effect;
        VBox vBox = new VBox(8.0);
        EnumControl<BlurType> blurTypeEditor = new EnumControl<BlurType>(this, "blurType", BlurType.values(), shadow.getBlurType());
        shadow.blurTypeProperty().bind(blurTypeEditor.valueProperty());
        vBox.getChildren().add(blurTypeEditor);
        SliderControl widthEditor = new SliderControl(this, "width", 0.0, 255.0, shadow.getWidth(), 1.0, false);
        shadow.widthProperty().bind((ObservableValue)widthEditor.valueProperty());
        vBox.getChildren().add((Object)widthEditor);
        SliderControl heightEditor = new SliderControl(this, "height", 0.0, 255.0, shadow.getHeight(), 1.0, false);
        shadow.heightProperty().bind((ObservableValue)heightEditor.valueProperty());
        vBox.getChildren().add((Object)heightEditor);
        SliderControl radiusEditor = new SliderControl(this, "radius", 0.0, 127.0, shadow.getRadius(), 1.0, false);
        shadow.radiusProperty().bind((ObservableValue)radiusEditor.valueProperty());
        vBox.getChildren().add((Object)radiusEditor);
        PaintPicker colorPicker = new PaintPicker(this.paintPickerDelegate, PaintPicker.Mode.COLOR);
        colorPicker.setPaintProperty((Paint)shadow.getColor());
        colorPicker.paintProperty().addListener((ChangeListener)new ColorChangeListener(this, (Effect)shadow));
        colorPicker.liveUpdateProperty().addListener((ChangeListener)new PaintPickerLiveUpdateListener(colorPicker, this));
        vBox.getChildren().add((Object)colorPicker);
        this.props_vbox.getChildren().add((Object)vBox);
    }

    private static class PaintChangeListener
    implements ChangeListener<Paint> {
        private final EffectPickerController effectPickerController;
        private final ColorInput colorInput;

        public PaintChangeListener(EffectPickerController effectPickerController, ColorInput colorInput) {
            this.effectPickerController = effectPickerController;
            this.colorInput = colorInput;
        }

        public void changed(ObservableValue<? extends Paint> ov, Paint oldValue, Paint newValue) {
            this.colorInput.setPaint(newValue);
            this.effectPickerController.incrementRevision();
        }
    }

    private static class ColorChangeListener
    implements ChangeListener<Paint> {
        private final EffectPickerController effectPickerController;
        private final Effect effect;

        public ColorChangeListener(EffectPickerController effectPickerController, Effect effect) {
            assert (effect instanceof DropShadow || effect instanceof InnerShadow || effect instanceof Shadow);
            this.effectPickerController = effectPickerController;
            this.effect = effect;
        }

        public void changed(ObservableValue<? extends Paint> ov, Paint oldValue, Paint newValue) {
            assert (newValue instanceof Color);
            Color color = (Color)newValue;
            if (this.effect instanceof DropShadow) {
                ((DropShadow)this.effect).setColor(color);
            } else if (this.effect instanceof InnerShadow) {
                ((InnerShadow)this.effect).setColor(color);
            } else {
                assert (this.effect instanceof Shadow);
                ((Shadow)this.effect).setColor(color);
            }
            this.effectPickerController.incrementRevision();
        }
    }

    private static class LightControlLiveUpdateListener
    implements ChangeListener<Boolean> {
        private final LightControl lightControl;
        private final EffectPickerController effectPickerController;

        public LightControlLiveUpdateListener(LightControl lightControl, EffectPickerController effectPickerController) {
            this.lightControl = lightControl;
            this.effectPickerController = effectPickerController;
        }

        public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
            this.effectPickerController.setLiveUpdate(this.lightControl.isLiveUpdate());
        }
    }

    private static class PaintPickerLiveUpdateListener
    implements ChangeListener<Boolean> {
        private final PaintPicker paintPicker;
        private final EffectPickerController effectPickerController;

        public PaintPickerLiveUpdateListener(PaintPicker paintPicker, EffectPickerController effectPickerController) {
            this.paintPicker = paintPicker;
            this.effectPickerController = effectPickerController;
        }

        public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
            this.effectPickerController.setLiveUpdate(this.paintPicker.isLiveUpdate());
        }
    }
}

