/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.effectpicker;

import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPathItem;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPickerController;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.ToggleGroup;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Lighting;

public class LightingPathItem
extends EffectPathItem {
    private final RadioMenuItem bumpMenuItem = new RadioMenuItem("BumpInput");
    private final RadioMenuItem contentMenuItem = new RadioMenuItem("ContentInput");
    private final ToggleGroup inputToggleGroup = new ToggleGroup();
    private EffectPathItem bumpInputPathItem;
    private EffectPathItem contentInputPathItem;

    public LightingPathItem(EffectPickerController epc, Effect effect, EffectPathItem hostPathItem) {
        super(epc, effect, hostPathItem);
        assert (effect instanceof Lighting);
        this.initialize();
    }

    @Override
    EffectPathItem getSelectedInputPathItem() {
        if (this.bumpMenuItem.isSelected()) {
            return this.bumpInputPathItem;
        }
        assert (this.contentMenuItem.isSelected());
        return this.contentInputPathItem;
    }

    @Override
    void setSelectedInputEffect(Effect input) {
        if (this.bumpMenuItem.isSelected()) {
            this.setBumpInput(input);
        } else {
            assert (this.contentMenuItem.isSelected());
            this.setContentInput(input);
        }
    }

    void setBumpInputPathItem(EffectPathItem epi) {
        this.bumpInputPathItem = epi;
    }

    void setContentInputPathItem(EffectPathItem epi) {
        this.contentInputPathItem = epi;
    }

    Effect getBumpInput() {
        return ((Lighting)this.effect).getBumpInput();
    }

    void setBumpInput(Effect input) {
        ((Lighting)this.effect).setBumpInput(input);
    }

    Effect getContentInput() {
        return ((Lighting)this.effect).getContentInput();
    }

    void setContentInput(Effect input) {
        ((Lighting)this.effect).setContentInput(input);
    }

    private void initialize() {
        Menu inputMenu = new Menu("Select Input");
        this.bumpMenuItem.setToggleGroup(this.inputToggleGroup);
        this.bumpMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                LightingPathItem.this.toggle_button.setText(LightingPathItem.this.getSimpleName() + " (BumpInput)");
                LightingPathItem.this.effectPickerController.updateUI(LightingPathItem.this);
            }
        });
        this.contentMenuItem.setToggleGroup(this.inputToggleGroup);
        this.contentMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                LightingPathItem.this.toggle_button.setText(LightingPathItem.this.getSimpleName() + " (ContentInput)");
                LightingPathItem.this.effectPickerController.updateUI(LightingPathItem.this);
            }
        });
        inputMenu.getItems().addAll((Object[])new MenuItem[]{this.bumpMenuItem, this.contentMenuItem});
        this.menu_button.getItems().add(0, (Object)inputMenu);
        this.menu_button.getItems().add(1, (Object)new SeparatorMenuItem());
        this.toggle_button.setText(this.getSimpleName() + " (BumpInput)");
        this.bumpMenuItem.setSelected(true);
        this.contentMenuItem.setSelected(false);
    }
}

