/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.editors;

import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPickerController;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;

public class CheckBoxControl
extends GridPane {
    @FXML
    private Label editor_label;
    @FXML
    private CheckBox editor_checkbox;
    private final BooleanProperty value = new SimpleBooleanProperty();
    private final EffectPickerController effectPickerController;

    public CheckBoxControl(EffectPickerController effectPickerController, String label, boolean initValue) {
        this.effectPickerController = effectPickerController;
        this.initialize(label, initValue);
    }

    public BooleanProperty valueProperty() {
        return this.value;
    }

    public boolean getValue() {
        return this.value.get();
    }

    public void setValue(boolean v) {
        this.value.set(v);
    }

    private void initialize(String label, boolean initValue) {
        URL layoutURL = CheckBoxControl.class.getResource("CheckBoxControl.fxml");
        try (InputStream is = layoutURL.openStream();){
            FXMLLoader loader = new FXMLLoader();
            loader.setController((Object)this);
            loader.setRoot((Object)this);
            loader.setLocation(layoutURL);
            Parent p = (Parent)loader.load(is);
            assert (p == this);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        this.editor_label.setText(label);
        this.editor_checkbox.setSelected(initValue);
        this.editor_checkbox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                CheckBoxControl.this.setValue(t1);
                CheckBoxControl.this.effectPickerController.incrementRevision();
            }
        });
        this.setValue(initValue);
    }
}

