/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.paintpicker;

import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.PaintPicker;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.colorpicker.ColorPicker;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.gradientpicker.GradientPicker;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.stage.Window;

public class PaintPickerController {
    @FXML
    private VBox root_vbox;
    @FXML
    private ToggleButton colorToggleButton;
    @FXML
    private ToggleButton linearToggleButton;
    @FXML
    private ToggleButton radialToggleButton;
    private ColorPicker colorPicker;
    private GradientPicker gradientPicker;
    private PaintPicker.Delegate delegate;
    private final ObjectProperty<Paint> paint = new SimpleObjectProperty();
    private final BooleanProperty liveUpdate = new SimpleBooleanProperty();
    public static final Color DEFAULT_COLOR = Color.BLACK;
    public static final LinearGradient DEFAULT_LINEAR = new LinearGradient(0.0, 0.0, 1.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[0]);
    public static final RadialGradient DEFAULT_RADIAL = new RadialGradient(0.0, 0.0, 0.5, 0.5, 0.5, true, CycleMethod.NO_CYCLE, new Stop[0]);

    public final ObjectProperty<Paint> paintProperty() {
        return this.paint;
    }

    public final Paint getPaintProperty() {
        return (Paint)this.paint.get();
    }

    public final void setPaintProperty(Paint value) {
        this.paint.setValue((Object)value);
    }

    public final BooleanProperty liveUpdateProperty() {
        return this.liveUpdate;
    }

    public boolean isLiveUpdate() {
        return this.liveUpdate.get();
    }

    public void setLiveUpdate(boolean value) {
        this.liveUpdate.setValue(Boolean.valueOf(value));
    }

    public ColorPicker getColorPicker() {
        return this.colorPicker;
    }

    public GradientPicker getGradientPicker() {
        return this.gradientPicker;
    }

    public PaintPicker.Delegate getDelegate() {
        return this.delegate;
    }

    public VBox getRoot() {
        return this.root_vbox;
    }

    public static double clamp(double min, double value, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    void setDelegate(PaintPicker.Delegate delegate) {
        this.delegate = delegate;
    }

    public PaintPicker.Mode getMode() {
        PaintPicker.Mode mode;
        Paint value = this.getPaintProperty();
        if (value instanceof Color) {
            mode = PaintPicker.Mode.COLOR;
        } else if (value instanceof LinearGradient) {
            mode = PaintPicker.Mode.LINEAR;
        } else {
            assert (value instanceof RadialGradient);
            mode = PaintPicker.Mode.RADIAL;
        }
        return mode;
    }

    public void updateUI(Paint value) {
        if (value != null) {
            this.setMode(value);
            if (value instanceof Color) {
                this.colorPicker.updateUI((Color)value);
            } else if (value instanceof LinearGradient) {
                this.gradientPicker.updateUI((Paint)((LinearGradient)value));
            } else if (value instanceof RadialGradient) {
                this.gradientPicker.updateUI((Paint)((RadialGradient)value));
            } else assert (value instanceof ImagePattern);
        }
    }

    @FXML
    public void initialize() {
        assert (this.root_vbox != null);
        assert (this.colorToggleButton != null);
        assert (this.linearToggleButton != null);
        assert (this.radialToggleButton != null);
        this.colorPicker = new ColorPicker(this);
        this.gradientPicker = new GradientPicker(this);
        this.setPaintProperty((Paint)DEFAULT_COLOR);
        this.root_vbox.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
                Window window = PaintPickerController.this.root_vbox.getScene().getWindow();
                window.sizeToScene();
            }
        });
        this.root_vbox.getChildren().add((Object)this.colorPicker);
    }

    void setSingleMode(PaintPicker.Mode mode) {
        Color value;
        this.colorToggleButton.setManaged(false);
        this.linearToggleButton.setManaged(false);
        this.radialToggleButton.setManaged(false);
        switch (mode) {
            case COLOR: {
                value = DEFAULT_COLOR;
                break;
            }
            case LINEAR: {
                value = DEFAULT_LINEAR;
                break;
            }
            case RADIAL: {
                value = DEFAULT_RADIAL;
                break;
            }
            default: {
                value = null;
                assert (false);
                break;
            }
        }
        this.setPaintProperty((Paint)value);
        this.updateUI((Paint)value);
    }

    private void setMode(Paint value) {
        if (value instanceof Color) {
            if (!this.colorToggleButton.isSelected()) {
                this.colorToggleButton.setSelected(true);
            }
            this.root_vbox.getChildren().remove((Object)this.gradientPicker);
        } else if (value instanceof LinearGradient) {
            if (!this.linearToggleButton.isSelected()) {
                this.linearToggleButton.setSelected(true);
            }
            if (!this.root_vbox.getChildren().contains((Object)this.gradientPicker)) {
                this.root_vbox.getChildren().add((Object)this.gradientPicker);
            }
        } else if (value instanceof RadialGradient) {
            if (!this.radialToggleButton.isSelected()) {
                this.radialToggleButton.setSelected(true);
            }
            if (!this.root_vbox.getChildren().contains((Object)this.gradientPicker)) {
                this.root_vbox.getChildren().add((Object)this.gradientPicker);
            }
        } else assert (value instanceof ImagePattern);
    }

    @FXML
    void onColorButtonAction(ActionEvent event) {
        ToggleButton tb = (ToggleButton)event.getTarget();
        assert (tb == this.colorToggleButton);
        Color value = this.colorPicker.getValue();
        this.setMode((Paint)value);
        this.setPaintProperty((Paint)value);
        event.consume();
    }

    @FXML
    void onLinearButtonAction(ActionEvent event) {
        ToggleButton tb = (ToggleButton)event.getTarget();
        assert (tb == this.linearToggleButton);
        Paint value = this.gradientPicker.getValue(PaintPicker.Mode.LINEAR);
        assert (value instanceof LinearGradient);
        this.setMode(value);
        this.gradientPicker.setMode(value);
        this.gradientPicker.updatePreview(value);
        this.setPaintProperty(value);
        event.consume();
    }

    @FXML
    void onRadialButtonAction(ActionEvent event) {
        ToggleButton tb = (ToggleButton)event.getTarget();
        assert (tb == this.radialToggleButton);
        Paint value = this.gradientPicker.getValue(PaintPicker.Mode.RADIAL);
        assert (value instanceof RadialGradient);
        this.setMode(value);
        this.gradientPicker.setMode(value);
        this.gradientPicker.updatePreview(value);
        this.setPaintProperty(value);
        event.consume();
    }
}

