/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.colorpicker;

import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.PaintPicker;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.PaintPickerController;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.gradientpicker.GradientPicker;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.gradientpicker.GradientPickerStop;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.shape.Circle;

public class ColorPicker
extends VBox {
    @FXML
    private Region chip_region;
    @FXML
    private Region alpha_region;
    @FXML
    private ScrollPane picker_scrollpane;
    @FXML
    private Region picker_region;
    @FXML
    private StackPane picker_handle_stackpane;
    @FXML
    private Circle picker_handle_chip_circle;
    @FXML
    private Slider hue_slider;
    @FXML
    private Slider alpha_slider;
    @FXML
    private TextField hue_textfield;
    @FXML
    private TextField saturation_textfield;
    @FXML
    private TextField brightness_textfield;
    @FXML
    private TextField red_textfield;
    @FXML
    private TextField green_textfield;
    @FXML
    private TextField blue_textfield;
    @FXML
    private TextField alpha_textfield;
    @FXML
    private TextField hexa_textfield;
    private final PaintPickerController paintPickerController;
    private boolean updating = false;

    public ColorPicker(PaintPickerController pe) {
        this.paintPickerController = pe;
        this.initialize();
    }

    public Color getValue() {
        double hue = Double.valueOf(this.hue_textfield.getText());
        double saturation = Double.valueOf(this.saturation_textfield.getText()) / 100.0;
        double brightness = Double.valueOf(this.brightness_textfield.getText()) / 100.0;
        double alpha = Double.valueOf(this.alpha_textfield.getText());
        return Color.hsb((double)hue, (double)saturation, (double)brightness, (double)alpha);
    }

    public void updateUI(Color color) {
        double hue = color.getHue();
        double saturation = color.getSaturation();
        double brightness = color.getBrightness();
        double alpha = color.getOpacity();
        this.updateUI(hue, saturation, brightness, alpha);
    }

    private void initialize() {
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(ColorPicker.class.getResource("ColorPicker.fxml"));
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        try {
            loader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(ColorPicker.class.getName()).log(Level.SEVERE, null, ex);
        }
        assert (this.hue_slider != null);
        assert (this.picker_region != null);
        assert (this.hue_textfield != null);
        assert (this.saturation_textfield != null);
        assert (this.brightness_textfield != null);
        assert (this.alpha_textfield != null);
        assert (this.red_textfield != null);
        assert (this.green_textfield != null);
        assert (this.blue_textfield != null);
        assert (this.alpha_slider != null);
        this.hue_slider.setStyle(this.makeHueSliderCSS());
        this.picker_region.boundsInParentProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> ov, Bounds oldb, Bounds newb) {
                GradientPicker gradientPicker;
                GradientPickerStop gradientPickerStop;
                ColorPicker.this.picker_scrollpane.setHvalue(0.5);
                ColorPicker.this.picker_scrollpane.setVvalue(0.5);
                Paint paint = ColorPicker.this.paintPickerController.getPaintProperty();
                if (paint instanceof Color) {
                    ColorPicker.this.updateUI((Color)paint);
                } else if ((paint instanceof LinearGradient || paint instanceof RadialGradient) && (gradientPickerStop = (gradientPicker = ColorPicker.this.paintPickerController.getGradientPicker()).getSelectedStop()) != null) {
                    ColorPicker.this.updateUI(gradientPickerStop.getColor());
                }
            }
        });
        ChangeListener<Boolean> onHSBFocusedChange = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Color color = ColorPicker.this.updateUI_OnHSBChange();
                    ColorPicker.this.setPaintProperty(color);
                }
            }
        };
        ChangeListener<Boolean> onRGBFocusedChange = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Color color = ColorPicker.this.updateUI_OnRGBChange();
                    ColorPicker.this.setPaintProperty(color);
                }
            }
        };
        ChangeListener<Boolean> onHexaFocusedChange = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    try {
                        Color color = ColorPicker.this.updateUI_OnHexaChange();
                        ColorPicker.this.setPaintProperty(color);
                    }
                    catch (IllegalArgumentException iae) {
                        ColorPicker.this.handleHexaException();
                    }
                }
            }
        };
        this.hue_textfield.focusedProperty().addListener((ChangeListener)onHSBFocusedChange);
        this.saturation_textfield.focusedProperty().addListener((ChangeListener)onHSBFocusedChange);
        this.brightness_textfield.focusedProperty().addListener((ChangeListener)onHSBFocusedChange);
        this.alpha_textfield.focusedProperty().addListener((ChangeListener)onHSBFocusedChange);
        this.red_textfield.focusedProperty().addListener((ChangeListener)onRGBFocusedChange);
        this.green_textfield.focusedProperty().addListener((ChangeListener)onRGBFocusedChange);
        this.blue_textfield.focusedProperty().addListener((ChangeListener)onRGBFocusedChange);
        this.hexa_textfield.focusedProperty().addListener((ChangeListener)onHexaFocusedChange);
        this.hue_slider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                if (ColorPicker.this.updating) {
                    return;
                }
                double hue = newValue.doubleValue();
                double saturation = Double.valueOf(ColorPicker.this.saturation_textfield.getText()) / 100.0;
                double brightness = Double.valueOf(ColorPicker.this.brightness_textfield.getText()) / 100.0;
                double alpha = Double.valueOf(ColorPicker.this.alpha_textfield.getText());
                Color color = ColorPicker.this.updateUI(hue, saturation, brightness, alpha);
                ColorPicker.this.setPaintProperty(color);
            }
        });
        this.alpha_slider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                if (ColorPicker.this.updating) {
                    return;
                }
                double alpha = newValue.doubleValue();
                double hue = Double.valueOf(ColorPicker.this.hue_textfield.getText());
                double saturation = Double.valueOf(ColorPicker.this.saturation_textfield.getText()) / 100.0;
                double brightness = Double.valueOf(ColorPicker.this.brightness_textfield.getText()) / 100.0;
                Color color = ColorPicker.this.updateUI(hue, saturation, brightness, alpha);
                ColorPicker.this.setPaintProperty(color);
            }
        });
        ChangeListener<Boolean> liveUpdateListener = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
                ColorPicker.this.paintPickerController.setLiveUpdate(newValue);
            }
        };
        this.picker_region.pressedProperty().addListener((ChangeListener)liveUpdateListener);
        this.hue_slider.pressedProperty().addListener((ChangeListener)liveUpdateListener);
        this.alpha_slider.pressedProperty().addListener((ChangeListener)liveUpdateListener);
    }

    private void setPaintProperty(Color color) {
        Color paint;
        PaintPicker.Mode mode = this.paintPickerController.getMode();
        switch (mode) {
            case COLOR: {
                paint = color;
                break;
            }
            case LINEAR: 
            case RADIAL: {
                GradientPicker gradientPicker = this.paintPickerController.getGradientPicker();
                GradientPickerStop gradientPickerStop = gradientPicker.getSelectedStop();
                if (gradientPickerStop != null) {
                    gradientPickerStop.setColor(color);
                }
                paint = gradientPicker.getValue(mode);
                gradientPicker.updatePreview((Paint)paint);
                break;
            }
            default: {
                paint = null;
            }
        }
        this.paintPickerController.setPaintProperty((Paint)paint);
    }

    @FXML
    void onActionHue(ActionEvent event) {
        this.onHSBChange(event);
    }

    @FXML
    void onActionSaturation(ActionEvent event) {
        this.onHSBChange(event);
    }

    @FXML
    void onActionBrightness(ActionEvent event) {
        this.onHSBChange(event);
    }

    @FXML
    void onActionAlpha(ActionEvent event) {
        this.onHSBChange(event);
    }

    @FXML
    void onActionRed(ActionEvent event) {
        this.onRGBChange(event);
    }

    @FXML
    void onActionGreen(ActionEvent event) {
        this.onRGBChange(event);
    }

    @FXML
    void onActionBlue(ActionEvent event) {
        this.onRGBChange(event);
    }

    @FXML
    void onActionHexa(ActionEvent event) {
        this.onHexaChange(event);
    }

    private void onHSBChange(ActionEvent event) {
        Color color = this.updateUI_OnHSBChange();
        Object source = event.getSource();
        assert (source instanceof TextField);
        ((TextField)source).selectAll();
        this.setPaintProperty(color);
    }

    private void onRGBChange(ActionEvent event) {
        Color color = this.updateUI_OnRGBChange();
        Object source = event.getSource();
        assert (source instanceof TextField);
        ((TextField)source).selectAll();
        this.setPaintProperty(color);
    }

    private void onHexaChange(ActionEvent event) {
        try {
            Color color = this.updateUI_OnHexaChange();
            Object source = event.getSource();
            assert (source instanceof TextField);
            ((TextField)source).selectAll();
            this.setPaintProperty(color);
        }
        catch (IllegalArgumentException iae) {
            this.handleHexaException();
        }
    }

    @FXML
    void onPickerRegionPressed(MouseEvent e) {
        double mx = e.getX();
        double my = e.getY();
        Color color = this.updateUI_OnPickerChange(mx, my);
        this.setPaintProperty(color);
    }

    @FXML
    void onPickerRegionDragged(MouseEvent e) {
        double mx = e.getX();
        double my = e.getY();
        Color color = this.updateUI_OnPickerChange(mx, my);
        this.setPaintProperty(color);
    }

    private Color updateUI_OnPickerChange(double x, double y) {
        double w = this.picker_region.getWidth();
        double h = this.picker_region.getHeight();
        double hue = Double.valueOf(this.hue_textfield.getText());
        double saturation = x / w;
        double brightness = 1.0 - y / h;
        double alpha = Double.valueOf(this.alpha_textfield.getText());
        return this.updateUI(hue, saturation, brightness, alpha);
    }

    private Color updateUI_OnHSBChange() {
        double hue = Double.valueOf(this.hue_textfield.getText());
        double saturation = Double.valueOf(this.saturation_textfield.getText()) / 100.0;
        double brightness = Double.valueOf(this.brightness_textfield.getText()) / 100.0;
        double alpha = Double.valueOf(this.alpha_textfield.getText());
        return this.updateUI(hue, saturation, brightness, alpha);
    }

    private Color updateUI_OnRGBChange() {
        int red = Double.valueOf(this.red_textfield.getText()).intValue();
        int green = Double.valueOf(this.green_textfield.getText()).intValue();
        int blue = Double.valueOf(this.blue_textfield.getText()).intValue();
        Color color = Color.rgb((int)red, (int)green, (int)blue);
        double hue = color.getHue();
        double saturation = color.getSaturation();
        double brightness = color.getBrightness();
        double alpha = Double.valueOf(this.alpha_textfield.getText());
        return this.updateUI(hue, saturation, brightness, alpha);
    }

    private Color updateUI_OnHexaChange() {
        String hexa = this.hexa_textfield.getText().trim();
        Color color = Color.web((String)hexa);
        double hue = color.getHue();
        double saturation = color.getSaturation();
        double brightness = color.getBrightness();
        double alpha = Double.valueOf(this.alpha_textfield.getText());
        return this.updateUI(hue, saturation, brightness, alpha);
    }

    private Color updateUI(double hue, double saturation, double brightness, double alpha) {
        this.updating = true;
        hue = PaintPickerController.clamp(0.0, hue, 360.0);
        saturation = PaintPickerController.clamp(0.0, saturation, 1.0);
        brightness = PaintPickerController.clamp(0.0, brightness, 1.0);
        alpha = PaintPickerController.clamp(0.0, alpha, 1.0);
        Color color = Color.hsb((double)hue, (double)saturation, (double)brightness, (double)alpha);
        int red = (int)(color.getRed() * 255.0);
        int green = (int)(color.getGreen() * 255.0);
        int blue = (int)(color.getBlue() * 255.0);
        String hexa = String.format("#%02x%02x%02x", red, green, blue);
        this.hue_textfield.setText(String.valueOf((int)hue));
        this.saturation_textfield.setText(String.valueOf((int)(saturation * 100.0)));
        this.brightness_textfield.setText(String.valueOf((int)(brightness * 100.0)));
        double alpha_rounded = this.round(alpha, 100);
        this.alpha_textfield.setText(Double.toString(alpha_rounded));
        this.red_textfield.setText(Integer.toString(red));
        this.green_textfield.setText(Integer.toString(green));
        this.blue_textfield.setText(Integer.toString(blue));
        this.hexa_textfield.setText(hexa);
        StringBuilder sb = new StringBuilder();
        sb.append("hsb(");
        sb.append(hue);
        sb.append(", ");
        sb.append(saturation * 100.0);
        sb.append("%, ");
        sb.append(brightness * 100.0);
        sb.append("%, ");
        sb.append(alpha);
        sb.append(")");
        String hsbCssValue = sb.toString();
        String chipStyle = "-fx-background-color: " + hsbCssValue;
        this.chip_region.setStyle(chipStyle);
        this.picker_handle_chip_circle.setFill((Paint)Color.rgb((int)red, (int)green, (int)blue));
        String alphaChipStyle = "-fx-background-color: linear-gradient(to right, transparent, " + hsbCssValue + ")";
        this.alpha_region.setStyle(alphaChipStyle);
        String pickerRegionStyle = "-fx-background-color: hsb(" + hue + ", 100%, 100%, 1.0);";
        this.picker_region.setStyle(pickerRegionStyle);
        double xSat = this.picker_region.getWidth() * saturation;
        double yBri = this.picker_region.getHeight() * (1.0 - brightness);
        double xPos = this.picker_region.getBoundsInParent().getMinX() + xSat - this.picker_handle_stackpane.getWidth() / 2.0;
        double yPos = this.picker_region.getBoundsInParent().getMinY() + yBri - this.picker_handle_stackpane.getHeight() / 2.0;
        this.picker_handle_stackpane.setLayoutX(xPos);
        this.picker_handle_stackpane.setLayoutY(yPos);
        this.hue_slider.adjustValue(hue);
        this.alpha_slider.adjustValue(alpha);
        this.updating = false;
        return color;
    }

    private String makeHueSliderCSS() {
        StringBuilder sb = new StringBuilder();
        sb.append("-fx-background-color: linear-gradient(to right ");
        for (int i = 0; i < 12; ++i) {
            sb.append(", hsb(");
            sb.append(i * 32);
            sb.append(", 100%, 100%)");
        }
        sb.append(");");
        return sb.toString();
    }

    private double round(double value, int roundingFactor) {
        double doubleRounded = Math.round(value * (double)roundingFactor);
        return doubleRounded / (double)roundingFactor;
    }

    private void handleHexaException() {
        Color color;
        this.paintPickerController.getDelegate().handleError("log.warning.color.creation.error.hexadecimal", this.hexa_textfield.getText().trim());
        switch (this.paintPickerController.getMode()) {
            case COLOR: {
                assert (this.paintPickerController.getPaintProperty() instanceof Color);
                color = (Color)this.paintPickerController.getPaintProperty();
                break;
            }
            case LINEAR: 
            case RADIAL: {
                GradientPicker gradientPicker = this.paintPickerController.getGradientPicker();
                if (!gradientPicker.getGradientStops().isEmpty()) {
                    GradientPickerStop stop = this.paintPickerController.getGradientPicker().getSelectedStop();
                    assert (stop != null);
                    color = stop.getColor();
                    break;
                }
                color = Color.BLACK;
                break;
            }
            default: {
                color = null;
                assert (false);
                break;
            }
        }
        assert (color != null);
        this.updateUI(color);
        this.hexa_textfield.selectAll();
    }
}

