/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.slider;

import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.gradientpicker.GradientPicker;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;

public class SliderControl
extends GridPane {
    @FXML
    private Slider slider_slider;
    @FXML
    private Label slider_label;
    @FXML
    private TextField slider_textfield;
    private final int roundingFactor = 100;

    public SliderControl(String text, double min, double max, double initVal) {
        this.initialize(text, min, max, initVal);
    }

    public final Slider getSlider() {
        return this.slider_slider;
    }

    private void initialize(String text, double min, double max, double initVal) {
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(SliderControl.class.getResource("SliderControl.fxml"));
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        try {
            loader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(GradientPicker.class.getName()).log(Level.SEVERE, null, ex);
        }
        assert (this.slider_label != null);
        assert (this.slider_slider != null);
        assert (this.slider_textfield != null);
        this.slider_label.setText(text);
        this.slider_slider.setMin(min);
        this.slider_slider.setMax(max);
        this.slider_slider.setValue(initVal);
        this.slider_textfield.setText(Double.toString(initVal));
        this.slider_slider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                double rounded = SliderControl.this.round(newValue.doubleValue(), 100);
                SliderControl.this.slider_textfield.setText(Double.toString(rounded));
            }
        });
    }

    @FXML
    void sliderAction(ActionEvent event) {
        double value = Double.valueOf(this.slider_textfield.getText());
        double rounded = this.round(value, 100);
        this.slider_slider.setValue(rounded);
        if (rounded > this.slider_slider.getMax()) {
            rounded = this.slider_slider.getMax();
            this.slider_textfield.setText(Double.toString(rounded));
        }
        if (rounded < this.slider_slider.getMin()) {
            rounded = this.slider_slider.getMin();
            this.slider_textfield.setText(Double.toString(rounded));
        }
        this.slider_textfield.selectAll();
    }

    @FXML
    void sliderKeyPressed(KeyEvent e) {
        switch (e.getCode()) {
            case UP: {
                this.incOrDecFieldValue(e, 0.1);
                break;
            }
            case DOWN: {
                this.incOrDecFieldValue(e, -0.1);
                break;
            }
        }
    }

    private void incOrDecFieldValue(KeyEvent e, double x) {
        if (!(e.getSource() instanceof TextField)) {
            return;
        }
        TextField tf = (TextField)e.getSource();
        Double newValue = Double.valueOf(tf.getText()) + x;
        double rounded = this.round(newValue, 100);
        this.slider_slider.setValue(rounded);
        tf.setText(Double.toString(newValue));
    }

    private double round(double value, int roundingFactor) {
        double doubleRounded = Math.round(value * (double)roundingFactor);
        return doubleRounded / (double)roundingFactor;
    }
}

