/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LexicalContextExpression;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.annotations.Ignore;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class CallNode
extends LexicalContextExpression {
    private final Expression function;
    private final List<Expression> args;
    public static final int IS_NEW = 1;
    private final int flags;
    private final int lineNumber;
    @Ignore
    private final EvalArgs evalArgs;

    public CallNode(int lineNumber, long token, int finish, Expression function, List<Expression> args) {
        super(token, finish);
        this.function = function;
        this.args = args;
        this.flags = 0;
        this.evalArgs = null;
        this.lineNumber = lineNumber;
    }

    private CallNode(CallNode callNode, Expression function, List<Expression> args, int flags, EvalArgs evalArgs) {
        super(callNode);
        this.lineNumber = callNode.lineNumber;
        this.function = function;
        this.args = args;
        this.flags = flags;
        this.evalArgs = evalArgs;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public Type getType() {
        return this.function instanceof FunctionNode ? ((FunctionNode)this.function).getReturnType() : Type.OBJECT;
    }

    @Override
    public Node accept(LexicalContext lc, NodeVisitor<? extends LexicalContext> visitor) {
        CallNode newCallNode;
        if (visitor.enterCallNode(this) && this != (newCallNode = (CallNode)visitor.leaveCallNode(this.setFunction((Expression)this.function.accept(visitor)).setArgs(Node.accept(visitor, Expression.class, this.args)).setFlags(this.flags).setEvalArgs(this.evalArgs == null ? null : this.evalArgs.setCode((Expression)this.evalArgs.getCode().accept(visitor)).setThis((IdentNode)this.evalArgs.getThis().accept(visitor)))))) {
            return Node.replaceInLexicalContext(lc, this, newCallNode);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        this.function.toString(sb);
        sb.append('(');
        boolean first = true;
        for (Node node : this.args) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            node.toString(sb);
        }
        sb.append(')');
    }

    public List<Expression> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    private CallNode setArgs(List<Expression> args) {
        if (this.args == args) {
            return this;
        }
        return new CallNode(this, this.function, args, this.flags, this.evalArgs);
    }

    public EvalArgs getEvalArgs() {
        return this.evalArgs;
    }

    public CallNode setEvalArgs(EvalArgs evalArgs) {
        if (this.evalArgs == evalArgs) {
            return this;
        }
        return new CallNode(this, this.function, this.args, this.flags, evalArgs);
    }

    public boolean isEval() {
        return this.evalArgs != null;
    }

    public Expression getFunction() {
        return this.function;
    }

    public CallNode setFunction(Expression function) {
        if (this.function == function) {
            return this;
        }
        return new CallNode(this, function, this.args, this.flags, this.evalArgs);
    }

    public boolean isNew() {
        return (this.flags & 1) == 1;
    }

    public CallNode setIsNew() {
        return this.setFlags(1);
    }

    private CallNode setFlags(int flags) {
        if (this.flags == flags) {
            return this;
        }
        return new CallNode(this, this.function, this.args, flags, this.evalArgs);
    }

    public static class EvalArgs {
        private final Expression code;
        private final IdentNode evalThis;
        private final String location;
        private final boolean strictMode;

        public EvalArgs(Expression code, IdentNode evalThis, String location, boolean strictMode) {
            this.code = code;
            this.evalThis = evalThis;
            this.location = location;
            this.strictMode = strictMode;
        }

        public Expression getCode() {
            return this.code;
        }

        private EvalArgs setCode(Expression code) {
            if (this.code == code) {
                return this;
            }
            return new EvalArgs(code, this.evalThis, this.location, this.strictMode);
        }

        public IdentNode getThis() {
            return this.evalThis;
        }

        private EvalArgs setThis(IdentNode evalThis) {
            if (this.evalThis == evalThis) {
                return this;
            }
            return new EvalArgs(this.code, evalThis, this.location, this.strictMode);
        }

        public String getLocation() {
            return this.location;
        }

        public boolean getStrictMode() {
            return this.strictMode;
        }
    }
}

