/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.util.Collections;
import jdk.nashorn.internal.objects.ArrayBufferView;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArrayBuffer;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.arrays.ArrayData;

public final class NativeFloat32Array
extends ArrayBufferView {
    public static final int BYTES_PER_ELEMENT = 4;
    private static PropertyMap $nasgenmap$;
    private static final ArrayBufferView.Factory FACTORY;

    public static Object constructor(boolean newObj, Object self, Object ... args) {
        return NativeFloat32Array.constructorImpl(args, FACTORY);
    }

    NativeFloat32Array(NativeArrayBuffer buffer, int byteOffset, int length) {
        super(buffer, byteOffset, length);
    }

    @Override
    public String getClassName() {
        return "Float32Array";
    }

    @Override
    protected ArrayBufferView.Factory factory() {
        return FACTORY;
    }

    @Override
    protected boolean isFloatArray() {
        return true;
    }

    protected static Object set(Object self, Object array, Object offset) {
        return ArrayBufferView.setImpl(self, array, offset);
    }

    protected static Object subarray(Object self, Object begin, Object end) {
        return ArrayBufferView.subarrayImpl(self, begin, end);
    }

    @Override
    protected ScriptObject getPrototype(Global global) {
        return global.getFloat32ArrayPrototype();
    }

    static {
        FACTORY = new ArrayBufferView.Factory(4){

            @Override
            public ArrayBufferView construct(NativeArrayBuffer buffer, int byteOffset, int length) {
                return new NativeFloat32Array(buffer, byteOffset, length);
            }

            @Override
            public ArrayData createArrayData(NativeArrayBuffer buffer, int byteOffset, int length) {
                return new Float32ArrayData(buffer, byteOffset, length);
            }
        };
        NativeFloat32Array.$clinit$();
    }

    public static void $clinit$() {
        $nasgenmap$ = PropertyMap.newMap(Collections.EMPTY_LIST).setIsShared();
    }

    private static final class Float32ArrayData
    extends ArrayBufferView.ArrayDataImpl {
        private Float32ArrayData(NativeArrayBuffer buffer, int byteOffset, int elementLength) {
            super(buffer, byteOffset, elementLength);
        }

        @Override
        protected int byteIndex(int index) {
            return index * 4 + this.byteOffset;
        }

        @Override
        protected double getDoubleImpl(int index) {
            int byteIndex = this.byteIndex(index);
            byte[] byteArray = this.buffer.getByteArray();
            int bits = byteArray[byteIndex] & 0xFF | byteArray[byteIndex + 1] << 8 & 0xFF00 | byteArray[byteIndex + 2] << 16 & 0xFF0000 | byteArray[byteIndex + 3] << 24 & 0xFF000000;
            return Float.intBitsToFloat(bits);
        }

        @Override
        protected int getIntImpl(int index) {
            return (int)this.getDoubleImpl(index);
        }

        @Override
        protected long getLongImpl(int key) {
            return (long)this.getDoubleImpl(key);
        }

        @Override
        protected Object getObjectImpl(int key) {
            return this.getDoubleImpl(key);
        }

        @Override
        protected void setImpl(int index, double value) {
            int bits = Float.floatToRawIntBits((float)value);
            int byteIndex = this.byteIndex(index);
            byte[] byteArray = this.buffer.getByteArray();
            byteArray[byteIndex] = (byte)(bits & 0xFF);
            byteArray[byteIndex + 1] = (byte)(bits >>> 8 & 0xFF);
            byteArray[byteIndex + 2] = (byte)(bits >>> 16 & 0xFF);
            byteArray[byteIndex + 3] = (byte)(bits >>> 24 & 0xFF);
        }

        @Override
        protected void setImpl(int key, int value) {
            this.setImpl(key, (double)value);
        }

        @Override
        protected void setImpl(int key, long value) {
            this.setImpl(key, (double)value);
        }

        @Override
        protected void setImpl(int key, Object value) {
            this.setImpl(key, JSType.toNumber(value));
        }
    }
}

