/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.UserAccessorProperty;

public final class FindProperty {
    private final ScriptObject self;
    private final ScriptObject prototype;
    private final Property property;

    public FindProperty(ScriptObject self, ScriptObject prototype, Property property) {
        this.self = self;
        this.prototype = prototype;
        this.property = property;
    }

    public MethodHandle getGetter(Class<?> type) {
        MethodHandle getter = this.property.getGetter(type);
        if (this.property instanceof UserAccessorProperty) {
            UserAccessorProperty uc = (UserAccessorProperty)this.property;
            getter = Lookup.MH.insertArguments(getter, 0, this.isInherited() ? this.getOwner() : null, uc.getGetterSlot());
        }
        return getter;
    }

    public MethodHandle getSetter(Class<?> type, boolean strict) {
        MethodHandle setter = this.property.getSetter(type, this.getOwner().getMap());
        if (this.property instanceof UserAccessorProperty) {
            UserAccessorProperty uc = (UserAccessorProperty)this.property;
            setter = Lookup.MH.insertArguments(setter, 0, this.isInherited() ? this.getOwner() : null, uc.getSetterSlot(), strict ? this.property.getKey() : null);
        }
        return setter;
    }

    public ScriptObject getOwner() {
        return this.prototype;
    }

    public ScriptObject getGetterReceiver() {
        return this.property != null && this.property.hasGetterFunction(this.prototype) ? this.self : this.prototype;
    }

    public ScriptObject getSetterReceiver() {
        return this.property != null && this.property.hasSetterFunction(this.prototype) ? this.self : this.prototype;
    }

    public Property getProperty() {
        return this.property;
    }

    public boolean isInherited() {
        return this.self != this.prototype;
    }

    public boolean isSelf() {
        return this.self == this.prototype;
    }

    public boolean isScope() {
        return this.prototype.isScope();
    }

    public Object getObjectValue() {
        return this.property.getObjectValue(this.getGetterReceiver(), this.getOwner());
    }

    public void setObjectValue(Object value, boolean strict) {
        this.property.setObjectValue(this.getSetterReceiver(), this.getOwner(), value, strict);
    }
}

