/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app;

import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import com.oracle.javafx.scenebuilder.app.util.MessageBox;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import com.sun.glass.ui.Application;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;

public class AppPlatform {
    private static String applicationDataFolder;
    private static String userLibraryFolder;
    private static String messageBoxFolder;
    private static MessageBox<MessageBoxMessage> messageBox;
    private static boolean startingFromTestBed;

    public static synchronized String getApplicationDataFolder() {
        if (applicationDataFolder == null) {
            String appName = "Scene Builder";
            if (EditorPlatform.IS_WINDOWS) {
                applicationDataFolder = System.getenv("APPDATA") + "\\" + "Scene Builder";
            } else if (EditorPlatform.IS_MAC) {
                applicationDataFolder = System.getProperty("user.home") + "/Library/Application Support/" + "Scene Builder";
            } else if (EditorPlatform.IS_LINUX) {
                applicationDataFolder = System.getProperty("user.home") + "/.scenebuilder";
            }
        }
        assert (applicationDataFolder != null);
        return applicationDataFolder;
    }

    public static synchronized String getUserLibraryFolder() {
        if (userLibraryFolder == null) {
            userLibraryFolder = AppPlatform.getApplicationDataFolder() + "/Library";
        }
        return userLibraryFolder;
    }

    public static boolean requestStart(AppNotificationHandler notificationHandler, Application.Parameters parameters) throws IOException {
        if (EditorPlatform.IS_MAC) {
            return AppPlatform.requestStartMac(notificationHandler, parameters);
        }
        if (EditorPlatform.isAssertionEnabled()) {
            notificationHandler.handleLaunch(parameters.getUnnamed());
            return true;
        }
        return AppPlatform.requestStartGeneric(notificationHandler, parameters);
    }

    private static synchronized boolean requestStartGeneric(AppNotificationHandler notificationHandler, Application.Parameters parameters) throws IOException {
        boolean result;
        assert (notificationHandler != null);
        assert (parameters != null);
        assert (messageBox == null);
        try {
            Files.createDirectories(Paths.get(AppPlatform.getMessageBoxFolder(), new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException x) {
            // empty catch block
        }
        messageBox = new MessageBox<MessageBoxMessage>(AppPlatform.getMessageBoxFolder(), MessageBoxMessage.class, 1000);
        if (messageBox.grab(new MessageBoxDelegate(notificationHandler))) {
            notificationHandler.handleLaunch(parameters.getUnnamed());
            result = true;
        } else {
            result = false;
            MessageBoxMessage unamedParameters = new MessageBoxMessage(parameters.getUnnamed());
            try {
                messageBox.sendMessage(unamedParameters);
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }
        return result;
    }

    private static String getMessageBoxFolder() {
        if (messageBoxFolder == null) {
            messageBoxFolder = AppPlatform.getApplicationDataFolder() + "/MB";
        }
        return messageBoxFolder;
    }

    private static boolean requestStartMac(AppNotificationHandler notificationHandler, Application.Parameters parameters) {
        Platform.setImplicitExit((boolean)false);
        notificationHandler.handleLaunch(Collections.emptyList());
        Deprecation.setPlatformEventHandler(new MacEventHandler(notificationHandler, Deprecation.getPlatformEventHandler()));
        return true;
    }

    public static void setStartingFromTestBed(boolean macWorkaroundEnabled) {
        startingFromTestBed = macWorkaroundEnabled;
    }

    private static class MacEventHandler
    extends Application.EventHandler {
        private final AppNotificationHandler notificationHandler;
        private final Application.EventHandler oldEventHandler;
        private int openFilesCount;

        public MacEventHandler(AppNotificationHandler notificationHandler, Application.EventHandler oldEventHandler) {
            assert (notificationHandler != null);
            this.notificationHandler = notificationHandler;
            this.oldEventHandler = oldEventHandler;
        }

        public void handleDidFinishLaunchingAction(Application app, long time) {
            if (this.oldEventHandler != null) {
                this.oldEventHandler.handleDidFinishLaunchingAction(app, time);
            }
        }

        public void handleDidBecomeActiveAction(Application app, long time) {
            if (this.oldEventHandler != null) {
                this.oldEventHandler.handleDidBecomeActiveAction(app, time);
            }
        }

        public void handleOpenFilesAction(Application app, long time, String[] files) {
            boolean openRejected;
            if (this.oldEventHandler != null) {
                this.oldEventHandler.handleOpenFilesAction(app, time, files);
            }
            if (!(openRejected = startingFromTestBed ? true : (this.openFilesCount++ == 0 ? files.length == 1 && files[0].equals(SceneBuilderApp.class.getName()) : false))) {
                this.notificationHandler.handleOpenFilesAction(Arrays.asList(files));
            }
        }

        public void handleQuitAction(Application app, long time) {
            if (this.oldEventHandler != null) {
                this.oldEventHandler.handleQuitAction(app, time);
            }
            this.notificationHandler.handleQuitAction();
        }
    }

    private static class MessageBoxDelegate
    implements MessageBox.Delegate<MessageBoxMessage> {
        private final AppNotificationHandler eventHandler;

        public MessageBoxDelegate(AppNotificationHandler eventHandler) {
            assert (eventHandler != null);
            this.eventHandler = eventHandler;
        }

        @Override
        public void messageBoxDidGetMessage(final MessageBoxMessage message) {
            assert (!Platform.isFxApplicationThread());
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    eventHandler.handleOpenFilesAction(message);
                }
            });
        }

        @Override
        public void messageBoxDidCatchException(final Exception x) {
            assert (!Platform.isFxApplicationThread());
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    eventHandler.handleMessageBoxFailure(x);
                }
            });
        }
    }

    private static class MessageBoxMessage
    extends ArrayList<String> {
        static final long serialVersionUID = 10L;

        public MessageBoxMessage(List<String> strings) {
            super(strings);
        }
    }

    public static interface AppNotificationHandler {
        public void handleLaunch(List<String> var1);

        public void handleOpenFilesAction(List<String> var1);

        public void handleMessageBoxFailure(Exception var1);

        public void handleQuitAction();
    }
}

