/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app;

import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.ResourceController;
import com.oracle.javafx.scenebuilder.app.SceneStyleSheetMenuController;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.util.FileWatcher;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;

public class DocumentWatchingController
implements FileWatcher.Delegate {
    private final DocumentWindowController documentWindowController;
    private final EditorController editorController;
    private final ResourceController resourceController;
    private final SceneStyleSheetMenuController sceneStyleSheetMenuController;
    private final FileWatcher fileWatcher = new FileWatcher(2000L, this, DocumentWindowController.class.getSimpleName());

    public DocumentWatchingController(DocumentWindowController documentWindowController) {
        this.documentWindowController = documentWindowController;
        this.editorController = documentWindowController.getEditorController();
        this.resourceController = documentWindowController.getResourceController();
        this.sceneStyleSheetMenuController = documentWindowController.getSceneStyleSheetMenuController();
        this.editorController.sceneStyleSheetProperty().addListener((ChangeListener)new ChangeListener<ObservableList<File>>(){

            public void changed(ObservableValue<? extends ObservableList<File>> ov, ObservableList<File> t, ObservableList<File> t1) {
                DocumentWatchingController.this.update();
            }
        });
    }

    public void start() {
        this.fileWatcher.start();
    }

    public void stop() {
        this.fileWatcher.stop();
    }

    public void update() {
        ArrayList<Path> targets = new ArrayList<Path>();
        FXOMDocument fxomDocument = this.editorController.getFxomDocument();
        if (fxomDocument != null && fxomDocument.getLocation() != null) {
            try {
                File fxmlFile = new File(fxomDocument.getLocation().toURI());
                targets.add(fxmlFile.toPath());
            }
            catch (URISyntaxException x) {
                throw new IllegalStateException("Bug", x);
            }
        }
        if (this.resourceController.getResourceFile() != null) {
            targets.add(this.resourceController.getResourceFile().toPath());
        }
        if (this.editorController.getSceneStyleSheets() != null) {
            for (File sceneStyleSheet : this.editorController.getSceneStyleSheets()) {
                targets.add(sceneStyleSheet.toPath());
            }
        }
        this.fileWatcher.setTargets(targets);
    }

    public void removeDocumentTarget() {
        FXOMDocument fxomDocument = this.editorController.getFxomDocument();
        assert (fxomDocument != null);
        assert (fxomDocument.getLocation() != null);
        try {
            File fxmlFile = new File(fxomDocument.getLocation().toURI());
            assert (this.fileWatcher.getTargets().contains(fxmlFile.toPath()));
            this.fileWatcher.removeTarget(fxmlFile.toPath());
        }
        catch (URISyntaxException x) {
            throw new IllegalStateException("Bug", x);
        }
    }

    @Override
    public void fileWatcherDidWatchTargetCreation(Path target) {
    }

    @Override
    public void fileWatcherDidWatchTargetDeletion(Path target) {
        if (this.isPathMatchingResourceLocation(target)) {
            this.resourceController.performRemoveResource();
            this.editorController.getMessageLog().logInfoMessage("log.info.file.deleted", I18N.getBundle(), target.getFileName());
        } else if (this.isPathMatchingSceneStyleSheet(target)) {
            this.sceneStyleSheetMenuController.performRemoveSceneStyleSheet(target.toFile());
            this.editorController.getMessageLog().logInfoMessage("log.info.file.deleted", I18N.getBundle(), target.getFileName());
        }
    }

    @Override
    public void fileWatcherDidWatchTargetModification(Path target) {
        FXOMDocument fxomDocument;
        if (this.isPathMatchingResourceLocation(target)) {
            this.resourceController.performReloadResource();
            this.editorController.getMessageLog().logInfoMessage("log.info.reload", I18N.getBundle(), target.getFileName());
        } else if (this.isPathMatchingDocumentLocation(target)) {
            if (!this.documentWindowController.isDocumentDirty()) {
                try {
                    this.documentWindowController.reload();
                    this.editorController.getMessageLog().logInfoMessage("log.info.reload", I18N.getBundle(), target.getFileName());
                }
                catch (IOException x) {}
            }
        } else if (this.isPathMatchingSceneStyleSheet(target) && (fxomDocument = this.editorController.getFxomDocument()) != null) {
            fxomDocument.reapplyCSS(target);
            this.editorController.getMessageLog().logInfoMessage("log.info.reload", I18N.getBundle(), target.getFileName());
        }
    }

    private boolean isPathMatchingDocumentLocation(Path p) {
        boolean result;
        FXOMDocument fxomDocument = this.editorController.getFxomDocument();
        if (fxomDocument != null && fxomDocument.getLocation() != null) {
            try {
                File fxmlFile = new File(fxomDocument.getLocation().toURI());
                result = p.equals(fxmlFile.toPath());
            }
            catch (URISyntaxException x) {
                throw new IllegalStateException("Bug", x);
            }
        } else {
            result = false;
        }
        return result;
    }

    private boolean isPathMatchingResourceLocation(Path p) {
        boolean result = this.resourceController.getResourceFile() != null ? p.equals(this.resourceController.getResourceFile().toPath()) : false;
        return result;
    }

    private boolean isPathMatchingSceneStyleSheet(Path p) {
        boolean result = this.editorController.getSceneStyleSheets() != null ? this.editorController.getSceneStyleSheets().contains((Object)p.toFile()) : false;
        return result;
    }
}

