/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app;

import com.oracle.javafx.scenebuilder.app.CssPanelDelegate;
import com.oracle.javafx.scenebuilder.app.CssPanelMenuController;
import com.oracle.javafx.scenebuilder.app.DocumentWatchingController;
import com.oracle.javafx.scenebuilder.app.ResourceController;
import com.oracle.javafx.scenebuilder.app.SBTextInputControlBindings;
import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import com.oracle.javafx.scenebuilder.app.SceneStyleSheetMenuController;
import com.oracle.javafx.scenebuilder.app.SplitController;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.app.info.InfoPanelController;
import com.oracle.javafx.scenebuilder.app.menubar.MenuBarController;
import com.oracle.javafx.scenebuilder.app.message.MessageBarController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordDocument;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordGlobal;
import com.oracle.javafx.scenebuilder.app.preview.BackgroundColorDialogController;
import com.oracle.javafx.scenebuilder.app.preview.PreviewWindowController;
import com.oracle.javafx.scenebuilder.app.report.JarAnalysisReportController;
import com.oracle.javafx.scenebuilder.app.selectionbar.SelectionBarController;
import com.oracle.javafx.scenebuilder.app.skeleton.SkeletonWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.css.CssPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.AbstractHierarchyPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.InspectorPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AbstractModalDialog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AlertDialog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.ErrorDialog;
import com.oracle.javafx.scenebuilder.kit.editor.search.SearchController;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.library.Library;
import com.oracle.javafx.scenebuilder.kit.library.user.UserLibrary;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.TitledPane;
import javafx.scene.input.Clipboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class DocumentWindowController
extends AbstractFxmlWindowController {
    private final EditorController editorController = new EditorController();
    private final MenuBarController menuBarController = new MenuBarController(this);
    private final ContentPanelController contentPanelController = new ContentPanelController(this.editorController);
    private final AbstractHierarchyPanelController hierarchyPanelController = new HierarchyPanelController(this.editorController);
    private final InfoPanelController infoPanelController = new InfoPanelController(this.editorController);
    private final InspectorPanelController inspectorPanelController = new InspectorPanelController(this.editorController);
    private final CssPanelDelegate cssPanelDelegate = new CssPanelDelegate(this.inspectorPanelController, this);
    private final CssPanelController cssPanelController = new CssPanelController(this.editorController, this.cssPanelDelegate);
    private final LibraryPanelController libraryPanelController = new LibraryPanelController(this.editorController);
    private final SelectionBarController selectionBarController = new SelectionBarController(this.editorController);
    private final MessageBarController messageBarController = new MessageBarController(this.editorController);
    private final SearchController librarySearchController = new SearchController(this.editorController);
    private final SearchController inspectorSearchController = new SearchController(this.editorController);
    private final SearchController cssPanelSearchController = new SearchController(this.editorController);
    private final SceneStyleSheetMenuController sceneStyleSheetMenuController = new SceneStyleSheetMenuController(this);
    private final CssPanelMenuController cssPanelMenuController = new CssPanelMenuController(this.cssPanelController);
    private final ResourceController resourceController = new ResourceController(this);
    private final DocumentWatchingController watchingController = new DocumentWatchingController(this);
    private PreviewWindowController previewWindowController = null;
    private SkeletonWindowController skeletonWindowController = null;
    private JarAnalysisReportController jarAnalysisReportController = null;
    @FXML
    private StackPane libraryPanelHost;
    @FXML
    private StackPane librarySearchPanelHost;
    @FXML
    private StackPane hierarchyPanelHost;
    @FXML
    private StackPane infoPanelHost;
    @FXML
    private StackPane contentPanelHost;
    @FXML
    private StackPane inspectorPanelHost;
    @FXML
    private StackPane inspectorSearchPanelHost;
    @FXML
    private StackPane cssPanelHost;
    @FXML
    private StackPane cssPanelSearchPanelHost;
    @FXML
    private StackPane messageBarHost;
    @FXML
    private Accordion documentAccordion;
    @FXML
    private SplitPane mainSplitPane;
    @FXML
    private SplitPane leftRightSplitPane;
    @FXML
    private SplitPane libraryDocumentSplitPane;
    @FXML
    private MenuButton libraryMenuButton;
    @FXML
    private MenuItem libraryImportSelection;
    @FXML
    private RadioMenuItem libraryViewAsList;
    @FXML
    private RadioMenuItem libraryViewAsSections;
    @FXML
    private MenuItem libraryReveal;
    @FXML
    private Menu customLibraryMenu;
    @FXML
    private MenuItem cssPanelShowStyledOnlyMi;
    @FXML
    private MenuItem cssPanelSplitDefaultsMi;
    @FXML
    private RadioMenuItem showInfoMenuItem;
    @FXML
    private RadioMenuItem showFxIdMenuItem;
    @FXML
    private RadioMenuItem showNodeIdMenuItem;
    private SplitController bottomSplitController;
    private SplitController leftSplitController;
    private SplitController rightSplitController;
    private SplitController librarySplitController;
    private SplitController documentSplitController;
    private FileTime loadFileTime;
    private Job saveJob;
    private static List<String> imageExtensions;
    private static List<String> audioExtensions;
    private static List<String> videoExtensions;
    private static List<String> mediaExtensions;
    private final EventHandler<KeyEvent> mainKeyEventFilter = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            boolean isSelectAll;
            Node focusOwner = DocumentWindowController.this.getScene().getFocusOwner();
            KeyCombination accelerator = DocumentWindowController.this.getAccelerator(event);
            if (DocumentWindowController.this.isTextInputControlEditing(focusOwner) && accelerator != null) {
                for (KeyBinding binding : SBTextInputControlBindings.getBindings()) {
                    if (binding.getSpecificity(null, event) <= 0) continue;
                    if (!DocumentWindowController.this.menuBarController.getMenuBar().isUseSystemMenuBar()) break;
                    event.consume();
                    break;
                }
            }
            boolean modifierDown = EditorPlatform.IS_MAC ? event.isMetaDown() : event.isControlDown();
            boolean bl = isSelectAll = KeyCode.A.equals((Object)event.getCode()) && modifierDown;
            if (DocumentWindowController.this.getHierarchyPanelController().getPanelControl().isFocused() && isSelectAll) {
                event.consume();
                if (!DocumentWindowController.this.menuBarController.getMenuBar().isUseSystemMenuBar() && DocumentWindowController.this.canPerformControlAction(DocumentControlAction.SELECT_ALL)) {
                    DocumentWindowController.this.performControlAction(DocumentControlAction.SELECT_ALL);
                }
            }
            boolean isBackspace = KeyCode.BACK_SPACE.equals((Object)event.getCode());
            if (!DocumentWindowController.this.isTextInputControlEditing(focusOwner) && isBackspace) {
                if (DocumentWindowController.this.canPerformEditAction(DocumentEditAction.DELETE)) {
                    DocumentWindowController.this.performEditAction(DocumentEditAction.DELETE);
                }
                event.consume();
            }
        }
    };

    public DocumentWindowController() {
        super(DocumentWindowController.class.getResource("DocumentWindow.fxml"), I18N.getBundle(), false);
        this.editorController.setLibrary(SceneBuilderApp.getSingleton().getUserLibrary());
    }

    public EditorController getEditorController() {
        return this.editorController;
    }

    public MenuBarController getMenuBarController() {
        return this.menuBarController;
    }

    public ContentPanelController getContentPanelController() {
        return this.contentPanelController;
    }

    public InspectorPanelController getInspectorPanelController() {
        return this.inspectorPanelController;
    }

    public CssPanelController getCssPanelController() {
        return this.cssPanelController;
    }

    public AbstractHierarchyPanelController getHierarchyPanelController() {
        return this.hierarchyPanelController;
    }

    public InfoPanelController getInfoPanelController() {
        return this.infoPanelController;
    }

    public PreviewWindowController getPreviewWindowController() {
        return this.previewWindowController;
    }

    public SceneStyleSheetMenuController getSceneStyleSheetMenuController() {
        return this.sceneStyleSheetMenuController;
    }

    public ResourceController getResourceController() {
        return this.resourceController;
    }

    public DocumentWatchingController getWatchingController() {
        return this.watchingController;
    }

    public SplitController getBottomSplitController() {
        return this.bottomSplitController;
    }

    public SplitController getLeftSplitController() {
        return this.leftSplitController;
    }

    public SplitController getRightSplitController() {
        return this.rightSplitController;
    }

    public SplitController getLibrarySplitController() {
        return this.librarySplitController;
    }

    public SplitController getDocumentSplitController() {
        return this.documentSplitController;
    }

    public void loadFromFile(File fxmlFile) throws IOException {
        URL fxmlURL = fxmlFile.toURI().toURL();
        String fxmlText = FXOMDocument.readContentFromURL(fxmlURL);
        this.editorController.setFxmlTextAndLocation(fxmlText, fxmlURL);
        this.updateLoadFileTime();
        this.updateStageTitle();
        this.updateFromDocumentPreferences();
        this.watchingController.update();
    }

    public void loadFromURL(URL fxmlURL) {
        assert (fxmlURL != null);
        try {
            String fxmlText = FXOMDocument.readContentFromURL(fxmlURL);
            this.editorController.setFxmlTextAndLocation(fxmlText, null);
            this.updateLoadFileTime();
            this.updateStageTitle();
            this.updateFromDocumentPreferences();
            this.watchingController.update();
        }
        catch (IOException x) {
            throw new IllegalStateException(x);
        }
    }

    public void loadWithDefaultContent() {
        try {
            this.editorController.setFxmlTextAndLocation("", null);
            this.updateLoadFileTime();
            this.updateStageTitle();
            this.watchingController.update();
        }
        catch (IOException x) {
            throw new IllegalStateException(x);
        }
    }

    public void reload() throws IOException {
        FXOMDocument fxomDocument = this.editorController.getFxomDocument();
        assert (fxomDocument != null && fxomDocument.getLocation() != null);
        URL fxmlURL = fxomDocument.getLocation();
        String fxmlText = FXOMDocument.readContentFromURL(fxmlURL);
        this.editorController.setFxmlTextAndLocation(fxmlText, fxmlURL);
        this.updateLoadFileTime();
    }

    public String getFxmlText() {
        return this.editorController.getFxmlText();
    }

    public void refreshLibraryDisplayOption(LibraryPanelController.DISPLAY_MODE option) {
        switch (option) {
            case LIST: {
                this.libraryViewAsList.setSelected(true);
                break;
            }
            case SECTIONS: {
                this.libraryViewAsSections.setSelected(true);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.libraryPanelController.setDisplayMode(option);
    }

    public void refreshHierarchyDisplayOption(AbstractHierarchyPanelController.DisplayOption option) {
        switch (option) {
            case INFO: {
                this.showInfoMenuItem.setSelected(true);
                break;
            }
            case FXID: {
                this.showFxIdMenuItem.setSelected(true);
                break;
            }
            case NODEID: {
                this.showNodeIdMenuItem.setSelected(true);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.hierarchyPanelController.setDisplayOption(option);
    }

    public void refreshCssTableColumnsOrderingReversed(boolean cssTableColumnsOrderingReversed) {
        this.cssPanelController.setTableColumnsOrderingReversed(cssTableColumnsOrderingReversed);
    }

    public static final String makeTitle(FXOMDocument fxomDocument) {
        String title;
        if (fxomDocument == null) {
            title = I18N.getString("label.no.document");
        } else if (fxomDocument.getLocation() == null) {
            title = I18N.getString("label.untitled");
        } else {
            String name = "";
            try {
                File toto = new File(fxomDocument.getLocation().toURI());
                name = toto.getName();
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException("Bug", ex);
            }
            title = name;
        }
        return title;
    }

    public boolean canPerformControlAction(DocumentControlAction controlAction) {
        boolean result;
        switch (controlAction) {
            case COPY: {
                result = this.canPerformCopy();
                break;
            }
            case SELECT_ALL: {
                result = this.canPerformSelectAll();
                break;
            }
            case SELECT_NONE: {
                result = this.canPerformSelectNone();
                break;
            }
            case SHOW_SAMPLE_CONTROLLER: {
                result = this.editorController.getFxomDocument() != null;
                break;
            }
            case TOGGLE_LIBRARY_PANEL: 
            case TOGGLE_DOCUMENT_PANEL: 
            case TOGGLE_CSS_PANEL: 
            case TOGGLE_LEFT_PANEL: 
            case TOGGLE_RIGHT_PANEL: 
            case TOGGLE_OUTLINES_VISIBILITY: 
            case TOGGLE_GUIDES_VISIBILITY: 
            case SHOW_PREVIEW_WINDOW: {
                result = true;
                break;
            }
            case CHOOSE_BACKGROUND_COLOR: {
                result = false;
                break;
            }
            case SAVE_FILE: {
                result = this.isDocumentDirty() || this.editorController.getFxomDocument().getLocation() == null;
                break;
            }
            case SAVE_AS_FILE: 
            case CLOSE_FILE: {
                result = true;
                break;
            }
            case REVERT_FILE: {
                result = this.isDocumentDirty() && this.editorController.getFxomDocument().getLocation() != null;
                break;
            }
            case REVEAL_FILE: {
                result = this.editorController.getFxomDocument() != null && this.editorController.getFxomDocument().getLocation() != null;
                break;
            }
            case GOTO_CONTENT: 
            case GOTO_PROPERTIES: 
            case GOTO_LAYOUT: 
            case GOTO_CODE: {
                result = true;
                break;
            }
            case ADD_SCENE_STYLE_SHEET: {
                result = true;
                break;
            }
            case SET_RESOURCE: {
                result = true;
                break;
            }
            case REMOVE_RESOURCE: 
            case REVEAL_RESOURCE: {
                result = this.resourceController.getResourceFile() != null;
                break;
            }
            case HELP: {
                result = true;
                break;
            }
            default: {
                result = false;
                assert (false);
                break;
            }
        }
        return result;
    }

    public void performControlAction(DocumentControlAction controlAction) {
        assert (this.canPerformControlAction(controlAction));
        PreferencesController pc = PreferencesController.getSingleton();
        PreferencesRecordDocument recordDocument = pc.getRecordDocument(this);
        switch (controlAction) {
            case COPY: {
                this.performCopy();
                break;
            }
            case SELECT_ALL: {
                this.performSelectAll();
                break;
            }
            case SELECT_NONE: {
                this.performSelectNone();
                break;
            }
            case SHOW_PREVIEW_WINDOW: {
                if (this.previewWindowController == null) {
                    this.previewWindowController = new PreviewWindowController(this.editorController, (Window)this.getStage());
                    this.previewWindowController.setToolStylesheet(this.getToolStylesheet());
                }
                this.previewWindowController.openWindow();
                break;
            }
            case CHOOSE_BACKGROUND_COLOR: {
                this.performChooseBackgroundColor((Window)this.getStage());
                break;
            }
            case SAVE_FILE: {
                this.performSaveOrSaveAsAction();
                break;
            }
            case SAVE_AS_FILE: {
                this.performSaveAsAction();
                break;
            }
            case REVERT_FILE: {
                this.performRevertAction();
                break;
            }
            case CLOSE_FILE: {
                this.performCloseAction();
                break;
            }
            case REVEAL_FILE: {
                this.performRevealAction();
                break;
            }
            case GOTO_CONTENT: {
                this.contentPanelController.getGlassLayer().requestFocus();
                break;
            }
            case GOTO_PROPERTIES: {
                this.performGoToSection(InspectorPanelController.SectionId.PROPERTIES);
                break;
            }
            case GOTO_LAYOUT: {
                this.performGoToSection(InspectorPanelController.SectionId.LAYOUT);
                break;
            }
            case GOTO_CODE: {
                this.performGoToSection(InspectorPanelController.SectionId.CODE);
                break;
            }
            case TOGGLE_LEFT_PANEL: {
                if (this.leftSplitController.isTargetVisible()) {
                    assert (this.librarySplitController.isTargetVisible() || this.documentSplitController.isTargetVisible());
                    this.librarySplitController.hideTarget();
                    this.documentSplitController.hideTarget();
                    this.leftSplitController.hideTarget();
                } else {
                    assert (!this.librarySplitController.isTargetVisible() && !this.documentSplitController.isTargetVisible());
                    this.librarySplitController.showTarget();
                    this.documentSplitController.showTarget();
                    this.leftSplitController.showTarget();
                    this.libraryDocumentSplitPane.layout();
                    this.libraryDocumentSplitPane.setDividerPositions(new double[]{0.5});
                }
                recordDocument.setLibraryVisible(this.librarySplitController.isTargetVisible());
                recordDocument.setDocumentVisible(this.documentSplitController.isTargetVisible());
                recordDocument.setLeftVisible(this.leftSplitController.isTargetVisible());
                break;
            }
            case TOGGLE_RIGHT_PANEL: {
                this.rightSplitController.toggleTarget();
                recordDocument.setRightVisible(this.rightSplitController.isTargetVisible());
                break;
            }
            case TOGGLE_CSS_PANEL: {
                this.initializeCssPanel();
                this.bottomSplitController.toggleTarget();
                if (this.bottomSplitController.isTargetVisible()) {
                    PreferencesRecordGlobal recordGlobal = pc.getRecordGlobal();
                    this.refreshCssTableColumnsOrderingReversed(recordGlobal.isCssTableColumnsOrderingReversed());
                    this.editorController.setPickModeEnabled(true);
                } else {
                    this.editorController.setPickModeEnabled(false);
                }
                recordDocument.setBottomVisible(this.bottomSplitController.isTargetVisible());
                break;
            }
            case TOGGLE_LIBRARY_PANEL: {
                if (this.librarySplitController.isTargetVisible()) {
                    assert (this.leftSplitController.isTargetVisible());
                    this.librarySplitController.hideTarget();
                    if (!this.documentSplitController.isTargetVisible()) {
                        this.leftSplitController.hideTarget();
                    }
                } else {
                    if (!this.leftSplitController.isTargetVisible()) {
                        this.leftSplitController.showTarget();
                    }
                    this.librarySplitController.showTarget();
                }
                recordDocument.setLibraryVisible(this.librarySplitController.isTargetVisible());
                recordDocument.setLeftVisible(this.leftSplitController.isTargetVisible());
                break;
            }
            case TOGGLE_DOCUMENT_PANEL: {
                if (this.documentSplitController.isTargetVisible()) {
                    assert (this.leftSplitController.isTargetVisible());
                    this.documentSplitController.hideTarget();
                    if (!this.librarySplitController.isTargetVisible()) {
                        this.leftSplitController.hideTarget();
                    }
                } else {
                    if (!this.leftSplitController.isTargetVisible()) {
                        this.leftSplitController.showTarget();
                    }
                    this.documentSplitController.showTarget();
                }
                recordDocument.setDocumentVisible(this.documentSplitController.isTargetVisible());
                recordDocument.setLeftVisible(this.leftSplitController.isTargetVisible());
                break;
            }
            case TOGGLE_OUTLINES_VISIBILITY: {
                this.contentPanelController.setOutlinesVisible(!this.contentPanelController.isOutlinesVisible());
                break;
            }
            case TOGGLE_GUIDES_VISIBILITY: {
                this.contentPanelController.setGuidesVisible(!this.contentPanelController.isGuidesVisible());
                break;
            }
            case ADD_SCENE_STYLE_SHEET: {
                this.sceneStyleSheetMenuController.performAddSceneStyleSheet();
                break;
            }
            case SET_RESOURCE: {
                this.resourceController.performSetResource();
                recordDocument.setI18NResourceFile(this.getResourceFile());
                break;
            }
            case REMOVE_RESOURCE: {
                this.resourceController.performRemoveResource();
                recordDocument.setI18NResourceFile(this.getResourceFile());
                break;
            }
            case REVEAL_RESOURCE: {
                this.resourceController.performRevealResource();
                break;
            }
            case HELP: {
                this.performHelp();
                break;
            }
            case SHOW_SAMPLE_CONTROLLER: {
                if (this.skeletonWindowController == null) {
                    this.skeletonWindowController = new SkeletonWindowController(this.editorController, (Window)this.getStage());
                    this.skeletonWindowController.setToolStylesheet(this.getToolStylesheet());
                }
                this.skeletonWindowController.openWindow();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public boolean canPerformEditAction(DocumentEditAction editAction) {
        boolean result;
        switch (editAction) {
            case DELETE: {
                result = this.editorController.canPerformEditAction(EditorController.EditAction.DELETE);
                break;
            }
            case CUT: {
                result = this.canPerformCut();
                break;
            }
            case IMPORT_FXML: 
            case IMPORT_MEDIA: {
                result = true;
                break;
            }
            case INCLUDE_FXML: {
                FXOMDocument fxomDocument = this.editorController.getFxomDocument();
                result = fxomDocument != null && fxomDocument.getFxomRoot() != null && fxomDocument.getLocation() != null;
                break;
            }
            case PASTE: {
                result = this.canPerformPaste();
                break;
            }
            default: {
                result = false;
                assert (false);
                break;
            }
        }
        return result;
    }

    public void performEditAction(DocumentEditAction editAction) {
        assert (this.canPerformEditAction(editAction));
        switch (editAction) {
            case DELETE: {
                this.performDelete();
                break;
            }
            case CUT: {
                this.performCut();
                break;
            }
            case IMPORT_FXML: {
                this.performImportFxml();
                break;
            }
            case IMPORT_MEDIA: {
                this.performImportMedia();
                break;
            }
            case INCLUDE_FXML: {
                this.performIncludeFxml();
                break;
            }
            case PASTE: {
                this.performPaste();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public boolean isLeftPanelVisible() {
        return this.leftSplitController.isTargetVisible();
    }

    public boolean isRightPanelVisible() {
        return this.rightSplitController.isTargetVisible();
    }

    public boolean isBottomPanelVisible() {
        return this.bottomSplitController.isTargetVisible();
    }

    public boolean isHierarchyPanelVisible() {
        return this.documentSplitController.isTargetVisible();
    }

    public boolean isLibraryPanelVisible() {
        return this.librarySplitController.isTargetVisible();
    }

    public File getResourceFile() {
        return this.resourceController.getResourceFile();
    }

    public void setResourceFile(File file) {
        this.resourceController.setResourceFile(file);
    }

    public boolean isDocumentDirty() {
        return this.getEditorController().getJobManager().getCurrentJob() != this.saveJob;
    }

    public boolean isUnused() {
        FXOMDocument fxomDocument = this.editorController.getFxomDocument();
        boolean noFxmlText = fxomDocument == null || fxomDocument.getFxomRoot() == null;
        boolean clean = !this.isDocumentDirty();
        boolean noName = fxomDocument != null && fxomDocument.getLocation() == null;
        return noFxmlText && clean && noName;
    }

    public void initializeCssPanel() {
        assert (this.cssPanelHost != null);
        assert (this.cssPanelSearchPanelHost != null);
        if (this.cssPanelHost.getChildren().isEmpty()) {
            this.cssPanelHost.getChildren().add((Object)this.cssPanelController.getPanelRoot());
        }
        if (this.cssPanelSearchPanelHost.getChildren().isEmpty()) {
            this.cssPanelSearchPanelHost.getChildren().add((Object)this.cssPanelSearchController.getPanelRoot());
            this.addCssPanelSearchListener();
        }
    }

    @Override
    protected void controllerDidLoadFxml() {
        String revealMenuKey;
        assert (this.libraryPanelHost != null);
        assert (this.librarySearchPanelHost != null);
        assert (this.hierarchyPanelHost != null);
        assert (this.infoPanelHost != null);
        assert (this.contentPanelHost != null);
        assert (this.inspectorPanelHost != null);
        assert (this.inspectorSearchPanelHost != null);
        assert (this.messageBarHost != null);
        assert (this.mainSplitPane != null);
        assert (this.mainSplitPane.getItems().size() == 2);
        assert (this.leftRightSplitPane != null);
        assert (this.leftRightSplitPane.getItems().size() == 3);
        assert (this.libraryDocumentSplitPane != null);
        assert (this.libraryDocumentSplitPane.getItems().size() == 2);
        assert (this.documentAccordion != null);
        assert (!this.documentAccordion.getPanes().isEmpty());
        assert (this.libraryViewAsList != null);
        assert (this.libraryViewAsSections != null);
        assert (this.libraryReveal != null);
        assert (this.libraryMenuButton != null);
        assert (this.libraryImportSelection != null);
        assert (this.customLibraryMenu != null);
        if (EditorPlatform.IS_WINDOWS) {
            this.getRoot().getStyleClass().add((Object)"windows-document-decoration");
        }
        this.mainSplitPane.addEventFilter(KeyEvent.KEY_PRESSED, this.mainKeyEventFilter);
        assert (this.getRoot() instanceof VBox);
        VBox rootVBox = (VBox)this.getRoot();
        rootVBox.getChildren().add(0, (Object)this.menuBarController.getMenuBar());
        this.libraryPanelHost.getChildren().add((Object)this.libraryPanelController.getPanelRoot());
        this.librarySearchPanelHost.getChildren().add((Object)this.librarySearchController.getPanelRoot());
        this.hierarchyPanelHost.getChildren().add((Object)this.hierarchyPanelController.getPanelRoot());
        this.infoPanelHost.getChildren().add((Object)this.infoPanelController.getPanelRoot());
        this.contentPanelHost.getChildren().add((Object)this.contentPanelController.getPanelRoot());
        this.inspectorPanelHost.getChildren().add((Object)this.inspectorPanelController.getPanelRoot());
        this.inspectorSearchPanelHost.getChildren().add((Object)this.inspectorSearchController.getPanelRoot());
        this.messageBarHost.getChildren().add((Object)this.messageBarController.getPanelRoot());
        this.messageBarController.getSelectionBarHost().getChildren().add((Object)this.selectionBarController.getPanelRoot());
        this.inspectorSearchController.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldStr, String newStr) {
                DocumentWindowController.this.inspectorPanelController.setSearchPattern(newStr);
            }
        });
        this.librarySearchController.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldStr, String newStr) {
                DocumentWindowController.this.libraryPanelController.setSearchPattern(newStr);
            }
        });
        this.bottomSplitController = new SplitController(this.mainSplitPane, SplitController.Target.LAST);
        this.leftSplitController = new SplitController(this.leftRightSplitPane, SplitController.Target.FIRST);
        this.rightSplitController = new SplitController(this.leftRightSplitPane, SplitController.Target.LAST);
        this.librarySplitController = new SplitController(this.libraryDocumentSplitPane, SplitController.Target.FIRST);
        this.documentSplitController = new SplitController(this.libraryDocumentSplitPane, SplitController.Target.LAST);
        this.messageBarHost.heightProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable o) {
                double h = DocumentWindowController.this.messageBarHost.getHeight();
                DocumentWindowController.this.contentPanelHost.setPadding(new Insets(h, 0.0, 0.0, 0.0));
            }
        });
        this.documentAccordion.setExpandedPane((TitledPane)this.documentAccordion.getPanes().get(0));
        this.getEditorController().getJobManager().revisionProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
                DocumentWindowController.this.messageBarController.setDocumentDirty(DocumentWindowController.this.isDocumentDirty());
            }
        });
        if (EditorPlatform.IS_MAC) {
            revealMenuKey = "menu.title.reveal.mac";
        } else if (EditorPlatform.IS_WINDOWS) {
            revealMenuKey = "menu.title.reveal.win";
        } else {
            assert (EditorPlatform.IS_LINUX);
            revealMenuKey = "menu.title.reveal.linux";
        }
        this.libraryReveal.setText(I18N.getString(revealMenuKey));
        this.libraryMenuButton.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                if (t1.booleanValue()) {
                    Library lib;
                    AbstractSelectionGroup asg = DocumentWindowController.this.getEditorController().getSelection().getGroup();
                    DocumentWindowController.this.libraryImportSelection.setDisable(true);
                    if (asg != null && asg instanceof ObjectSelectionGroup && ((ObjectSelectionGroup)asg).getItems().size() >= 1) {
                        DocumentWindowController.this.libraryImportSelection.setDisable(false);
                    }
                    if ((lib = DocumentWindowController.this.getEditorController().getLibrary()) instanceof UserLibrary) {
                        File userLibDir = new File(((UserLibrary)lib).getPath());
                        if (userLibDir.canRead()) {
                            DocumentWindowController.this.customLibraryMenu.setDisable(false);
                        } else {
                            DocumentWindowController.this.customLibraryMenu.setDisable(true);
                        }
                    }
                }
            }
        });
    }

    @Override
    protected void controllerDidCreateStage() {
        this.updateStageTitle();
        this.updateFromDocumentPreferences();
    }

    @Override
    public void openWindow() {
        if (!this.getStage().isShowing()) {
            assert (!this.editorController.isFileWatchingStarted());
            this.editorController.startFileWatching();
            this.watchingController.start();
        }
        super.openWindow();
        assert (this.librarySearchController != null);
        this.librarySearchController.requestFocus();
    }

    @Override
    public void closeWindow() {
        super.closeWindow();
        this.editorController.stopFileWatching();
        this.watchingController.stop();
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.performCloseAction();
    }

    public boolean isFrontDocumentWindow() {
        return this.getStage().isFocused() || this.previewWindowController != null && this.previewWindowController.getStage().isFocused() || this.skeletonWindowController != null && this.skeletonWindowController.getStage().isFocused() || this.jarAnalysisReportController != null && this.jarAnalysisReportController.getStage().isFocused();
    }

    public void performCloseFrontDocumentWindow() {
        if (this.getStage().isFocused()) {
            this.performCloseAction();
        } else if (this.previewWindowController != null && this.previewWindowController.getStage().isFocused()) {
            this.previewWindowController.closeWindow();
        } else if (this.skeletonWindowController != null && this.skeletonWindowController.getStage().isFocused()) {
            this.skeletonWindowController.closeWindow();
        } else if (this.jarAnalysisReportController != null && this.jarAnalysisReportController.getStage().isFocused()) {
            this.jarAnalysisReportController.closeWindow();
        }
    }

    @Override
    protected void toolStylesheetDidChange(String oldStylesheet) {
        super.toolStylesheetDidChange(oldStylesheet);
        this.editorController.setToolStylesheet(this.getToolStylesheet());
        if (this.skeletonWindowController != null) {
            this.skeletonWindowController.setToolStylesheet(this.getToolStylesheet());
        }
        if (this.jarAnalysisReportController != null) {
            this.jarAnalysisReportController.setToolStylesheet(this.getToolStylesheet());
        }
    }

    @FXML
    void onInspectorShowAllAction(ActionEvent event) {
        this.inspectorPanelController.setShowMode(InspectorPanelController.ShowMode.ALL);
    }

    @FXML
    void onInspectorShowEditedAction(ActionEvent event) {
        this.inspectorPanelController.setShowMode(InspectorPanelController.ShowMode.EDITED);
    }

    @FXML
    void onInspectorViewSectionsAction(ActionEvent event) {
        this.inspectorPanelController.setViewMode(InspectorPanelController.ViewMode.SECTION);
    }

    @FXML
    void onInspectorViewByPropertyNameAction(ActionEvent event) {
        this.inspectorPanelController.setViewMode(InspectorPanelController.ViewMode.PROPERTY_NAME);
    }

    @FXML
    void onInspectorViewByPropertyTypeAction(ActionEvent event) {
        this.inspectorPanelController.setViewMode(InspectorPanelController.ViewMode.PROPERTY_TYPE);
    }

    @FXML
    void onCssPanelViewRulesAction(ActionEvent event) {
        this.cssPanelMenuController.viewRules();
        this.cssPanelSplitDefaultsMi.setDisable(true);
        this.cssPanelShowStyledOnlyMi.setDisable(true);
    }

    @FXML
    void onCssPanelViewTableAction(ActionEvent event) {
        this.cssPanelMenuController.viewTable();
        this.cssPanelSplitDefaultsMi.setDisable(false);
        this.cssPanelShowStyledOnlyMi.setDisable(false);
    }

    @FXML
    void onCssPanelViewTextAction(ActionEvent event) {
        this.cssPanelMenuController.viewText();
        this.cssPanelSplitDefaultsMi.setDisable(true);
        this.cssPanelShowStyledOnlyMi.setDisable(true);
    }

    @FXML
    void onCssPanelCopyStyleablePathAction(ActionEvent event) {
        this.cssPanelMenuController.copyStyleablePath();
    }

    @FXML
    void onCssPanelSplitDefaultsAction(ActionEvent event) {
        this.cssPanelMenuController.splitDefaultsAction(this.cssPanelSplitDefaultsMi);
    }

    @FXML
    void onCssPanelShowStyledOnlyAction(ActionEvent event) {
        this.cssPanelMenuController.showStyledOnly(this.cssPanelShowStyledOnlyMi);
    }

    @FXML
    void onHierarchyShowInfo(ActionEvent event) {
        this.hierarchyPanelController.setDisplayOption(AbstractHierarchyPanelController.DisplayOption.INFO);
        this.documentAccordion.setExpandedPane((TitledPane)this.documentAccordion.getPanes().get(0));
    }

    @FXML
    void onHierarchyShowFxId(ActionEvent event) {
        this.hierarchyPanelController.setDisplayOption(AbstractHierarchyPanelController.DisplayOption.FXID);
        this.documentAccordion.setExpandedPane((TitledPane)this.documentAccordion.getPanes().get(0));
    }

    @FXML
    void onHierarchyShowNodeId(ActionEvent event) {
        this.hierarchyPanelController.setDisplayOption(AbstractHierarchyPanelController.DisplayOption.NODEID);
        this.documentAccordion.setExpandedPane((TitledPane)this.documentAccordion.getPanes().get(0));
    }

    @FXML
    void onLibraryImportJarFxml(ActionEvent event) {
        this.libraryPanelController.performImportJarFxml();
    }

    @FXML
    void onLibraryViewAsList(ActionEvent event) {
        if (this.libraryPanelController.getDisplayMode() != LibraryPanelController.DISPLAY_MODE.SEARCH) {
            this.libraryPanelController.setDisplayMode(LibraryPanelController.DISPLAY_MODE.LIST);
        } else {
            this.libraryPanelController.setPreviousDisplayMode(LibraryPanelController.DISPLAY_MODE.LIST);
        }
    }

    @FXML
    void onLibraryViewAsSections(ActionEvent event) {
        if (this.libraryPanelController.getDisplayMode() != LibraryPanelController.DISPLAY_MODE.SEARCH) {
            this.libraryPanelController.setDisplayMode(LibraryPanelController.DISPLAY_MODE.SECTIONS);
        } else {
            this.libraryPanelController.setPreviousDisplayMode(LibraryPanelController.DISPLAY_MODE.SECTIONS);
        }
    }

    @FXML
    void onLibraryImportSelection(ActionEvent event) {
        AbstractSelectionGroup asg = this.getEditorController().getSelection().getGroup();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            assert (!osg.getItems().isEmpty());
            ArrayList<FXOMObject> selection = new ArrayList<FXOMObject>(osg.getItems());
            this.libraryPanelController.performImportSelection(selection);
        }
    }

    @FXML
    void onLibraryRevealCustomFolder(ActionEvent event) {
        String userLibraryPath = ((UserLibrary)this.getEditorController().getLibrary()).getPath();
        try {
            EditorPlatform.revealInFileBrowser(new File(userLibraryPath));
        }
        catch (IOException x) {
            ErrorDialog errorDialog = new ErrorDialog(null);
            errorDialog.setMessage(I18N.getString("alert.reveal.failure.message", this.getStage().getTitle()));
            errorDialog.setDetails(I18N.getString("alert.reveal.failure.details"));
            errorDialog.setDebugInfoWithThrowable(x);
            errorDialog.showAndWait();
        }
    }

    @FXML
    void onLibraryShowJarAnalysisReport(ActionEvent event) {
        if (this.jarAnalysisReportController == null) {
            this.jarAnalysisReportController = new JarAnalysisReportController(this.getEditorController(), (Window)this.getStage());
            this.jarAnalysisReportController.setToolStylesheet(this.getToolStylesheet());
        }
        this.jarAnalysisReportController.openWindow();
    }

    private boolean canPerformSelectAll() {
        boolean result;
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.isPopupEditing(focusOwner)) {
            return false;
        }
        if (this.isTextInputControlEditing(focusOwner)) {
            TextInputControl tic = this.getTextInputControl(focusOwner);
            String text = tic.getText();
            String selectedText = tic.getSelectedText();
            result = text == null || text.isEmpty() ? false : selectedText == null || selectedText.length() < tic.getText().length();
        } else {
            result = this.getEditorController().canPerformControlAction(EditorController.ControlAction.SELECT_ALL);
        }
        return result;
    }

    private void performSelectAll() {
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.isTextInputControlEditing(focusOwner)) {
            TextInputControl tic = this.getTextInputControl(focusOwner);
            tic.selectAll();
        } else {
            this.getEditorController().performControlAction(EditorController.ControlAction.SELECT_ALL);
        }
    }

    private boolean canPerformSelectNone() {
        TextInputControl tic;
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.isPopupEditing(focusOwner)) {
            return false;
        }
        boolean result = this.isTextInputControlEditing(focusOwner) ? (tic = this.getTextInputControl(focusOwner)).getSelectedText() != null && !tic.getSelectedText().isEmpty() : this.getEditorController().canPerformControlAction(EditorController.ControlAction.SELECT_NONE);
        return result;
    }

    private void performSelectNone() {
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.isTextInputControlEditing(focusOwner)) {
            TextInputControl tic = this.getTextInputControl(focusOwner);
            tic.deselect();
        } else {
            this.getEditorController().performControlAction(EditorController.ControlAction.SELECT_NONE);
        }
    }

    private boolean canPerformCopy() {
        TextInputControl tic;
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.isPopupEditing(focusOwner)) {
            return false;
        }
        boolean result = this.isTextInputControlEditing(focusOwner) ? (tic = this.getTextInputControl(focusOwner)).getSelectedText() != null && !tic.getSelectedText().isEmpty() : (this.isCssRulesEditing(focusOwner) || this.isCssTextEditing(focusOwner) ? true : this.getEditorController().canPerformControlAction(EditorController.ControlAction.COPY));
        return result;
    }

    private void performCopy() {
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.isTextInputControlEditing(focusOwner)) {
            TextInputControl tic = this.getTextInputControl(focusOwner);
            tic.copy();
        } else if (this.isCssRulesEditing(focusOwner)) {
            this.cssPanelController.copyRules();
        } else if (!this.isCssTextEditing(focusOwner)) {
            this.getEditorController().performControlAction(EditorController.ControlAction.COPY);
        }
    }

    private boolean canPerformCut() {
        TextInputControl tic;
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.isPopupEditing(focusOwner)) {
            return false;
        }
        boolean result = this.isTextInputControlEditing(focusOwner) ? (tic = this.getTextInputControl(focusOwner)).getSelectedText() != null && !tic.getSelectedText().isEmpty() : this.getEditorController().canPerformEditAction(EditorController.EditAction.CUT);
        return result;
    }

    private void performCut() {
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.isTextInputControlEditing(focusOwner)) {
            TextInputControl tic = this.getTextInputControl(focusOwner);
            tic.cut();
        } else {
            this.getEditorController().performEditAction(EditorController.EditAction.CUT);
        }
    }

    private boolean canPerformPaste() {
        Node focusOwner = this.getScene().getFocusOwner();
        boolean result = this.getEditorController().canPerformEditAction(EditorController.EditAction.PASTE) ? true : (this.isTextInputControlEditing(focusOwner) ? Clipboard.getSystemClipboard().hasString() : false);
        return result;
    }

    private void performPaste() {
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.getEditorController().canPerformEditAction(EditorController.EditAction.PASTE)) {
            this.getEditorController().performEditAction(EditorController.EditAction.PASTE);
            this.contentPanelController.getGlassLayer().requestFocus();
        } else {
            assert (this.isTextInputControlEditing(focusOwner));
            TextInputControl tic = this.getTextInputControl(focusOwner);
            tic.paste();
        }
    }

    private void performDelete() {
        boolean deleteConfirmed;
        ArrayList<FXOMObject> selectedObjects = new ArrayList<FXOMObject>();
        Selection selection = this.editorController.getSelection();
        if (selection.getGroup() instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            selectedObjects.addAll(osg.getItems());
        } else if (selection.getGroup() instanceof GridSelectionGroup) {
            GridSelectionGroup gsg = (GridSelectionGroup)selection.getGroup();
            selectedObjects.addAll(gsg.collectSelectedObjects());
        } else assert (false);
        HashMap<String, FXOMObject> fxIdMap = new HashMap<String, FXOMObject>();
        for (FXOMObject selectedObject : selectedObjects) {
            fxIdMap.putAll(selectedObject.collectFxIds());
        }
        FXOMNodes.removeToggleGroups(fxIdMap);
        if (fxIdMap.isEmpty()) {
            deleteConfirmed = true;
        } else {
            String message = fxIdMap.size() == 1 ? (selectedObjects.size() == 1 ? I18N.getString("alert.delete.fxid1of1.message") : I18N.getString("alert.delete.fxid1ofN.message")) : (selectedObjects.size() == fxIdMap.size() ? I18N.getString("alert.delete.fxidNofN.message") : I18N.getString("alert.delete.fxidKofN.message"));
            AlertDialog d = new AlertDialog((Window)this.getStage());
            d.setMessage(message);
            d.setDetails(I18N.getString("alert.delete.fxid.details"));
            d.setOKButtonTitle(I18N.getString("label.delete"));
            boolean bl = deleteConfirmed = d.showAndWait() == AbstractModalDialog.ButtonID.OK;
        }
        if (deleteConfirmed) {
            this.editorController.performEditAction(EditorController.EditAction.DELETE);
        }
    }

    private void performImportFxml() {
        File fxmlFile;
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter f = new FileChooser.ExtensionFilter(I18N.getString("file.filter.label.fxml"), new String[]{"*.fxml"});
        fileChooser.getExtensionFilters().add((Object)f);
        File nextInitialDirectory = SceneBuilderApp.getSingleton().getNextInitialDirectory();
        if (nextInitialDirectory != null) {
            fileChooser.setInitialDirectory(nextInitialDirectory);
        }
        if ((fxmlFile = fileChooser.showOpenDialog((Window)this.getStage())) != null) {
            String path = fxmlFile.getPath();
            if (!path.endsWith(".fxml")) {
                fxmlFile = new File(path + ".fxml");
            }
            SceneBuilderApp.getSingleton().updateNextInitialDirectory(fxmlFile);
            this.getEditorController().performImportFxml(fxmlFile);
        }
    }

    private void performImportMedia() {
        File mediaFile;
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter imageFilter = new FileChooser.ExtensionFilter(I18N.getString("file.filter.label.image"), DocumentWindowController.getImageExtensions());
        FileChooser.ExtensionFilter audioFilter = new FileChooser.ExtensionFilter(I18N.getString("file.filter.label.audio"), DocumentWindowController.getAudioExtensions());
        FileChooser.ExtensionFilter videoFilter = new FileChooser.ExtensionFilter(I18N.getString("file.filter.label.video"), DocumentWindowController.getVideoExtensions());
        FileChooser.ExtensionFilter mediaFilter = new FileChooser.ExtensionFilter(I18N.getString("file.filter.label.media"), DocumentWindowController.getMediaExtensions());
        fileChooser.getExtensionFilters().add((Object)mediaFilter);
        fileChooser.getExtensionFilters().add((Object)imageFilter);
        fileChooser.getExtensionFilters().add((Object)audioFilter);
        fileChooser.getExtensionFilters().add((Object)videoFilter);
        File nextInitialDirectory = SceneBuilderApp.getSingleton().getNextInitialDirectory();
        if (nextInitialDirectory != null) {
            fileChooser.setInitialDirectory(nextInitialDirectory);
        }
        if ((mediaFile = fileChooser.showOpenDialog((Window)this.getStage())) != null) {
            SceneBuilderApp.getSingleton().updateNextInitialDirectory(mediaFile);
            this.getEditorController().performImportMedia(mediaFile);
        }
    }

    private static synchronized List<String> getImageExtensions() {
        if (imageExtensions == null) {
            imageExtensions = new ArrayList<String>();
            imageExtensions.add("*.jpg");
            imageExtensions.add("*.jpeg");
            imageExtensions.add("*.png");
            imageExtensions.add("*.gif");
            imageExtensions = Collections.unmodifiableList(imageExtensions);
        }
        return imageExtensions;
    }

    private static synchronized List<String> getAudioExtensions() {
        if (audioExtensions == null) {
            audioExtensions = new ArrayList<String>();
            audioExtensions.add("*.aif");
            audioExtensions.add("*.aiff");
            audioExtensions.add("*.mp3");
            audioExtensions.add("*.m4a");
            audioExtensions.add("*.wav");
            audioExtensions.add("*.m3u");
            audioExtensions.add("*.m3u8");
            audioExtensions = Collections.unmodifiableList(audioExtensions);
        }
        return audioExtensions;
    }

    private static synchronized List<String> getVideoExtensions() {
        if (videoExtensions == null) {
            videoExtensions = new ArrayList<String>();
            videoExtensions.add("*.flv");
            videoExtensions.add("*.fxm");
            videoExtensions.add("*.mp4");
            videoExtensions.add("*.m4v");
            videoExtensions = Collections.unmodifiableList(videoExtensions);
        }
        return videoExtensions;
    }

    private static synchronized List<String> getMediaExtensions() {
        if (mediaExtensions == null) {
            mediaExtensions = new ArrayList<String>();
            mediaExtensions.addAll(DocumentWindowController.getImageExtensions());
            mediaExtensions.addAll(DocumentWindowController.getAudioExtensions());
            mediaExtensions.addAll(DocumentWindowController.getVideoExtensions());
            mediaExtensions = Collections.unmodifiableList(mediaExtensions);
        }
        return mediaExtensions;
    }

    private void performIncludeFxml() {
        File fxmlFile;
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter f = new FileChooser.ExtensionFilter(I18N.getString("file.filter.label.fxml"), new String[]{"*.fxml"});
        fileChooser.getExtensionFilters().add((Object)f);
        File nextInitialDirectory = SceneBuilderApp.getSingleton().getNextInitialDirectory();
        if (nextInitialDirectory != null) {
            fileChooser.setInitialDirectory(nextInitialDirectory);
        }
        if ((fxmlFile = fileChooser.showOpenDialog((Window)this.getStage())) != null) {
            String path = fxmlFile.getPath();
            if (!path.endsWith(".fxml")) {
                fxmlFile = new File(path + ".fxml");
            }
            SceneBuilderApp.getSingleton().updateNextInitialDirectory(fxmlFile);
            this.getEditorController().performIncludeFxml(fxmlFile);
        }
    }

    private boolean isTextInputControlEditing(Node node) {
        return node instanceof TextInputControl || node instanceof ComboBox;
    }

    private TextInputControl getTextInputControl(Node node) {
        TextInputControl tic;
        assert (this.isTextInputControlEditing(node));
        if (node instanceof TextInputControl) {
            tic = (TextInputControl)node;
        } else {
            assert (node instanceof ComboBox);
            ComboBox cb = (ComboBox)node;
            tic = cb.getEditor();
        }
        return tic;
    }

    private boolean isPopupEditing(Node node) {
        return node instanceof MenuButton && ((MenuButton)node).isShowing() || this.editorController.getInlineEditController().isWindowOpened();
    }

    private boolean isCssRulesEditing(Node node) {
        Node cssRules = this.cssPanelController.getRulesPane();
        if (cssRules != null) {
            return this.isDescendantOf(cssRules, node);
        }
        return false;
    }

    private boolean isCssTextEditing(Node node) {
        Node cssText = this.cssPanelController.getTextPane();
        if (cssText != null) {
            return this.isDescendantOf(cssText, node);
        }
        return false;
    }

    private boolean isDescendantOf(Node container, Node node) {
        for (Node child = node; child != null; child = child.getParent()) {
            if (child != container) continue;
            return true;
        }
        return false;
    }

    private KeyCombination getAccelerator(KeyEvent event) {
        KeyCombination result = null;
        for (KeyCombination kc : this.menuBarController.getAccelerators()) {
            if (!kc.match(event)) continue;
            result = kc;
            break;
        }
        return result;
    }

    private void updateStageTitle() {
        if (this.libraryPanelHost != null) {
            this.getStage().setTitle(DocumentWindowController.makeTitle(this.editorController.getFxomDocument()));
        }
    }

    private void updateFromDocumentPreferences() {
        if (this.libraryPanelHost != null) {
            PreferencesController pc = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = pc.getRecordGlobal();
            recordGlobal.refresh(this);
            PreferencesRecordDocument recordDocument = pc.getRecordDocument(this);
            recordDocument.readFromJavaPreferences();
            recordDocument.refresh();
        }
    }

    private void resetDocumentPreferences() {
        PreferencesController pc = PreferencesController.getSingleton();
        PreferencesRecordDocument recordDocument = pc.getRecordDocument(this);
        recordDocument.resetDocumentPreferences();
    }

    private void performChooseBackgroundColor(Window owner) {
        BackgroundColorDialogController bcdc = new BackgroundColorDialogController(owner);
        bcdc.setToolStylesheet(this.getToolStylesheet());
        bcdc.openWindow();
    }

    ActionStatus performSaveOrSaveAsAction() {
        ActionStatus result = this.editorController.getFxomDocument().getLocation() == null ? this.performSaveAsAction() : this.performSaveAction();
        if (result.equals((Object)ActionStatus.DONE)) {
            this.messageBarController.setDocumentDirty(false);
            this.saveJob = this.getEditorController().getJobManager().getCurrentJob();
        }
        return result;
    }

    private void addCssPanelSearchListener() {
        this.cssPanelSearchController.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldStr, String newStr) {
                DocumentWindowController.this.cssPanelController.setSearchPattern(newStr);
            }
        });
    }

    private void performGoToSection(InspectorPanelController.SectionId sectionId) {
        if (!this.isRightPanelVisible()) {
            this.performControlAction(DocumentControlAction.TOGGLE_RIGHT_PANEL);
        }
        this.inspectorPanelController.setExpandedSection(sectionId);
    }

    private ActionStatus performSaveAction() {
        ActionStatus result;
        block13: {
            FXOMDocument fxomDocument = this.editorController.getFxomDocument();
            assert (fxomDocument != null);
            assert (fxomDocument.getLocation() != null);
            if (this.editorController.canGetFxmlText()) {
                Path fxmlPath;
                try {
                    fxmlPath = Paths.get(fxomDocument.getLocation().toURI());
                }
                catch (URISyntaxException x) {
                    throw new RuntimeException("Bug in " + this.getClass().getSimpleName(), x);
                }
                String fileName = fxmlPath.getFileName().toString();
                try {
                    boolean saveConfirmed;
                    if (this.checkLoadFileTime()) {
                        saveConfirmed = true;
                    } else {
                        AlertDialog d = new AlertDialog((Window)this.getStage());
                        d.setMessage(I18N.getString("alert.overwrite.message", fileName));
                        d.setDetails(I18N.getString("alert.overwrite.details"));
                        d.setOKButtonVisible(true);
                        d.setOKButtonTitle(I18N.getString("label.overwrite"));
                        d.setDefaultButtonID(AbstractModalDialog.ButtonID.CANCEL);
                        d.setShowDefaultButton(true);
                        boolean bl = saveConfirmed = d.showAndWait() == AbstractModalDialog.ButtonID.OK;
                    }
                    if (saveConfirmed) {
                        try {
                            this.watchingController.removeDocumentTarget();
                            byte[] fxmlBytes = this.editorController.getFxmlText().getBytes("UTF-8");
                            Files.write(fxmlPath, fxmlBytes, new OpenOption[0]);
                            this.updateLoadFileTime();
                            this.watchingController.update();
                            this.editorController.getMessageLog().logInfoMessage("log.info.save.confirmation", I18N.getBundle(), fileName);
                            result = ActionStatus.DONE;
                            break block13;
                        }
                        catch (UnsupportedEncodingException x) {
                            throw new RuntimeException("Bug", x);
                        }
                    }
                    result = ActionStatus.CANCELLED;
                }
                catch (IOException x) {
                    ErrorDialog d = new ErrorDialog((Window)this.getStage());
                    d.setMessage(I18N.getString("alert.save.failure.message", fileName));
                    d.setDetails(I18N.getString("alert.save.failure.details"));
                    d.setDebugInfoWithThrowable(x);
                    d.showAndWait();
                    result = ActionStatus.CANCELLED;
                }
            } else {
                result = ActionStatus.CANCELLED;
            }
        }
        return result;
    }

    private ActionStatus performSaveAsAction() {
        ActionStatus result;
        if (this.editorController.canGetFxmlText()) {
            File fxmlFile;
            FileChooser fileChooser = new FileChooser();
            FileChooser.ExtensionFilter f = new FileChooser.ExtensionFilter(I18N.getString("file.filter.label.fxml"), new String[]{"*.fxml"});
            fileChooser.getExtensionFilters().add((Object)f);
            File nextInitialDirectory = SceneBuilderApp.getSingleton().getNextInitialDirectory();
            if (nextInitialDirectory != null) {
                fileChooser.setInitialDirectory(nextInitialDirectory);
            }
            if ((fxmlFile = fileChooser.showSaveDialog((Window)this.getStage())) == null) {
                result = ActionStatus.CANCELLED;
            } else {
                URL newLocation;
                boolean forgetSave = false;
                String path = fxmlFile.getPath();
                if (!path.endsWith(".fxml")) {
                    try {
                        URL alternateURL = new URL(fxmlFile.toURI().toURL().toExternalForm() + ".fxml");
                        File alternateFxmlFile = new File(alternateURL.toURI());
                        AlertDialog d = new AlertDialog((Window)this.getStage());
                        d.setMessage(I18N.getString("alert.save.noextension.message", fxmlFile.getName()));
                        String details = I18N.getString("alert.save.noextension.details");
                        if (alternateFxmlFile.exists()) {
                            details = details + "\n" + I18N.getString("alert.save.noextension.details.overwrite", alternateFxmlFile.getName());
                        }
                        d.setDetails(details);
                        d.setOKButtonVisible(true);
                        d.setOKButtonTitle(I18N.getString("alert.save.noextension.savewith"));
                        d.setDefaultButtonID(AbstractModalDialog.ButtonID.OK);
                        d.setShowDefaultButton(true);
                        d.setActionButtonDisable(false);
                        d.setActionButtonVisible(true);
                        d.setActionButtonTitle(I18N.getString("alert.save.noextension.savewithout"));
                        switch (d.showAndWait()) {
                            case ACTION: {
                                break;
                            }
                            case CANCEL: {
                                forgetSave = true;
                                break;
                            }
                            case OK: {
                                fxmlFile = alternateFxmlFile;
                            }
                        }
                    }
                    catch (MalformedURLException | URISyntaxException ex) {
                        forgetSave = true;
                    }
                }
                try {
                    newLocation = fxmlFile.toURI().toURL();
                }
                catch (MalformedURLException x) {
                    throw new RuntimeException("Bug in " + this.getClass().getSimpleName(), x);
                }
                DocumentWindowController dwc = SceneBuilderApp.getSingleton().lookupDocumentWindowControllers(newLocation);
                if (dwc != null && dwc != this) {
                    Path fxmlPath = Paths.get(fxmlFile.toString(), new String[0]);
                    String fileName = fxmlPath.getFileName().toString();
                    ErrorDialog d = new ErrorDialog((Window)this.getStage());
                    d.setMessage(I18N.getString("alert.save.conflict.message", fileName));
                    d.setDetails(I18N.getString("alert.save.conflict.details"));
                    d.showAndWait();
                    result = ActionStatus.CANCELLED;
                } else if (forgetSave) {
                    result = ActionStatus.CANCELLED;
                } else {
                    this.editorController.setFxmlLocation(newLocation);
                    this.updateLoadFileTime();
                    this.updateStageTitle();
                    this.resetDocumentPreferences();
                    this.watchingController.update();
                    result = this.performSaveAction();
                    SceneBuilderApp.getSingleton().updateNextInitialDirectory(fxmlFile);
                    PreferencesController pc = PreferencesController.getSingleton();
                    PreferencesRecordGlobal recordGlobal = pc.getRecordGlobal();
                    recordGlobal.addRecentItem(fxmlFile);
                }
            }
        } else {
            result = ActionStatus.CANCELLED;
        }
        return result;
    }

    private void performRevertAction() {
        assert (this.editorController.getFxomDocument() != null);
        assert (this.editorController.getFxomDocument().getLocation() != null);
        AlertDialog d = new AlertDialog((Window)this.getStage());
        d.setMessage(I18N.getString("alert.revert.question.message", this.getStage().getTitle()));
        d.setDetails(I18N.getString("alert.revert.question.details"));
        d.setOKButtonTitle(I18N.getString("label.revert"));
        if (d.showAndWait() == AbstractModalDialog.ButtonID.OK) {
            try {
                this.reload();
            }
            catch (IOException x) {
                ErrorDialog errorDialog = new ErrorDialog(null);
                errorDialog.setMessage(I18N.getString("alert.open.failure1.message", this.getStage().getTitle()));
                errorDialog.setDetails(I18N.getString("alert.open.failure1.details"));
                errorDialog.setDebugInfoWithThrowable(x);
                errorDialog.setTitle(I18N.getString("alert.title.open"));
                errorDialog.showAndWait();
                SceneBuilderApp.getSingleton().documentWindowRequestClose(this);
            }
        }
    }

    ActionStatus performCloseAction() {
        boolean closeConfirmed;
        this.getStage().toFront();
        if (this.getEditorController().isTextEditingSessionOnGoing() && !this.getEditorController().canGetFxmlText()) {
            return ActionStatus.CANCELLED;
        }
        if (this.isDocumentDirty()) {
            AlertDialog d = new AlertDialog((Window)this.getStage());
            d.setMessage(I18N.getString("alert.save.question.message", this.getStage().getTitle()));
            d.setDetails(I18N.getString("alert.save.question.details"));
            d.setOKButtonTitle(I18N.getString("label.save"));
            d.setActionButtonTitle(I18N.getString("label.do.not.save"));
            d.setActionButtonVisible(true);
            switch (d.showAndWait()) {
                default: {
                    if (this.editorController.getFxomDocument().getLocation() == null) {
                        closeConfirmed = this.performSaveAsAction() == ActionStatus.DONE;
                        break;
                    }
                    closeConfirmed = this.performSaveAction() == ActionStatus.DONE;
                    break;
                }
                case CANCEL: {
                    closeConfirmed = false;
                    break;
                }
                case ACTION: {
                    closeConfirmed = true;
                    break;
                }
            }
        } else {
            closeConfirmed = true;
        }
        if (closeConfirmed) {
            SceneBuilderApp.getSingleton().documentWindowRequestClose(this);
            PreferencesController pc = PreferencesController.getSingleton();
            PreferencesRecordDocument recordDocument = pc.getRecordDocument(this);
            recordDocument.writeToJavaPreferences();
        }
        return closeConfirmed ? ActionStatus.DONE : ActionStatus.CANCELLED;
    }

    private void performRevealAction() {
        assert (this.editorController.getFxomDocument() != null);
        assert (this.editorController.getFxomDocument().getLocation() != null);
        URL location = this.editorController.getFxomDocument().getLocation();
        try {
            File fxmlFile = new File(location.toURI());
            EditorPlatform.revealInFileBrowser(fxmlFile);
        }
        catch (IOException | URISyntaxException x) {
            ErrorDialog errorDialog = new ErrorDialog(null);
            errorDialog.setMessage(I18N.getString("alert.reveal.failure.message", this.getStage().getTitle()));
            errorDialog.setDetails(I18N.getString("alert.reveal.failure.details"));
            errorDialog.setDebugInfoWithThrowable(x);
            errorDialog.showAndWait();
        }
    }

    private void updateLoadFileTime() {
        URL fxmlURL = this.editorController.getFxmlLocation();
        if (fxmlURL == null) {
            this.loadFileTime = null;
        } else {
            try {
                Path fxmlPath = Paths.get(fxmlURL.toURI());
                this.loadFileTime = Files.exists(fxmlPath, new LinkOption[0]) ? Files.getLastModifiedTime(fxmlPath, new LinkOption[0]) : null;
            }
            catch (URISyntaxException x) {
                throw new RuntimeException("Bug", x);
            }
            catch (IOException x) {
                this.loadFileTime = null;
            }
        }
    }

    private boolean checkLoadFileTime() throws IOException {
        boolean result;
        assert (this.editorController.getFxmlLocation() != null);
        if (this.loadFileTime == null) {
            result = true;
        } else {
            try {
                Path fxmlPath = Paths.get(this.editorController.getFxmlLocation().toURI());
                FileTime currentFileTime = Files.getLastModifiedTime(fxmlPath, new LinkOption[0]);
                result = this.loadFileTime.compareTo(currentFileTime) == 0;
            }
            catch (NoSuchFileException x) {
                result = true;
            }
            catch (URISyntaxException x) {
                throw new RuntimeException("Bug", x);
            }
        }
        return result;
    }

    private void performHelp() {
        try {
            EditorPlatform.open("http://docs.oracle.com/javafx/index.html");
        }
        catch (IOException ioe) {
            ErrorDialog errorDialog = new ErrorDialog(null);
            errorDialog.setMessage(I18N.getString("alert.help.failure.message", "http://docs.oracle.com/javafx/index.html"));
            errorDialog.setDetails(I18N.getString("alert.messagebox.failure.details"));
            errorDialog.setDebugInfoWithThrowable(ioe);
            errorDialog.showAndWait();
        }
    }

    public static class TitleComparator
    implements Comparator<DocumentWindowController> {
        @Override
        public int compare(DocumentWindowController d1, DocumentWindowController d2) {
            int result;
            assert (d1 != null);
            assert (d2 != null);
            if (d1 == d2) {
                result = 0;
            } else {
                String t1 = d1.getStage().getTitle();
                String t2 = d2.getStage().getTitle();
                assert (t1 != null);
                assert (t2 != null);
                result = t1.compareTo(t2);
            }
            return result;
        }
    }

    public static enum ActionStatus {
        CANCELLED,
        DONE;

    }

    public static enum DocumentEditAction {
        DELETE,
        CUT,
        PASTE,
        IMPORT_FXML,
        IMPORT_MEDIA,
        INCLUDE_FXML;

    }

    public static enum DocumentControlAction {
        COPY,
        SELECT_ALL,
        SELECT_NONE,
        SAVE_FILE,
        SAVE_AS_FILE,
        REVERT_FILE,
        CLOSE_FILE,
        REVEAL_FILE,
        GOTO_CONTENT,
        GOTO_PROPERTIES,
        GOTO_LAYOUT,
        GOTO_CODE,
        TOGGLE_LIBRARY_PANEL,
        TOGGLE_DOCUMENT_PANEL,
        TOGGLE_CSS_PANEL,
        TOGGLE_LEFT_PANEL,
        TOGGLE_RIGHT_PANEL,
        TOGGLE_OUTLINES_VISIBILITY,
        TOGGLE_GUIDES_VISIBILITY,
        SHOW_PREVIEW_WINDOW,
        CHOOSE_BACKGROUND_COLOR,
        ADD_SCENE_STYLE_SHEET,
        SET_RESOURCE,
        REMOVE_RESOURCE,
        REVEAL_RESOURCE,
        HELP,
        SHOW_SAMPLE_CONTROLLER;

    }
}

