/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app;

import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.ErrorDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.PropertyResourceBundle;
import javafx.stage.FileChooser;
import javafx.stage.Window;

class ResourceController {
    private final DocumentWindowController documentWindowController;
    private File resourceFile;

    public ResourceController(DocumentWindowController dwc) {
        this.documentWindowController = dwc;
    }

    public File getResourceFile() {
        return this.resourceFile;
    }

    public void setResourceFile(File file) {
        if (file != null && ResourceController.readPropertyResourceBundle(file) != null) {
            this.resourceFile = file;
            this.resourceFileDidChange();
        }
    }

    public void performSetResource() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18N.getString("resource.filechooser.filter.msg"), new String[]{"*.properties"}));
        File newResourceFile = fileChooser.showOpenDialog((Window)this.documentWindowController.getStage());
        this.setResourceFile(newResourceFile);
    }

    public void performRemoveResource() {
        assert (this.resourceFile != null);
        this.resourceFile = null;
        this.resourceFileDidChange();
    }

    public void performRevealResource() {
        assert (this.resourceFile != null);
        try {
            EditorPlatform.revealInFileBrowser(this.resourceFile);
        }
        catch (IOException ioe) {
            ErrorDialog errorDialog = new ErrorDialog(null);
            errorDialog.setTitle(I18N.getString("error.file.reveal.title"));
            errorDialog.setMessage(I18N.getString("error.file.reveal.message"));
            errorDialog.setDetails(I18N.getString("error.filesystem.details"));
            errorDialog.setDebugInfoWithThrowable(ioe);
            errorDialog.showAndWait();
        }
    }

    public void performReloadResource() {
        assert (this.resourceFile != null);
        this.resourceFileDidChange();
    }

    private void resourceFileDidChange() {
        PropertyResourceBundle resources;
        if (this.resourceFile != null) {
            resources = ResourceController.readPropertyResourceBundle(this.resourceFile);
            assert (resources != null);
        } else {
            resources = null;
        }
        this.documentWindowController.getEditorController().setResources(resources);
        this.documentWindowController.getWatchingController().update();
    }

    private static PropertyResourceBundle readPropertyResourceBundle(File f) {
        PropertyResourceBundle result;
        try {
            result = new PropertyResourceBundle(new InputStreamReader((InputStream)new FileInputStream(f), Charset.forName("UTF-8")));
        }
        catch (IOException ex) {
            result = null;
        }
        return result;
    }
}

