/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app;

import com.oracle.javafx.scenebuilder.app.AppPlatform;
import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.ScenicViewStarter;
import com.oracle.javafx.scenebuilder.app.about.AboutWindowController;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.app.menubar.MenuBarController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordDocument;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordGlobal;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesWindowController;
import com.oracle.javafx.scenebuilder.app.template.FxmlTemplates;
import com.oracle.javafx.scenebuilder.app.template.TemplateDialogController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AlertDialog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.ErrorDialog;
import com.oracle.javafx.scenebuilder.kit.library.BuiltinLibrary;
import com.oracle.javafx.scenebuilder.kit.library.user.UserLibrary;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReport;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPicker;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.stage.FileChooser;
import javafx.stage.Stage;

public class SceneBuilderApp
extends Application
implements AppPlatform.AppNotificationHandler {
    private static SceneBuilderApp singleton;
    private static String darkToolStylesheet;
    private static final CountDownLatch launchLatch;
    private final List<DocumentWindowController> windowList = new ArrayList<DocumentWindowController>();
    private final PreferencesWindowController preferencesWindowController = new PreferencesWindowController();
    private final AboutWindowController aboutWindowController = new AboutWindowController();
    private UserLibrary userLibrary;
    private File nextInitialDirectory;
    private ToolTheme toolTheme = ToolTheme.DEFAULT;

    public static SceneBuilderApp getSingleton() {
        return singleton;
    }

    public SceneBuilderApp() {
        assert (singleton == null);
        singleton = this;
        Runnable p0 = new Runnable(){

            @Override
            public void run() {
                SceneBuilderApp.this.backgroundStartPhase0();
            }
        };
        Runnable p1 = new Runnable(){

            @Override
            public void run() {
                try {
                    launchLatch.await();
                    SceneBuilderApp.this.backgroundStartPhase2();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        Thread phase0 = new Thread(p0, "Phase 0");
        Thread phase1 = new Thread(p1, "Phase 1");
        phase0.setDaemon(true);
        phase1.setDaemon(true);
        phase0.start();
        phase1.start();
    }

    public void performControlAction(ApplicationControlAction a, DocumentWindowController source) {
        switch (a) {
            case ABOUT: {
                this.aboutWindowController.openWindow();
                break;
            }
            case NEW_FILE: {
                DocumentWindowController newWindow = this.makeNewWindow();
                newWindow.loadWithDefaultContent();
                newWindow.openWindow();
                break;
            }
            case NEW_ALERT_DIALOG: 
            case NEW_BASIC_APPLICATION: 
            case NEW_COMPLEX_APPLICATION: {
                this.performNewTemplate(a);
                break;
            }
            case NEW_ALERT_DIALOG_CSS: 
            case NEW_ALERT_DIALOG_I18N: 
            case NEW_BASIC_APPLICATION_CSS: 
            case NEW_BASIC_APPLICATION_I18N: 
            case NEW_COMPLEX_APPLICATION_CSS: 
            case NEW_COMPLEX_APPLICATION_I18N: {
                this.performNewTemplateWithResources(a);
                break;
            }
            case OPEN_FILE: {
                this.performOpenFile(source);
                break;
            }
            case CLOSE_FRONT_WINDOW: {
                this.performCloseFrontWindow();
                break;
            }
            case USE_DEFAULT_THEME: {
                this.performUseToolTheme(ToolTheme.DEFAULT);
                break;
            }
            case USE_DARK_THEME: {
                this.performUseToolTheme(ToolTheme.DARK);
                break;
            }
            case SHOW_PREFERENCES: {
                this.preferencesWindowController.openWindow();
                break;
            }
            case EXIT: {
                this.performExit();
            }
        }
    }

    public boolean canPerformControlAction(ApplicationControlAction a, DocumentWindowController source) {
        boolean result;
        switch (a) {
            case ABOUT: 
            case NEW_FILE: 
            case NEW_ALERT_DIALOG: 
            case NEW_BASIC_APPLICATION: 
            case NEW_COMPLEX_APPLICATION: 
            case NEW_ALERT_DIALOG_CSS: 
            case NEW_ALERT_DIALOG_I18N: 
            case NEW_BASIC_APPLICATION_CSS: 
            case NEW_BASIC_APPLICATION_I18N: 
            case NEW_COMPLEX_APPLICATION_CSS: 
            case NEW_COMPLEX_APPLICATION_I18N: 
            case OPEN_FILE: 
            case SHOW_PREFERENCES: 
            case EXIT: {
                result = true;
                break;
            }
            case CLOSE_FRONT_WINDOW: {
                result = !this.windowList.isEmpty();
                break;
            }
            case USE_DEFAULT_THEME: {
                result = this.toolTheme != ToolTheme.DEFAULT;
                break;
            }
            case USE_DARK_THEME: {
                result = this.toolTheme != ToolTheme.DARK;
                break;
            }
            default: {
                result = false;
                assert (false);
                break;
            }
        }
        return result;
    }

    public void performOpenRecent(DocumentWindowController source, File fxmlFile) {
        assert (fxmlFile != null && fxmlFile.exists());
        ArrayList<File> fxmlFiles = new ArrayList<File>();
        fxmlFiles.add(fxmlFile);
        this.performOpenFiles(fxmlFiles, source);
    }

    public void documentWindowRequestClose(DocumentWindowController fromWindow) {
        this.closeWindow(fromWindow);
    }

    public UserLibrary getUserLibrary() {
        return this.userLibrary;
    }

    public List<DocumentWindowController> getDocumentWindowControllers() {
        return Collections.unmodifiableList(this.windowList);
    }

    public DocumentWindowController lookupDocumentWindowControllers(URL fxmlLocation) {
        assert (fxmlLocation != null);
        DocumentWindowController result = null;
        try {
            URI fxmlURI = fxmlLocation.toURI();
            for (DocumentWindowController dwc : this.windowList) {
                URL docLocation = dwc.getEditorController().getFxmlLocation();
                if (docLocation == null || !fxmlURI.equals(docLocation.toURI())) continue;
                result = dwc;
                break;
            }
        }
        catch (URISyntaxException x) {
            throw new RuntimeException("Bug in " + this.getClass().getSimpleName(), x);
        }
        return result;
    }

    public DocumentWindowController lookupUnusedDocumentWindowController() {
        DocumentWindowController result = null;
        for (DocumentWindowController dwc : this.windowList) {
            if (!dwc.isUnused()) continue;
            result = dwc;
            break;
        }
        return result;
    }

    public void toggleDebugMenu() {
        boolean visible;
        if (this.windowList.isEmpty()) {
            visible = false;
        } else {
            DocumentWindowController dwc = this.windowList.get(0);
            visible = dwc.getMenuBarController().isDebugMenuVisible();
        }
        for (DocumentWindowController dwc : this.windowList) {
            dwc.getMenuBarController().setDebugMenuVisible(!visible);
        }
        if (EditorPlatform.IS_MAC) {
            MenuBarController.getSystemMenuBarController().setDebugMenuVisible(!visible);
        }
    }

    public void updateNextInitialDirectory(File chosenFile) {
        assert (chosenFile != null);
        Path chosenFolder = chosenFile.toPath().getParent();
        if (chosenFolder != null) {
            this.nextInitialDirectory = chosenFolder.toFile();
        }
    }

    public File getNextInitialDirectory() {
        return this.nextInitialDirectory;
    }

    public static synchronized String getDarkToolStylesheet() {
        if (darkToolStylesheet == null) {
            URL url = SceneBuilderApp.class.getResource("css/ThemeDark.css");
            assert (url != null);
            darkToolStylesheet = url.toExternalForm();
        }
        return darkToolStylesheet;
    }

    public void start(Stage stage) throws Exception {
        launchLatch.countDown();
        this.setApplicationUncaughtExceptionHandler();
        try {
            if (!AppPlatform.requestStart(this, this.getParameters())) {
                Platform.exit();
            }
        }
        catch (IOException x) {
            ErrorDialog errorDialog = new ErrorDialog(null);
            errorDialog.setTitle(I18N.getString("alert.title.start"));
            errorDialog.setMessage(I18N.getString("alert.start.failure.message"));
            errorDialog.setDetails(I18N.getString("alert.start.failure.details"));
            errorDialog.setDebugInfoWithThrowable(x);
            errorDialog.showAndWait();
            Platform.exit();
        }
        this.logTimestamp(ACTION.START);
    }

    @Override
    public void handleLaunch(List<String> files) {
        this.setApplicationUncaughtExceptionHandler();
        this.userLibrary = new UserLibrary(AppPlatform.getUserLibraryFolder());
        this.userLibrary.explorationCountProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
                SceneBuilderApp.this.userLibraryExplorationCountDidChange();
            }
        });
        this.userLibrary.startWatching();
        if (files.isEmpty()) {
            DocumentWindowController newWindow = this.makeNewWindow();
            newWindow.loadWithDefaultContent();
            newWindow.openWindow();
            if (System.getProperty("scenic") != null) {
                Platform.runLater((Runnable)new ScenicViewStarter(newWindow.getScene()));
            }
        } else {
            this.handleOpenFilesAction(files);
        }
        if (!Platform.isImplicitExit()) {
            Deprecation.setDefaultSystemMenuBar(MenuBarController.getSystemMenuBarController().getMenuBar());
        }
    }

    @Override
    public void handleOpenFilesAction(List<String> files) {
        assert (files != null);
        assert (!files.isEmpty());
        ArrayList<File> fileObjs = new ArrayList<File>();
        for (String file : files) {
            fileObjs.add(new File(file));
        }
        this.performOpenFiles(fileObjs, null);
    }

    @Override
    public void handleMessageBoxFailure(Exception x) {
        ErrorDialog errorDialog = new ErrorDialog(null);
        errorDialog.setTitle(I18N.getString("alert.title.messagebox"));
        errorDialog.setMessage(I18N.getString("alert.messagebox.failure.message"));
        errorDialog.setDetails(I18N.getString("alert.messagebox.failure.details"));
        errorDialog.setDebugInfoWithThrowable(x);
        errorDialog.showAndWait();
    }

    @Override
    public void handleQuitAction() {
        if (this.windowList.isEmpty()) {
            this.logTimestamp(ACTION.STOP);
            Platform.exit();
        }
    }

    public static void main(String[] args) {
        SceneBuilderApp.launch((String[])args);
    }

    public DocumentWindowController makeNewWindow() {
        DocumentWindowController result = new DocumentWindowController();
        this.windowList.add(result);
        return result;
    }

    private void closeWindow(DocumentWindowController w) {
        assert (this.windowList.contains(w));
        this.windowList.remove(w);
        w.closeWindow();
    }

    private static String displayName(String pathString) {
        return Paths.get(pathString, new String[0]).getFileName().toString();
    }

    private void performOpenFile(DocumentWindowController fromWindow) {
        List fxmlFiles;
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18N.getString("file.filter.label.fxml"), new String[]{"*.fxml"}));
        if (this.nextInitialDirectory != null) {
            fileChooser.setInitialDirectory(this.nextInitialDirectory);
        }
        if ((fxmlFiles = fileChooser.showOpenMultipleDialog(null)) != null) {
            assert (!fxmlFiles.isEmpty());
            this.updateNextInitialDirectory((File)fxmlFiles.get(0));
            this.performOpenFiles(fxmlFiles, fromWindow);
        }
    }

    private void performNewTemplate(ApplicationControlAction action) {
        DocumentWindowController newTemplateWindow = this.makeNewWindow();
        URL url = FxmlTemplates.getContentURL(action);
        newTemplateWindow.loadFromURL(url);
        newTemplateWindow.openWindow();
    }

    private void performNewTemplateWithResources(ApplicationControlAction action) {
        TemplateDialogController tdc = new TemplateDialogController(action);
        tdc.setToolStylesheet(this.getToolStylesheet());
        tdc.openWindow();
    }

    private void performCloseFrontWindow() {
        if (this.preferencesWindowController != null && this.preferencesWindowController.getStage().isFocused()) {
            this.preferencesWindowController.closeWindow();
        } else {
            for (DocumentWindowController dwc : this.windowList) {
                if (!dwc.isFrontDocumentWindow()) continue;
                dwc.performCloseFrontDocumentWindow();
                break;
            }
        }
    }

    private void performOpenFiles(List<File> fxmlFiles, DocumentWindowController fromWindow) {
        assert (fxmlFiles != null);
        assert (!fxmlFiles.isEmpty());
        HashMap<File, IOException> exceptions = new HashMap<File, IOException>();
        for (File fxmlFile : fxmlFiles) {
            try {
                DocumentWindowController dwc = this.lookupDocumentWindowControllers(fxmlFile.toURI().toURL());
                if (dwc != null) {
                    dwc.getStage().toFront();
                    continue;
                }
                DocumentWindowController unusedWindow = this.lookupUnusedDocumentWindowController();
                DocumentWindowController hostWindow = unusedWindow != null ? unusedWindow : this.makeNewWindow();
                hostWindow.loadFromFile(fxmlFile);
                hostWindow.openWindow();
            }
            catch (IOException xx) {
                exceptions.put(fxmlFile, xx);
            }
        }
        switch (exceptions.size()) {
            case 0: {
                PreferencesController pc = PreferencesController.getSingleton();
                PreferencesRecordGlobal recordGlobal = pc.getRecordGlobal();
                recordGlobal.addRecentItems(fxmlFiles);
                break;
            }
            case 1: {
                File fxmlFile = (File)exceptions.keySet().iterator().next();
                Exception x = (Exception)exceptions.get(fxmlFile);
                ErrorDialog errorDialog = new ErrorDialog(null);
                errorDialog.setMessage(I18N.getString("alert.open.failure1.message", SceneBuilderApp.displayName(fxmlFile.getPath())));
                errorDialog.setDetails(I18N.getString("alert.open.failure1.details"));
                errorDialog.setDebugInfoWithThrowable(x);
                errorDialog.setTitle(I18N.getString("alert.title.open"));
                errorDialog.showAndWait();
                break;
            }
            default: {
                ErrorDialog errorDialog = new ErrorDialog(null);
                if (exceptions.size() == fxmlFiles.size()) {
                    errorDialog.setMessage(I18N.getString("alert.open.failureN.message"));
                    errorDialog.setDetails(I18N.getString("alert.open.failureN.details"));
                } else {
                    errorDialog.setMessage(I18N.getString("alert.open.failureMofN.message", exceptions.size(), fxmlFiles.size()));
                    errorDialog.setDetails(I18N.getString("alert.open.failureMofN.details"));
                }
                errorDialog.setTitle(I18N.getString("alert.title.open"));
                errorDialog.showAndWait();
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void performExit() {
        void var2_9;
        for (DocumentWindowController documentWindowController : this.windowList) {
            if (!documentWindowController.getEditorController().isTextEditingSessionOnGoing() || documentWindowController.getEditorController().canGetFxmlText()) continue;
            return;
        }
        ArrayList<DocumentWindowController> pendingDocs = new ArrayList<DocumentWindowController>();
        for (DocumentWindowController dwc : this.windowList) {
            if (!dwc.isDocumentDirty()) continue;
            pendingDocs.add(dwc);
        }
        block0 : switch (pendingDocs.size()) {
            case 0: {
                boolean bl = true;
                break;
            }
            case 1: {
                DocumentWindowController dwc0 = (DocumentWindowController)pendingDocs.get(0);
                boolean bl = dwc0.performCloseAction() == DocumentWindowController.ActionStatus.DONE;
                break;
            }
            default: {
                assert (pendingDocs.size() >= 2);
                AlertDialog d = new AlertDialog(null);
                d.setMessage(I18N.getString("alert.review.question.message", pendingDocs.size()));
                d.setDetails(I18N.getString("alert.review.question.details"));
                d.setOKButtonTitle(I18N.getString("label.review.changes"));
                d.setActionButtonTitle(I18N.getString("label.discard.changes"));
                d.setActionButtonVisible(true);
                switch (d.showAndWait()) {
                    default: {
                        DocumentWindowController.ActionStatus status;
                        int i = 0;
                        while ((status = ((DocumentWindowController)pendingDocs.get(i++)).performCloseAction()) == DocumentWindowController.ActionStatus.DONE && i < pendingDocs.size()) {
                        }
                        boolean bl = status == DocumentWindowController.ActionStatus.DONE;
                        break block0;
                    }
                    case CANCEL: {
                        boolean bl = false;
                        break block0;
                    }
                    case ACTION: 
                }
                boolean bl = true;
                break;
            }
        }
        if (var2_9 != false) {
            PreferencesController pc = PreferencesController.getSingleton();
            for (DocumentWindowController dwc : new ArrayList<DocumentWindowController>(this.windowList)) {
                PreferencesRecordDocument recordDocument = pc.getRecordDocument(dwc);
                recordDocument.writeToJavaPreferences();
                this.documentWindowRequestClose(dwc);
            }
            this.logTimestamp(ACTION.STOP);
            Platform.exit();
        }
    }

    private void logTimestamp(ACTION type) {
        switch (type) {
            case START: {
                Logger.getLogger(this.getClass().getName()).info(I18N.getString("log.start"));
                break;
            }
            case STOP: {
                Logger.getLogger(this.getClass().getName()).info(I18N.getString("log.stop"));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void setApplicationUncaughtExceptionHandler() {
        if (Thread.getDefaultUncaughtExceptionHandler() == null) {
            Thread.setDefaultUncaughtExceptionHandler(new SceneBuilderUncaughtExceptionHandler());
        }
    }

    private void performUseToolTheme(ToolTheme toolTheme) {
        this.toolTheme = toolTheme;
        String toolStylesheet = this.getToolStylesheet();
        for (DocumentWindowController dwc : this.windowList) {
            dwc.setToolStylesheet(toolStylesheet);
        }
        this.preferencesWindowController.setToolStylesheet(toolStylesheet);
        this.aboutWindowController.setToolStylesheet(toolStylesheet);
    }

    private String getToolStylesheet() {
        String result;
        switch (this.toolTheme) {
            default: {
                result = EditorController.getBuiltinToolStylesheet();
                break;
            }
            case DARK: {
                result = SceneBuilderApp.getDarkToolStylesheet();
            }
        }
        return result;
    }

    private void backgroundStartPhase0() {
        assert (!Platform.isFxApplicationThread());
        PreferencesController.getSingleton();
        Metadata.getMetadata();
    }

    private void backgroundStartPhase2() {
        assert (!Platform.isFxApplicationThread());
        assert (launchLatch.getCount() == 0L);
        BuiltinLibrary.getLibrary();
        if (EditorPlatform.IS_MAC) {
            MenuBarController.getSystemMenuBarController();
        }
        EffectPicker.getEffectClasses();
    }

    private void userLibraryExplorationCountDidChange() {
        switch (this.userLibrary.getJarReports().size()) {
            case 0: {
                if (this.userLibrary.getPreviousJarReports().size() <= 0) break;
                this.logInfoMessage("log.user.jar.exploration.0");
                break;
            }
            case 1: {
                Path jarPath = ((JarReport)this.userLibrary.getJarReports().get(0)).getJar();
                this.logInfoMessage("log.user.jar.exploration.1", jarPath.getFileName());
                break;
            }
            default: {
                int jarCount = this.userLibrary.getJarReports().size();
                this.logInfoMessage("log.user.jar.exploration.n", jarCount);
            }
        }
    }

    private void logInfoMessage(String key) {
        for (DocumentWindowController dwc : this.windowList) {
            dwc.getEditorController().getMessageLog().logInfoMessage(key, I18N.getBundle(), new Object[0]);
        }
    }

    private void logInfoMessage(String key, Object arg) {
        for (DocumentWindowController dwc : this.windowList) {
            dwc.getEditorController().getMessageLog().logInfoMessage(key, I18N.getBundle(), arg);
        }
    }

    static {
        launchLatch = new CountDownLatch(1);
    }

    private static class SceneBuilderUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private SceneBuilderUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "An exception was thrown:", e);
        }
    }

    private static enum ACTION {
        START,
        STOP;

    }

    public static enum ToolTheme {
        DEFAULT{

            public String toString() {
                return I18N.getString("prefs.tool.theme.default");
            }
        }
        ,
        DARK{

            public String toString() {
                return I18N.getString("prefs.tool.theme.dark");
            }
        };

    }

    public static enum ApplicationControlAction {
        ABOUT,
        NEW_FILE,
        NEW_ALERT_DIALOG,
        NEW_ALERT_DIALOG_CSS,
        NEW_ALERT_DIALOG_I18N,
        NEW_BASIC_APPLICATION,
        NEW_BASIC_APPLICATION_CSS,
        NEW_BASIC_APPLICATION_I18N,
        NEW_COMPLEX_APPLICATION,
        NEW_COMPLEX_APPLICATION_CSS,
        NEW_COMPLEX_APPLICATION_I18N,
        OPEN_FILE,
        CLOSE_FRONT_WINDOW,
        USE_DEFAULT_THEME,
        USE_DARK_THEME,
        SHOW_PREFERENCES,
        EXIT;

    }
}

