/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app;

import com.oracle.javafx.scenebuilder.app.AppPlatform;
import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import com.oracle.javafx.scenebuilder.app.about.AboutWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractGenericHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.util.CardinalPoint;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.AbstractHierarchyPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyItem;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Cell;
import javafx.scene.control.TreeItem;

public class SceneBuilderTest {
    public static Scene newFxmlFile() {
        DocumentWindowController newWindow = SceneBuilderApp.getSingleton().makeNewWindow();
        newWindow.openWindow();
        return newWindow.getScene();
    }

    public static Scene openFxmlFile(File fxmlFile) throws IOException {
        assert (fxmlFile != null);
        DocumentWindowController newWindow = SceneBuilderApp.getSingleton().makeNewWindow();
        newWindow.loadFromFile(fxmlFile);
        newWindow.openWindow();
        return newWindow.getScene();
    }

    public static Object getUserSceneGraphRoot(Scene documentScene) {
        assert (documentScene != null);
        FXOMDocument fxomDocument = SceneBuilderTest.lookupFxomDocument(documentScene);
        Object result = fxomDocument == null ? null : fxomDocument.getSceneGraphRoot();
        return result;
    }

    public static Set<FXOMObject> findSelectedObjects(Scene documentScene) {
        Set<Object> result;
        assert (documentScene != null);
        DocumentWindowController dwc = SceneBuilderTest.lookupWindowController(documentScene);
        if (dwc == null) {
            result = null;
        } else {
            Selection selection = dwc.getEditorController().getSelection();
            if (selection.getGroup() instanceof ObjectSelectionGroup) {
                ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
                result = Collections.unmodifiableSet(osg.getItems());
            } else {
                result = Collections.emptySet();
            }
        }
        return result;
    }

    public static FXOMObject fxomObjectFromContentPanelNode(Node node) {
        FXOMObject result;
        assert (node != null);
        assert (node.getScene() != null);
        DocumentWindowController dwc = SceneBuilderTest.lookupWindowController(node.getScene());
        if (dwc == null) {
            result = null;
        } else {
            Bounds b = node.getLayoutBounds();
            double midX = (b.getMinX() + b.getMaxX()) / 2.0;
            double midY = (b.getMinY() + b.getMaxY()) / 2.0;
            Point2D nodeCenter = node.localToScene(midX, midY);
            ContentPanelController cpc = dwc.getContentPanelController();
            result = cpc.searchWithNode(node, nodeCenter.getX(), nodeCenter.getY());
        }
        return result;
    }

    public static Node fxomObjectToContentPanelNode(Scene documentScene, FXOMObject fxomObject) {
        assert (documentScene != null);
        assert (fxomObject != null);
        Node result = fxomObject.getSceneGraphObject() instanceof Node ? (Node)fxomObject.getSceneGraphObject() : null;
        return result;
    }

    public static FXOMObject fxomObjectFromHierarchyPanelNode(Node node) {
        FXOMObject result;
        assert (node != null);
        assert (node.getScene() != null);
        DocumentWindowController dwc = SceneBuilderTest.lookupWindowController(node.getScene());
        if (dwc == null) {
            result = null;
        } else {
            Parent parent = node.getParent();
            Cell cell = null;
            while (parent != null) {
                if (!(parent instanceof Cell)) continue;
                cell = (Cell)parent;
                break;
            }
            if (cell != null) {
                assert (!cell.isEmpty());
                if (cell.isVisible()) {
                    Object item = cell.getItem();
                    assert (item instanceof HierarchyItem);
                    HierarchyItem hierarchyItem = (HierarchyItem)item;
                    result = hierarchyItem.getFxomObject();
                } else {
                    result = null;
                }
            } else {
                result = null;
            }
        }
        return result;
    }

    public static Node fxomObjectToHierarchyPanelNode(Scene documentScene, FXOMObject fxomObject) {
        Cell<?> result;
        assert (documentScene != null);
        assert (fxomObject != null);
        DocumentWindowController dwc = SceneBuilderTest.lookupWindowController(documentScene);
        if (dwc == null) {
            result = null;
        } else {
            TreeItem<HierarchyItem> treeItem;
            EditorController ec = dwc.getEditorController();
            assert (fxomObject.getFxomDocument() == ec.getFxomDocument());
            AbstractHierarchyPanelController hpc = dwc.getHierarchyPanelController();
            assert (hpc != null);
            assert (hpc.getPanelControl() != null);
            result = hpc.getPanelControl().isVisible() ? ((treeItem = hpc.lookupTreeItem(fxomObject)) != null ? hpc.getCell(treeItem) : null) : null;
        }
        return result;
    }

    public static void revealInHierarchyPanel(Scene documentScene, FXOMObject fxomObject) {
        assert (documentScene != null);
        assert (fxomObject != null);
        DocumentWindowController dwc = SceneBuilderTest.lookupWindowController(documentScene);
        if (dwc != null) {
            TreeItem<HierarchyItem> treeItem;
            EditorController ec = dwc.getEditorController();
            assert (fxomObject.getFxomDocument() == ec.getFxomDocument());
            AbstractHierarchyPanelController hpc = dwc.getHierarchyPanelController();
            assert (hpc != null);
            assert (hpc.getPanelControl() != null);
            SceneBuilderTest.expandAllTreeItems(hpc.getRoot());
            if (hpc.getPanelControl().isVisible() && (treeItem = hpc.lookupTreeItem(fxomObject)) != null) {
                hpc.scrollTo(treeItem);
            }
        }
    }

    public static Node lookupResizeHandle(Scene documentScene, FXOMObject fxomObject, CardinalPoint cp) {
        Node result;
        assert (documentScene != null);
        assert (fxomObject != null);
        DocumentWindowController dwc = SceneBuilderTest.lookupWindowController(documentScene);
        if (dwc == null) {
            result = null;
        } else {
            EditorController ec = dwc.getEditorController();
            assert (fxomObject.getFxomDocument() == ec.getFxomDocument());
            assert (ec.getSelection().isSelected(fxomObject));
            ContentPanelController cpc = dwc.getContentPanelController();
            AbstractHandles<?> h = cpc.lookupHandles(fxomObject);
            if (h instanceof AbstractGenericHandles) {
                AbstractGenericHandles gh = (AbstractGenericHandles)h;
                result = gh.getHandleNode(cp);
            } else {
                result = null;
            }
        }
        return result;
    }

    public static String getVersionString() {
        AboutWindowController awc = new AboutWindowController();
        return awc.getBuildInfo();
    }

    public static void closePreviewWindow(Scene documentScene) {
        DocumentWindowController dwc = SceneBuilderTest.lookupWindowController(documentScene);
        if (dwc != null) {
            dwc.getPreviewWindowController().closeWindow();
        }
    }

    public static void startApplication(String[] args) {
        AppPlatform.setStartingFromTestBed(true);
        SceneBuilderApp.main(args);
    }

    private static FXOMDocument lookupFxomDocument(Scene documentScene) {
        DocumentWindowController dwc = SceneBuilderTest.lookupWindowController(documentScene);
        FXOMDocument result = dwc == null ? null : dwc.getEditorController().getFxomDocument();
        return result;
    }

    private static DocumentWindowController lookupWindowController(Scene documentScene) {
        DocumentWindowController result = null;
        SceneBuilderApp app = SceneBuilderApp.getSingleton();
        for (DocumentWindowController c : app.getDocumentWindowControllers()) {
            if (c.getScene() != documentScene) continue;
            result = c;
            break;
        }
        return result;
    }

    private static <T> void expandAllTreeItems(TreeItem<T> parentTreeItem) {
        if (parentTreeItem != null) {
            parentTreeItem.setExpanded(true);
            ObservableList children = parentTreeItem.getChildren();
            if (children != null) {
                for (TreeItem child : children) {
                    SceneBuilderTest.expandAllTreeItems(child);
                }
            }
        }
    }
}

