/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app;

import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.ErrorDialog;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class SceneStyleSheetMenuController {
    private final DocumentWindowController documentWindowController;

    public SceneStyleSheetMenuController(DocumentWindowController dwc) {
        this.documentWindowController = dwc;
    }

    void performAddSceneStyleSheet() {
        boolean knownFilesModified = false;
        ObservableList knownFiles = this.documentWindowController.getEditorController().getSceneStyleSheets();
        if (knownFiles == null) {
            knownFiles = FXCollections.observableArrayList();
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18N.getString("scenestylesheet.filechooser.filter.msg"), new String[]{"*.css", "*.bss"}));
        List selectedFiles = fileChooser.showOpenMultipleDialog((Window)this.documentWindowController.getStage());
        if (selectedFiles != null) {
            assert (!selectedFiles.isEmpty());
            for (File f : selectedFiles) {
                if (knownFiles.contains((Object)f)) continue;
                knownFiles.add((Object)f);
                knownFilesModified = true;
            }
        }
        if (knownFilesModified) {
            this.documentWindowController.getEditorController().setSceneStyleSheets((ObservableList<File>)knownFiles);
        }
    }

    public void performRemoveSceneStyleSheet(File toRemove) {
        ObservableList<File> knownFiles = this.documentWindowController.getEditorController().getSceneStyleSheets();
        assert (knownFiles != null);
        if (knownFiles.contains((Object)toRemove)) {
            knownFiles.remove((Object)toRemove);
            this.documentWindowController.getEditorController().setSceneStyleSheets(knownFiles);
        }
    }

    public void performOpenSceneStyleSheet(File toOpen) {
        try {
            EditorPlatform.open(toOpen.getPath());
        }
        catch (IOException ioe) {
            ErrorDialog errorDialog = new ErrorDialog(null);
            errorDialog.setTitle(I18N.getString("error.file.open.title"));
            errorDialog.setMessage(I18N.getString("error.file.open.message"));
            errorDialog.setDetails(I18N.getString("error.filesystem.details"));
            errorDialog.setDebugInfoWithThrowable(ioe);
            errorDialog.showAndWait();
        }
    }
}

