/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.about;

import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import com.sun.javafx.tk.Toolkit;
import com.sun.prism.GraphicsPipeline;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javafx.fxml.FXML;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.WindowEvent;

public final class AboutWindowController
extends AbstractFxmlWindowController {
    @FXML
    private VBox vbox;
    @FXML
    private TextArea textArea;
    private String sbBuildInfo = "PLACEHOLDER";
    private String sbBuildDate = "PLACEHOLDER";
    private String sbBuildJavaVersion = "PLACEHOLDER";
    private String sbAboutCopyrightKeyName = "about.copyright.open";
    private final String LOG_FILE_NAME = "scenebuilder-2.0.log";

    public AboutWindowController() {
        super(AboutWindowController.class.getResource("About.fxml"), I18N.getBundle());
        try (InputStream in = this.getClass().getResourceAsStream("about.properties");){
            if (in != null) {
                Properties sbProps = new Properties();
                sbProps.load(in);
                this.sbBuildInfo = sbProps.getProperty("build.info", "UNSET");
                this.sbBuildDate = sbProps.getProperty("build.date", "UNSET");
                this.sbBuildJavaVersion = sbProps.getProperty("build.java.version", "UNSET");
                this.sbAboutCopyrightKeyName = sbProps.getProperty("copyright.key.name", "UNSET");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @FXML
    public void onMousePressed(MouseEvent event) {
        if (event.getClickCount() == 2 && event.isAltDown()) {
            SceneBuilderApp.getSingleton().toggleDebugMenu();
        }
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.closeWindow();
    }

    @Override
    protected void controllerDidCreateStage() {
        assert (this.getRoot() != null);
        assert (this.getRoot().getScene() != null);
        assert (this.getRoot().getScene().getWindow() != null);
        this.getStage().setTitle(I18N.getString("about.title"));
        this.getStage().initModality(Modality.APPLICATION_MODAL);
    }

    @Override
    protected void controllerDidLoadFxml() {
        super.controllerDidLoadFxml();
        assert (this.vbox != null);
        assert (this.textArea != null);
        this.textArea.setText(this.getAboutText());
    }

    private String getAboutText() {
        StringBuilder text = this.getVersionParagraph().append((CharSequence)this.getBuildInfoParagraph()).append((CharSequence)this.getLoggingParagraph()).append((CharSequence)this.getFxParagraph()).append((CharSequence)this.getJavaParagraph()).append((CharSequence)this.getOsParagraph()).append(I18N.getString(this.sbAboutCopyrightKeyName));
        return text.toString();
    }

    public String getBuildJavaVersion() {
        return this.sbBuildJavaVersion;
    }

    public String getBuildInfo() {
        return this.sbBuildInfo;
    }

    private StringBuilder getVersionParagraph() {
        StringBuilder sb = new StringBuilder(I18N.getString("about.product.version"));
        sb.append("\nJavaFX Scene Builder 2.0\n\n");
        return sb;
    }

    private String getLogFilePath() {
        StringBuilder sb = new StringBuilder(System.getProperty("java.io.tmpdir"));
        if (sb.charAt(sb.length() - 1) != File.separatorChar) {
            sb.append(File.separatorChar);
        }
        sb.append("scenebuilder-2.0.log");
        return sb.toString();
    }

    private StringBuilder getBuildInfoParagraph() {
        StringBuilder sb = new StringBuilder(I18N.getString("about.build.information"));
        sb.append("\n").append(this.sbBuildInfo).append("\n").append(I18N.getString("about.build.date", this.sbBuildDate)).append("\n\n");
        return sb;
    }

    private StringBuilder getLoggingParagraph() {
        StringBuilder sb = new StringBuilder(I18N.getString("about.logging.title"));
        sb.append("\n").append(I18N.getString("about.logging.body.first", "scenebuilder-2.0.log")).append("\n").append(I18N.getString("about.logging.body.second", this.getLogFilePath())).append("\n\n");
        return sb;
    }

    private StringBuilder getFxParagraph() {
        boolean hwAccelerated = false;
        String tk = Toolkit.getToolkit().getClass().getSimpleName();
        StringBuilder fxtra = new StringBuilder("JavaFX\n");
        fxtra.append(I18N.getString("about.fx.toolkit")).append(" = ").append(tk).append("\n");
        if ("GlassToolkit".equals(tk) || "PrismToolkit".equals(tk) || "QuantumToolkit".equals(tk)) {
            String ppl = GraphicsPipeline.getPipeline().getClass().getSimpleName();
            fxtra.append(I18N.getString("about.fx.pipeline")).append(" = ").append(ppl).append("\n");
            if (ppl.trim().equals("D3DPipeline") || ppl.trim().equals("ES1Pipeline") || ppl.trim().equals("ES2Pipeline")) {
                hwAccelerated = true;
            }
        }
        fxtra.append(I18N.getString("about.fx.hardware.acceleration")).append(" ").append(hwAccelerated ? I18N.getString("about.fx.hardware.acceleration.enabled") : I18N.getString("about.fx.hardware.acceleration.disabled")).append("\n\n");
        return fxtra;
    }

    private StringBuilder getJavaParagraph() {
        StringBuilder sb = new StringBuilder("Java\n");
        sb.append(System.getProperty("java.runtime.version")).append(", ").append(System.getProperty("java.vendor")).append("\n\n");
        return sb;
    }

    private StringBuilder getOsParagraph() {
        StringBuilder sb = new StringBuilder(I18N.getString("about.operating.system"));
        sb.append("\n").append(System.getProperty("os.name")).append(", ").append(System.getProperty("os.arch")).append(", ").append(System.getProperty("os.version")).append("\n\n");
        return sb;
    }
}

