/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.menubar;

import com.oracle.javafx.scenebuilder.app.AppPlatform;
import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.JobManager;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.CompositeJob;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.ErrorDialog;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;

class DebugMenuController {
    private final Menu menu = new Menu("Debug");
    private final DocumentWindowController documentWindowController;

    public DebugMenuController(DocumentWindowController documentWindowController) {
        this.documentWindowController = documentWindowController;
        final String applicationDataFolder = AppPlatform.getApplicationDataFolder();
        MenuItem libraryFolderMenuItem = new MenuItem();
        libraryFolderMenuItem.setText(applicationDataFolder);
        libraryFolderMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                DebugMenuController.this.handleRevealPath(applicationDataFolder);
            }
        });
        Menu libraryFolderMenu = new Menu("Application Data Folder");
        libraryFolderMenu.getItems().add((Object)libraryFolderMenuItem);
        MenuItem layoutMenuItem = new MenuItem();
        layoutMenuItem.setText("Check \"localToSceneTransform Properties\" in Content Panel");
        layoutMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                System.out.println("CHECK LOCAL TO SCENE TRANSFORM BEGINS");
                ContentPanelController cpc = DebugMenuController.this.documentWindowController.getContentPanelController();
                DebugMenuController.this.checkLocalToSceneTransform((Node)cpc.getPanelRoot());
                System.out.println("CHECK LOCAL TO SCENE TRANSFORM ENDS");
            }
        });
        MenuItem useDefaultThemeMenuItem = new MenuItem();
        useDefaultThemeMenuItem.setText("Use Default Theme");
        useDefaultThemeMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                SceneBuilderApp.getSingleton().performControlAction(SceneBuilderApp.ApplicationControlAction.USE_DEFAULT_THEME, DebugMenuController.this.documentWindowController);
            }
        });
        MenuItem useDarkThemeMenuItem = new MenuItem();
        useDarkThemeMenuItem.setText("Use Dark Theme");
        useDarkThemeMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                SceneBuilderApp.getSingleton().performControlAction(SceneBuilderApp.ApplicationControlAction.USE_DARK_THEME, DebugMenuController.this.documentWindowController);
            }
        });
        Menu undoRedoStack = new Menu();
        undoRedoStack.setText("Undo/Redo Stack");
        undoRedoStack.getItems().add((Object)this.makeMenuItem("Dummy", true));
        undoRedoStack.setOnMenuValidation((EventHandler)new EventHandler<Event>(){

            public void handle(Event t) {
                assert (t.getTarget() instanceof Menu);
                DebugMenuController.this.undoRedoStackMenuShowing((Menu)t.getTarget());
            }
        });
        this.menu.getItems().add((Object)libraryFolderMenu);
        this.menu.getItems().add((Object)new SeparatorMenuItem());
        this.menu.getItems().add((Object)layoutMenuItem);
        this.menu.getItems().add((Object)new SeparatorMenuItem());
        this.menu.getItems().add((Object)useDefaultThemeMenuItem);
        this.menu.getItems().add((Object)useDarkThemeMenuItem);
        this.menu.getItems().add((Object)new SeparatorMenuItem());
        this.menu.getItems().add((Object)undoRedoStack);
    }

    public Menu getMenu() {
        return this.menu;
    }

    private void handleRevealPath(String path) {
        try {
            EditorPlatform.revealInFileBrowser(new File(path));
        }
        catch (IOException x) {
            ErrorDialog d = new ErrorDialog(null);
            d.setMessage("Failed to reveal folder");
            d.setDetails(path);
            d.setDebugInfoWithThrowable(x);
            d.showAndWait();
        }
    }

    private void checkLocalToSceneTransform(Node node) {
        Point2D p1 = node.localToScene(0.0, 0.0);
        Point2D p2 = node.getLocalToSceneTransform().transform(0.0, 0.0);
        boolean okX = MathUtils.equals(p1.getX(), p2.getX(), 1.0E-7);
        boolean okY = MathUtils.equals(p1.getY(), p2.getY(), 1.0E-7);
        if (!okX || !okY) {
            System.out.println("CHECK FAILED FOR " + node + ", p1=" + p1 + ", p2=" + p2);
        }
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            for (Node child : parent.getChildrenUnmodifiable()) {
                this.checkLocalToSceneTransform(child);
            }
        }
    }

    private void undoRedoStackMenuShowing(Menu menu) {
        JobManager jobManager = this.documentWindowController.getEditorController().getJobManager();
        List<Job> redoStack = jobManager.getRedoStack();
        List<Job> undoStack = jobManager.getUndoStack();
        ObservableList menuItems = menu.getItems();
        menuItems.clear();
        if (redoStack.isEmpty()) {
            menuItems.add(this.makeMenuItem("Redo Stack Empty", true));
        } else {
            for (Job job : redoStack) {
                menuItems.add(0, this.makeJobMenuItem(job));
            }
        }
        menuItems.add(new SeparatorMenuItem());
        if (undoStack.isEmpty()) {
            menuItems.add(this.makeMenuItem("Undo Stack Empty", true));
        } else {
            for (Job job : undoStack) {
                menuItems.add(this.makeJobMenuItem(job));
            }
        }
    }

    private MenuItem makeMenuItem(String text, boolean disable) {
        MenuItem result = new MenuItem();
        result.setText(text);
        result.setDisable(disable);
        return result;
    }

    private MenuItem makeJobMenuItem(Job job) {
        MenuItem result;
        if (job instanceof CompositeJob) {
            CompositeJob compositeJob = (CompositeJob)job;
            Menu newMenu = new Menu(compositeJob.getClass().getSimpleName());
            this.addJobMenuItems(compositeJob.getSubJobs(), newMenu);
            result = newMenu;
        } else if (job instanceof BatchJob) {
            BatchJob batchJob = (BatchJob)job;
            Menu newMenu = new Menu(batchJob.getClass().getSimpleName());
            this.addJobMenuItems(batchJob.getSubJobs(), newMenu);
            result = newMenu;
        } else {
            result = new MenuItem(job.getClass().getSimpleName());
        }
        return result;
    }

    private void addJobMenuItems(List<Job> jobs, Menu targetMenu) {
        targetMenu.getItems().clear();
        for (Job job : jobs) {
            targetMenu.getItems().add((Object)this.makeJobMenuItem(job));
        }
        if (targetMenu.getItems().isEmpty()) {
            targetMenu.getItems().add((Object)this.makeMenuItem("Empty", true));
        }
    }
}

