/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.menubar;

import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.app.menubar.DebugMenuController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordGlobal;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.library.BuiltinLibrary;
import com.oracle.javafx.scenebuilder.kit.library.BuiltinSectionComparator;
import com.oracle.javafx.scenebuilder.kit.library.LibraryItem;
import com.oracle.javafx.scenebuilder.kit.library.LibraryItemNameComparator;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPicker;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.effect.Effect;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.StackPane;

public class MenuBarController {
    private static MenuBarController systemMenuBarController;
    private Menu insertCustomMenu;
    private final DocumentWindowController documentWindowController;
    private DebugMenuController debugMenuController;
    @FXML
    private MenuBar menuBar;
    @FXML
    private Menu insertMenu;
    @FXML
    private Menu addEffectMenu;
    @FXML
    private Menu fileMenu;
    @FXML
    private Menu previewMenu;
    @FXML
    private Menu windowMenu;
    @FXML
    private MenuItem newMenuItem;
    @FXML
    private MenuItem newAlertDialogMenuItem;
    @FXML
    private MenuItem newAlertDialogCssMenuItem;
    @FXML
    private MenuItem newAlertDialogI18nMenuItem;
    @FXML
    private MenuItem newBasicAppMenuItem;
    @FXML
    private MenuItem newBasicAppCssMenuItem;
    @FXML
    private MenuItem newBasicAppI18nMenuItem;
    @FXML
    private MenuItem newComplexAppMenuItem;
    @FXML
    private MenuItem newComplexAppCssMenuItem;
    @FXML
    private MenuItem newComplexAppI18nMenuItem;
    @FXML
    private MenuItem openMenuItem;
    @FXML
    private Menu openRecentMenu;
    @FXML
    private MenuItem saveMenuItem;
    @FXML
    private MenuItem saveAsMenuItem;
    @FXML
    private MenuItem revertMenuItem;
    @FXML
    private MenuItem closeMenuItem;
    @FXML
    private MenuItem revealMenuItem;
    @FXML
    private MenuItem importFxmlMenuItem;
    @FXML
    private MenuItem importMediaMenuItem;
    @FXML
    private MenuItem includeFileMenuItem;
    @FXML
    private MenuItem editIncludedFileMenuItem;
    @FXML
    private MenuItem revealIncludedFileMenuItem;
    @FXML
    private MenuItem showPreferencesMenuItem;
    @FXML
    private MenuItem separatorAbovePreferencesMenuItem;
    @FXML
    private MenuItem exitMenuItem;
    @FXML
    private MenuItem undoMenuItem;
    @FXML
    private MenuItem redoMenuItem;
    @FXML
    private MenuItem copyMenuItem;
    @FXML
    private MenuItem cutMenuItem;
    @FXML
    private MenuItem pasteMenuItem;
    @FXML
    private MenuItem pasteIntoMenuItem;
    @FXML
    private MenuItem duplicateMenuItem;
    @FXML
    private MenuItem deleteMenuItem;
    @FXML
    private MenuItem selectAllMenuItem;
    @FXML
    private MenuItem selectNoneMenuItem;
    @FXML
    private MenuItem selectParentMenuItem;
    @FXML
    private MenuItem selectNextMenuItem;
    @FXML
    private MenuItem selectPreviousMenuItem;
    @FXML
    private MenuItem trimMenuItem;
    @FXML
    private MenuItem gotoContentMenuItem;
    @FXML
    private MenuItem gotoPropertiesMenuItem;
    @FXML
    private MenuItem gotoLayoutMenuItem;
    @FXML
    private MenuItem gotoCodeMenuItem;
    @FXML
    private MenuItem toggleLibraryPanelMenuItem;
    @FXML
    private MenuItem toggleHierarchyPanelMenuItem;
    @FXML
    private MenuItem toggleCSSPanelMenuItem;
    @FXML
    private MenuItem toggleLeftPanelMenuItem;
    @FXML
    private MenuItem toggleRightPanelMenuItem;
    @FXML
    private MenuItem toggleOutlinesMenuItem;
    @FXML
    private MenuItem toggleSampleDataMenuItem;
    @FXML
    private MenuItem toggleAlignmentGuidesMenuItem;
    @FXML
    private MenuItem showSampleControllerMenuItem;
    @FXML
    private Menu zoomMenu;
    @FXML
    private MenuItem fitToParentMenuItem;
    @FXML
    private MenuItem useComputedSizesMenuItem;
    @FXML
    private MenuItem addContextMenuMenuItem;
    @FXML
    private MenuItem addTooltipMenuItem;
    @FXML
    private MenuItem moveRowAboveMenuItem;
    @FXML
    private MenuItem moveRowBelowMenuItem;
    @FXML
    private MenuItem moveColumnBeforeMenuItem;
    @FXML
    private MenuItem moveColumnAfterMenuItem;
    @FXML
    private MenuItem addRowAboveMenuItem;
    @FXML
    private MenuItem addRowBelowMenuItem;
    @FXML
    private MenuItem addColumnBeforeMenuItem;
    @FXML
    private MenuItem addColumnAfterMenuItem;
    @FXML
    private MenuItem increaseRowSpanMenuItem;
    @FXML
    private MenuItem decreaseRowSpanMenuItem;
    @FXML
    private MenuItem increaseColumnSpanMenuItem;
    @FXML
    private MenuItem decreaseColumnSpanMenuItem;
    @FXML
    private RadioMenuItem qvgaSetSizeMenuItem;
    @FXML
    private RadioMenuItem vgaSetSizeMenuItem;
    @FXML
    private RadioMenuItem touchSetSizeMenuItem;
    @FXML
    private RadioMenuItem hdSetSizeMenuItem;
    @FXML
    private MenuItem bringToFrontMenuItem;
    @FXML
    private MenuItem sendToBackMenuItem;
    @FXML
    private MenuItem bringForwardMenuItem;
    @FXML
    private MenuItem sendBackwardMenuItem;
    @FXML
    private MenuItem wrapInAnchorPaneMenuItem;
    @FXML
    private MenuItem wrapInGridPaneMenuItem;
    @FXML
    private MenuItem wrapInHBoxMenuItem;
    @FXML
    private MenuItem wrapInPaneMenuItem;
    @FXML
    private MenuItem wrapInScrollPaneMenuItem;
    @FXML
    private MenuItem wrapInSplitPaneMenuItem;
    @FXML
    private MenuItem wrapInStackPaneMenuItem;
    @FXML
    private MenuItem wrapInTabPaneMenuItem;
    @FXML
    private MenuItem wrapInTitledPaneMenuItem;
    @FXML
    private MenuItem wrapInToolBarMenuItem;
    @FXML
    private MenuItem wrapInVBoxMenuItem;
    @FXML
    private MenuItem wrapInGroupMenuItem;
    @FXML
    private MenuItem unwrapMenuItem;
    @FXML
    private MenuItem showPreviewMenuItem;
    @FXML
    private RadioMenuItem modenaThemeMenuItem;
    @FXML
    private RadioMenuItem modenaTouchThemeMenuItem;
    @FXML
    private RadioMenuItem modenaHighContrastBlackonwhiteThemeMenuItem;
    @FXML
    private RadioMenuItem modenaHighContrastWhiteonblackThemeMenuItem;
    @FXML
    private RadioMenuItem modenaHighContrastYellowonblackThemeMenuItem;
    @FXML
    private RadioMenuItem caspianThemeMenuItem;
    @FXML
    private CheckMenuItem caspianHighContrastThemeMenuItem;
    @FXML
    private RadioMenuItem caspianEmbeddedThemeMenuItem;
    @FXML
    private RadioMenuItem caspianEmbeddedQVGAThemeMenuItem;
    @FXML
    private MenuItem separatorAboveChooseBackgroundColorMenuItem;
    @FXML
    private MenuItem chooseBackgroundColorMenuItem;
    @FXML
    private MenuItem addSceneStyleSheetMenuItem;
    @FXML
    private Menu removeSceneStyleSheetMenu;
    @FXML
    private Menu openSceneStyleSheetMenu;
    @FXML
    private MenuItem setResourceMenuItem;
    @FXML
    private MenuItem removeResourceMenuItem;
    @FXML
    private MenuItem revealResourceMenuItem;
    @FXML
    private RadioMenuItem qvgaPreviewSizeMenuItem;
    @FXML
    private RadioMenuItem vgaPreviewSizeMenuItem;
    @FXML
    private RadioMenuItem touchPreviewSizeMenuItem;
    @FXML
    private RadioMenuItem hdPreviewSizeMenuItem;
    @FXML
    private RadioMenuItem preferredPreviewSizeMenuItem;
    @FXML
    private MenuItem helpMenuItem;
    @FXML
    private MenuItem aboutMenuItem;
    private static final KeyCombination.Modifier modifier;
    private final Map<KeyCombination, MenuItem> keyToMenu = new HashMap<KeyCombination, MenuItem>();
    private final EventHandler<Event> onMenuValidationEventHandler = new EventHandler<Event>(){

        public void handle(Event t) {
            assert (t.getSource() instanceof Menu);
            MenuBarController.this.handleOnMenuValidation((Menu)t.getSource());
        }
    };
    private final EventHandler<ActionEvent> onActionEventHandler = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent t) {
            assert (t.getSource() instanceof MenuItem);
            MenuBarController.this.handleOnActionMenu((MenuItem)t.getSource());
        }
    };
    private final EventHandler<Event> onCustomPartOfInsertMenuValidationHandler = new EventHandler<Event>(){

        public void handle(Event t) {
            assert (t.getSource() == MenuBarController.this.insertMenu);
            MenuBarController.this.updateCustomPartOfInsertMenu();
        }
    };
    private final EventHandler<Event> onWindowMenuValidationHandler = new EventHandler<Event>(){

        public void handle(Event t) {
            assert (t.getSource() == MenuBarController.this.windowMenu);
            MenuBarController.this.handleOnWindowMenuValidation();
        }
    };

    public MenuBarController(DocumentWindowController documentWindowController) {
        this.documentWindowController = documentWindowController;
    }

    public MenuBar getMenuBar() {
        if (this.menuBar == null) {
            URL fxmlURL = MenuBarController.class.getResource("MenuBar.fxml");
            FXMLLoader loader = new FXMLLoader();
            loader.setController((Object)this);
            loader.setLocation(fxmlURL);
            loader.setResources(I18N.getBundle());
            try {
                loader.load();
                this.controllerDidLoadFxml();
            }
            catch (IOException | RuntimeException x) {
                System.out.println("loader.getController()=" + loader.getController());
                System.out.println("loader.getLocation()=" + loader.getLocation());
                throw new RuntimeException("Failed to load " + fxmlURL.getFile(), x);
            }
        }
        return this.menuBar;
    }

    public void setDebugMenuVisible(boolean visible) {
        if (this.isDebugMenuVisible() != visible) {
            if (visible) {
                if (this.debugMenuController == null) {
                    this.debugMenuController = new DebugMenuController(this.documentWindowController);
                }
                this.menuBar.getMenus().add((Object)this.debugMenuController.getMenu());
            } else {
                this.menuBar.getMenus().remove((Object)this.debugMenuController.getMenu());
            }
        }
    }

    public boolean isDebugMenuVisible() {
        boolean result = this.debugMenuController == null ? false : this.menuBar.getMenus().contains((Object)this.debugMenuController.getMenu());
        return result;
    }

    public static synchronized MenuBarController getSystemMenuBarController() {
        if (systemMenuBarController == null) {
            systemMenuBarController = new MenuBarController(null);
        }
        return systemMenuBarController;
    }

    private void controllerDidLoadFxml() {
        String revealMenuKey;
        assert (this.menuBar != null);
        assert (this.menuBar.getParent() instanceof StackPane);
        assert (this.insertMenu != null);
        assert (this.addEffectMenu != null);
        assert (this.fileMenu != null);
        assert (this.windowMenu != null);
        assert (this.newMenuItem != null);
        assert (this.newAlertDialogMenuItem != null);
        assert (this.newAlertDialogCssMenuItem != null);
        assert (this.newAlertDialogI18nMenuItem != null);
        assert (this.newBasicAppMenuItem != null);
        assert (this.newBasicAppCssMenuItem != null);
        assert (this.newBasicAppI18nMenuItem != null);
        assert (this.newComplexAppMenuItem != null);
        assert (this.newComplexAppCssMenuItem != null);
        assert (this.newComplexAppI18nMenuItem != null);
        assert (this.openMenuItem != null);
        assert (this.openRecentMenu != null);
        assert (this.saveMenuItem != null);
        assert (this.saveAsMenuItem != null);
        assert (this.revertMenuItem != null);
        assert (this.closeMenuItem != null);
        assert (this.revealMenuItem != null);
        assert (this.importFxmlMenuItem != null);
        assert (this.importMediaMenuItem != null);
        assert (this.includeFileMenuItem != null);
        assert (this.editIncludedFileMenuItem != null);
        assert (this.revealIncludedFileMenuItem != null);
        assert (this.separatorAbovePreferencesMenuItem != null);
        assert (this.showPreferencesMenuItem != null);
        assert (this.exitMenuItem != null);
        assert (this.undoMenuItem != null);
        assert (this.redoMenuItem != null);
        assert (this.copyMenuItem != null);
        assert (this.cutMenuItem != null);
        assert (this.pasteMenuItem != null);
        assert (this.pasteIntoMenuItem != null);
        assert (this.duplicateMenuItem != null);
        assert (this.deleteMenuItem != null);
        assert (this.selectAllMenuItem != null);
        assert (this.selectNoneMenuItem != null);
        assert (this.selectParentMenuItem != null);
        assert (this.selectNextMenuItem != null);
        assert (this.selectPreviousMenuItem != null);
        assert (this.trimMenuItem != null);
        assert (this.gotoContentMenuItem != null);
        assert (this.gotoPropertiesMenuItem != null);
        assert (this.gotoLayoutMenuItem != null);
        assert (this.gotoCodeMenuItem != null);
        assert (this.toggleLibraryPanelMenuItem != null);
        assert (this.toggleHierarchyPanelMenuItem != null);
        assert (this.toggleCSSPanelMenuItem != null);
        assert (this.toggleLeftPanelMenuItem != null);
        assert (this.toggleRightPanelMenuItem != null);
        assert (this.toggleOutlinesMenuItem != null);
        assert (this.toggleSampleDataMenuItem != null);
        assert (this.toggleAlignmentGuidesMenuItem != null);
        assert (this.showSampleControllerMenuItem != null);
        assert (this.zoomMenu != null);
        assert (this.zoomMenu.getItems().isEmpty());
        assert (this.fitToParentMenuItem != null);
        assert (this.useComputedSizesMenuItem != null);
        assert (this.addContextMenuMenuItem != null);
        assert (this.addTooltipMenuItem != null);
        assert (this.moveRowAboveMenuItem != null);
        assert (this.moveRowBelowMenuItem != null);
        assert (this.moveColumnBeforeMenuItem != null);
        assert (this.moveColumnAfterMenuItem != null);
        assert (this.addRowAboveMenuItem != null);
        assert (this.addRowBelowMenuItem != null);
        assert (this.addColumnBeforeMenuItem != null);
        assert (this.addColumnAfterMenuItem != null);
        assert (this.increaseRowSpanMenuItem != null);
        assert (this.decreaseRowSpanMenuItem != null);
        assert (this.increaseColumnSpanMenuItem != null);
        assert (this.decreaseColumnSpanMenuItem != null);
        assert (this.qvgaSetSizeMenuItem != null);
        assert (this.vgaSetSizeMenuItem != null);
        assert (this.touchSetSizeMenuItem != null);
        assert (this.hdSetSizeMenuItem != null);
        assert (this.bringToFrontMenuItem != null);
        assert (this.sendToBackMenuItem != null);
        assert (this.bringForwardMenuItem != null);
        assert (this.sendBackwardMenuItem != null);
        assert (this.wrapInAnchorPaneMenuItem != null);
        assert (this.wrapInGridPaneMenuItem != null);
        assert (this.wrapInHBoxMenuItem != null);
        assert (this.wrapInPaneMenuItem != null);
        assert (this.wrapInScrollPaneMenuItem != null);
        assert (this.wrapInSplitPaneMenuItem != null);
        assert (this.wrapInStackPaneMenuItem != null);
        assert (this.wrapInTabPaneMenuItem != null);
        assert (this.wrapInTitledPaneMenuItem != null);
        assert (this.wrapInToolBarMenuItem != null);
        assert (this.wrapInVBoxMenuItem != null);
        assert (this.wrapInGroupMenuItem != null);
        assert (this.unwrapMenuItem != null);
        assert (this.showPreviewMenuItem != null);
        assert (this.modenaThemeMenuItem != null);
        assert (this.modenaTouchThemeMenuItem != null);
        assert (this.modenaHighContrastBlackonwhiteThemeMenuItem != null);
        assert (this.modenaHighContrastWhiteonblackThemeMenuItem != null);
        assert (this.modenaHighContrastYellowonblackThemeMenuItem != null);
        assert (this.caspianThemeMenuItem != null);
        assert (this.caspianHighContrastThemeMenuItem != null);
        assert (this.caspianEmbeddedThemeMenuItem != null);
        assert (this.caspianEmbeddedQVGAThemeMenuItem != null);
        assert (this.chooseBackgroundColorMenuItem != null);
        assert (this.addSceneStyleSheetMenuItem != null);
        assert (this.removeSceneStyleSheetMenu != null);
        assert (this.openSceneStyleSheetMenu != null);
        assert (this.setResourceMenuItem != null);
        assert (this.removeResourceMenuItem != null);
        assert (this.revealResourceMenuItem != null);
        assert (this.qvgaPreviewSizeMenuItem != null);
        assert (this.vgaPreviewSizeMenuItem != null);
        assert (this.touchPreviewSizeMenuItem != null);
        assert (this.hdPreviewSizeMenuItem != null);
        assert (this.preferredPreviewSizeMenuItem != null);
        assert (this.helpMenuItem != null);
        assert (this.aboutMenuItem != null);
        StackPane rootStackPane = (StackPane)this.menuBar.getParent();
        rootStackPane.getChildren().remove((Object)this.menuBar);
        if (EditorPlatform.IS_MAC) {
            this.menuBar.setUseSystemMenuBar(true);
            this.exitMenuItem.getParentMenu().getItems().remove((Object)this.exitMenuItem);
        }
        if (EditorPlatform.IS_MAC) {
            revealMenuKey = "menu.title.reveal.mac";
        } else if (EditorPlatform.IS_WINDOWS) {
            revealMenuKey = "menu.title.reveal.win.mnemonic";
        } else {
            assert (EditorPlatform.IS_LINUX);
            revealMenuKey = "menu.title.reveal.linux";
        }
        this.revealMenuItem.setText(I18N.getString(revealMenuKey));
        this.newMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.NEW_FILE));
        this.newMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[]{modifier}));
        this.newAlertDialogMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.NEW_ALERT_DIALOG));
        this.newAlertDialogCssMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.NEW_ALERT_DIALOG_CSS));
        this.newAlertDialogI18nMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.NEW_ALERT_DIALOG_I18N));
        this.newBasicAppMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.NEW_BASIC_APPLICATION));
        this.newBasicAppCssMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.NEW_BASIC_APPLICATION_CSS));
        this.newBasicAppI18nMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.NEW_BASIC_APPLICATION_I18N));
        this.newComplexAppMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.NEW_COMPLEX_APPLICATION));
        this.newComplexAppCssMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.NEW_COMPLEX_APPLICATION_CSS));
        this.newComplexAppI18nMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.NEW_COMPLEX_APPLICATION_I18N));
        this.openMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.OPEN_FILE));
        this.openMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{modifier}));
        this.openRecentMenu.setOnShowing((EventHandler)new EventHandler<Event>(){

            public void handle(Event t) {
                MenuBarController.this.updateOpenRecentMenuItems();
            }
        });
        this.saveMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.SAVE_FILE));
        this.saveMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{modifier}));
        this.saveAsMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.SAVE_AS_FILE));
        this.saveAsMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, modifier}));
        this.revertMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.REVERT_FILE));
        this.revealMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.REVEAL_FILE));
        this.importFxmlMenuItem.setUserData((Object)new DocumentEditActionController(DocumentWindowController.DocumentEditAction.IMPORT_FXML));
        this.importMediaMenuItem.setUserData((Object)new DocumentEditActionController(DocumentWindowController.DocumentEditAction.IMPORT_MEDIA));
        this.includeFileMenuItem.setUserData((Object)new DocumentEditActionController(DocumentWindowController.DocumentEditAction.INCLUDE_FXML));
        this.editIncludedFileMenuItem.setUserData((Object)new ControlActionController(EditorController.ControlAction.EDIT_INCLUDED_FILE){

            @Override
            public String getTitle() {
                File file;
                String title = I18N.getString("menu.title.edit.included.default");
                if (MenuBarController.this.documentWindowController != null && (file = MenuBarController.this.documentWindowController.getEditorController().getIncludedFile()) != null) {
                    title = I18N.getString("menu.title.edit.included", file.getName());
                }
                return title;
            }
        });
        this.revealIncludedFileMenuItem.setUserData((Object)new ControlActionController(EditorController.ControlAction.REVEAL_INCLUDED_FILE){

            @Override
            public String getTitle() {
                File file;
                String title = I18N.getString("menu.title.reveal.included.default");
                if (MenuBarController.this.documentWindowController != null && (file = MenuBarController.this.documentWindowController.getEditorController().getIncludedFile()) != null) {
                    title = EditorPlatform.IS_MAC ? I18N.getString("menu.title.reveal.included.finder", file.getName()) : I18N.getString("menu.title.reveal.included.explorer", file.getName());
                }
                return title;
            }
        });
        this.closeMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.CLOSE_FRONT_WINDOW));
        this.closeMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{modifier}));
        this.showPreferencesMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.SHOW_PREFERENCES));
        this.showPreferencesMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.COMMA, new KeyCombination.Modifier[]{modifier}));
        this.exitMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.EXIT));
        this.undoMenuItem.setUserData((Object)new UndoActionController());
        this.undoMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{modifier}));
        this.redoMenuItem.setUserData((Object)new RedoActionController());
        if (EditorPlatform.IS_MAC) {
            this.redoMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, modifier}));
        } else {
            this.redoMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Y, new KeyCombination.Modifier[]{modifier}));
        }
        this.copyMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.COPY));
        this.copyMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{modifier}));
        this.cutMenuItem.setUserData((Object)new DocumentEditActionController(DocumentWindowController.DocumentEditAction.CUT));
        this.cutMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.X, new KeyCombination.Modifier[]{modifier}));
        this.pasteMenuItem.setUserData((Object)new DocumentEditActionController(DocumentWindowController.DocumentEditAction.PASTE));
        this.pasteMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{modifier}));
        this.pasteIntoMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.PASTE_INTO));
        this.pasteIntoMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, modifier}));
        this.duplicateMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.DUPLICATE));
        this.duplicateMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.D, new KeyCombination.Modifier[]{modifier}));
        this.deleteMenuItem.setUserData((Object)new DocumentEditActionController(DocumentWindowController.DocumentEditAction.DELETE));
        this.deleteMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DELETE, new KeyCombination.Modifier[0]));
        this.selectAllMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.SELECT_ALL));
        this.selectAllMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{modifier}));
        this.selectNoneMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.SELECT_NONE));
        this.selectNoneMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, modifier}));
        this.selectParentMenuItem.setUserData((Object)new ControlActionController(EditorController.ControlAction.SELECT_PARENT));
        this.selectParentMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.UP, new KeyCombination.Modifier[]{modifier}));
        this.selectNextMenuItem.setUserData((Object)new ControlActionController(EditorController.ControlAction.SELECT_NEXT));
        this.selectNextMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[]{modifier}));
        this.selectPreviousMenuItem.setUserData((Object)new ControlActionController(EditorController.ControlAction.SELECT_PREVIOUS));
        this.selectPreviousMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[]{modifier}));
        this.trimMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.TRIM));
        this.gotoContentMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.GOTO_CONTENT));
        this.gotoContentMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT0, new KeyCombination.Modifier[]{modifier}));
        this.gotoPropertiesMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.GOTO_PROPERTIES));
        this.gotoPropertiesMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT1, new KeyCombination.Modifier[]{modifier}));
        this.gotoLayoutMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.GOTO_LAYOUT));
        this.gotoLayoutMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT2, new KeyCombination.Modifier[]{modifier}));
        this.gotoCodeMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.GOTO_CODE));
        this.gotoCodeMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT3, new KeyCombination.Modifier[]{modifier}));
        this.toggleLibraryPanelMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.TOGGLE_LIBRARY_PANEL){

            @Override
            public String getTitle() {
                String titleKey = MenuBarController.this.documentWindowController == null ? "menu.title.hide.library.panel" : (MenuBarController.this.documentWindowController.isLibraryPanelVisible() ? "menu.title.hide.library.panel" : "menu.title.show.library.panel");
                return I18N.getString(titleKey);
            }
        });
        this.toggleLibraryPanelMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT4, new KeyCombination.Modifier[]{modifier}));
        this.toggleHierarchyPanelMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.TOGGLE_DOCUMENT_PANEL){

            @Override
            public String getTitle() {
                String titleKey = MenuBarController.this.documentWindowController == null ? "menu.title.hide.document.panel" : (MenuBarController.this.documentWindowController.isHierarchyPanelVisible() ? "menu.title.hide.document.panel" : "menu.title.show.document.panel");
                return I18N.getString(titleKey);
            }
        });
        this.toggleHierarchyPanelMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT5, new KeyCombination.Modifier[]{modifier}));
        this.toggleCSSPanelMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.TOGGLE_CSS_PANEL){

            @Override
            public String getTitle() {
                String titleKey = MenuBarController.this.documentWindowController == null ? "menu.title.hide.bottom.panel" : (MenuBarController.this.documentWindowController.isBottomPanelVisible() ? "menu.title.hide.bottom.panel" : "menu.title.show.bottom.panel");
                return I18N.getString(titleKey);
            }
        });
        this.toggleCSSPanelMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT6, new KeyCombination.Modifier[]{modifier}));
        this.toggleLeftPanelMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.TOGGLE_LEFT_PANEL){

            @Override
            public String getTitle() {
                String titleKey = MenuBarController.this.documentWindowController == null ? "menu.title.hide.left.panel" : (MenuBarController.this.documentWindowController.isLeftPanelVisible() ? "menu.title.hide.left.panel" : "menu.title.show.left.panel");
                return I18N.getString(titleKey);
            }
        });
        this.toggleLeftPanelMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT7, new KeyCombination.Modifier[]{modifier}));
        this.toggleRightPanelMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.TOGGLE_RIGHT_PANEL){

            @Override
            public String getTitle() {
                String titleKey = MenuBarController.this.documentWindowController == null ? "menu.title.hide.right.panel" : (MenuBarController.this.documentWindowController.isRightPanelVisible() ? "menu.title.hide.right.panel" : "menu.title.show.right.panel");
                return I18N.getString(titleKey);
            }
        });
        this.toggleRightPanelMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT8, new KeyCombination.Modifier[]{modifier}));
        this.toggleOutlinesMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.TOGGLE_OUTLINES_VISIBILITY){

            @Override
            public String getTitle() {
                String titleKey = MenuBarController.this.documentWindowController == null ? "menu.title.hide.outlines" : (MenuBarController.this.documentWindowController.getContentPanelController().isOutlinesVisible() ? "menu.title.hide.outlines" : "menu.title.show.outlines");
                return I18N.getString(titleKey);
            }
        });
        this.toggleOutlinesMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.E, new KeyCombination.Modifier[]{modifier}));
        this.toggleSampleDataMenuItem.setUserData((Object)new ControlActionController(EditorController.ControlAction.TOGGLE_SAMPLE_DATA){

            @Override
            public String getTitle() {
                String titleKey = MenuBarController.this.documentWindowController == null ? "menu.title.hide.sample.data" : (MenuBarController.this.documentWindowController.getEditorController().isSampleDataEnabled() ? "menu.title.hide.sample.data" : "menu.title.show.sample.data");
                return I18N.getString(titleKey);
            }
        });
        this.toggleAlignmentGuidesMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.TOGGLE_GUIDES_VISIBILITY){

            @Override
            public String getTitle() {
                ContentPanelController contentPanelController;
                String titleKey = MenuBarController.this.documentWindowController == null ? "menu.title.disable.guides" : ((contentPanelController = MenuBarController.this.documentWindowController.getContentPanelController()).isGuidesVisible() ? "menu.title.disable.guides" : "menu.title.enable.guides");
                return I18N.getString(titleKey);
            }
        });
        this.showSampleControllerMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.SHOW_SAMPLE_CONTROLLER));
        this.updateZoomMenu();
        this.fitToParentMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.FIT_TO_PARENT));
        this.fitToParentMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.K, new KeyCombination.Modifier[]{modifier}));
        this.useComputedSizesMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.USE_COMPUTED_SIZES));
        this.useComputedSizesMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.K, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, modifier}));
        this.addContextMenuMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.ADD_CONTEXT_MENU));
        this.addTooltipMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.ADD_TOOLTIP));
        this.moveRowAboveMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.MOVE_ROW_ABOVE));
        this.moveRowBelowMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.MOVE_ROW_BELOW));
        this.moveColumnBeforeMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.MOVE_COLUMN_BEFORE));
        this.moveColumnAfterMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.MOVE_COLUMN_AFTER));
        this.addRowAboveMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.ADD_ROW_ABOVE));
        this.addRowBelowMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.ADD_ROW_BELOW));
        this.addColumnBeforeMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.ADD_COLUMN_BEFORE));
        this.addColumnAfterMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.ADD_COLUMN_AFTER));
        this.increaseRowSpanMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.INCREASE_ROW_SPAN));
        this.decreaseRowSpanMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.DECREASE_ROW_SPAN));
        this.increaseColumnSpanMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.INCREASE_COLUMN_SPAN));
        this.decreaseColumnSpanMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.DECREASE_COLUMN_SPAN));
        this.qvgaSetSizeMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.SET_SIZE_320x240){

            @Override
            public void perform() {
                super.perform();
                MenuBarController.this.updatePreviewWindowSize(EditorController.Size.SIZE_320x240);
            }
        });
        this.vgaSetSizeMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.SET_SIZE_640x480){

            @Override
            public void perform() {
                super.perform();
                MenuBarController.this.updatePreviewWindowSize(EditorController.Size.SIZE_640x480);
            }
        });
        this.touchSetSizeMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.SET_SIZE_1280x800){

            @Override
            public void perform() {
                super.perform();
                MenuBarController.this.updatePreviewWindowSize(EditorController.Size.SIZE_1280x800);
            }
        });
        this.hdSetSizeMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.SET_SIZE_1920x1080){

            @Override
            public void perform() {
                super.perform();
                MenuBarController.this.updatePreviewWindowSize(EditorController.Size.SIZE_1920x1080);
            }
        });
        this.updateAddEffectMenu();
        this.bringToFrontMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.BRING_TO_FRONT));
        this.bringToFrontMenuItem.setAccelerator((KeyCombination)new KeyCharacterCombination("]", new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, modifier}));
        this.sendToBackMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.SEND_TO_BACK));
        this.sendToBackMenuItem.setAccelerator((KeyCombination)new KeyCharacterCombination("[", new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, modifier}));
        this.bringForwardMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.BRING_FORWARD));
        this.bringForwardMenuItem.setAccelerator((KeyCombination)new KeyCharacterCombination("]", new KeyCombination.Modifier[]{modifier}));
        this.sendBackwardMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.SEND_BACKWARD));
        this.sendBackwardMenuItem.setAccelerator((KeyCombination)new KeyCharacterCombination("[", new KeyCombination.Modifier[]{modifier}));
        this.wrapInAnchorPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_ANCHOR_PANE));
        this.wrapInGroupMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_GROUP));
        this.wrapInGridPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_GRID_PANE));
        this.wrapInHBoxMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_HBOX));
        this.wrapInPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_PANE));
        this.wrapInScrollPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_SCROLL_PANE));
        this.wrapInSplitPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_SPLIT_PANE));
        this.wrapInStackPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_STACK_PANE));
        this.wrapInTabPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_TAB_PANE));
        this.wrapInTitledPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_TITLED_PANE));
        this.wrapInToolBarMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_TOOL_BAR));
        this.wrapInVBoxMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_VBOX));
        this.wrapInGroupMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_GROUP));
        this.unwrapMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.UNWRAP));
        this.unwrapMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.U, new KeyCombination.Modifier[]{modifier}));
        this.showPreviewMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.SHOW_PREVIEW_WINDOW));
        this.showPreviewMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{modifier}));
        this.chooseBackgroundColorMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.CHOOSE_BACKGROUND_COLOR));
        this.chooseBackgroundColorMenuItem.setDisable(true);
        this.caspianHighContrastThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.CASPIAN_HIGH_CONTRAST));
        this.caspianThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.CASPIAN));
        this.caspianEmbeddedThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.CASPIAN_EMBEDDED));
        this.caspianEmbeddedQVGAThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.CASPIAN_EMBEDDED_QVGA));
        this.modenaThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.MODENA));
        this.modenaTouchThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.MODENA_TOUCH));
        this.modenaHighContrastBlackonwhiteThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.MODENA_HIGH_CONTRAST_BLACK_ON_WHITE));
        this.modenaHighContrastWhiteonblackThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.MODENA_HIGH_CONTRAST_WHITE_ON_BLACK));
        this.modenaHighContrastYellowonblackThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK));
        this.addSceneStyleSheetMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.ADD_SCENE_STYLE_SHEET));
        this.updateOpenAndRemoveSceneStyleSheetMenus();
        if (this.documentWindowController != null) {
            this.documentWindowController.getEditorController().sceneStyleSheetProperty().addListener((ChangeListener)new ChangeListener<ObservableList<File>>(){

                public void changed(ObservableValue<? extends ObservableList<File>> ov, ObservableList<File> t, ObservableList<File> t1) {
                    if (t1 != null) {
                        MenuBarController.this.updateOpenAndRemoveSceneStyleSheetMenus();
                        MenuBarController.this.setupMenuItemHandlers((MenuItem)MenuBarController.this.removeSceneStyleSheetMenu);
                        MenuBarController.this.setupMenuItemHandlers((MenuItem)MenuBarController.this.openSceneStyleSheetMenu);
                    }
                }
            });
        }
        this.setResourceMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.SET_RESOURCE));
        this.removeResourceMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.REMOVE_RESOURCE){

            @Override
            public String getTitle() {
                String title = I18N.getString("menu.title.remove.resource");
                if (MenuBarController.this.documentWindowController != null && MenuBarController.this.documentWindowController.getResourceFile() != null) {
                    title = I18N.getString("menu.title.remove.resource.with.file", MenuBarController.this.documentWindowController.getResourceFile().getName());
                }
                return title;
            }
        });
        this.revealResourceMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.REVEAL_RESOURCE){

            @Override
            public String getTitle() {
                String title = I18N.getString("menu.title.reveal.resource");
                if (MenuBarController.this.documentWindowController != null && MenuBarController.this.documentWindowController.getResourceFile() != null) {
                    title = I18N.getString("menu.title.reveal.resource.with.file", MenuBarController.this.documentWindowController.getResourceFile().getName());
                }
                return title;
            }
        });
        this.qvgaPreviewSizeMenuItem.setUserData((Object)new SetSizeActionController(EditorController.Size.SIZE_320x240));
        this.vgaPreviewSizeMenuItem.setUserData((Object)new SetSizeActionController(EditorController.Size.SIZE_640x480));
        this.touchPreviewSizeMenuItem.setUserData((Object)new SetSizeActionController(EditorController.Size.SIZE_1280x800));
        this.hdPreviewSizeMenuItem.setUserData((Object)new SetSizeActionController(EditorController.Size.SIZE_1920x1080));
        this.preferredPreviewSizeMenuItem.setUserData((Object)new SetSizeActionController(EditorController.Size.SIZE_PREFERRED));
        this.aboutMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.ABOUT));
        this.helpMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.HELP));
        this.helpMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F1, new KeyCombination.Modifier[0]));
        for (Menu m : this.menuBar.getMenus()) {
            this.setupMenuItemHandlers((MenuItem)m);
        }
        this.constructBuiltinPartOfInsertMenu();
        this.constructCustomPartOfInsertMenu();
        this.insertMenu.setOnMenuValidation(this.onCustomPartOfInsertMenuValidationHandler);
        this.windowMenu.setOnMenuValidation(this.onWindowMenuValidationHandler);
        this.previewMenu.getItems().remove((Object)this.separatorAboveChooseBackgroundColorMenuItem);
        this.previewMenu.getItems().remove((Object)this.chooseBackgroundColorMenuItem);
    }

    private void setupMenuItemHandlers(MenuItem i) {
        if (i instanceof Menu) {
            Menu m = (Menu)i;
            m.setOnMenuValidation(this.onMenuValidationEventHandler);
            for (MenuItem child : m.getItems()) {
                this.setupMenuItemHandlers(child);
            }
        } else {
            i.setOnAction(this.onActionEventHandler);
            if (i.getAccelerator() != null) {
                this.keyToMenu.put(i.getAccelerator(), i);
            }
        }
    }

    private void handleOnMenuValidation(Menu menu) {
        for (MenuItem i : menu.getItems()) {
            boolean selected;
            String title;
            boolean disable;
            if (i.getUserData() instanceof MenuItemController) {
                boolean canPerform;
                MenuItemController c = (MenuItemController)i.getUserData();
                try {
                    canPerform = c.canPerform();
                }
                catch (RuntimeException x) {
                    canPerform = false;
                    Exception xx = new Exception(c.getClass().getSimpleName() + ".canPerform() did break for menu item " + i, x);
                    xx.printStackTrace();
                }
                disable = !canPerform;
                title = c.getTitle();
                selected = c.isSelected();
            } else if (i instanceof Menu) {
                disable = false;
                selected = false;
                title = null;
            } else {
                disable = true;
                selected = false;
                title = null;
            }
            i.setDisable(disable);
            if (title != null) {
                i.setText(title);
            }
            if (!(i instanceof RadioMenuItem)) continue;
            RadioMenuItem ri = (RadioMenuItem)i;
            ri.setSelected(selected);
        }
    }

    private void handleOnActionMenu(MenuItem i) {
        assert (i.getUserData() instanceof MenuItemController);
        MenuItemController c = (MenuItemController)i.getUserData();
        c.perform();
    }

    private void updateZoomMenu() {
        double[] scalingTable = new double[]{0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 4.0};
        for (int i = 0; i < scalingTable.length; ++i) {
            double scaling = scalingTable[i];
            String title = String.format("%.0f%%", scaling * 100.0);
            RadioMenuItem mi = new RadioMenuItem(title);
            mi.setUserData((Object)new SetZoomActionController(scaling));
            this.zoomMenu.getItems().add((Object)mi);
        }
    }

    private void updateOpenRecentMenuItems() {
        ArrayList<Object> menuItems = new ArrayList<Object>();
        PreferencesController pc = PreferencesController.getSingleton();
        PreferencesRecordGlobal recordGlobal = pc.getRecordGlobal();
        List<String> recentItems = recordGlobal.getRecentItems();
        MenuItem clearMenuItem = new MenuItem(I18N.getString("menu.title.open.recent.clear"));
        clearMenuItem.setOnAction((EventHandler)new ClearOpenRecentHandler());
        if (recentItems.isEmpty()) {
            clearMenuItem.setDisable(true);
            menuItems.add(clearMenuItem);
        } else {
            String name;
            File recentItemFile;
            clearMenuItem.setDisable(false);
            HashMap<String, Integer> recentItemsNames = new HashMap<String, Integer>();
            ArrayList<String> recentItemsToRemove = new ArrayList<String>();
            for (final String recentItem : recentItems) {
                recentItemFile = new File(recentItem);
                if (recentItemFile.exists()) {
                    name = recentItemFile.getName();
                    if (recentItemsNames.containsKey(name)) {
                        recentItemsNames.replace(name, (Integer)recentItemsNames.get(name) + 1);
                        continue;
                    }
                    recentItemsNames.put(name, 1);
                    continue;
                }
                recentItemsToRemove.add(recentItem);
            }
            for (final String recentItem : recentItems) {
                MenuItem mi;
                recentItemFile = new File(recentItem);
                if (!recentItemFile.exists()) continue;
                name = recentItemFile.getName();
                assert (recentItemsNames.keySet().contains(name));
                if ((Integer)recentItemsNames.get(name) > 1) {
                    mi = new MenuItem(recentItem);
                } else {
                    assert ((Integer)recentItemsNames.get(name) == 1);
                    mi = new MenuItem(name);
                }
                mi.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent t) {
                        File file = new File(recentItem);
                        SceneBuilderApp.getSingleton().performOpenRecent(MenuBarController.this.documentWindowController, file);
                    }
                });
                menuItems.add(mi);
            }
            if (!recentItemsToRemove.isEmpty()) {
                recordGlobal.removeRecentItems(recentItemsToRemove);
            }
            menuItems.add(new SeparatorMenuItem());
            menuItems.add(clearMenuItem);
        }
        this.openRecentMenu.getItems().setAll(menuItems);
    }

    private void updateOpenAndRemoveSceneStyleSheetMenus() {
        ObservableList<File> sceneStyleSheets;
        assert (this.removeSceneStyleSheetMenu != null);
        if (this.documentWindowController != null && (sceneStyleSheets = this.documentWindowController.getEditorController().getSceneStyleSheets()) != null) {
            this.removeSceneStyleSheetMenu.getItems().clear();
            this.openSceneStyleSheetMenu.getItems().clear();
            if (sceneStyleSheets.size() == 0) {
                MenuItem mi = new MenuItem(I18N.getString("scenestylesheet.none"));
                mi.setDisable(true);
                this.removeSceneStyleSheetMenu.getItems().add((Object)mi);
                MenuItem mi2 = new MenuItem(I18N.getString("scenestylesheet.none"));
                mi2.setDisable(true);
                this.openSceneStyleSheetMenu.getItems().add((Object)mi2);
            } else {
                for (File f : sceneStyleSheets) {
                    MenuItem mi = new MenuItem(f.getName());
                    mi.setUserData((Object)new RemoveSceneStyleSheetActionController(f));
                    this.removeSceneStyleSheetMenu.getItems().add((Object)mi);
                    MenuItem mi2 = new MenuItem(f.getName());
                    mi2.setUserData((Object)new OpenSceneStyleSheetActionController(f));
                    this.openSceneStyleSheetMenu.getItems().add((Object)mi2);
                }
            }
        }
    }

    private void updateCustomPartOfInsertMenu() {
        assert (this.insertMenu != null);
        assert (this.insertCustomMenu != null);
        if (this.documentWindowController != null) {
            EditorController editorController = this.documentWindowController.getEditorController();
            assert (editorController.getLibrary() != null);
            TreeSet<LibraryItem> sectionItems = new TreeSet<LibraryItem>(new LibraryItemNameComparator());
            for (LibraryItem li : editorController.getLibrary().getItems()) {
                if (!li.getSection().equals("Custom")) continue;
                sectionItems.add(li);
            }
            if (sectionItems.size() > 0) {
                this.insertCustomMenu.getItems().clear();
                for (LibraryItem li : sectionItems) {
                    this.insertCustomMenu.getItems().add((Object)this.makeMenuItemForLibraryItem(li));
                }
                this.insertCustomMenu.setVisible(true);
            } else {
                this.insertCustomMenu.setVisible(false);
            }
        }
    }

    private void constructCustomPartOfInsertMenu() {
        assert (this.insertMenu != null);
        this.insertCustomMenu = this.makeMenuForLibrarySection("Custom");
        this.insertMenu.getItems().add(0, (Object)this.insertCustomMenu);
        this.insertCustomMenu.setVisible(false);
    }

    private void constructBuiltinPartOfInsertMenu() {
        assert (this.insertMenu != null);
        this.insertMenu.getItems().clear();
        TreeMap<String, TreeSet<LibraryItem>> sectionMap = new TreeMap<String, TreeSet<LibraryItem>>(new BuiltinSectionComparator());
        for (LibraryItem li : BuiltinLibrary.getLibrary().getItems()) {
            TreeSet<LibraryItem> sectionItems = (TreeSet<LibraryItem>)sectionMap.get(li.getSection());
            if (sectionItems == null) {
                sectionItems = new TreeSet<LibraryItem>(new LibraryItemNameComparator());
                sectionMap.put(li.getSection(), sectionItems);
            }
            sectionItems.add(li);
        }
        for (Map.Entry e : sectionMap.entrySet()) {
            Menu sectionMenu = this.makeMenuForLibrarySection((String)e.getKey());
            this.insertMenu.getItems().add((Object)sectionMenu);
            for (LibraryItem li : (Set)e.getValue()) {
                sectionMenu.getItems().add((Object)this.makeMenuItemForLibraryItem(li));
            }
        }
    }

    private Menu makeMenuForLibrarySection(String section) {
        final Menu result = new Menu();
        result.setText(section);
        result.setOnShowing((EventHandler)new EventHandler<Event>(){

            public void handle(Event t) {
                MenuBarController.this.updateInsertMenuState(result);
            }
        });
        return result;
    }

    private MenuItem makeMenuItemForLibraryItem(final LibraryItem li) {
        MenuItem result = new MenuItem();
        result.setText(li.getName());
        result.setUserData((Object)li);
        result.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                MenuBarController.this.handleInsertMenuAction(li);
            }
        });
        return result;
    }

    private void updateInsertMenuState(Menu sectionMenu) {
        if (this.documentWindowController != null && this.documentWindowController.getStage().isFocused()) {
            EditorController editorController = this.documentWindowController.getEditorController();
            for (MenuItem menuItem : sectionMenu.getItems()) {
                assert (menuItem.getUserData() instanceof LibraryItem);
                LibraryItem li = (LibraryItem)menuItem.getUserData();
                boolean enabled = editorController.canPerformInsert(li);
                menuItem.setDisable(!enabled);
            }
        } else {
            for (MenuItem menuItem : sectionMenu.getItems()) {
                assert (menuItem.getUserData() instanceof LibraryItem);
                menuItem.setDisable(true);
            }
        }
    }

    private void handleInsertMenuAction(LibraryItem li) {
        if (this.documentWindowController != null) {
            EditorController editorController = this.documentWindowController.getEditorController();
            editorController.performInsert(li);
        }
    }

    private void updateAddEffectMenu() {
        this.addEffectMenu.getItems().clear();
        for (Class<? extends Effect> c : EffectPicker.getEffectClasses()) {
            this.addEffectMenu.getItems().add((Object)this.makeMenuItemForEffect(c));
        }
    }

    private MenuItem makeMenuItemForEffect(Class<? extends Effect> effectClass) {
        MenuItem result = new MenuItem();
        result.setText(effectClass.getSimpleName());
        result.setUserData((Object)new AddEffectActionController(effectClass));
        return result;
    }

    private void handleOnWindowMenuValidation() {
        this.windowMenu.getItems().clear();
        List<DocumentWindowController> documentWindowControllers = SceneBuilderApp.getSingleton().getDocumentWindowControllers();
        if (documentWindowControllers.isEmpty()) {
            this.windowMenu.getItems().add((Object)this.makeWindowMenuItem(null));
        } else {
            ArrayList<DocumentWindowController> sortedControllers = new ArrayList<DocumentWindowController>(documentWindowControllers);
            Collections.sort(sortedControllers, new DocumentWindowController.TitleComparator());
            for (DocumentWindowController dwc : sortedControllers) {
                this.windowMenu.getItems().add((Object)this.makeWindowMenuItem(dwc));
            }
        }
    }

    private MenuItem makeWindowMenuItem(DocumentWindowController dwc) {
        RadioMenuItem result = new RadioMenuItem();
        if (dwc != null) {
            result.setText(dwc.getStage().getTitle());
            result.setDisable(false);
            result.setSelected(dwc.getStage().isFocused());
            result.setOnAction((EventHandler)new WindowMenuEventHandler(dwc));
        } else {
            result.setText(I18N.getString("menu.title.no.window"));
            result.setDisable(true);
            result.setSelected(false);
        }
        return result;
    }

    private void updatePreviewWindowSize(EditorController.Size size) {
        if (this.documentWindowController != null && this.documentWindowController.getPreviewWindowController() != null && this.documentWindowController.getPreviewWindowController().getStage().isShowing()) {
            this.documentWindowController.getPreviewWindowController().setSize(size);
        }
    }

    public MenuItem getMenuItem(KeyCombination key) {
        return this.keyToMenu.get(key);
    }

    public Set<KeyCombination> getAccelerators() {
        return this.keyToMenu.keySet();
    }

    private String getStringFromDouble(double value) {
        String res = Double.toString(value);
        if (res.endsWith(".0")) {
            res = Integer.toString((int)value);
        }
        return res;
    }

    static {
        modifier = EditorPlatform.IS_MAC ? KeyCombination.META_DOWN : KeyCombination.CONTROL_DOWN;
    }

    private static class ClearOpenRecentHandler
    implements EventHandler<ActionEvent> {
        private ClearOpenRecentHandler() {
        }

        public void handle(ActionEvent t) {
            PreferencesController pc = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = pc.getRecordGlobal();
            recordGlobal.clearRecentItems();
        }
    }

    class OpenSceneStyleSheetActionController
    extends MenuItemController {
        private final File styleSheet;

        public OpenSceneStyleSheetActionController(File file) {
            this.styleSheet = file;
        }

        @Override
        public boolean canPerform() {
            return MenuBarController.this.documentWindowController != null && this.styleSheet.exists();
        }

        @Override
        public void perform() {
            assert (MenuBarController.this.documentWindowController != null);
            MenuBarController.this.documentWindowController.getSceneStyleSheetMenuController().performOpenSceneStyleSheet(this.styleSheet);
        }

        @Override
        public String getTitle() {
            return this.styleSheet.getName();
        }
    }

    class RemoveSceneStyleSheetActionController
    extends MenuItemController {
        private final File styleSheet;

        public RemoveSceneStyleSheetActionController(File file) {
            this.styleSheet = file;
        }

        @Override
        public boolean canPerform() {
            return MenuBarController.this.documentWindowController != null && this.styleSheet.exists();
        }

        @Override
        public void perform() {
            assert (MenuBarController.this.documentWindowController != null);
            MenuBarController.this.documentWindowController.getSceneStyleSheetMenuController().performRemoveSceneStyleSheet(this.styleSheet);
        }

        @Override
        public String getTitle() {
            return this.styleSheet.getName();
        }
    }

    class SetThemeActionController
    extends MenuItemController {
        private final EditorPlatform.Theme theme;

        public SetThemeActionController(EditorPlatform.Theme theme) {
            this.theme = theme;
        }

        @Override
        public boolean canPerform() {
            boolean res = MenuBarController.this.documentWindowController != null;
            EditorPlatform.Theme currentTheme = MenuBarController.this.documentWindowController.getEditorController().getTheme();
            if (this.theme == EditorPlatform.Theme.CASPIAN_HIGH_CONTRAST && EditorPlatform.isModena(currentTheme)) {
                res = false;
                MenuBarController.this.caspianHighContrastThemeMenuItem.setSelected(false);
            } else if (this.theme == EditorPlatform.Theme.MODENA_HIGH_CONTRAST_BLACK_ON_WHITE && EditorPlatform.isCaspian(currentTheme)) {
                res = false;
                MenuBarController.this.modenaHighContrastBlackonwhiteThemeMenuItem.setSelected(false);
            } else if (this.theme == EditorPlatform.Theme.MODENA_HIGH_CONTRAST_WHITE_ON_BLACK && EditorPlatform.isCaspian(currentTheme)) {
                res = false;
                MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.setSelected(false);
            } else if (this.theme == EditorPlatform.Theme.MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK && EditorPlatform.isCaspian(currentTheme)) {
                res = false;
                MenuBarController.this.modenaHighContrastYellowonblackThemeMenuItem.setSelected(false);
            }
            return res;
        }

        @Override
        public void perform() {
            assert (MenuBarController.this.documentWindowController != null);
            EditorPlatform.Theme currentTheme = MenuBarController.this.documentWindowController.getEditorController().getTheme();
            EditorPlatform.Theme overiddingTheme = this.theme;
            block0 : switch (this.theme) {
                case CASPIAN: {
                    if (!MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break;
                    overiddingTheme = EditorPlatform.Theme.CASPIAN_HIGH_CONTRAST;
                    break;
                }
                case CASPIAN_EMBEDDED: {
                    if (!MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break;
                    overiddingTheme = EditorPlatform.Theme.CASPIAN_EMBEDDED_HIGH_CONTRAST;
                    break;
                }
                case CASPIAN_EMBEDDED_QVGA: {
                    if (!MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break;
                    overiddingTheme = EditorPlatform.Theme.CASPIAN_EMBEDDED_QVGA_HIGH_CONTRAST;
                    break;
                }
                case CASPIAN_HIGH_CONTRAST: {
                    switch (currentTheme) {
                        case CASPIAN: {
                            if (!MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.CASPIAN_HIGH_CONTRAST;
                            break block0;
                        }
                        case CASPIAN_EMBEDDED: {
                            if (!MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.CASPIAN_EMBEDDED_HIGH_CONTRAST;
                            break block0;
                        }
                        case CASPIAN_EMBEDDED_QVGA: {
                            if (!MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.CASPIAN_EMBEDDED_QVGA_HIGH_CONTRAST;
                            break block0;
                        }
                        case CASPIAN_HIGH_CONTRAST: {
                            if (MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.CASPIAN;
                            break block0;
                        }
                        case CASPIAN_EMBEDDED_HIGH_CONTRAST: {
                            if (MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.CASPIAN_EMBEDDED;
                            break block0;
                        }
                        case CASPIAN_EMBEDDED_QVGA_HIGH_CONTRAST: {
                            if (MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.CASPIAN_EMBEDDED_QVGA;
                            break block0;
                        }
                        default: {
                            assert (false);
                            break block0;
                        }
                    }
                }
                case MODENA: {
                    if (MenuBarController.this.modenaHighContrastBlackonwhiteThemeMenuItem.isSelected()) {
                        overiddingTheme = EditorPlatform.Theme.MODENA_HIGH_CONTRAST_BLACK_ON_WHITE;
                        break;
                    }
                    if (MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.isSelected()) {
                        overiddingTheme = EditorPlatform.Theme.MODENA_HIGH_CONTRAST_WHITE_ON_BLACK;
                        break;
                    }
                    if (!MenuBarController.this.modenaHighContrastYellowonblackThemeMenuItem.isSelected()) break;
                    overiddingTheme = EditorPlatform.Theme.MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK;
                    break;
                }
                case MODENA_TOUCH: {
                    if (MenuBarController.this.modenaHighContrastBlackonwhiteThemeMenuItem.isSelected()) {
                        overiddingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE;
                        break;
                    }
                    if (MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.isSelected()) {
                        overiddingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK;
                        break;
                    }
                    if (!MenuBarController.this.modenaHighContrastYellowonblackThemeMenuItem.isSelected()) break;
                    overiddingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK;
                    break;
                }
                case MODENA_HIGH_CONTRAST_BLACK_ON_WHITE: {
                    switch (currentTheme) {
                        case MODENA: {
                            if (!MenuBarController.this.modenaHighContrastBlackonwhiteThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA_HIGH_CONTRAST_BLACK_ON_WHITE;
                            break;
                        }
                        case MODENA_TOUCH: {
                            if (!MenuBarController.this.modenaHighContrastBlackonwhiteThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE;
                            break;
                        }
                        case MODENA_HIGH_CONTRAST_BLACK_ON_WHITE: {
                            if (!MenuBarController.this.modenaHighContrastBlackonwhiteThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA;
                            break;
                        }
                        case MODENA_HIGH_CONTRAST_WHITE_ON_BLACK: {
                            break;
                        }
                        case MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK: {
                            break;
                        }
                        case MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE: {
                            if (!MenuBarController.this.modenaHighContrastBlackonwhiteThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA_TOUCH;
                            break;
                        }
                        case MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK: {
                            if (!MenuBarController.this.modenaHighContrastBlackonwhiteThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE;
                            break;
                        }
                        case MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK: {
                            if (!MenuBarController.this.modenaHighContrastBlackonwhiteThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE;
                            break;
                        }
                    }
                    break;
                }
                case MODENA_HIGH_CONTRAST_WHITE_ON_BLACK: {
                    switch (currentTheme) {
                        case MODENA: {
                            if (!MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA_HIGH_CONTRAST_WHITE_ON_BLACK;
                            break;
                        }
                        case MODENA_TOUCH: {
                            if (!MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK;
                            break;
                        }
                        case MODENA_HIGH_CONTRAST_BLACK_ON_WHITE: {
                            break;
                        }
                        case MODENA_HIGH_CONTRAST_WHITE_ON_BLACK: {
                            if (!MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA;
                            break;
                        }
                        case MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK: {
                            break;
                        }
                        case MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE: {
                            if (!MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK;
                            break;
                        }
                        case MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK: {
                            if (!MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA_TOUCH;
                            break;
                        }
                        case MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK: {
                            if (!MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK;
                            break;
                        }
                    }
                    break;
                }
                case MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK: {
                    switch (currentTheme) {
                        case MODENA: {
                            if (!MenuBarController.this.modenaHighContrastYellowonblackThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK;
                            break;
                        }
                        case MODENA_TOUCH: {
                            if (!MenuBarController.this.modenaHighContrastYellowonblackThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK;
                            break;
                        }
                        case MODENA_HIGH_CONTRAST_BLACK_ON_WHITE: {
                            break;
                        }
                        case MODENA_HIGH_CONTRAST_WHITE_ON_BLACK: {
                            break;
                        }
                        case MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK: {
                            if (!MenuBarController.this.modenaHighContrastYellowonblackThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA;
                            break;
                        }
                        case MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE: {
                            if (!MenuBarController.this.modenaHighContrastYellowonblackThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK;
                            break;
                        }
                        case MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK: {
                            if (!MenuBarController.this.modenaHighContrastYellowonblackThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK;
                            break;
                        }
                        case MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK: {
                            if (!MenuBarController.this.modenaHighContrastYellowonblackThemeMenuItem.isSelected()) break block0;
                            overiddingTheme = EditorPlatform.Theme.MODENA_TOUCH;
                            break;
                        }
                    }
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            MenuBarController.this.documentWindowController.getEditorController().setTheme(overiddingTheme);
        }

        @Override
        public boolean isSelected() {
            boolean res;
            if (MenuBarController.this.documentWindowController == null) {
                res = false;
            } else {
                EditorPlatform.Theme currentTheme = MenuBarController.this.documentWindowController.getEditorController().getTheme();
                switch (this.theme) {
                    case CASPIAN_HIGH_CONTRAST: {
                        res = EditorPlatform.isCaspian(currentTheme);
                        break;
                    }
                    case CASPIAN: {
                        res = currentTheme == this.theme || currentTheme == EditorPlatform.Theme.CASPIAN_HIGH_CONTRAST;
                        break;
                    }
                    case CASPIAN_EMBEDDED: {
                        res = currentTheme == this.theme || currentTheme == EditorPlatform.Theme.CASPIAN_EMBEDDED_HIGH_CONTRAST;
                        break;
                    }
                    case CASPIAN_EMBEDDED_QVGA: {
                        res = currentTheme == this.theme || currentTheme == EditorPlatform.Theme.CASPIAN_EMBEDDED_QVGA_HIGH_CONTRAST;
                        break;
                    }
                    case MODENA_HIGH_CONTRAST_BLACK_ON_WHITE: {
                        res = EditorPlatform.isModenaBlackonwhite(currentTheme) && EditorPlatform.isModenaHighContrast(currentTheme);
                        break;
                    }
                    case MODENA_HIGH_CONTRAST_WHITE_ON_BLACK: {
                        res = EditorPlatform.isModenaWhiteonblack(currentTheme) && EditorPlatform.isModenaHighContrast(currentTheme);
                        break;
                    }
                    case MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK: {
                        res = EditorPlatform.isModenaYellowonblack(currentTheme) && EditorPlatform.isModenaHighContrast(currentTheme);
                        break;
                    }
                    case MODENA: {
                        res = currentTheme == this.theme || EditorPlatform.isModenaHighContrast(currentTheme) && !EditorPlatform.isModenaTouch(currentTheme);
                        break;
                    }
                    case MODENA_TOUCH: {
                        res = currentTheme == this.theme || EditorPlatform.isModenaTouchHighContrast(currentTheme);
                        break;
                    }
                    default: {
                        assert (false);
                        res = false;
                    }
                }
            }
            return res;
        }
    }

    class SetSizeActionController
    extends MenuItemController {
        private final EditorController.Size size;

        public SetSizeActionController(EditorController.Size size) {
            this.size = size;
        }

        @Override
        public boolean canPerform() {
            boolean res = MenuBarController.this.documentWindowController != null && MenuBarController.this.documentWindowController.getPreviewWindowController() != null && MenuBarController.this.documentWindowController.getPreviewWindowController().getStage().isShowing() && !MenuBarController.this.documentWindowController.getEditorController().is3D() && MenuBarController.this.documentWindowController.getEditorController().isNode() && MenuBarController.this.documentWindowController.getPreviewWindowController().sizeDoesFit(this.size);
            return res;
        }

        @Override
        public void perform() {
            assert (MenuBarController.this.documentWindowController != null);
            assert (MenuBarController.this.documentWindowController.getPreviewWindowController() != null);
            MenuBarController.this.documentWindowController.getPreviewWindowController().setSize(this.size);
        }

        @Override
        public boolean isSelected() {
            EditorController.Size currentSize;
            boolean res = MenuBarController.this.documentWindowController == null || MenuBarController.this.documentWindowController.getPreviewWindowController() == null ? false : this.size == (currentSize = MenuBarController.this.documentWindowController.getPreviewWindowController().getSize()) && MenuBarController.this.documentWindowController.getPreviewWindowController().getStage().isShowing() && !MenuBarController.this.documentWindowController.getPreviewWindowController().userResizedPreviewWindow() && !MenuBarController.this.documentWindowController.getEditorController().is3D() && MenuBarController.this.documentWindowController.getEditorController().isNode();
            return res;
        }

        @Override
        public String getTitle() {
            if (MenuBarController.this.documentWindowController == null) {
                return null;
            }
            if (this.size == EditorController.Size.SIZE_PREFERRED) {
                String title = I18N.getString("menu.title.size.preferred");
                if (MenuBarController.this.documentWindowController.getPreviewWindowController() != null && MenuBarController.this.documentWindowController.getPreviewWindowController().getStage().isShowing() && !MenuBarController.this.documentWindowController.getEditorController().is3D() && MenuBarController.this.documentWindowController.getEditorController().isNode()) {
                    title = I18N.getString("menu.title.size.preferred.with.value", MenuBarController.this.getStringFromDouble(MenuBarController.this.documentWindowController.getPreviewWindowController().getRoot().prefWidth(-1.0)), MenuBarController.this.getStringFromDouble(MenuBarController.this.documentWindowController.getPreviewWindowController().getRoot().prefHeight(-1.0)));
                }
                return title;
            }
            return null;
        }
    }

    class SetZoomActionController
    extends MenuItemController {
        private final double scaling;

        public SetZoomActionController(double scaling) {
            this.scaling = scaling;
        }

        @Override
        public boolean canPerform() {
            return MenuBarController.this.documentWindowController != null;
        }

        @Override
        public void perform() {
            ContentPanelController contentPanelController = MenuBarController.this.documentWindowController.getContentPanelController();
            double currentScaling = contentPanelController.getScaling();
            if (!MathUtils.equals(currentScaling, this.scaling)) {
                contentPanelController.setScaling(this.scaling);
            }
        }

        @Override
        public boolean isSelected() {
            boolean result;
            if (MenuBarController.this.documentWindowController == null) {
                result = false;
            } else {
                double currentScaling = MenuBarController.this.documentWindowController.getContentPanelController().getScaling();
                result = MathUtils.equals(currentScaling, this.scaling);
            }
            return result;
        }
    }

    class AddEffectActionController
    extends MenuItemController {
        private final Class<? extends Effect> effectClass;

        public AddEffectActionController(Class<? extends Effect> effectClass) {
            this.effectClass = effectClass;
        }

        @Override
        public boolean canPerform() {
            boolean result = MenuBarController.this.documentWindowController == null || !MenuBarController.this.documentWindowController.getStage().isFocused() ? false : MenuBarController.this.documentWindowController.getEditorController().canPerformSetEffect();
            return result;
        }

        @Override
        public void perform() {
            MenuBarController.this.documentWindowController.getEditorController().performSetEffect(this.effectClass);
        }
    }

    class ApplicationControlActionController
    extends MenuItemController {
        private final SceneBuilderApp.ApplicationControlAction controlAction;

        public ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction controlAction) {
            this.controlAction = controlAction;
        }

        @Override
        public boolean canPerform() {
            return SceneBuilderApp.getSingleton().canPerformControlAction(this.controlAction, MenuBarController.this.documentWindowController);
        }

        @Override
        public void perform() {
            SceneBuilderApp.getSingleton().performControlAction(this.controlAction, MenuBarController.this.documentWindowController);
        }
    }

    class DocumentControlActionController
    extends MenuItemController {
        private final DocumentWindowController.DocumentControlAction controlAction;

        public DocumentControlActionController(DocumentWindowController.DocumentControlAction controlAction) {
            this.controlAction = controlAction;
        }

        @Override
        public boolean canPerform() {
            boolean result = MenuBarController.this.documentWindowController == null ? false : MenuBarController.this.documentWindowController.canPerformControlAction(this.controlAction);
            return result;
        }

        @Override
        public void perform() {
            assert (this.canPerform()) : "controlAction=" + (Object)((Object)this.controlAction);
            MenuBarController.this.documentWindowController.performControlAction(this.controlAction);
        }
    }

    class DocumentEditActionController
    extends MenuItemController {
        private final DocumentWindowController.DocumentEditAction editAction;

        public DocumentEditActionController(DocumentWindowController.DocumentEditAction editAction) {
            this.editAction = editAction;
        }

        @Override
        public boolean canPerform() {
            boolean result = MenuBarController.this.documentWindowController == null || !MenuBarController.this.documentWindowController.getStage().isFocused() ? false : MenuBarController.this.documentWindowController.canPerformEditAction(this.editAction);
            return result;
        }

        @Override
        public void perform() {
            assert (this.canPerform()) : "editAction=" + (Object)((Object)this.editAction);
            MenuBarController.this.documentWindowController.performEditAction(this.editAction);
        }
    }

    class ControlActionController
    extends MenuItemController {
        private final EditorController.ControlAction controlAction;

        public ControlActionController(EditorController.ControlAction controlAction) {
            this.controlAction = controlAction;
        }

        @Override
        public boolean canPerform() {
            boolean result = MenuBarController.this.documentWindowController == null ? false : MenuBarController.this.documentWindowController.getEditorController().canPerformControlAction(this.controlAction);
            return result;
        }

        @Override
        public void perform() {
            assert (this.canPerform()) : "controlAction=" + (Object)((Object)this.controlAction);
            MenuBarController.this.documentWindowController.getEditorController().performControlAction(this.controlAction);
        }
    }

    class EditActionController
    extends MenuItemController {
        private final EditorController.EditAction editAction;

        public EditActionController(EditorController.EditAction editAction) {
            this.editAction = editAction;
        }

        @Override
        public boolean canPerform() {
            boolean result = MenuBarController.this.documentWindowController == null || !MenuBarController.this.documentWindowController.getStage().isFocused() ? false : MenuBarController.this.documentWindowController.getEditorController().canPerformEditAction(this.editAction);
            return result;
        }

        @Override
        public void perform() {
            assert (this.canPerform()) : "editAction=" + (Object)((Object)this.editAction);
            MenuBarController.this.documentWindowController.getEditorController().performEditAction(this.editAction);
        }
    }

    class RedoActionController
    extends MenuItemController {
        RedoActionController() {
        }

        @Override
        public boolean canPerform() {
            boolean result = MenuBarController.this.documentWindowController == null || !MenuBarController.this.documentWindowController.getStage().isFocused() ? false : MenuBarController.this.documentWindowController.getEditorController().canRedo();
            return result;
        }

        @Override
        public void perform() {
            assert (this.canPerform());
            MenuBarController.this.documentWindowController.getEditorController().redo();
        }

        @Override
        public String getTitle() {
            StringBuilder result = new StringBuilder();
            result.append(I18N.getString("menu.title.redo"));
            if (this.canPerform()) {
                result.append(" ");
                result.append(MenuBarController.this.documentWindowController.getEditorController().getRedoDescription());
            }
            return result.toString();
        }
    }

    class UndoActionController
    extends MenuItemController {
        UndoActionController() {
        }

        @Override
        public boolean canPerform() {
            boolean result = MenuBarController.this.documentWindowController == null || !MenuBarController.this.documentWindowController.getStage().isFocused() ? false : MenuBarController.this.documentWindowController.getEditorController().canUndo();
            return result;
        }

        @Override
        public void perform() {
            assert (this.canPerform());
            MenuBarController.this.documentWindowController.getEditorController().undo();
        }

        @Override
        public String getTitle() {
            StringBuilder result = new StringBuilder();
            result.append(I18N.getString("menu.title.undo"));
            if (this.canPerform()) {
                result.append(" ");
                result.append(MenuBarController.this.documentWindowController.getEditorController().getUndoDescription());
            }
            return result.toString();
        }
    }

    abstract class MenuItemController {
        MenuItemController() {
        }

        public abstract boolean canPerform();

        public abstract void perform();

        public String getTitle() {
            return null;
        }

        public boolean isSelected() {
            return false;
        }
    }

    private static class WindowMenuEventHandler
    implements EventHandler<ActionEvent> {
        private final DocumentWindowController dwc;

        public WindowMenuEventHandler(DocumentWindowController dwc) {
            this.dwc = dwc;
        }

        public void handle(ActionEvent t) {
            this.dwc.getStage().toFront();
        }
    }
}

