/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.message;

import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.app.message.MessagePopupController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.messagelog.MessageLogEntry;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlPanelController;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import java.net.URL;
import javafx.animation.FadeTransition;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class MessageBarController
extends AbstractFxmlPanelController {
    private MessagePopupController messageWindowController;
    private int previousTotalNumOfMessages = 0;
    @FXML
    private HBox messageBox;
    @FXML
    private Button messageButton;
    @FXML
    private Label messageLabel;
    @FXML
    private Label statusLabel;
    @FXML
    private StackPane selectionBarHost;
    @FXML
    private HBox messagePart;
    @FXML
    private HBox iconsHbox;
    private final ImageView fileDirtyImage;
    private Tooltip statusLabelTooltip = null;

    public MessageBarController(EditorController editorController) {
        super(MessageBarController.class.getResource("MessageBar.fxml"), I18N.getBundle(), editorController);
        URL fileDirtyURL = MessageBarController.class.getResource("file-dirty.png");
        assert (fileDirtyURL != null);
        this.fileDirtyImage = new ImageView(new Image(fileDirtyURL.toExternalForm()));
    }

    public StackPane getSelectionBarHost() {
        return this.selectionBarHost;
    }

    @FXML
    void onOpenCloseAction(ActionEvent e) {
        if (this.messageWindowController == null) {
            this.messageWindowController = new MessagePopupController(this.getEditorController());
        }
        if (this.messageWindowController.isWindowOpened()) {
            this.messageWindowController.closeWindow();
        } else {
            this.messageWindowController.openWindow((Node)this.messageBox);
        }
    }

    @Override
    protected void fxomDocumentDidChange(FXOMDocument oldDocument) {
    }

    @Override
    protected void sceneGraphRevisionDidChange() {
    }

    @Override
    protected void cssRevisionDidChange() {
    }

    @Override
    protected void jobManagerRevisionDidChange() {
    }

    @Override
    protected void editorSelectionDidChange() {
    }

    @Override
    protected void controllerDidLoadFxml() {
        assert (this.messageBox != null);
        assert (this.messageLabel != null);
        assert (this.statusLabel != null);
        assert (this.selectionBarHost != null);
        this.messageLabel.setText("");
        this.statusLabel.setText("");
        this.messageButton.setVisible(false);
        this.getEditorController().getMessageLog().revisionProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
                MessageBarController.this.messageLogDidChange();
            }
        });
        this.getEditorController().getMessageLog().numOfWarningMessagesProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
                String numberOfMessages = Integer.toString(t1.intValue());
                if (t1.intValue() > 9) {
                    numberOfMessages = "*";
                }
                MessageBarController.this.messageButton.setText(numberOfMessages);
            }
        });
        this.statusLabelTooltip = this.statusLabel.getTooltip();
        this.messageLogDidChange();
    }

    public void setDocumentDirty(boolean isDirty) {
        if (this.statusLabel != null) {
            if (isDirty) {
                this.statusLabel.setGraphic((Node)this.fileDirtyImage);
                this.statusLabel.setTooltip(this.statusLabelTooltip);
            } else {
                this.statusLabel.setGraphic(null);
                this.statusLabel.setTooltip(null);
            }
        }
    }

    private void messageLogDidChange() {
        assert (this.messageLabel != null);
        MessageLogEntry entry = this.getEditorController().getMessageLog().getYoungestEntry();
        int logSize = this.getEditorController().getMessageLog().getEntries().size();
        if (entry != null && logSize > this.previousTotalNumOfMessages) {
            HBox.setHgrow((Node)this.messagePart, (Priority)Priority.ALWAYS);
            this.getSelectionBarHost().setVisible(false);
            this.getSelectionBarHost().setManaged(false);
            this.messageLabel.setManaged(true);
            this.setStyle(entry.getType());
            if (this.messageWindowController == null || !this.messageWindowController.isWindowOpened()) {
                if (this.getEditorController().getMessageLog().getWarningEntryCount() == 0) {
                    this.messageButton.setVisible(false);
                    this.messageButton.setManaged(false);
                } else {
                    this.messageButton.setVisible(true);
                    this.messageButton.setManaged(true);
                }
            }
            this.messageLabel.setText(entry.getText());
            this.messageLabel.setVisible(true);
            FadeTransition showHost = new FadeTransition(Duration.seconds((double)1.0), (Node)this.messagePart);
            showHost.setFromValue(1.0);
            showHost.setToValue(0.0);
            showHost.setDelay(Duration.seconds((double)3.0));
            showHost.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    MessageBarController.this.messageLabel.setVisible(false);
                    MessageBarController.this.messageLabel.setGraphic(null);
                    MessageBarController.this.messageLabel.setManaged(false);
                    if (MessageBarController.this.getEditorController().getMessageLog().getWarningEntryCount() == 0) {
                        MessageBarController.this.messageButton.setVisible(false);
                        MessageBarController.this.messageButton.setManaged(false);
                    }
                    MessageBarController.this.resetStyle();
                    MessageBarController.this.getSelectionBarHost().setManaged(true);
                    MessageBarController.this.getSelectionBarHost().setVisible(true);
                    MessageBarController.this.messagePart.setOpacity(1.0);
                    HBox.setHgrow((Node)MessageBarController.this.messagePart, (Priority)Priority.NEVER);
                }
            });
            showHost.play();
        } else if (this.getEditorController().getMessageLog().getEntryCount() == 0) {
            this.messageButton.setVisible(false);
            this.messageButton.setManaged(false);
            if (this.messageWindowController != null && this.messageWindowController.isWindowOpened()) {
                this.messageWindowController.closeWindow();
            }
        }
        this.previousTotalNumOfMessages = logSize;
    }

    private void resetStyle() {
        this.messageLabel.getStyleClass().removeAll((Object[])new String[]{"message-info"});
        this.messageLabel.getStyleClass().removeAll((Object[])new String[]{"message-warning"});
        this.statusLabel.getStyleClass().removeAll((Object[])new String[]{"message-info"});
        this.statusLabel.getStyleClass().removeAll((Object[])new String[]{"message-warning"});
        this.iconsHbox.getStyleClass().removeAll((Object[])new String[]{"message-info"});
        this.iconsHbox.getStyleClass().removeAll((Object[])new String[]{"message-warning"});
    }

    private void setStyle(MessageLogEntry.Type type) {
        this.resetStyle();
        switch (type) {
            case INFO: {
                this.messageLabel.getStyleClass().add((Object)"message-info");
                this.statusLabel.getStyleClass().add((Object)"message-info");
                this.iconsHbox.getStyleClass().add((Object)"message-info");
                break;
            }
            case WARNING: {
                this.messageLabel.getStyleClass().add((Object)"message-warning");
                this.statusLabel.getStyleClass().add((Object)"message-warning");
                this.iconsHbox.getStyleClass().add((Object)"message-warning");
                break;
            }
        }
    }
}

