/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.preferences;

import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordDocument;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordGlobal;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class PreferencesController {
    static final String SB_RELEASE_NODE = "SB_2.0";
    static final String ROOT_CONTAINER_HEIGHT = "ROOT_CONTAINER_HEIGHT";
    static final String ROOT_CONTAINER_WIDTH = "ROOT_CONTAINER_WIDTH";
    static final String BACKGROUND_IMAGE = "BACKGROUND_IMAGE";
    static final String ALIGNMENT_GUIDES_COLOR = "ALIGNMENT_GUIDES_COLOR";
    static final String PARENT_RING_COLOR = "PARENT_RING_COLOR";
    static final String TOOL_THEME = "TOOL_THEME";
    static final String LIBRARY_DISPLAY_OPTION = "LIBRARY_DISPLAY_OPTION";
    static final String HIERARCHY_DISPLAY_OPTION = "HIERARCHY_DISPLAY_OPTION";
    static final String CSS_TABLE_COLUMNS_ORDERING_REVERSED = "CSS_TABLE_COLUMNS_ORDERING_REVERSED";
    static final String RECENT_ITEMS = "RECENT_ITEMS";
    static final String RECENT_ITEMS_SIZE = "RECENT_ITEMS_SIZE";
    static final String DOCUMENTS = "DOCUMENTS";
    static final String PATH = "path";
    static final String X_POS = "X";
    static final String Y_POS = "Y";
    static final String STAGE_HEIGHT = "height";
    static final String STAGE_WIDTH = "width";
    static final String BOTTOM_VISIBLE = "bottomVisible";
    static final String LEFT_VISIBLE = "leftVisible";
    static final String RIGHT_VISIBLE = "rightVisible";
    static final String LIBRARY_VISIBLE = "libraryVisible";
    static final String DOCUMENT_VISIBLE = "documentVisible";
    static final String INSPECTOR_SECTION_ID = "inspectorSectionId";
    static final String LEFT_DIVIDER_HPOS = "leftDividerHPos";
    static final String RIGHT_DIVIDER_HPOS = "rightDividerHPos";
    static final String BOTTOM_DIVIDER_VPOS = "bottomDividerVPos";
    static final String LEFT_DIVIDER_VPOS = "leftDividerVPos";
    static final String SCENE_STYLE_SHEETS = "sceneStyleSheets";
    static final String I18N_RESOURCE = "I18NResource";
    private static PreferencesController singleton;
    private final Preferences applicationRootPreferences;
    private final Preferences documentsRootPreferences;
    private final PreferencesRecordGlobal recordGlobal;
    private final Map<DocumentWindowController, PreferencesRecordDocument> recordDocuments = new HashMap<DocumentWindowController, PreferencesRecordDocument>();

    private PreferencesController() {
        this.applicationRootPreferences = Preferences.userNodeForPackage(PreferencesController.class).node(SB_RELEASE_NODE);
        this.recordGlobal = new PreferencesRecordGlobal(this.applicationRootPreferences);
        this.documentsRootPreferences = this.applicationRootPreferences.node(DOCUMENTS);
        String items = this.applicationRootPreferences.get(RECENT_ITEMS, null);
        if (items != null) {
            try {
                String[] childrenNames;
                for (String child : childrenNames = this.documentsRootPreferences.childrenNames()) {
                    Preferences documentPreferences = this.documentsRootPreferences.node(child);
                    String nodePath = documentPreferences.get(PATH, null);
                    if (nodePath == null || nodePath.isEmpty()) {
                        documentPreferences.removeNode();
                        continue;
                    }
                    if (items.contains(nodePath)) continue;
                    documentPreferences.removeNode();
                }
            }
            catch (BackingStoreException ex) {
                Logger.getLogger(PreferencesRecordGlobal.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static synchronized PreferencesController getSingleton() {
        if (singleton == null) {
            singleton = new PreferencesController();
            singleton.getRecordGlobal().readFromJavaPreferences();
        }
        return singleton;
    }

    public PreferencesRecordGlobal getRecordGlobal() {
        return this.recordGlobal;
    }

    public PreferencesRecordDocument getRecordDocument(DocumentWindowController dwc) {
        PreferencesRecordDocument recordDocument;
        if (this.recordDocuments.containsKey(dwc)) {
            recordDocument = this.recordDocuments.get(dwc);
        } else {
            recordDocument = new PreferencesRecordDocument(this.documentsRootPreferences, dwc);
            this.recordDocuments.put(dwc, recordDocument);
        }
        return recordDocument;
    }
}

