/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.preferences;

import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.AbstractHierarchyPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryPanelController;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class PreferencesRecordGlobal {
    static final double DEFAULT_ROOT_CONTAINER_HEIGHT = 400.0;
    static final double DEFAULT_ROOT_CONTAINER_WIDTH = 600.0;
    static final BackgroundImage DEFAULT_BACKGROUND_IMAGE = BackgroundImage.BACKGROUND_03;
    static final Color DEFAULT_ALIGNMENT_GUIDES_COLOR = Color.RED;
    static final Color DEFAULT_PARENT_RING_COLOR = Color.rgb((int)238, (int)168, (int)47);
    static final SceneBuilderApp.ToolTheme DEFAULT_TOOL_THEME = SceneBuilderApp.ToolTheme.DEFAULT;
    static final LibraryPanelController.DISPLAY_MODE DEFAULT_LIBRARY_DISPLAY_OPTION = LibraryPanelController.DISPLAY_MODE.SECTIONS;
    static final AbstractHierarchyPanelController.DisplayOption DEFAULT_HIERARCHY_DISPLAY_OPTION = AbstractHierarchyPanelController.DisplayOption.INFO;
    static final boolean DEFAULT_CSS_TABLE_COLUMNS_ORDERING_REVERSED = false;
    static final int DEFAULT_RECENT_ITEMS_SIZE = 15;
    private double rootContainerHeight = 400.0;
    private double rootContainerWidth = 600.0;
    private BackgroundImage backgroundImage = DEFAULT_BACKGROUND_IMAGE;
    private Color alignmentGuidesColor = DEFAULT_ALIGNMENT_GUIDES_COLOR;
    private Color parentRingColor = DEFAULT_PARENT_RING_COLOR;
    private SceneBuilderApp.ToolTheme toolTheme = DEFAULT_TOOL_THEME;
    private LibraryPanelController.DISPLAY_MODE libraryDisplayOption = DEFAULT_LIBRARY_DISPLAY_OPTION;
    private AbstractHierarchyPanelController.DisplayOption hierarchyDisplayOption = DEFAULT_HIERARCHY_DISPLAY_OPTION;
    private boolean cssTableColumnsOrderingReversed = false;
    private int recentItemsSize = 15;
    private final List<String> recentItems = new ArrayList<String>();
    private final Preferences applicationRootPreferences;
    static final Integer[] recentItemsSizes = new Integer[]{5, 10, 15, 20};

    public PreferencesRecordGlobal(Preferences applicationRootPreferences) {
        this.applicationRootPreferences = applicationRootPreferences;
    }

    public double getRootContainerHeight() {
        return this.rootContainerHeight;
    }

    public void setRootContainerHeight(double value) {
        this.rootContainerHeight = value;
    }

    public double getRootContainerWidth() {
        return this.rootContainerWidth;
    }

    public void setRootContainerWidth(double value) {
        this.rootContainerWidth = value;
    }

    public BackgroundImage getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(BackgroundImage value) {
        this.backgroundImage = value;
    }

    public Color getAlignmentGuidesColor() {
        return this.alignmentGuidesColor;
    }

    public void setAlignmentGuidesColor(Color value) {
        this.alignmentGuidesColor = value;
    }

    public Color getParentRingColor() {
        return this.parentRingColor;
    }

    public void setParentRingColor(Color value) {
        this.parentRingColor = value;
    }

    public SceneBuilderApp.ToolTheme getToolTheme() {
        return this.toolTheme;
    }

    public void setToolTheme(SceneBuilderApp.ToolTheme value) {
        this.toolTheme = value;
    }

    public LibraryPanelController.DISPLAY_MODE getLibraryDisplayOption() {
        return this.libraryDisplayOption;
    }

    public void setLibraryDisplayOption(LibraryPanelController.DISPLAY_MODE value) {
        this.libraryDisplayOption = value;
    }

    public AbstractHierarchyPanelController.DisplayOption getHierarchyDisplayOption() {
        return this.hierarchyDisplayOption;
    }

    public void setHierarchyDisplayOption(AbstractHierarchyPanelController.DisplayOption value) {
        this.hierarchyDisplayOption = value;
    }

    public CSSAnalyzerColumnsOrder getDefaultCSSAnalyzerColumnsOrder() {
        return CSSAnalyzerColumnsOrder.DEFAULTS_FIRST;
    }

    public CSSAnalyzerColumnsOrder getCSSAnalyzerColumnsOrder() {
        if (this.isCssTableColumnsOrderingReversed()) {
            return CSSAnalyzerColumnsOrder.DEFAULTS_LAST;
        }
        return CSSAnalyzerColumnsOrder.DEFAULTS_FIRST;
    }

    public void setCSSAnalyzerColumnsOrder(CSSAnalyzerColumnsOrder value) {
        switch (value) {
            case DEFAULTS_FIRST: {
                this.setCssTableColumnsOrderingReversed(false);
                break;
            }
            case DEFAULTS_LAST: {
                this.setCssTableColumnsOrderingReversed(true);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public boolean isCssTableColumnsOrderingReversed() {
        return this.cssTableColumnsOrderingReversed;
    }

    public void setCssTableColumnsOrderingReversed(boolean value) {
        this.cssTableColumnsOrderingReversed = value;
    }

    public int getRecentItemsSize() {
        return this.recentItemsSize;
    }

    public void setRecentItemsSize(int value) {
        this.recentItemsSize = value;
        while (this.recentItems.size() > this.recentItemsSize) {
            this.recentItems.remove(this.recentItems.size() - 1);
        }
    }

    public List<String> getRecentItems() {
        return this.recentItems;
    }

    public void addRecentItem(File file) {
        ArrayList<File> files = new ArrayList<File>();
        files.add(file);
        this.addRecentItems(files);
    }

    public void addRecentItems(List<File> files) {
        for (File file : files) {
            String path = file.getPath();
            if (this.recentItems.contains(path)) {
                this.recentItems.remove(path);
            }
            this.recentItems.add(0, path);
        }
        while (this.recentItems.size() > this.recentItemsSize) {
            this.recentItems.remove(this.recentItems.size() - 1);
        }
        this.writeToJavaPreferences("RECENT_ITEMS");
    }

    public void removeRecentItems(List<String> filePaths) {
        for (String filePath : filePaths) {
            this.recentItems.remove(filePath);
        }
        this.writeToJavaPreferences("RECENT_ITEMS");
    }

    public void clearRecentItems() {
        this.recentItems.clear();
        this.writeToJavaPreferences("RECENT_ITEMS");
    }

    public void refreshAlignmentGuidesColor(DocumentWindowController dwc) {
        ContentPanelController cpc = dwc.getContentPanelController();
        cpc.setGuidesColor((Paint)this.alignmentGuidesColor);
    }

    public void refreshBackgroundImage(DocumentWindowController dwc) {
        Image img1 = PreferencesRecordGlobal.getImage(this.backgroundImage);
        javafx.scene.layout.BackgroundImage bgi1 = new javafx.scene.layout.BackgroundImage(img1, BackgroundRepeat.REPEAT, BackgroundRepeat.REPEAT, BackgroundPosition.CENTER, BackgroundSize.DEFAULT);
        Background bg = new Background(new javafx.scene.layout.BackgroundImage[]{bgi1});
        ContentPanelController cpc = dwc.getContentPanelController();
        cpc.getWorkspacePane().setBackground(bg);
    }

    public void refreshCSSAnalyzerColumnsOrder(DocumentWindowController dwc) {
        dwc.refreshCssTableColumnsOrderingReversed(this.cssTableColumnsOrderingReversed);
    }

    public void refreshToolTheme(DocumentWindowController dwc) {
        SceneBuilderApp.ApplicationControlAction aca;
        SceneBuilderApp app = SceneBuilderApp.getSingleton();
        switch (this.toolTheme) {
            case DEFAULT: {
                aca = SceneBuilderApp.ApplicationControlAction.USE_DEFAULT_THEME;
                break;
            }
            case DARK: {
                aca = SceneBuilderApp.ApplicationControlAction.USE_DARK_THEME;
                break;
            }
            default: {
                assert (false);
                aca = null;
            }
        }
        app.performControlAction(aca, dwc);
    }

    public void refreshLibraryDisplayOption(DocumentWindowController dwc) {
        dwc.refreshLibraryDisplayOption(this.libraryDisplayOption);
    }

    public void refreshHierarchyDisplayOption(DocumentWindowController dwc) {
        dwc.refreshHierarchyDisplayOption(this.hierarchyDisplayOption);
    }

    public void refreshParentRingColor(DocumentWindowController dwc) {
        ContentPanelController cpc = dwc.getContentPanelController();
        cpc.setPringColor((Paint)this.parentRingColor);
        AbstractHierarchyPanelController hpc = dwc.getHierarchyPanelController();
        hpc.setParentRingColor((Paint)this.parentRingColor);
    }

    public void refreshRootContainerHeight(DocumentWindowController dwc) {
        EditorController ec = dwc.getEditorController();
        ec.setDefaultRootContainerHeight(this.rootContainerHeight);
    }

    public void refreshRootContainerWidth(DocumentWindowController dwc) {
        EditorController ec = dwc.getEditorController();
        ec.setDefaultRootContainerWidth(this.rootContainerWidth);
    }

    public void refreshAlignmentGuidesColor() {
        SceneBuilderApp app = SceneBuilderApp.getSingleton();
        for (DocumentWindowController dwc : app.getDocumentWindowControllers()) {
            this.refreshAlignmentGuidesColor(dwc);
        }
    }

    public void refreshBackgroundImage() {
        SceneBuilderApp app = SceneBuilderApp.getSingleton();
        for (DocumentWindowController dwc : app.getDocumentWindowControllers()) {
            this.refreshBackgroundImage(dwc);
        }
    }

    public void refreshCSSAnalyzerColumnsOrder() {
        SceneBuilderApp app = SceneBuilderApp.getSingleton();
        for (DocumentWindowController dwc : app.getDocumentWindowControllers()) {
            this.refreshCSSAnalyzerColumnsOrder(dwc);
        }
    }

    public void refreshToolTheme() {
        this.refreshToolTheme(null);
    }

    public void refreshLibraryDisplayOption() {
        SceneBuilderApp app = SceneBuilderApp.getSingleton();
        for (DocumentWindowController dwc : app.getDocumentWindowControllers()) {
            this.refreshLibraryDisplayOption(dwc);
        }
    }

    public void refreshHierarchyDisplayOption() {
        SceneBuilderApp app = SceneBuilderApp.getSingleton();
        for (DocumentWindowController dwc : app.getDocumentWindowControllers()) {
            this.refreshHierarchyDisplayOption(dwc);
        }
    }

    public void refreshParentRingColor() {
        SceneBuilderApp app = SceneBuilderApp.getSingleton();
        for (DocumentWindowController dwc : app.getDocumentWindowControllers()) {
            this.refreshParentRingColor(dwc);
        }
    }

    public void refreshRootContainerHeight() {
        SceneBuilderApp app = SceneBuilderApp.getSingleton();
        for (DocumentWindowController dwc : app.getDocumentWindowControllers()) {
            this.refreshRootContainerHeight(dwc);
        }
    }

    public void refreshRootContainerWidth() {
        SceneBuilderApp app = SceneBuilderApp.getSingleton();
        for (DocumentWindowController dwc : app.getDocumentWindowControllers()) {
            this.refreshRootContainerWidth(dwc);
        }
    }

    public void refresh(DocumentWindowController dwc) {
        this.refreshAlignmentGuidesColor(dwc);
        this.refreshBackgroundImage(dwc);
        this.refreshCSSAnalyzerColumnsOrder(dwc);
        this.refreshToolTheme(dwc);
        this.refreshLibraryDisplayOption(dwc);
        this.refreshHierarchyDisplayOption(dwc);
        this.refreshParentRingColor(dwc);
        this.refreshRootContainerHeight(dwc);
        this.refreshRootContainerWidth(dwc);
    }

    public void readFromJavaPreferences() {
        assert (this.applicationRootPreferences != null);
        double height = this.applicationRootPreferences.getDouble("ROOT_CONTAINER_HEIGHT", 400.0);
        this.setRootContainerHeight(height);
        double width = this.applicationRootPreferences.getDouble("ROOT_CONTAINER_WIDTH", 600.0);
        this.setRootContainerWidth(width);
        String image = this.applicationRootPreferences.get("BACKGROUND_IMAGE", DEFAULT_BACKGROUND_IMAGE.name());
        this.setBackgroundImage(BackgroundImage.valueOf(image));
        String agColor = this.applicationRootPreferences.get("ALIGNMENT_GUIDES_COLOR", DEFAULT_ALIGNMENT_GUIDES_COLOR.toString());
        this.setAlignmentGuidesColor(Color.valueOf((String)agColor));
        String prColor = this.applicationRootPreferences.get("PARENT_RING_COLOR", DEFAULT_PARENT_RING_COLOR.toString());
        this.setParentRingColor(Color.valueOf((String)prColor));
        String tool_theme = this.applicationRootPreferences.get("TOOL_THEME", DEFAULT_TOOL_THEME.name());
        this.setToolTheme(SceneBuilderApp.ToolTheme.valueOf(tool_theme));
        String library_DisplayOption = this.applicationRootPreferences.get("LIBRARY_DISPLAY_OPTION", DEFAULT_LIBRARY_DISPLAY_OPTION.name());
        this.setLibraryDisplayOption(LibraryPanelController.DISPLAY_MODE.valueOf(library_DisplayOption));
        String hierarchy_DisplayOption = this.applicationRootPreferences.get("HIERARCHY_DISPLAY_OPTION", DEFAULT_HIERARCHY_DISPLAY_OPTION.name());
        this.setHierarchyDisplayOption(AbstractHierarchyPanelController.DisplayOption.valueOf(hierarchy_DisplayOption));
        boolean reversed = this.applicationRootPreferences.getBoolean("CSS_TABLE_COLUMNS_ORDERING_REVERSED", false);
        this.setCssTableColumnsOrderingReversed(reversed);
        int size = this.applicationRootPreferences.getInt("RECENT_ITEMS_SIZE", 15);
        this.setRecentItemsSize(size);
        String items = this.applicationRootPreferences.get("RECENT_ITEMS", null);
        assert (this.recentItems.isEmpty());
        if (items != null) {
            String[] itemsArray = items.split("\\" + File.pathSeparator);
            assert (itemsArray.length <= this.recentItemsSize);
            this.recentItems.addAll(Arrays.asList(itemsArray));
        }
    }

    public void writeToJavaPreferences(String key) {
        assert (this.applicationRootPreferences != null);
        assert (key != null);
        switch (key) {
            case "ROOT_CONTAINER_HEIGHT": {
                this.applicationRootPreferences.putDouble("ROOT_CONTAINER_HEIGHT", this.getRootContainerHeight());
                break;
            }
            case "ROOT_CONTAINER_WIDTH": {
                this.applicationRootPreferences.putDouble("ROOT_CONTAINER_WIDTH", this.getRootContainerWidth());
                break;
            }
            case "BACKGROUND_IMAGE": {
                this.applicationRootPreferences.put("BACKGROUND_IMAGE", this.getBackgroundImage().name());
                break;
            }
            case "ALIGNMENT_GUIDES_COLOR": {
                this.applicationRootPreferences.put("ALIGNMENT_GUIDES_COLOR", this.getAlignmentGuidesColor().toString());
                break;
            }
            case "PARENT_RING_COLOR": {
                this.applicationRootPreferences.put("PARENT_RING_COLOR", this.getParentRingColor().toString());
                break;
            }
            case "TOOL_THEME": {
                this.applicationRootPreferences.put("TOOL_THEME", this.getToolTheme().name());
                break;
            }
            case "LIBRARY_DISPLAY_OPTION": {
                this.applicationRootPreferences.put("LIBRARY_DISPLAY_OPTION", this.getLibraryDisplayOption().name());
                break;
            }
            case "HIERARCHY_DISPLAY_OPTION": {
                this.applicationRootPreferences.put("HIERARCHY_DISPLAY_OPTION", this.getHierarchyDisplayOption().name());
                break;
            }
            case "CSS_TABLE_COLUMNS_ORDERING_REVERSED": {
                this.applicationRootPreferences.putBoolean("CSS_TABLE_COLUMNS_ORDERING_REVERSED", this.isCssTableColumnsOrderingReversed());
                break;
            }
            case "RECENT_ITEMS_SIZE": {
                this.applicationRootPreferences.putInt("RECENT_ITEMS_SIZE", this.getRecentItemsSize());
                break;
            }
            case "RECENT_ITEMS": {
                StringBuilder sb = new StringBuilder();
                for (String recentItem : this.getRecentItems()) {
                    sb.append(recentItem);
                    sb.append(File.pathSeparator);
                }
                this.applicationRootPreferences.put("RECENT_ITEMS", sb.toString());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private static Image getImage(BackgroundImage bgi) {
        URL url;
        switch (bgi) {
            case BACKGROUND_01: {
                url = PreferencesRecordGlobal.class.getResource("Background-Blue-Grid.png");
                break;
            }
            case BACKGROUND_02: {
                url = PreferencesRecordGlobal.class.getResource("Background-Neutral-Grid.png");
                break;
            }
            case BACKGROUND_03: {
                url = PreferencesRecordGlobal.class.getResource("Background-Neutral-Uniform.png");
                break;
            }
            default: {
                url = null;
                assert (false);
                break;
            }
        }
        assert (url != null);
        return new Image(url.toExternalForm());
    }

    public static enum CSSAnalyzerColumnsOrder {
        DEFAULTS_FIRST{

            public String toString() {
                return I18N.getString("prefs.cssanalyzer.columns.defaults.first");
            }
        }
        ,
        DEFAULTS_LAST{

            public String toString() {
                return I18N.getString("prefs.cssanalyzer.columns.defaults.last");
            }
        };

    }

    public static enum BackgroundImage {
        BACKGROUND_01{

            public String toString() {
                return I18N.getString("prefs.background.value1");
            }
        }
        ,
        BACKGROUND_02{

            public String toString() {
                return I18N.getString("prefs.background.value2");
            }
        }
        ,
        BACKGROUND_03{

            public String toString() {
                return I18N.getString("prefs.background.value3");
            }
        };

    }
}

