/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.preferences;

import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordGlobal;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.AbstractHierarchyPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.DoubleField;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.PaintPicker;
import java.util.Arrays;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.MenuButton;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.WindowEvent;

public class PreferencesWindowController
extends AbstractFxmlWindowController {
    @FXML
    private DoubleField rootContainerHeight;
    @FXML
    private DoubleField rootContainerWidth;
    @FXML
    private ChoiceBox<PreferencesRecordGlobal.BackgroundImage> backgroundImage;
    @FXML
    private ChoiceBox<SceneBuilderApp.ToolTheme> toolTheme;
    @FXML
    private ChoiceBox<LibraryPanelController.DISPLAY_MODE> libraryDisplayOption;
    @FXML
    private ChoiceBox<AbstractHierarchyPanelController.DisplayOption> hierarchyDisplayOption;
    @FXML
    private ChoiceBox<PreferencesRecordGlobal.CSSAnalyzerColumnsOrder> cssAnalyzerColumnsOrder;
    @FXML
    private MenuButton alignmentGuidesButton;
    @FXML
    private MenuButton parentRingButton;
    @FXML
    private CustomMenuItem alignmentGuidesMenuItem;
    @FXML
    private CustomMenuItem parentRingMenuItem;
    @FXML
    private Rectangle alignmentGuidesGraphic;
    @FXML
    private Rectangle parentRingGraphic;
    @FXML
    private ChoiceBox<Integer> recentItemsSize;
    private PaintPicker alignmentColorPicker;
    private PaintPicker parentRingColorPicker;

    public PreferencesWindowController() {
        super(PreferencesWindowController.class.getResource("Preferences.fxml"), I18N.getBundle());
    }

    @Override
    protected void controllerDidLoadFxml() {
        super.controllerDidLoadFxml();
        PreferencesController preferencesController = PreferencesController.getSingleton();
        final PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
        this.rootContainerHeight.setText(String.valueOf(recordGlobal.getRootContainerHeight()));
        this.rootContainerHeight.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                String value = PreferencesWindowController.this.rootContainerHeight.getText();
                recordGlobal.setRootContainerHeight(Double.valueOf(value));
                PreferencesWindowController.this.rootContainerHeight.selectAll();
                recordGlobal.writeToJavaPreferences("ROOT_CONTAINER_HEIGHT");
                recordGlobal.refreshRootContainerHeight();
            }
        });
        this.rootContainerWidth.setText(String.valueOf(recordGlobal.getRootContainerWidth()));
        this.rootContainerWidth.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                String value = PreferencesWindowController.this.rootContainerWidth.getText();
                recordGlobal.setRootContainerWidth(Double.valueOf(value));
                PreferencesWindowController.this.rootContainerWidth.selectAll();
                recordGlobal.writeToJavaPreferences("ROOT_CONTAINER_WIDTH");
                recordGlobal.refreshRootContainerWidth();
            }
        });
        this.backgroundImage.getItems().setAll(Arrays.asList(PreferencesRecordGlobal.BackgroundImage.class.getEnumConstants()));
        this.backgroundImage.setValue((Object)recordGlobal.getBackgroundImage());
        this.backgroundImage.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new BackgroundImageListener());
        PaintPickerDelegate delegate = new PaintPickerDelegate();
        Color alignmentColor = recordGlobal.getAlignmentGuidesColor();
        this.alignmentColorPicker = new PaintPicker(delegate, PaintPicker.Mode.COLOR);
        this.alignmentGuidesGraphic.setFill((Paint)alignmentColor);
        this.alignmentGuidesMenuItem.setContent((Node)this.alignmentColorPicker);
        this.alignmentColorPicker.setPaintProperty((Paint)alignmentColor);
        this.alignmentColorPicker.paintProperty().addListener((ChangeListener)new AlignmentGuidesColorListener(this.alignmentGuidesGraphic));
        Color parentRingColor = recordGlobal.getParentRingColor();
        this.parentRingColorPicker = new PaintPicker(delegate, PaintPicker.Mode.COLOR);
        this.parentRingGraphic.setFill((Paint)parentRingColor);
        this.parentRingMenuItem.setContent((Node)this.parentRingColorPicker);
        this.parentRingColorPicker.setPaintProperty((Paint)parentRingColor);
        this.parentRingColorPicker.paintProperty().addListener((ChangeListener)new ParentRingColorListener(this.parentRingGraphic));
        this.toolTheme.getItems().setAll(Arrays.asList(SceneBuilderApp.ToolTheme.class.getEnumConstants()));
        this.toolTheme.setValue((Object)recordGlobal.getToolTheme());
        this.toolTheme.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ToolThemeListener());
        LibraryPanelController.DISPLAY_MODE[] availableDisplayMode = new LibraryPanelController.DISPLAY_MODE[]{LibraryPanelController.DISPLAY_MODE.LIST, LibraryPanelController.DISPLAY_MODE.SECTIONS};
        this.libraryDisplayOption.getItems().setAll(Arrays.asList(availableDisplayMode));
        this.libraryDisplayOption.setValue((Object)recordGlobal.getLibraryDisplayOption());
        this.libraryDisplayOption.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new LibraryOptionListener());
        this.hierarchyDisplayOption.getItems().setAll(Arrays.asList(AbstractHierarchyPanelController.DisplayOption.class.getEnumConstants()));
        this.hierarchyDisplayOption.setValue((Object)recordGlobal.getHierarchyDisplayOption());
        this.hierarchyDisplayOption.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new DisplayOptionListener());
        this.cssAnalyzerColumnsOrder.getItems().setAll(Arrays.asList(PreferencesRecordGlobal.CSSAnalyzerColumnsOrder.class.getEnumConstants()));
        this.cssAnalyzerColumnsOrder.setValue((Object)recordGlobal.getCSSAnalyzerColumnsOrder());
        this.cssAnalyzerColumnsOrder.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ColumnOrderListener());
        this.recentItemsSize.getItems().setAll((Object[])PreferencesRecordGlobal.recentItemsSizes);
        this.recentItemsSize.setValue((Object)recordGlobal.getRecentItemsSize());
        this.recentItemsSize.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new RecentItemsSizeListener());
    }

    @Override
    protected void controllerDidCreateStage() {
        assert (this.getRoot() != null);
        assert (this.getRoot().getScene() != null);
        assert (this.getRoot().getScene().getWindow() != null);
        this.getStage().setTitle(I18N.getString("prefs.title"));
        this.getStage().setResizable(false);
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        super.closeWindow();
    }

    @FXML
    void resetToDefaultAction(ActionEvent event) {
        PreferencesController preferencesController = PreferencesController.getSingleton();
        PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
        this.rootContainerHeight.setText(String.valueOf(400.0));
        this.rootContainerHeight.getOnAction().handle((Event)new ActionEvent());
        this.rootContainerWidth.setText(String.valueOf(600.0));
        this.rootContainerWidth.getOnAction().handle((Event)new ActionEvent());
        this.backgroundImage.setValue((Object)PreferencesRecordGlobal.DEFAULT_BACKGROUND_IMAGE);
        this.alignmentColorPicker.setPaintProperty((Paint)PreferencesRecordGlobal.DEFAULT_ALIGNMENT_GUIDES_COLOR);
        this.parentRingColorPicker.setPaintProperty((Paint)PreferencesRecordGlobal.DEFAULT_PARENT_RING_COLOR);
        this.toolTheme.setValue((Object)PreferencesRecordGlobal.DEFAULT_TOOL_THEME);
        this.libraryDisplayOption.setValue((Object)PreferencesRecordGlobal.DEFAULT_LIBRARY_DISPLAY_OPTION);
        this.hierarchyDisplayOption.setValue((Object)PreferencesRecordGlobal.DEFAULT_HIERARCHY_DISPLAY_OPTION);
        this.cssAnalyzerColumnsOrder.setValue((Object)recordGlobal.getDefaultCSSAnalyzerColumnsOrder());
        this.recentItemsSize.setValue((Object)15);
    }

    private static class PaintPickerDelegate
    implements PaintPicker.Delegate {
        private PaintPickerDelegate() {
        }

        @Override
        public void handleError(String warningKey, Object ... arguments) {
        }
    }

    private static class ParentRingColorListener
    implements ChangeListener<Paint> {
        private final Rectangle graphic;

        public ParentRingColorListener(Rectangle graphic) {
            this.graphic = graphic;
        }

        public void changed(ObservableValue<? extends Paint> ov, Paint oldValue, Paint newValue) {
            assert (newValue instanceof Color);
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setParentRingColor((Color)newValue);
            recordGlobal.writeToJavaPreferences("PARENT_RING_COLOR");
            recordGlobal.refreshParentRingColor();
            this.graphic.setFill(newValue);
        }
    }

    private static class AlignmentGuidesColorListener
    implements ChangeListener<Paint> {
        private final Rectangle graphic;

        public AlignmentGuidesColorListener(Rectangle graphic) {
            this.graphic = graphic;
        }

        public void changed(ObservableValue<? extends Paint> ov, Paint oldValue, Paint newValue) {
            assert (newValue instanceof Color);
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setAlignmentGuidesColor((Color)newValue);
            recordGlobal.writeToJavaPreferences("ALIGNMENT_GUIDES_COLOR");
            recordGlobal.refreshAlignmentGuidesColor();
            this.graphic.setFill(newValue);
        }
    }

    private static class RecentItemsSizeListener
    implements ChangeListener<Integer> {
        private RecentItemsSizeListener() {
        }

        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setRecentItemsSize(newValue);
            recordGlobal.writeToJavaPreferences("RECENT_ITEMS_SIZE");
            recordGlobal.writeToJavaPreferences("RECENT_ITEMS");
        }
    }

    private static class ColumnOrderListener
    implements ChangeListener<PreferencesRecordGlobal.CSSAnalyzerColumnsOrder> {
        private ColumnOrderListener() {
        }

        public void changed(ObservableValue<? extends PreferencesRecordGlobal.CSSAnalyzerColumnsOrder> observable, PreferencesRecordGlobal.CSSAnalyzerColumnsOrder oldValue, PreferencesRecordGlobal.CSSAnalyzerColumnsOrder newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setCSSAnalyzerColumnsOrder(newValue);
            recordGlobal.writeToJavaPreferences("CSS_TABLE_COLUMNS_ORDERING_REVERSED");
            recordGlobal.refreshCSSAnalyzerColumnsOrder();
        }
    }

    private static class DisplayOptionListener
    implements ChangeListener<AbstractHierarchyPanelController.DisplayOption> {
        private DisplayOptionListener() {
        }

        public void changed(ObservableValue<? extends AbstractHierarchyPanelController.DisplayOption> observable, AbstractHierarchyPanelController.DisplayOption oldValue, AbstractHierarchyPanelController.DisplayOption newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setHierarchyDisplayOption(newValue);
            recordGlobal.writeToJavaPreferences("HIERARCHY_DISPLAY_OPTION");
            recordGlobal.refreshHierarchyDisplayOption();
        }
    }

    private static class LibraryOptionListener
    implements ChangeListener<LibraryPanelController.DISPLAY_MODE> {
        private LibraryOptionListener() {
        }

        public void changed(ObservableValue<? extends LibraryPanelController.DISPLAY_MODE> ov, LibraryPanelController.DISPLAY_MODE oldValue, LibraryPanelController.DISPLAY_MODE newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setLibraryDisplayOption(newValue);
            recordGlobal.writeToJavaPreferences("LIBRARY_DISPLAY_OPTION");
            recordGlobal.refreshLibraryDisplayOption();
        }
    }

    private static class ToolThemeListener
    implements ChangeListener<SceneBuilderApp.ToolTheme> {
        private ToolThemeListener() {
        }

        public void changed(ObservableValue<? extends SceneBuilderApp.ToolTheme> observable, SceneBuilderApp.ToolTheme oldValue, SceneBuilderApp.ToolTheme newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setToolTheme(newValue);
            recordGlobal.writeToJavaPreferences("TOOL_THEME");
            recordGlobal.refreshToolTheme();
        }
    }

    private static class BackgroundImageListener
    implements ChangeListener<PreferencesRecordGlobal.BackgroundImage> {
        private BackgroundImageListener() {
        }

        public void changed(ObservableValue<? extends PreferencesRecordGlobal.BackgroundImage> observable, PreferencesRecordGlobal.BackgroundImage oldValue, PreferencesRecordGlobal.BackgroundImage newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setBackgroundImage(newValue);
            recordGlobal.writeToJavaPreferences("BACKGROUND_IMAGE");
            recordGlobal.refreshBackgroundImage();
        }
    }
}

