/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.preview;

import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AbstractModalDialog;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.PaintPicker;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Window;

public class BackgroundColorDialogController
extends AbstractModalDialog {
    public BackgroundColorDialogController(Window owner) {
        super(BackgroundColorDialogController.class.getResource("BackgroundColor.fxml"), I18N.getBundle(), owner);
    }

    @Override
    protected void controllerDidLoadFxml() {
        super.controllerDidLoadFxml();
        this.setActionButtonVisible(false);
        this.setDefaultButtonID(AbstractModalDialog.ButtonID.OK);
        this.setShowDefaultButton(true);
        String title = I18N.getString("preview.background.color");
        this.getStage().setTitle(title);
    }

    @Override
    protected void controllerDidLoadContentFxml() {
        assert (this.getContentRoot() instanceof Pane);
        Pane contentRoot = (Pane)this.getContentRoot();
        PaintPickerDelegate delegate = new PaintPickerDelegate();
        PaintPicker paintPicker = new PaintPicker(delegate);
        contentRoot.getChildren().add((Object)paintPicker);
        ChangeListener<Number> sizeListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
                BackgroundColorDialogController.this.getStage().sizeToScene();
            }
        };
        contentRoot.heightProperty().addListener((ChangeListener)sizeListener);
        contentRoot.widthProperty().addListener((ChangeListener)sizeListener);
        paintPicker.paintProperty().addListener(new PaintChangeListener());
    }

    @Override
    protected void okButtonPressed(ActionEvent e) {
        this.closeWindow();
    }

    @Override
    protected void cancelButtonPressed(ActionEvent e) {
        this.closeWindow();
    }

    @Override
    protected void actionButtonPressed(ActionEvent e) {
        throw new IllegalStateException();
    }

    private static class PaintPickerDelegate
    implements PaintPicker.Delegate {
        private PaintPickerDelegate() {
        }

        @Override
        public void handleError(String warningKey, Object ... arguments) {
        }
    }

    private static class PaintChangeListener<Paint>
    implements ChangeListener<Paint> {
        private PaintChangeListener() {
        }

        public void changed(ObservableValue<? extends Paint> ov, Paint oldValue, Paint newValue) {
            System.err.println("Update Preview background color with " + newValue);
        }
    }
}

