/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.selectionbar;

import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.images.ImageUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.net.URL;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;

public class SelectionBarController
extends AbstractFxmlPanelController {
    @FXML
    private HBox pathBox;
    private final Image selectionChevronImage;
    private final Image warningBadgeImage;
    private final EventHandler<ActionEvent> hyperlinkHandler = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent t) {
            assert (t.getSource() instanceof Hyperlink);
            Hyperlink hyperlink = (Hyperlink)t.getSource();
            assert (hyperlink.getUserData() instanceof FXOMObject);
            SelectionBarController.this.handleSelect((FXOMObject)hyperlink.getUserData());
            hyperlink.setVisited(false);
        }
    };

    public SelectionBarController(EditorController editorController) {
        super(SelectionBarController.class.getResource("SelectionBar.fxml"), I18N.getBundle(), editorController);
        URL selectionChevronURL = SelectionBarController.class.getResource("selection-chevron.png");
        assert (selectionChevronURL != null);
        this.selectionChevronImage = new Image(selectionChevronURL.toExternalForm());
        this.warningBadgeImage = ImageUtils.getWarningBadgeImage();
    }

    @Override
    protected void fxomDocumentDidChange(FXOMDocument oldDocument) {
        if (this.pathBox != null) {
            this.updateSelectionBar();
        }
    }

    @Override
    protected void sceneGraphRevisionDidChange() {
        if (this.pathBox != null) {
            this.updateSelectionBar();
        }
    }

    @Override
    protected void cssRevisionDidChange() {
    }

    @Override
    protected void jobManagerRevisionDidChange() {
        this.sceneGraphRevisionDidChange();
    }

    @Override
    protected void editorSelectionDidChange() {
        if (this.pathBox != null) {
            this.updateSelectionBar();
        }
    }

    @Override
    protected void controllerDidLoadFxml() {
        assert (this.pathBox != null);
        this.updateSelectionBar();
    }

    private void updateSelectionBar() {
        Selection selection = this.getEditorController().getSelection();
        this.pathBox.getChildren().clear();
        if (selection.isEmpty()) {
            this.pathBox.getChildren().add((Object)new Label(I18N.getString("selectionbar.no.selected")));
        } else if (selection.getGroup() instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            assert (!osg.getItems().isEmpty());
            FXOMObject fxomObject = osg.getItems().iterator().next();
            while (fxomObject != null) {
                DesignHierarchyMask mask = new DesignHierarchyMask(fxomObject);
                String entryText = this.makeEntryText(mask);
                Hyperlink boxItem = new Hyperlink();
                boxItem.setText(entryText);
                ImageView graphic = new ImageView(mask.getClassNameIcon());
                boxItem.setGraphic((Node)graphic);
                boxItem.setFocusTraversable(false);
                boxItem.setUserData((Object)fxomObject);
                boxItem.setOnAction(this.hyperlinkHandler);
                this.pathBox.getChildren().add(0, (Object)boxItem);
                if (this.pathBox.getChildren().size() <= 3) {
                    boxItem.setMinWidth(Double.NEGATIVE_INFINITY);
                    HBox.setHgrow((Node)boxItem, (Priority)Priority.ALWAYS);
                } else {
                    boxItem.setMinWidth(graphic.getBoundsInLocal().getWidth());
                }
                if ((fxomObject = mask.getParentFXOMObject()) == null) continue;
                ImageView img = new ImageView(this.selectionChevronImage);
                StackPane sp = new StackPane();
                sp.getChildren().add((Object)img);
                sp.setMinWidth(this.selectionChevronImage.getWidth());
                this.pathBox.getChildren().add(0, (Object)sp);
            }
        } else {
            this.pathBox.getChildren().add((Object)new Label(I18N.getString("selectionbar.not.object")));
        }
    }

    private String makeEntryText(DesignHierarchyMask mask) {
        StringBuilder result = new StringBuilder();
        result.append(mask.getClassNameInfo());
        String description = mask.getSingleLineDescription();
        if (description != null) {
            result.append(" : ");
            result.append(description);
        }
        return result.toString();
    }

    private void handleSelect(FXOMObject fxomObject) {
        Selection selection = this.getEditorController().getSelection();
        assert (fxomObject.getFxomDocument() == this.getEditorController().getFxomDocument());
        selection.select(fxomObject);
    }
}

