/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.skeleton;

import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javafx.fxml.FXML;

class SkeletonBuffer {
    private final FXOMDocument document;
    private final String INDENT = "    ";
    private final Set<String> imports = new TreeSet<String>();
    private final StringBuilder variables = new StringBuilder();
    private final StringBuilder asserts = new StringBuilder();
    private TEXT_TYPE textType = TEXT_TYPE.WITHOUT_COMMENTS;
    private FORMAT_TYPE textFormat = FORMAT_TYPE.COMPACT;
    private final StringBuilder packageLine = new StringBuilder();
    private final StringBuilder classLine = new StringBuilder();
    private final StringBuilder header = new StringBuilder();
    private final StringBuilder initialize = new StringBuilder();
    private final StringBuilder handlers = new StringBuilder();

    SkeletonBuffer(FXOMDocument document) {
        assert (document != null);
        this.document = document;
    }

    public void setTextType(TEXT_TYPE type) {
        this.textType = type;
    }

    public void setFormat(FORMAT_TYPE format) {
        this.textFormat = format;
    }

    private void constructHeader() {
        if (this.textType == TEXT_TYPE.WITH_COMMENTS) {
            String documentName = DocumentWindowController.makeTitle(this.document);
            String title = I18N.getString("skeleton.window.title", documentName);
            this.header.append("/**\n");
            this.header.append(" * ");
            this.header.append(title);
            this.header.append("\n */\n\n");
        }
    }

    private void constructPackageLine() {
        String controller = this.document.getFxomRoot().getFxController();
        if (controller != null && !controller.isEmpty() && controller.contains(".") && !controller.contains("$")) {
            this.packageLine.append("package ");
            this.packageLine.append(controller.substring(0, controller.indexOf(".")));
            this.packageLine.append(";\n\n");
        }
    }

    private void constructClassLine() {
        String controller = this.document.getFxomRoot().getFxController();
        this.classLine.append("\npublic ");
        if (controller != null && controller.contains("$")) {
            this.classLine.append("static ");
        }
        this.classLine.append("class ");
        if (controller != null && !controller.isEmpty()) {
            String simpleName = controller.replace("$", ".");
            int dot = simpleName.lastIndexOf(46);
            if (dot > -1) {
                simpleName = simpleName.substring(dot + 1);
            }
            this.classLine.append(simpleName);
        } else {
            this.classLine.append("PleaseProvideControllerClassName");
        }
        this.classLine.append(" {\n\n");
    }

    private void constructInitialize() {
        if (this.textFormat == FORMAT_TYPE.FULL) {
            this.initialize.append("    ");
            this.initialize.append("@FXML");
            if (this.textType == TEXT_TYPE.WITH_COMMENTS) {
                this.initialize.append(" // This method is called by the FXMLLoader when initialization is complete\n");
            } else {
                this.initialize.append("\n");
            }
            this.initialize.append("    ");
            this.initialize.append("void initialize() {\n");
            this.initialize.append((CharSequence)this.asserts);
            this.initialize.append("\n");
            this.initialize.append("    ");
            this.initialize.append("}\n");
        }
    }

    private void construct() {
        this.constructHeader();
        this.constructPackageLine();
        this.constructClassLine();
        String documentName = DocumentWindowController.makeTitle(this.document);
        Map<String, FXOMObject> fxids = this.document.collectFxIds();
        for (FXOMObject value : fxids.values()) {
            String key = value.getFxId();
            Object obj = value.getSceneGraphObject();
            Class<?> type = obj.getClass();
            this.addImportsFor(this.imports, FXML.class, type);
            this.variables.append("    ").append("@FXML");
            if (this.textType == TEXT_TYPE.WITH_COMMENTS) {
                this.variables.append(" // fx:id=\"").append(key).append("\"");
            }
            this.variables.append("\n");
            this.variables.append("    ").append("private ").append(type.getSimpleName());
            TypeVariable<Class<?>>[] parameters = type.getTypeParameters();
            if (parameters.length > 0) {
                this.variables.append("<");
                String sep = "";
                for (TypeVariable<Class<?>> t : parameters) {
                    this.variables.append(sep).append("?");
                    sep = ", ";
                    t.getName();
                }
                this.variables.append(">");
            }
            if (this.textType == TEXT_TYPE.WITH_COMMENTS) {
                this.variables.append(" ").append(key).append("; // Value injected by FXMLLoader\n\n");
            } else {
                this.variables.append(" ").append(key).append(";\n\n");
            }
            this.asserts.append("    ").append("    ").append("assert ").append(key).append(" != null : ").append("\"fx:id=\\\"").append(key).append("\\\" was not injected: check your FXML file ").append("'").append(documentName).append("'.\";\n");
        }
        if (this.textFormat == FORMAT_TYPE.FULL) {
            this.addImportsFor(this.imports, URL.class, ResourceBundle.class);
        }
        for (FXOMPropertyT property : this.document.getFxomRoot().collectEventHandlers()) {
            this.handlers.append("    ").append("@FXML\n").append("    ").append("void ");
            String methodName = property.getValue().replace("#", "");
            this.handlers.append(methodName);
            this.handlers.append("(ActionEvent event) {\n\n").append("    ").append("}\n\n");
        }
        this.constructInitialize();
    }

    private void addImportsFor(Set<String> imports, Class<?> ... classes) {
        for (Class<?> c : classes) {
            StringBuilder importb = new StringBuilder();
            importb.append("import ").append(c.getName().replace("$", ".")).append(";\n");
            imports.add(importb.toString());
        }
    }

    public String toString() {
        if (this.document.getFxomRoot() == null) {
            return I18N.getString("skeleton.empty");
        }
        this.construct();
        StringBuilder code = new StringBuilder();
        code.append((CharSequence)this.header);
        code.append((CharSequence)this.packageLine);
        for (String importStatement : this.imports) {
            code.append(importStatement);
        }
        code.append((CharSequence)this.classLine);
        if (this.textType == TEXT_TYPE.WITH_COMMENTS && this.textFormat == FORMAT_TYPE.FULL) {
            code.append("    ").append("@FXML // ResourceBundle that was given to the FXMLLoader\n").append("    ").append("private ResourceBundle resources;\n\n").append("    ").append("@FXML // URL location of the FXML file that was given to the FXMLLoader\n").append("    ").append("private URL location;\n\n");
        } else if (this.textFormat == FORMAT_TYPE.FULL) {
            code.append("    ").append("@FXML\n").append("    ").append("private ResourceBundle resources;\n\n").append("    ").append("@FXML\n").append("    ").append("private URL location;\n\n");
        }
        code.append((CharSequence)this.variables);
        code.append((CharSequence)this.handlers);
        code.append((CharSequence)this.initialize);
        code.append("}\n");
        return code.toString();
    }

    static enum FORMAT_TYPE {
        COMPACT,
        FULL;

    }

    static enum TEXT_TYPE {
        WITH_COMMENTS,
        WITHOUT_COMMENTS;

    }
}

