/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.skeleton;

import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.app.skeleton.SkeletonBuffer;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextArea;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class SkeletonWindowController
extends AbstractFxmlWindowController {
    @FXML
    CheckBox commentCheckBox;
    @FXML
    CheckBox formatCheckBox;
    @FXML
    TextArea textArea;
    private final EditorController editorController;
    private boolean dirty = false;
    private final ChangeListener<Number> fxomDocumentRevisionListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            SkeletonWindowController.this.update();
        }
    };

    @FXML
    void onCopyAction(ActionEvent event) {
        HashMap<DataFormat, String> content = new HashMap<DataFormat, String>();
        if (this.textArea.getSelection().getLength() == 0) {
            content.put(DataFormat.PLAIN_TEXT, this.textArea.getText());
        } else {
            content.put(DataFormat.PLAIN_TEXT, this.textArea.getSelectedText());
        }
        Clipboard.getSystemClipboard().setContent(content);
    }

    public SkeletonWindowController(final EditorController editorController, Window owner) {
        super(SkeletonWindowController.class.getResource("SkeletonWindow.fxml"), I18N.getBundle(), owner);
        this.editorController = editorController;
        this.editorController.fxomDocumentProperty().addListener((ChangeListener)new ChangeListener<FXOMDocument>(){

            public void changed(ObservableValue<? extends FXOMDocument> ov, FXOMDocument od, FXOMDocument nd) {
                assert (editorController.getFxomDocument() == nd);
                if (od != null) {
                    od.sceneGraphRevisionProperty().removeListener(SkeletonWindowController.this.fxomDocumentRevisionListener);
                }
                if (nd != null) {
                    nd.sceneGraphRevisionProperty().addListener(SkeletonWindowController.this.fxomDocumentRevisionListener);
                    SkeletonWindowController.this.update();
                }
            }
        });
        if (editorController.getFxomDocument() != null) {
            editorController.getFxomDocument().sceneGraphRevisionProperty().addListener(this.fxomDocumentRevisionListener);
        }
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.getStage().close();
    }

    @Override
    public void openWindow() {
        super.openWindow();
        if (this.dirty) {
            this.update();
        }
    }

    @Override
    protected void controllerDidLoadFxml() {
        super.controllerDidLoadFxml();
        assert (this.commentCheckBox != null);
        assert (this.formatCheckBox != null);
        assert (this.textArea != null);
        this.commentCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                SkeletonWindowController.this.update();
            }
        });
        this.formatCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                SkeletonWindowController.this.update();
            }
        });
        this.update();
    }

    private void updateTitle() {
        String documentName = DocumentWindowController.makeTitle(this.editorController.getFxomDocument());
        String title = I18N.getString("skeleton.window.title", documentName);
        this.getStage().setTitle(title);
    }

    private void update() {
        assert (this.editorController.getFxomDocument() != null);
        if (this.getStage().isShowing()) {
            this.updateTitle();
            SkeletonBuffer buf = new SkeletonBuffer(this.editorController.getFxomDocument());
            if (this.commentCheckBox.isSelected()) {
                buf.setTextType(SkeletonBuffer.TEXT_TYPE.WITH_COMMENTS);
            } else {
                buf.setTextType(SkeletonBuffer.TEXT_TYPE.WITHOUT_COMMENTS);
            }
            if (this.formatCheckBox.isSelected()) {
                buf.setFormat(SkeletonBuffer.FORMAT_TYPE.FULL);
            } else {
                buf.setFormat(SkeletonBuffer.FORMAT_TYPE.COMPACT);
            }
            this.textArea.setText(buf.toString());
            this.dirty = false;
        } else {
            this.dirty = true;
        }
    }
}

