/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.template;

import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class FxmlTemplates {
    public static URL getContentURL(SceneBuilderApp.ApplicationControlAction action) {
        String name = FxmlTemplates.getTemplateFileName(action);
        return FxmlTemplates.class.getResource(name);
    }

    public static String getTemplateName(SceneBuilderApp.ApplicationControlAction action) {
        String name = FxmlTemplates.getTemplateFileName(action);
        return name.substring(0, name.indexOf(".fxml"));
    }

    public static String getTemplateFileName(SceneBuilderApp.ApplicationControlAction action) {
        String name;
        switch (action) {
            case NEW_ALERT_DIALOG: {
                name = "AlertDialog.fxml";
                break;
            }
            case NEW_ALERT_DIALOG_CSS: {
                name = "AlertDialog_css.fxml";
                break;
            }
            case NEW_ALERT_DIALOG_I18N: {
                name = "AlertDialog_i18n.fxml";
                break;
            }
            case NEW_BASIC_APPLICATION: {
                name = "BasicApplication.fxml";
                break;
            }
            case NEW_BASIC_APPLICATION_CSS: {
                name = "BasicApplication_css.fxml";
                break;
            }
            case NEW_BASIC_APPLICATION_I18N: {
                name = "BasicApplication_i18n.fxml";
                break;
            }
            case NEW_COMPLEX_APPLICATION: {
                name = "ComplexApplication.fxml";
                break;
            }
            case NEW_COMPLEX_APPLICATION_CSS: {
                name = "ComplexApplication_css.fxml";
                break;
            }
            case NEW_COMPLEX_APPLICATION_I18N: {
                name = "ComplexApplication_i18n.fxml";
                break;
            }
            default: {
                name = null;
            }
        }
        return name;
    }

    public static Set<String> getResourceFileNames(SceneBuilderApp.ApplicationControlAction action) {
        HashSet<String> names = new HashSet<String>();
        switch (action) {
            case NEW_ALERT_DIALOG_CSS: {
                names.add("AlertDialog.css");
                names.add("AlertDialog.png");
                break;
            }
            case NEW_ALERT_DIALOG_I18N: {
                names.add("AlertDialog.css");
                names.add("AlertDialog.png");
                names.add("AlertDialog_en.properties");
                names.add("AlertDialog_fr.properties");
                break;
            }
            case NEW_BASIC_APPLICATION_CSS: {
                names.add("BasicApplication.css");
                break;
            }
            case NEW_BASIC_APPLICATION_I18N: {
                names.add("BasicApplication.css");
                names.add("BasicApplication_en.properties");
                names.add("BasicApplication_fr.properties");
                break;
            }
            case NEW_COMPLEX_APPLICATION_CSS: {
                names.add("ComplexApplication.css");
                break;
            }
            case NEW_COMPLEX_APPLICATION_I18N: {
                names.add("ComplexApplication.css");
                names.add("ComplexApplication_en.properties");
                names.add("ComplexApplication_fr.properties");
                break;
            }
        }
        return names;
    }
}

