/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.template;

import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.app.template.FxmlTemplates;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AbstractModalDialog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.ErrorDialog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.stage.DirectoryChooser;

public class TemplateDialogController
extends AbstractModalDialog {
    @FXML
    private Button chooseButton;
    @FXML
    private Label detailsLabel;
    @FXML
    private Label messageLabel;
    @FXML
    private TextField locationTextField;
    @FXML
    private TextField nameTextField;
    private final SceneBuilderApp.ApplicationControlAction template;

    public TemplateDialogController(SceneBuilderApp.ApplicationControlAction template) {
        super(TemplateDialogController.class.getResource("TemplateDialog.fxml"), I18N.getBundle(), null);
        this.template = template;
    }

    @Override
    protected void controllerDidLoadFxml() {
        super.controllerDidLoadFxml();
        this.setActionButtonVisible(false);
        this.setDefaultButtonID(AbstractModalDialog.ButtonID.OK);
        this.setShowDefaultButton(true);
        String title = MessageFormat.format(I18N.getString("template.title.new.project"), FxmlTemplates.getTemplateName(this.template));
        this.getStage().setTitle(title);
    }

    @Override
    protected void controllerDidLoadContentFxml() {
        this.nameTextField.textProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                TemplateDialogController.this.updateDetails();
                TemplateDialogController.this.updateOkButtonState();
            }
        });
        this.locationTextField.textProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                TemplateDialogController.this.updateDetails();
                TemplateDialogController.this.updateOkButtonState();
            }
        });
        this.nameTextField.setText(FxmlTemplates.getTemplateName(this.template));
        File initialDirectory = SceneBuilderApp.getSingleton().getNextInitialDirectory();
        if (initialDirectory != null) {
            this.locationTextField.setText(initialDirectory.getAbsolutePath());
        } else {
            this.locationTextField.setText(System.getProperty("user.home"));
        }
    }

    public File getNewProjectDirectory() {
        String location = this.locationTextField.getText().trim();
        String name = this.nameTextField.getText().trim();
        return new File(location, name);
    }

    @FXML
    public void chooseButtonPressed(ActionEvent e) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        File selectedDir = directoryChooser.showDialog(this.getStage().getOwner());
        if (selectedDir != null) {
            this.locationTextField.setText(selectedDir.getAbsolutePath());
        }
    }

    public void locationTextFieldOnAction(ActionEvent e) {
        this.locationTextField.selectAll();
    }

    public void nameTextFieldOnAction(ActionEvent e) {
        this.nameTextField.selectAll();
    }

    @Override
    protected void okButtonPressed(ActionEvent e) {
        File newProjectDirectory = this.getNewProjectDirectory();
        assert (newProjectDirectory.mkdir());
        try {
            Files.createDirectories(newProjectDirectory.toPath(), new FileAttribute[0]);
            if (this.createTemplateFiles(newProjectDirectory)) {
                String fxmlFileName = FxmlTemplates.getTemplateFileName(this.template);
                File fxmlFile = new File(newProjectDirectory, fxmlFileName);
                DocumentWindowController newTemplateWindow = SceneBuilderApp.getSingleton().makeNewWindow();
                newTemplateWindow.loadFromFile(fxmlFile);
                newTemplateWindow.openWindow();
            }
        }
        catch (IOException ex) {
            ErrorDialog errorDialog = new ErrorDialog(null);
            errorDialog.setMessage(I18N.getString("alert.open.failure1.message", this.getStage().getTitle()));
            errorDialog.setDetails(I18N.getString("alert.open.failure1.details"));
            errorDialog.setDebugInfoWithThrowable(ex);
            errorDialog.setTitle(I18N.getString("alert.title.open"));
            errorDialog.showAndWait();
        }
        SceneBuilderApp.getSingleton().updateNextInitialDirectory(newProjectDirectory);
        this.closeWindow();
    }

    @Override
    protected void cancelButtonPressed(ActionEvent e) {
        this.closeWindow();
    }

    @Override
    protected void actionButtonPressed(ActionEvent e) {
        throw new IllegalStateException();
    }

    private boolean createTemplateFiles(File newProjectDirectory) {
        File toFxmlFile;
        assert (newProjectDirectory.exists());
        String fxmlFileName = FxmlTemplates.getTemplateFileName(this.template);
        InputStream fromFxmlFile = TemplateDialogController.class.getResourceAsStream(fxmlFileName);
        if (!this.copyFile(fromFxmlFile, toFxmlFile = new File(newProjectDirectory, fxmlFileName), StandardCopyOption.REPLACE_EXISTING)) {
            return false;
        }
        for (String resourceFileName : FxmlTemplates.getResourceFileNames(this.template)) {
            File toResourceFile;
            InputStream fromResourceFile = TemplateDialogController.class.getResourceAsStream(resourceFileName);
            if (this.copyFile(fromResourceFile, toResourceFile = new File(newProjectDirectory, resourceFileName), StandardCopyOption.REPLACE_EXISTING)) continue;
            return false;
        }
        return true;
    }

    private void updateOkButtonState() {
        String location = this.locationTextField.getText().trim();
        File newProjectDirectory = this.getNewProjectDirectory();
        boolean disabled = false;
        if (!new File(location).exists()) {
            this.messageLabel.setText(MessageFormat.format(I18N.getString("template.location.does.not.exist"), location));
            disabled = true;
        } else if (newProjectDirectory.exists()) {
            this.messageLabel.setText(MessageFormat.format(I18N.getString("template.name.already.exists"), newProjectDirectory.getName()));
            disabled = true;
        } else if (!this.isValidFileName(newProjectDirectory)) {
            this.messageLabel.setText(MessageFormat.format(I18N.getString("template.cannot.create"), newProjectDirectory.getAbsolutePath()));
            disabled = true;
        }
        if (disabled) {
            this.messageLabel.setVisible(true);
        } else {
            this.messageLabel.setVisible(false);
        }
        this.setOKButtonDisable(disabled);
    }

    private boolean isValidFileName(File file) {
        boolean isValid = true;
        try {
            if (file.mkdir()) {
                if (!file.delete()) {
                    isValid = false;
                }
            } else {
                isValid = false;
            }
        }
        catch (RuntimeException e) {
            isValid = false;
        }
        return isValid;
    }

    private void updateDetails() {
        String location = this.locationTextField.getText().trim();
        String name = this.nameTextField.getText().trim();
        String path = location + File.separator + name + File.separator;
        String fxmlFileName = FxmlTemplates.getTemplateFileName(this.template);
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        sb.append(fxmlFileName);
        for (String resourceFileName : FxmlTemplates.getResourceFileNames(this.template)) {
            sb.append("\n");
            sb.append(path);
            sb.append(resourceFileName);
        }
        this.detailsLabel.setText(sb.toString());
    }

    private boolean copyFile(InputStream in, File toFile, CopyOption ... options) {
        try {
            Path target = Paths.get(toFile.toURI());
            Files.copy(in, target, options);
        }
        catch (IOException ioe) {
            ErrorDialog errorDialog = new ErrorDialog(null);
            errorDialog.setMessage(I18N.getString("alert.copy.failure.message", this.getStage().getTitle()));
            errorDialog.setDebugInfoWithThrowable(ioe);
            errorDialog.setTitle(I18N.getString("alert.title.copy"));
            errorDialog.showAndWait();
            return false;
        }
        return true;
    }
}

