/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Timer;
import java.util.TimerTask;

class FileMutex {
    private final Path lockFile;
    private FileLock lock;

    public FileMutex(Path lockFile) {
        assert (lockFile != null);
        this.lockFile = lockFile;
    }

    public Path getLockFile() {
        return this.lockFile;
    }

    public void lock(long timeout) throws IOException {
        assert (this.lock == null);
        FileChannel channel = this.createFileChannel();
        Timer timer = new Timer();
        timer.schedule((TimerTask)new InterruptTask(), timeout);
        this.lock = channel.lock();
        timer.cancel();
        assert (this.lock != null);
    }

    public boolean tryLock() throws IOException {
        assert (this.lock == null);
        FileChannel channel = this.createFileChannel();
        this.lock = channel.tryLock();
        if (this.lock == null) {
            channel.close();
        }
        return this.lock != null;
    }

    public void unlock() throws IOException {
        assert (this.lock != null);
        this.lock.release();
        this.lock.channel().close();
        this.lock = null;
    }

    public boolean isLocked() {
        return this.lock != null;
    }

    private FileChannel createFileChannel() throws IOException {
        try {
            Files.createFile(this.lockFile, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException x) {
            // empty catch block
        }
        RandomAccessFile raf = new RandomAccessFile(this.lockFile.toFile(), "rw");
        return raf.getChannel();
    }

    private static class InterruptTask
    extends TimerTask {
        private InterruptTask() {
        }

        @Override
        public void run() {
            Thread.currentThread().interrupt();
        }
    }
}

