/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.PromptData;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.scene.web.WebViewBuilder;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WebBrowser2
implements Runnable,
LayoutManager,
ActionListener {
    public static final int WIDTH = 640;
    public static final int HEIGHT = 480;
    public static final String VERSION = "V1.0.0a";
    private Stage primaryStage = null;
    private Scene scene = null;
    private Vector<Context> contextVec = new Vector();
    private JFXPanel jfxPanel;
    private WebEngine engine;
    private JFrame frame = new JFrame("Matt Web Browser V1.0.0a");
    private JPanel panel = new JPanel(new BorderLayout());
    private JTextField lblStatus = new JTextField();
    private JTextField txtURL = new JTextField();
    private JProgressBar progressBar = new JProgressBar();
    private String currentURL = null;
    private JPanel statusBar = null;
    private JScrollPane scrollPane = null;
    private JButton stopButton = null;
    private JButton refreshButton = null;
    private JButton homeButton = null;
    private JButton backButton = null;
    private JButton nextButton = null;
    private JTabbedPane tabCtrl = null;
    private JMenuItem newWindowMenuItem = null;
    private JMenuItem newTabMenuItem = null;
    private JMenuItem quitMenuItem = null;
    private JMenuBar menuBar = null;
    private JMenu menu;
    private JMenu submenu = null;
    private JMenuItem menuItem = null;
    private JMenuItem gtkItem = null;
    private JMenuItem winItem = null;
    private JMenuItem unixItem = null;
    private JMenuItem javaItem = null;
    private Properties props = null;
    private static int winCount = 1;
    private String url = "http://www.google.com/";
    private String google_redirect = "http://www.google.com/url?";
    private String home_page = "http://www.google.com/";
    private String home_page_title = "Google";
    private JMenu bookmark_menu = null;
    private WebView view = null;
    public LinkedList<Context> ctxList = new LinkedList();
    private static boolean DEBUG_FLAG = true;

    private WebView buildWebView(String url) {
        WebView webView;
        this.view = webView = WebViewBuilder.create().build();
        this.engine = webView.getEngine();
        webView.getEngine().load(url);
        return webView;
    }

    private Pane preparePage(String title, String url) {
        BorderPane pane = new BorderPane((Node)this.buildWebView(url));
        return pane;
    }

    private void bind(Pane pane, Scene scene) {
        pane.prefHeightProperty().bind((ObservableValue)scene.heightProperty());
        pane.prefWidthProperty().bind((ObservableValue)scene.widthProperty());
    }

    private Scene getNewScene(String title, String url) {
        Group rootGroup = new Group();
        TreeMap titleToUrl = new TreeMap();
        Pane pane = this.preparePage(title, url);
        rootGroup.getChildren().add((Object)pane);
        Scene scene = new Scene((Parent)rootGroup, 640.0, 480.0, (Paint)Color.WHITE);
        this.bind(pane, scene);
        return scene;
    }

    public Context getContext() {
        Context ctx = new Context();
        ctx.jfxPanel = new JFXPanel();
        ctx.view = this.view;
        ctx.scene = this.scene;
        ctx.engine = this.engine;
        ctx.url = this.currentURL;
        return ctx;
    }

    public void swapin(Context ctx) {
        this.jfxPanel = ctx.jfxPanel;
        this.view = ctx.view;
        this.scene = ctx.scene;
        this.engine = ctx.engine;
        this.currentURL = ctx.url;
        this.txtURL.setText(this.currentURL);
    }

    public void swapout(Context ctx) {
        ctx.jfxPanel = this.jfxPanel;
        ctx.view = this.view;
        ctx.scene = this.scene;
        ctx.engine = this.engine;
        ctx.url = this.currentURL;
    }

    public void debug(String str) {
        if (DEBUG_FLAG) {
            System.err.println(str);
        }
    }

    public ImageIcon getImageIcon(String fileName) {
        URL imageURL = WebBrowser2.class.getResource(fileName);
        return new ImageIcon(imageURL);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.txtURL)) {
            this.currentURL = this.txtURL.getText();
            this.debug("ENTER: " + this.currentURL);
            if (this.currentURL.length() == 0) {
                return;
            }
            this.lblStatus.setText("get: " + this.currentURL);
            try {
                this.lblStatus.setText("connecting...");
                this.loadURL(this.currentURL);
                this.lblStatus.setText("done...");
            }
            catch (Exception ex) {
                this.lblStatus.setText("connection error...");
                JOptionPane.showMessageDialog(this.frame, "Connection error...", "Connection error...", 0);
            }
        } else if (e.getSource().equals(this.refreshButton)) {
            this.lblStatus.setText("refreshing...");
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    WebBrowser2.this.engine.reload();
                }
            });
            this.lblStatus.setText("done...");
        } else if (e.getSource().equals(this.homeButton)) {
            this.currentURL = this.props.getProperty("home.page");
            this.debug("HOME: " + this.currentURL);
            this.lblStatus.setText("connecting...");
            this.loadURL(this.currentURL);
            this.txtURL.setText(this.currentURL);
            this.lblStatus.setText("done...");
        } else if (e.getSource().equals(this.backButton)) {
            final WebHistory history = this.engine.getHistory();
            this.txtURL.setText(this.currentURL);
            if (history.getCurrentIndex() >= 1) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        history.go(-1);
                    }
                });
            }
        } else if (e.getSource().equals(this.nextButton)) {
            final WebHistory history = this.engine.getHistory();
            if (history.getCurrentIndex() + 1 < history.getEntries().size()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        history.go(1);
                    }
                });
            }
        } else if (e.getSource().equals(this.newWindowMenuItem)) {
            ++winCount;
            WebBrowser2 browser = new WebBrowser2();
            new Thread(browser).start();
        } else if (e.getSource().equals(this.newTabMenuItem)) {
            try {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WebBrowser2.this.currentURL = WebBrowser2.this.home_page;
                        Context ctx = WebBrowser2.this.getContext();
                        WebBrowser2.this.contextVec.add(ctx);
                        WebBrowser2.this.scene = WebBrowser2.this.getNewScene("Loading...", WebBrowser2.this.home_page);
                        ctx.jfxPanel.setScene(WebBrowser2.this.scene);
                        WebBrowser2.this.createScene();
                        ctx.engine = WebBrowser2.this.engine;
                        ctx.view = WebBrowser2.this.view;
                        ctx.scene = WebBrowser2.this.scene;
                        WebBrowser2.this.tabCtrl.addTab("New Tab", WebBrowser2.this.getImageIcon("file.gif"), (Component)ctx.jfxPanel);
                        WebBrowser2.this.tabCtrl.setSelectedIndex(WebBrowser2.this.tabCtrl.getTabCount() - 1);
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
                JOptionPane.showMessageDialog(this.frame, "Unable to create new web browser window...", "Error...", 0);
            }
        } else if (e.getSource().equals(this.gtkItem)) {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                SwingUtilities.updateComponentTreeUI(this.frame);
                this.frame.pack();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        } else if (e.getSource().equals(this.winItem)) {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                SwingUtilities.updateComponentTreeUI(this.frame);
                this.frame.pack();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        } else if (e.getSource().equals(this.javaItem)) {
            try {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                SwingUtilities.updateComponentTreeUI(this.frame);
                this.frame.pack();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        } else if (e.getSource().equals(this.unixItem)) {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                SwingUtilities.updateComponentTreeUI(this.frame);
                this.frame.pack();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        } else if (e.getSource().equals(this.quitMenuItem)) {
            if (winCount == 1) {
                this.frame.setVisible(false);
                System.exit(0);
            } else {
                --winCount;
                this.frame.setVisible(false);
                this.frame.dispose();
            }
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        Rectangle dim = parent.getBounds();
        int h = 40;
        this.txtURL.setSize(dim.width - 6, h - 6);
        this.txtURL.setLocation(3, h);
        int stat_h = 40;
        this.tabCtrl.setSize(dim.width - 6, dim.height - (stat_h + 80) - 6);
        this.tabCtrl.setLocation(3, h * 2 - 3);
        int w = dim.width / 5;
        this.backButton.setLocation(3, 3);
        this.backButton.setSize(w - 6, h - 6);
        this.nextButton.setLocation(w + 3, 3);
        this.nextButton.setSize(w - 6, h - 6);
        this.stopButton.setLocation(w + w + 3, 3);
        this.stopButton.setSize(w - 6, h - 6);
        this.refreshButton.setLocation(w + w + w + 3, 3);
        this.refreshButton.setSize(w - 6, h - 6);
        this.homeButton.setLocation(w + w + w + w + 3, 3);
        this.homeButton.setSize(w - 6, h - 6);
        this.statusBar.setLocation(3, dim.height - h - 6);
        this.statusBar.setSize(dim.width - 6, h - 6);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(640, 480);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(640, 480);
    }

    private void initComponents() {
        this.jfxPanel = new JFXPanel();
        this.createScene();
        this.txtURL.addActionListener(this);
        ImageIcon img = this.getImageIcon("home.gif");
        this.homeButton = new JButton("Home", img);
        this.homeButton.addActionListener(this);
        img = this.getImageIcon("back.gif");
        this.backButton = new JButton("Back", img);
        this.backButton.addActionListener(this);
        img = this.getImageIcon("forward.gif");
        this.nextButton = new JButton("Forward", img);
        this.nextButton.addActionListener(this);
        img = this.getImageIcon("stop.gif");
        this.stopButton = new JButton("Stop", img);
        this.stopButton.addActionListener(this);
        img = this.getImageIcon("refresh.gif");
        this.refreshButton = new JButton("Refresh", img);
        this.refreshButton.addActionListener(this);
        this.frame.getContentPane().setLayout(this);
        this.menuBar = new JMenuBar();
        this.menu = new JMenu("File");
        this.menuBar.add(this.menu);
        this.newTabMenuItem = this.menuItem = new JMenuItem("New Tab", this.getImageIcon("file.gif"));
        this.newTabMenuItem.addActionListener(this);
        this.menu.add(this.newTabMenuItem);
        this.menuItem = this.menuItem = new JMenuItem("Close Tab", this.getImageIcon("file.gif"));
        this.menuItem.addActionListener(new CloseTabAction());
        this.menu.add(this.menuItem);
        this.newWindowMenuItem = this.menuItem = new JMenuItem("New Window", this.getImageIcon("file.gif"));
        this.newWindowMenuItem.addActionListener(this);
        this.menu.add(this.newWindowMenuItem);
        this.menuItem = new JMenuItem("Open", this.getImageIcon("file.gif"));
        this.menu.add(this.menuItem);
        this.menuItem = new JMenuItem("Save", this.getImageIcon("file.gif"));
        this.menu.add(this.menuItem);
        this.menuItem = new JMenuItem("Save As", this.getImageIcon("file.gif"));
        this.menu.add(this.menuItem);
        this.menuItem = new JMenuItem("Properties", this.getImageIcon("file.gif"));
        this.menu.add(this.menuItem);
        this.menuItem = new JMenuItem("Close", this.getImageIcon("file.gif"));
        this.menu.add(this.menuItem);
        this.quitMenuItem = new JMenuItem("Exit", this.getImageIcon("file.gif"));
        this.quitMenuItem.addActionListener(this);
        this.menu.add(this.quitMenuItem);
        this.menu = new JMenu("Edit");
        this.menuItem = new JMenuItem("Cut", this.getImageIcon("file.gif"));
        this.menu.add(this.menuItem);
        this.menuItem = new JMenuItem("Copy", this.getImageIcon("file.gif"));
        this.menu.add(this.menuItem);
        this.menuItem = new JMenuItem("Paste", this.getImageIcon("file.gif"));
        this.menu.add(this.menuItem);
        this.menuItem = new JMenuItem("Find", this.getImageIcon("file.gif"));
        this.menuItem.addActionListener(new Find());
        this.menu.add(this.menuItem);
        this.menuItem = new JMenuItem("View Source", this.getImageIcon("file.gif"));
        this.menuItem.addActionListener(new ViewSource());
        this.menu.add(this.menuItem);
        this.menuBar.add(this.menu);
        this.menu = new JMenu("View");
        this.winItem = new JMenuItem("Windows View", this.getImageIcon("file.gif"));
        this.winItem.addActionListener(this);
        this.menu.add(this.winItem);
        this.gtkItem = new JMenuItem("GTK View", this.getImageIcon("file.gif"));
        this.gtkItem.addActionListener(this);
        this.menu.add(this.gtkItem);
        this.unixItem = new JMenuItem("UNIX View", this.getImageIcon("file.gif"));
        this.unixItem.addActionListener(this);
        this.menu.add(this.unixItem);
        this.javaItem = new JMenuItem("Java View", this.getImageIcon("file.gif"));
        this.javaItem.addActionListener(this);
        this.menu.add(this.javaItem);
        this.menuBar.add(this.menu);
        this.bookmark_menu = this.menu = new JMenu("Bookmarks");
        this.menuItem = new JMenuItem("Bookmark Page", this.getImageIcon("file.gif"));
        this.menuItem.addActionListener(new BookmarkAction());
        this.menu.add(this.menuItem);
        try {
            CSVFileReader csv = new CSVFileReader("bookmarks.txt", true);
            csv.open();
            while (csv.readLine()) {
                this.menuItem = new JMenuItem(csv.getValue("title"), this.getImageIcon("file.gif"));
                this.menuItem.addActionListener(new BookmarkHandler(csv.getValue("url")));
                this.menu.add(this.menuItem);
            }
            csv.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        this.menuBar.add(this.menu);
        this.menu = new JMenu("Tools");
        this.menuItem = new JMenuItem("Java Console", this.getImageIcon("file.gif"));
        this.menuItem.addActionListener(new JavaConsole());
        this.menu.add(this.menuItem);
        this.menuBar.add(this.menu);
        this.menu = new JMenu("Help");
        this.menuItem = new JMenuItem("Documentation", this.getImageIcon("file.gif"));
        this.menu.add(this.menuItem);
        this.menuItem = new JMenuItem("About", this.getImageIcon("file.gif"));
        this.menu.add(this.menuItem);
        this.menuBar.add(this.menu);
        this.frame.setJMenuBar(this.menuBar);
        this.progressBar.setPreferredSize(new Dimension(200, 40));
        this.progressBar.setStringPainted(true);
        this.statusBar = new JPanel(new MyLayout());
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        this.lblStatus.setEditable(false);
        this.statusBar.add(this.lblStatus);
        this.statusBar.add(this.progressBar);
        this.frame.getContentPane().add(this.stopButton);
        this.frame.getContentPane().add(this.refreshButton);
        this.frame.getContentPane().add(this.homeButton);
        this.frame.getContentPane().add(this.backButton);
        this.frame.getContentPane().add(this.nextButton);
        this.frame.getContentPane().add(this.txtURL);
        this.currentURL = this.home_page;
        final Context ctx = this.getContext();
        this.tabCtrl = new JTabbedPane();
        this.jfxPanel = ctx.jfxPanel;
        this.contextVec.add(ctx);
        this.tabCtrl.addChangeListener(new TabChangeListener());
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ctx.jfxPanel.setScene(WebBrowser2.this.getNewScene(WebBrowser2.this.home_page_title, WebBrowser2.this.home_page));
                WebBrowser2.this.createScene();
                ctx.engine = WebBrowser2.this.engine;
                ctx.view = WebBrowser2.this.view;
                ctx.scene = WebBrowser2.this.scene;
                WebBrowser2.this.tabCtrl.addTab(WebBrowser2.this.home_page_title, WebBrowser2.this.getImageIcon("file.gif"), (Component)ctx.jfxPanel);
                WebBrowser2.this.txtURL.setText(WebBrowser2.this.home_page);
            }
        });
        this.frame.getContentPane().add(this.tabCtrl);
        this.frame.getContentPane().add(this.statusBar);
        this.loadURL(this.home_page);
        try {
            this.props = new Properties();
            this.props.load(new FileInputStream("web_browser.properties"));
            if (this.url == "") {
                this.home_page = this.currentURL = this.props.getProperty("home.page");
                this.home_page_title = this.currentURL = this.props.getProperty("home.page.title");
            }
            this.lblStatus.setText("Welcome...");
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }

    private void createScene() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (WebBrowser2.this.view == null) {
                    WebBrowser2.this.view = new WebView();
                }
                if (WebBrowser2.this.engine == null) {
                    WebBrowser2.this.engine = WebBrowser2.this.view.getEngine();
                }
                WebBrowser2.this.engine.setUserAgent("Matt Web Browser: V1.0.0a");
                WebBrowser2.this.engine.setJavaScriptEnabled(true);
                WebBrowser2.this.engine.setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

                    public void handle(WebEvent<String> ev) {
                        String message = (String)ev.getData();
                        JOptionPane.showMessageDialog(WebBrowser2.this.frame, message, message, 1);
                    }
                });
                WebBrowser2.this.engine.setConfirmHandler((Callback)new Callback<String, Boolean>(){

                    public Boolean call(String message) {
                        int ret = JOptionPane.showConfirmDialog(WebBrowser2.this.frame, message, message, 0);
                        if (ret == 0) {
                            return new Boolean(true);
                        }
                        return new Boolean(false);
                    }
                });
                WebBrowser2.this.engine.setPromptHandler((Callback)new Callback<PromptData, String>(){

                    public String call(PromptData message) {
                        String ret = JOptionPane.showInputDialog(WebBrowser2.this.frame, message.getMessage(), message.getMessage(), 3);
                        return ret;
                    }
                });
                WebBrowser2.this.engine.titleProperty().addListener((javafx.beans.value.ChangeListener)new javafx.beans.value.ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> observable, final String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                int index = WebBrowser2.this.tabCtrl.getSelectedIndex();
                                String temp = "";
                                if (newValue != null) {
                                    temp = new String(newValue);
                                }
                                if (index >= 0) {
                                    if (temp.equals("")) {
                                        temp = "Unknown";
                                    }
                                    if (oldValue != null) {
                                        temp = oldValue;
                                    }
                                    WebBrowser2.this.tabCtrl.setTitleAt(index, temp);
                                }
                            }
                        });
                    }
                });
                WebBrowser2.this.engine.setOnStatusChanged((EventHandler)new EventHandler<WebEvent<String>>(){

                    public void handle(final WebEvent<String> event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                WebBrowser2.this.lblStatus.setText((String)event.getData());
                            }
                        });
                    }
                });
                WebBrowser2.this.engine.locationProperty().addListener((javafx.beans.value.ChangeListener)new javafx.beans.value.ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> ov, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                WebBrowser2.this.currentURL = newValue;
                                WebBrowser2.this.debug("CLICK: " + WebBrowser2.this.currentURL);
                                WebBrowser2.this.txtURL.setText(newValue);
                            }
                        });
                    }
                });
                WebBrowser2.this.engine.getLoadWorker().workDoneProperty().addListener((javafx.beans.value.ChangeListener)new javafx.beans.value.ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, final Number newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                WebBrowser2.this.progressBar.setValue(newValue.intValue());
                            }
                        });
                    }
                });
                WebBrowser2.this.engine.getLoadWorker().exceptionProperty().addListener((javafx.beans.value.ChangeListener)new javafx.beans.value.ChangeListener<Throwable>(){

                    public void changed(ObservableValue<? extends Throwable> o, Throwable old, final Throwable value) {
                        if (WebBrowser2.this.engine.getLoadWorker().getState() == Worker.State.FAILED) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(WebBrowser2.this.panel, value != null ? WebBrowser2.this.engine.getLocation() + "\n" + value.getMessage() : WebBrowser2.this.engine.getLocation() + "\nUnexpected error.", "Loading error...", 0);
                                }
                            });
                        }
                    }
                });
                WebBrowser2.this.engine.setCreatePopupHandler((Callback)new Callback<PopupFeatures, WebEngine>(){

                    public WebEngine call(PopupFeatures popupFeatures) {
                        System.out.println("Popup: " + popupFeatures);
                        return WebBrowser2.this.engine;
                    }
                });
            }
        });
    }

    public void loadURL(final String the_url) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                System.err.println("the_url=[" + the_url + "]");
                String currentURL = WebBrowser2.toURL(the_url);
                System.err.println("currentURL=[" + currentURL + "]");
                if (WebBrowser2.this.engine != null) {
                    WebBrowser2.this.engine.load(currentURL);
                }
            }
        });
    }

    private static String toURL(String str) {
        if (str.indexOf("http://") != 0 && str.indexOf("https://") != 0) {
            return "http://" + str;
        }
        return str;
    }

    @Override
    public void run() {
        this.frame.setPreferredSize(new Dimension(1024, 600));
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                winCount--;
                if (winCount <= 0) {
                    System.exit(0);
                }
            }
        });
        this.initComponents();
        this.frame.pack();
        this.frame.setVisible(true);
        this.frame.setExtendedState(this.frame.getExtendedState() | 6);
    }

    public static void main(String[] args) {
        new WebBrowser2().run();
    }

    public class ViewSource
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            WebBrowser2.this.debug("ViewSource...");
            final JFrame frame = new JFrame("View Source");
            JTextArea text = new JTextArea();
            text.setEditable(false);
            try {
                int ch;
                StringBuffer data = new StringBuffer();
                URL url = new URL(WebBrowser2.this.currentURL);
                InputStream in = url.openConnection().getInputStream();
                while ((ch = in.read()) != -1) {
                    data.append((char)ch);
                }
                in.close();
                text.setText(data.toString());
            }
            catch (IOException data) {
                // empty catch block
            }
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    frame.setVisible(false);
                    frame.dispose();
                }
            });
            frame.setLayout(new GridLayout(1, 1));
            JScrollPane scroll = new JScrollPane(text);
            frame.getContentPane().add(scroll);
            frame.setSize(640, 480);
            frame.setVisible(true);
        }
    }

    public class JavaConsole
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            final JFrame frame = new JFrame("Java Console");
            JTextArea text = new JTextArea();
            text.setText("Matt Web Browser: V1.0.0a\n\nWelcome to the java console...\n\n");
            text.setEditable(false);
            frame.setLayout(new GridLayout(1, 1));
            JScrollPane scroll = new JScrollPane(text);
            frame.getContentPane().add(scroll);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    frame.setVisible(false);
                    frame.dispose();
                }
            });
            frame.pack();
            frame.setSize(640, 480);
            frame.setVisible(true);
        }
    }

    public class Find
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String ret = JOptionPane.showInputDialog(WebBrowser2.this.frame, "Find on this page", "Search current page", 3);
        }
    }

    public class MyLayout
    implements LayoutManager {
        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(640, 40);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            Rectangle dim = parent.getBounds();
            WebBrowser2.this.progressBar.setLocation(dim.width - 200 + 3, dim.height - 40 + 6);
            WebBrowser2.this.progressBar.setSize(194, 34);
            WebBrowser2.this.lblStatus.setLocation(3, dim.height - 40 + 6);
            WebBrowser2.this.lblStatus.setSize(dim.width - 200 - 6, 34);
        }
    }

    public class CloseTabAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            int index = WebBrowser2.this.tabCtrl.getSelectedIndex();
            WebBrowser2.this.tabCtrl.remove(index);
            ((Context)((WebBrowser2)WebBrowser2.this).contextVec.get((int)index)).jfxPanel.setEnabled(false);
            WebBrowser2.this.contextVec.remove(index);
            if (index < WebBrowser2.this.contextVec.size()) {
                WebBrowser2.this.swapin((Context)WebBrowser2.this.contextVec.get(index));
            }
        }
    }

    public class BookmarkHandler
    implements ActionListener {
        private String url;

        public BookmarkHandler(String url) {
            this.url = url;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WebBrowser2.this.debug("BOOKBARK: " + this.url);
            WebBrowser2.this.currentURL = this.url;
            WebBrowser2.this.lblStatus.setText("connecting...");
            WebBrowser2.this.loadURL(this.url);
            WebBrowser2.this.lblStatus.setText("done...");
        }
    }

    public class BookmarkAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FileOutputStream fout = new FileOutputStream("bookmarks.txt", true);
                PrintStream pout = new PrintStream(fout);
                String title = WebBrowser2.this.frame.getTitle();
                pout.println("\"" + WebBrowser2.this.currentURL + "\",\"" + title + "\"");
                pout.flush();
                fout.close();
                JMenuItem bookmark = new JMenuItem(title, WebBrowser2.this.getImageIcon("file.gif"));
                bookmark.addActionListener(new BookmarkHandler(WebBrowser2.this.currentURL));
                WebBrowser2.this.bookmark_menu.add(bookmark);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
            }
        }
    }

    public class Context {
        public JFXPanel jfxPanel = null;
        public WebView view = null;
        public Scene scene = null;
        public WebEngine engine = null;
        public String url = null;
    }

    public class TabChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            int index = WebBrowser2.this.tabCtrl.getSelectedIndex();
            if (index >= 0 && index < WebBrowser2.this.contextVec.size() && index < WebBrowser2.this.tabCtrl.getTabCount()) {
                Context ctx = (Context)WebBrowser2.this.contextVec.get(index);
                WebBrowser2.this.swapin(ctx);
            }
        }
    }
}

