/*

(C) Copyright 2011.  All rights reserved.
Intellectual proplerty of Matthew William Coan.

Simple Web Browser Written in the Java Programming Language using 
the JFC or Swing software library.

@author Matthew William Coan
@version Sat Feb 12 17:23:24 EST 2011

*/

import java.awt.*;
import java.awt.event.*;

import java.net.*;
import java.io.*;

import java.util.*;

import javax.swing.*;
import javax.swing.event.*;

import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import static javafx.concurrent.Worker.State.FAILED;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;


public class WebBrowser extends Thread 
implements Runnable, HyperlinkListener, LayoutManager, ActionListener, WindowListener  {
   public static final int WIDTH = 640;
   public static final int HEIGHT = 480;

   private String currentURL = null;
   private JEditorPane editorPane = null;
   private JTextField urlText = null;
   private JTextField statusBar = null;
   private JScrollPane scrollPane = null;
   private JButton goButton = null;
   private JButton stopButton = null;
   private JButton refreshButton = null;
   private JButton homeButton = null;
   private JButton backButton = null;
   private JButton nextButton = null;
   private JMenuItem newMenuItem = null;
   private JMenuItem quitMenuItem = null;
   private JMenuBar menuBar = null;
   private JMenu menu, submenu = null;
   private JMenuItem menuItem = null;
   private JMenuItem gtkItem = null;
   private JMenuItem winItem = null;
   private JMenuItem unixItem = null;
   private JMenuItem javaItem = null;
   private Properties props = null;
   private Stack< String > backStack = new Stack< String >();
   private Stack< String > forwardStack = new Stack< String >();
   private JFrame jFrame = null;
   private static int winCount = 1;

   public void addLayoutComponent(String name, Component comp) {
   }

   public void layoutContainer(Container parent) {
      Rectangle dim = parent.getBounds();

      int h = 40;//goButton.getPreferredSize().height;

      urlText.setSize(dim.width, h);
      urlText.setLocation(0,h);

      scrollPane.setSize(dim.width, dim.height-(60+40));
      scrollPane.setLocation(0, h*2);

      int w = dim.width / 6;

      goButton.setLocation(0, 0);
      goButton.setSize(w, h);

      stopButton.setLocation(w, 0);
      stopButton.setSize(w, h);

      refreshButton.setLocation(w + w, 0);
      refreshButton.setSize(w, h);

      homeButton.setLocation(w + w + w, 0);
      homeButton.setSize(w, h);

      backButton.setLocation(w + w + w + w, 0);
      backButton.setSize(w, h);

      nextButton.setLocation(w + w + w + w + w, 0);
      nextButton.setSize(w, h);

      statusBar.setLocation(0, dim.height - h);
      statusBar.setSize(dim.width, h);
   }

   public Dimension minimumLayoutSize(Container parent) {
      return new Dimension(WIDTH, HEIGHT);
   }

   public Dimension preferredLayoutSize(Container parent) {
      return new Dimension(WIDTH, HEIGHT);
   }

   public void removeLayoutComponent(Component comp) {

   }

   public void actionPerformed(ActionEvent e) {
      if(e.getSource().equals(goButton) || e.getSource().equals(urlText)) {

         forwardStack.clear();
         backStack.push(currentURL);

         currentURL = urlText.getText();

         if(currentURL.length() == 0) {
            return;
         }

         if(currentURL.indexOf("http://") != 0) {
            currentURL = "http://" + currentURL;
         }

         statusBar.setText("get: " + currentURL);

         try {
            statusBar.setText("connecting...");
            editorPane.setPage(currentURL);
            statusBar.setText("done...");
         }
         catch(Exception ex) {
            statusBar.setText("connection error...");
            JOptionPane.showMessageDialog(jFrame, 
                                          "Connection error...",
                                          "Connection error...",
                                          JOptionPane.ERROR_MESSAGE);
         }
      }
      else if(e.getSource().equals(refreshButton)) {
         try {
            statusBar.setText("connecting...");
            editorPane.setPage(currentURL);
            statusBar.setText("done...");
         }
         catch(IOException ioe) {
            statusBar.setText("connection error...");
         }
      }
      else if(e.getSource().equals(homeButton)) {
         forwardStack.clear();
         backStack.push(currentURL);
         currentURL = props.getProperty("home.page");
         try {
            urlText.setText(currentURL);
            statusBar.setText("connecting...");
            editorPane.setPage(currentURL);
            statusBar.setText("done...");
         }
         catch(IOException ioe) {
            statusBar.setText("connection error...");
         }
      }
      else if(e.getSource().equals(backButton)) {
         if(backStack.size() > 0) {
            forwardStack.push(currentURL);
            currentURL = backStack.pop();
            try {
               editorPane.setPage(currentURL);
               statusBar.setText("connecting...");
               urlText.setText(currentURL);
               statusBar.setText("done...");
            }
            catch(IOException ioe) {
               statusBar.setText("connection error...");
            }
         }
      }
      else if(e.getSource().equals(nextButton)) {
         if(forwardStack.size() > 0) {
            backStack.push(currentURL);
            currentURL = forwardStack.pop();
            try {
               editorPane.setPage(currentURL);
               statusBar.setText("connecting...");
               urlText.setText(currentURL);
               statusBar.setText("done...");
            }
            catch(IOException ioe) {
               statusBar.setText("connection error...");
            }
         }
      }
      else if(e.getSource().equals(newMenuItem)) {
         try {
            winCount++;
            WebBrowser browser = new WebBrowser(currentURL);
            browser.start();
         }
         catch(Exception ex) {
            JOptionPane.showMessageDialog(jFrame, 
                                          "Unable to create new web browser window...", 
                                          "Error...",
                                          JOptionPane.ERROR_MESSAGE);
         }
      }
      else if(e.getSource().equals(gtkItem)) {
         try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            SwingUtilities.updateComponentTreeUI(jFrame);
            jFrame.pack();
         }
         catch(Exception ex) { 
            ex.printStackTrace(System.err);
         } 
      }
      else if(e.getSource().equals(winItem)) {
         try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            SwingUtilities.updateComponentTreeUI(jFrame);
            jFrame.pack();
         }
         catch(Exception ex) { 
            ex.printStackTrace(System.err);
         } 
      }
      else if(e.getSource().equals(javaItem)) {
         try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            SwingUtilities.updateComponentTreeUI(jFrame);
            jFrame.pack();
         }
         catch(Exception ex) { 
            ex.printStackTrace(System.err);
         } 
      }
      else if(e.getSource().equals(unixItem)) {
         try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            SwingUtilities.updateComponentTreeUI(jFrame);
            jFrame.pack();
         }
         catch(Exception ex) { 
            ex.printStackTrace(System.err);
         } 
      }
      else if(e.getSource().equals(quitMenuItem)) {
         if(winCount == 1) {
            System.exit(0);
         }
         else {
            winCount--;
            jFrame.setVisible(false);
         }
      }
   }

   public void windowClosing(WindowEvent e) {
      if(winCount == 1) {
         System.exit(0);
      }
      else {
         winCount--;
         jFrame.setVisible(false);
      }
   }

   public void windowDeactivated(WindowEvent e) {
   }

   public void windowActivated(WindowEvent e) {
   }

   public void windowDeiconified(WindowEvent e) {
   }

   public void windowIconified(WindowEvent e) {
   }

   public void windowClosed(WindowEvent e) {
   }

   public void windowOpened(WindowEvent e) {
   }

   public WebBrowser(String url) throws Exception { 
      currentURL = url;

      jFrame = new JFrame("WebBrowser: 1.0.0");
      //jFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      jFrame.addWindowListener(this);

      jFrame.setContentPane(new JPanel());
      jFrame.getContentPane().setLayout(this);

      editorPane = new JEditorPane(url);
      editorPane.setEditable(false);
      editorPane.addHyperlinkListener(this);
      jFrame.getContentPane().add(editorPane);

      urlText = new JTextField();
      urlText.addActionListener(this);
      jFrame.getContentPane().add(urlText);

      statusBar = new JTextField();
      statusBar.setEditable(false);
      jFrame.getContentPane().add(statusBar);

      ImageIcon img;
      JLabel label;

      //goButton = new JButton("Go");
      img = new ImageIcon("go.gif");
      goButton = new JButton("Go", img);
      goButton.addActionListener(this);
      jFrame.getContentPane().add(goButton);

      img = new ImageIcon("stop.gif");
      stopButton = new JButton("Stop", img);
      //stopButton = new JButton("Stop");
      stopButton.addActionListener(this);
      jFrame.getContentPane().add(stopButton);

      img = new ImageIcon("refresh.gif");
      refreshButton = new JButton("Refresh", img);
      //refreshButton = new JButton("Refresh");
      refreshButton.addActionListener(this);
      jFrame.getContentPane().add(refreshButton);

      img = new ImageIcon("home.gif");
      homeButton = new JButton("Home", img);
      //homeButton = new JButton("Home");
      homeButton.addActionListener(this);
      jFrame.getContentPane().add(homeButton);

      img = new ImageIcon("back.gif");
      backButton = new JButton("Back", img);
      //backButton = new JButton("Back");
      backButton.addActionListener(this);
      jFrame.getContentPane().add(backButton);

      img = new ImageIcon("forward.gif");
      nextButton = new JButton("Forward", img);
      //nextButton = new JButton("Forward");
      nextButton.addActionListener(this);
      jFrame.getContentPane().add(nextButton);

      scrollPane = new JScrollPane(editorPane);
      jFrame.getContentPane().add(scrollPane);
 
      menuBar = new JMenuBar();

      // file menu
      menu = new JMenu("File");

      menuBar.add(menu);
      newMenuItem = menuItem = new JMenuItem("New");

      newMenuItem.addActionListener(this);
      menu.add(newMenuItem);

      menuItem = new JMenuItem("Open");
      menu.add(menuItem);

      menuItem = new JMenuItem("Save");
      menu.add(menuItem);

      menuItem = new JMenuItem("Save As");
      menu.add(menuItem);

      menuItem = new JMenuItem("Properties");
      menu.add(menuItem);

      menuItem = new JMenuItem("Close");
      menu.add(menuItem);

      quitMenuItem = new JMenuItem("Exit");
      quitMenuItem.addActionListener(this);
      menu.add(quitMenuItem);

      // edit menu
      menu = new JMenu("Edit");

      menuItem = new JMenuItem("Cut");
      menu.add(menuItem);

      menuItem = new JMenuItem("Copy");
      menu.add(menuItem);

      menuItem = new JMenuItem("Paste");
      menu.add(menuItem);

      menuBar.add(menu);

      // edit view
      menu = new JMenu("View");

      winItem = new JMenuItem("Windows View");
      winItem.addActionListener(this);

      menu.add(winItem);

      gtkItem = new JMenuItem("GTK View");
      gtkItem.addActionListener(this);
      menu.add(gtkItem);

      unixItem = new JMenuItem("UNIX View");
      unixItem.addActionListener(this);

      menu.add(unixItem);

      javaItem = new JMenuItem("Java View");
      javaItem.addActionListener(this);

      menu.add(javaItem);

      menuItem = new JMenuItem("View Source");
      menu.add(menuItem);

      menuBar.add(menu);

      // help menu
      menu = new JMenu("Help");

      menuBar.add(menu);

      menuItem = new JMenuItem("Documentation");

      menu.add(menuItem);

      menuItem = new JMenuItem("About");

      menu.add(menuItem);

      jFrame.setJMenuBar(menuBar);

      //UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());

      SwingUtilities.updateComponentTreeUI(jFrame);

      jFrame.setLocation(100,100);

      jFrame.setSize(WIDTH, HEIGHT);

      jFrame.pack();

      jFrame.setVisible(true);

      // props
      props = new Properties();
      props.load(new FileInputStream("web_browser.properties"));

      if(url == "") {
         currentURL = props.getProperty("home.page");
         editorPane.setPage(currentURL);
      }

      urlText.setText(currentURL);
      statusBar.setText("Welcome...");
   }


   public void run() {
      try {
         Object obj = new Object();
         synchronized(obj) {
            obj.wait();
         }
      }
      catch(Exception ex) {
         JOptionPane.showMessageDialog(jFrame, 
                                       "Unable to wait...", 
                                       "Error...", 
                                       JOptionPane.ERROR_MESSAGE);
      }
   }

   public void hyperlinkUpdate(HyperlinkEvent event) {
      if(event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
         try {
            forwardStack.clear();
            backStack.push(currentURL);
            currentURL = event.getURL().toString();
            urlText.setText(currentURL);
            statusBar.setText("connecting...");
            editorPane.setPage(currentURL);
            statusBar.setText("done...");
           
         }
         catch(IOException ioe) {
            statusBar.setText("error...");
         }
      }
   }

   public static void main(String args[]) throws Exception {
      WebBrowser wb;

      if(args.length == 1) {
         wb = new WebBrowser(args[0]);
      }
      else {
         Properties props = new Properties();

         props.load(new FileInputStream("web_browser.properties"));

         String url = props.getProperty("home.page");

         if(url == null) {
           System.err.println("Unknown home page...");
           System.exit(1);
         }

         wb = new WebBrowser(url);
      }

      wb.run();
   }
}
