/**
 *
 * SIMPLE WEB BROWSER USING JAVA FX FOUND IN JDK8
 *
 * @author Matthew W. Coan
 * @version Fri Aug 22 11:35:54 EDT 2014
 *
 */

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import javax.swing.*;
import org.w3c.dom.*;
import javafx.application.*;
import javafx.beans.value.*;
import javafx.embed.swing.*;
import javafx.event.*;
import javafx.scene.*;
import javafx.scene.web.*;
import javafx.util.*;
import javafx.scene.control.*;
import javafx.application.*;
import javafx.geometry.*;
import javafx.scene.control.*;
import javafx.scene.paint.*;
import javafx.scene.layout.*;
import javafx.scene.paint.*;
import javafx.stage.*;

public class WebBrowser2 implements Runnable, LayoutManager, ActionListener {
   public static final int WIDTH = 640;
   public static final int HEIGHT = 480;
   public static final String VERSION = "V1.0.0a";

   private WebView buildWebView(String url) {
      WebView webView = WebViewBuilder.create().build();
      view = webView;
      engine = webView.getEngine();
      webView.getEngine().load(url);
      return webView;
   }

   private Pane preparePage(String title, String url) {
      Pane pane = new BorderPane(buildWebView(url));
      return pane;
   }

   private void bind(Pane pane, Scene scene) {
      pane.prefHeightProperty().bind(scene.heightProperty());
      pane.prefWidthProperty().bind(scene.widthProperty());
   }

   private Scene getNewScene(String title, String url) {
      Group rootGroup = new Group();
      TreeMap< String, String > titleToUrl = new TreeMap< String, String >();
      Pane pane = preparePage(title, url);
      rootGroup.getChildren().add(pane);
      Scene scene = new Scene(rootGroup, WIDTH, HEIGHT, javafx.scene.paint.Color.WHITE);
      bind(pane, scene);
      return scene;
   }

   public class TabChangeListener implements javax.swing.event.ChangeListener {
      public void stateChanged(javax.swing.event.ChangeEvent e) {
         int index = tabCtrl.getSelectedIndex();
         if(index >= 0 && index < contextVec.size() && index < tabCtrl.getTabCount()) {
            Context ctx = contextVec.get(index);
            swapin(ctx);
         }
      }
   }

   public class Context {
      public JFXPanel jfxPanel = null; 
      public WebView view = null;
      public Scene scene = null;
      public WebEngine engine = null;
      public String url = null;
   }

   public Context getContext() {
      Context ctx = new Context();
      ctx.jfxPanel = new JFXPanel(); 
      ctx.view = view;
      ctx.scene = scene;
      ctx.engine = engine;
      //ctx.jfxPanel.setScene(ctx.scene);
      ctx.url = currentURL;
      return ctx;
   }

   public void swapin(Context ctx) {
      jfxPanel = ctx.jfxPanel;
      view = ctx.view;
      scene = ctx.scene;
      engine = ctx.engine;
      currentURL = ctx.url;
      txtURL.setText(currentURL);
   }

   public void swapout(Context ctx) {
      ctx.jfxPanel = jfxPanel;
      ctx.view = view;
      ctx.scene = scene;
      ctx.engine = engine;
      ctx.url = currentURL;
   }

   private Stage primaryStage = null;
   private Scene scene = null;
   private Vector< Context > contextVec = new Vector< Context >();
   private JFXPanel jfxPanel;
   private WebEngine engine;
   private JFrame frame = new JFrame("Matt Web Browser " + VERSION);
   private JPanel panel = new JPanel(new BorderLayout());
   private JTextField lblStatus = new JTextField();
   private JTextField txtURL = new JTextField();
   private JProgressBar progressBar = new JProgressBar();
   private String currentURL = null;
   private JPanel statusBar = null;
   private JScrollPane scrollPane = null;
   private JButton stopButton = null;
   private JButton refreshButton = null;
   private JButton homeButton = null;
   private JButton backButton = null;
   private JButton nextButton = null;
   private JTabbedPane tabCtrl = null;
   private JMenuItem newWindowMenuItem = null;
   private JMenuItem newTabMenuItem = null;
   private JMenuItem quitMenuItem = null;
   private JMenuBar menuBar = null;
   private JMenu menu, submenu = null;
   private JMenuItem menuItem = null;
   private JMenuItem gtkItem = null;
   private JMenuItem winItem = null;
   private JMenuItem unixItem = null;
   private JMenuItem javaItem = null;
   private Properties props = null;
   private static int winCount = 1;
   private String url = "http://www.google.com/";
   private String google_redirect = "http://www.google.com/url?";
   private String home_page = "http://www.google.com/";
   private String home_page_title = "Google";
   private JMenu bookmark_menu = null;
   private WebView view = null;
   public LinkedList< Context > ctxList = new LinkedList< Context >();
   private static boolean DEBUG_FLAG = true;

   public void debug(String str) {
      if(DEBUG_FLAG) {
         System.err.println(str);
      }
   }

   public class BookmarkAction implements ActionListener {
      public void actionPerformed(java.awt.event.ActionEvent e) {
         try {
            FileOutputStream fout = new FileOutputStream("bookmarks.txt", true);
            PrintStream pout = new PrintStream(fout);
            String title = frame.getTitle();
            pout.println("\"" + currentURL + "\",\"" + title + "\"");
            pout.flush();
            fout.close();
            JMenuItem bookmark = new JMenuItem(title, getImageIcon("file.gif"));
            bookmark.addActionListener(new BookmarkHandler(currentURL));
            bookmark_menu.add(bookmark);
         }
         catch(IOException ioe) {
            ioe.printStackTrace(System.err);
         }
      }
   }

   public class BookmarkHandler implements ActionListener {
      private String url;

      public BookmarkHandler(String url) {
         this.url = url;
      }

      public void actionPerformed(java.awt.event.ActionEvent e) {
         debug("BOOKBARK: " + url);
         currentURL = url;
         lblStatus.setText("connecting...");
         loadURL(url); 
         lblStatus.setText("done...");
      }
   }

   public class CloseTabAction implements ActionListener {

      public CloseTabAction() {
      }

      public void actionPerformed(java.awt.event.ActionEvent e) {
         int index = tabCtrl.getSelectedIndex();
         tabCtrl.remove(index);
         contextVec.get(index).jfxPanel.setEnabled(false);
         contextVec.remove(index);
         if(index < contextVec.size()) {
            swapin(contextVec.get(index));
         }
      }
   }
 
   public ImageIcon getImageIcon(String fileName) {
       URL imageURL = WebBrowser2.class.getResource(fileName);
       return new ImageIcon(imageURL);
   }

   public void actionPerformed(java.awt.event.ActionEvent e) {
       if(e.getSource().equals(txtURL)) {
         currentURL = txtURL.getText();

         debug("ENTER: " + currentURL);

         if(currentURL.length() == 0) {
            return;
         }

         lblStatus.setText("get: " + currentURL);

         try {
            lblStatus.setText("connecting...");
            loadURL(currentURL);
            lblStatus.setText("done...");
         }
         catch(Exception ex) {
            lblStatus.setText("connection error...");
            JOptionPane.showMessageDialog(frame, 
                                          "Connection error...",
                                          "Connection error...",
                                          JOptionPane.ERROR_MESSAGE);
         }
      }
      else if(e.getSource().equals(refreshButton)) {
         lblStatus.setText("refreshing...");
         Platform.runLater(new Runnable() {
            public void run() {
               engine.reload(); 
            }
         });
         lblStatus.setText("done...");
      }
      else if(e.getSource().equals(homeButton)) {
         currentURL = props.getProperty("home.page");
         debug("HOME: " + currentURL);
         lblStatus.setText("connecting...");
         loadURL(currentURL);
         txtURL.setText(currentURL);
         lblStatus.setText("done...");
      }
      else if(e.getSource().equals(backButton)) {
         WebHistory history = engine.getHistory();
         txtURL.setText(currentURL);
         if(history.getCurrentIndex() >= 1) {
            Platform.runLater(new Runnable() {
               public void run() {
                   history.go(-1);
               }
            });
         }
      }
      else if(e.getSource().equals(nextButton)) {
         WebHistory history = engine.getHistory();
         if((history.getCurrentIndex()+1) < history.getEntries().size()) {
            Platform.runLater(new Runnable() {
               public void run() {
                  history.go(1);
               }
            });
         }
      }
      else if(e.getSource().equals(newWindowMenuItem)) {
         winCount++;
         WebBrowser2 browser = new WebBrowser2();
         new Thread(browser).start();
      }
      else if(e.getSource().equals(newTabMenuItem)) {
         try {
            Platform.runLater(new Runnable() {
               public void run() {
                  currentURL = home_page;
                  Context ctx = getContext();
                  contextVec.add(ctx);
                  scene = getNewScene("Loading...", home_page);
                  ctx.jfxPanel.setScene(scene);
                  createScene();
                  ctx.engine = engine;
                  ctx.view = view;
                  ctx.scene = scene;
                  tabCtrl.addTab("New Tab", getImageIcon("file.gif"), ctx.jfxPanel);
/******************
		  int index = tabCtrl.indexOfTab("New Tab");
                  JPanel pnlTab = new JPanel(new GridBagLayout());
                  pnlTab.setOpaque(false);
                  JLabel lblTitle = new JLabel("New Tab");
                  //JCheckBox box = new JCheckBox();
                  JLabel box = new JLabel(" [x]");
                  GridBagConstraints gbc = new GridBagConstraints();
                  pnlTab.add(lblTitle, gbc);
                  pnlTab.add(box, gbc);
                  tabCtrl.setTabComponentAt(tabCtrl.getTabCount()-1, pnlTab);
                  box.addActionListener(new CloseTabAction());
*******************/
                  tabCtrl.setSelectedIndex(tabCtrl.getTabCount()-1);
               }
            });
         }
         catch(Exception ex) {
            ex.printStackTrace(System.err);
            JOptionPane.showMessageDialog(frame, 
                                          "Unable to create new web browser window...", 
                                          "Error...",
                                          JOptionPane.ERROR_MESSAGE);
         }
      }
      else if(e.getSource().equals(gtkItem)) {
         try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            SwingUtilities.updateComponentTreeUI(frame);
            frame.pack();
         }
         catch(Exception ex) { 
            ex.printStackTrace(System.err);
         } 
      }
      else if(e.getSource().equals(winItem)) {
         try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            SwingUtilities.updateComponentTreeUI(frame);
            frame.pack();
         }
         catch(Exception ex) { 
            ex.printStackTrace(System.err);
         } 
      }
      else if(e.getSource().equals(javaItem)) {
         try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            SwingUtilities.updateComponentTreeUI(frame);
            frame.pack();
         }
         catch(Exception ex) { 
            ex.printStackTrace(System.err);
         } 
      }
      else if(e.getSource().equals(unixItem)) {
         try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            SwingUtilities.updateComponentTreeUI(frame);
            frame.pack();
         }
         catch(Exception ex) { 
            ex.printStackTrace(System.err);
         } 
      }
      else if(e.getSource().equals(quitMenuItem)) {
         if(winCount == 1) {
            frame.setVisible(false);
            System.exit(0);
         }
         else {
            winCount--;
            frame.setVisible(false);
            frame.dispose();
         }
      }
   }

   public void addLayoutComponent(String name, Component comp) {
   }

   public void layoutContainer(Container parent) {
      Rectangle dim = parent.getBounds();

      int h = 40;

      txtURL.setSize(dim.width - 6,  h - 6);
      txtURL.setLocation(3, h);

      int stat_h = 40;

      tabCtrl.setSize(dim.width-6, dim.height-(stat_h+80) - 6);
      tabCtrl.setLocation(3, h*2 - 3);

      int w = dim.width / 5;

      backButton.setLocation(3, 3);
      backButton.setSize(w-6, h-6);

      nextButton.setLocation(w + 3, 3);
      nextButton.setSize(w-6, h-6);

      stopButton.setLocation(w + w + 3, 3);
      stopButton.setSize(w-6, h-6);

      refreshButton.setLocation(w + w + w + 3, 3);
      refreshButton.setSize(w-6, h-6);

      homeButton.setLocation(w + w + w + w + 3, 3);
      homeButton.setSize(w-6, h-6);

      statusBar.setLocation(3, dim.height - h - 6);
      statusBar.setSize(dim.width-6, h-6);
   }

   public class MyLayout implements LayoutManager {
      public Dimension minimumLayoutSize(Container parent) {
         return new Dimension(0, 0);
      }

      public Dimension preferredLayoutSize(Container parent) {
         return new Dimension(WIDTH, 40);
      }

      public void removeLayoutComponent(Component comp) {

      }

      public void addLayoutComponent(String name, Component comp) {
      }

      public void layoutContainer(Container parent) {
         Rectangle dim = parent.getBounds();

         progressBar.setLocation(dim.width - 200 + 3, (dim.height - 40) + 6);
         progressBar.setSize(200 - 6, 40 - 6);

         lblStatus.setLocation(3, (dim.height - 40) + 6);
         lblStatus.setSize(dim.width - 200 - 6 , 40 - 6);
      }
   }

   public void removeLayoutComponent(Component comp) {

   }

   public Dimension minimumLayoutSize(Container parent) {
      return new Dimension(WIDTH, HEIGHT);
   }

   public Dimension preferredLayoutSize(Container parent) {
      return new Dimension(WIDTH, HEIGHT);
   }

   public class Find implements ActionListener {
      public void actionPerformed(java.awt.event.ActionEvent e) {
         String ret = JOptionPane.showInputDialog(frame,
                                                  "Find on this page",
                                                  "Search current page",
                                                  JOptionPane.QUESTION_MESSAGE);
      }
   }

   public class JavaConsole implements ActionListener {
      public void actionPerformed(java.awt.event.ActionEvent e) {
         JFrame frame = new JFrame("Java Console");
         JTextArea text = new JTextArea();
         text.setText(  "Matt Web Browser: " + VERSION + "\n\n"
                      + "Welcome to the java console...\n\n");
         text.setEditable(false);
         frame.setLayout(new GridLayout(1, 1));
         JScrollPane scroll = new JScrollPane(text);
         frame.getContentPane().add(scroll);
         frame.addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent windowEvent) {
               frame.setVisible(false);
               frame.dispose();
            }
         });
         frame.pack();
         frame.setSize(WIDTH, HEIGHT);
         frame.setVisible(true);
      }
   }

   public class ViewSource implements ActionListener {
      public void actionPerformed(java.awt.event.ActionEvent e) {
         debug("ViewSource...");
         JFrame frame = new JFrame("View Source");
         JTextArea text = new JTextArea();
         text.setEditable(false);
         try {
            StringBuffer data = new StringBuffer();
            URL url = new URL(currentURL);
            InputStream in = url.openConnection().getInputStream();
            int ch;
            while((ch = in.read()) != -1) {
               data.append((char)ch);
            }
            in.close();
            text.setText(data.toString());
         }
         catch(IOException ioe) {
         } 
         frame.addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent windowEvent) {
               frame.setVisible(false);
               frame.dispose();
            }
         });
         frame.setLayout(new GridLayout(1, 1));
         JScrollPane scroll = new JScrollPane(text);
         frame.getContentPane().add(scroll);
         frame.setSize(WIDTH, HEIGHT);
         frame.setVisible(true);
      }
   }

   private void initComponents() {
      jfxPanel = new JFXPanel();

      createScene();

      txtURL.addActionListener(this);

      ImageIcon img = getImageIcon("home.gif");
      homeButton = new JButton("Home", img);
      //homeButton = new JButton("Home");
      homeButton.addActionListener(this);
      //frame.getContentPane().add(homeButton);

      img = getImageIcon("back.gif");
      backButton = new JButton("Back", img);
      //backButton = new JButton("Back");
      backButton.addActionListener(this);
      //frame.getContentPane().add(backButton);

      img = getImageIcon("forward.gif");
      nextButton = new JButton("Forward", img);
      //nextButton = new JButton("Forward");
      nextButton.addActionListener(this);
      //frame.getContentPane().add(nextButton);

      img = getImageIcon("stop.gif");
      stopButton = new JButton("Stop", img);
      //stopButton = new JButton("Stop");
      stopButton.addActionListener(this);
      //frame.getContentPane().add(stopButton);

      img = getImageIcon("refresh.gif");
      refreshButton = new JButton("Refresh", img);
      //refreshButton = new JButton("Refresh");
      refreshButton.addActionListener(this);
      //frame.getContentPane().add(refreshButton);

      frame.getContentPane().setLayout(this);

      menuBar = new JMenuBar();

      // file menu
      menu = new JMenu("File");
      //menu.setIcon(getImageIcon("file.gif"));

      menuBar.add(menu);

      newTabMenuItem = menuItem = new JMenuItem("New Tab", getImageIcon("file.gif"));
      newTabMenuItem.addActionListener(this);
      menu.add(newTabMenuItem);

      menuItem = menuItem = new JMenuItem("Close Tab", getImageIcon("file.gif"));
      menuItem.addActionListener(new CloseTabAction());
      menu.add(menuItem);

      newWindowMenuItem = menuItem = new JMenuItem("New Window", getImageIcon("file.gif"));
      newWindowMenuItem.addActionListener(this);
      menu.add(newWindowMenuItem);

      menuItem = new JMenuItem("Open", getImageIcon("file.gif"));
      menu.add(menuItem);

      menuItem = new JMenuItem("Save", getImageIcon("file.gif"));
      menu.add(menuItem);

      menuItem = new JMenuItem("Save As", getImageIcon("file.gif"));
      menu.add(menuItem);

      menuItem = new JMenuItem("Properties", getImageIcon("file.gif"));
      menu.add(menuItem);

      menuItem = new JMenuItem("Close", getImageIcon("file.gif"));
      menu.add(menuItem);

      quitMenuItem = new JMenuItem("Exit", getImageIcon("file.gif"));
      quitMenuItem.addActionListener(this);
      menu.add(quitMenuItem);

      // edit menu
      menu = new JMenu("Edit");
      //menu.setIcon(getImageIcon("file.gif"));


      menuItem = new JMenuItem("Cut", getImageIcon("file.gif"));
      menu.add(menuItem);

      menuItem = new JMenuItem("Copy", getImageIcon("file.gif"));
      menu.add(menuItem);

      menuItem = new JMenuItem("Paste", getImageIcon("file.gif"));
      menu.add(menuItem);

      menuItem = new JMenuItem("Find", getImageIcon("file.gif"));
      menuItem.addActionListener(new Find());
      menu.add(menuItem);

      menuItem = new JMenuItem("View Source", getImageIcon("file.gif"));
      menuItem.addActionListener(new ViewSource());
      menu.add(menuItem);


      menuBar.add(menu);

      // edit view
      menu = new JMenu("View");
      //menu.setIcon(getImageIcon("file.gif"));

      winItem = new JMenuItem("Windows View", getImageIcon("file.gif"));
      winItem.addActionListener(this);

      menu.add(winItem);

      gtkItem = new JMenuItem("GTK View", getImageIcon("file.gif"));
      gtkItem.addActionListener(this);
      menu.add(gtkItem);

      unixItem = new JMenuItem("UNIX View", getImageIcon("file.gif"));
      unixItem.addActionListener(this);

      menu.add(unixItem);

      javaItem = new JMenuItem("Java View", getImageIcon("file.gif"));
      javaItem.addActionListener(this);

      menu.add(javaItem);

      menuBar.add(menu);

      bookmark_menu = menu = new JMenu("Bookmarks");
      //bookmark_menu.setIcon(getImageIcon("file.gif"));

      menuItem = new JMenuItem("Bookmark Page", getImageIcon("file.gif"));
      menuItem.addActionListener(new BookmarkAction());

      menu.add(menuItem);

      try {
         CSVFileReader csv = new CSVFileReader("bookmarks.txt", true);
         csv.open();
         while(csv.readLine()) {
            menuItem = new JMenuItem(csv.getValue("title"), getImageIcon("file.gif"));
            menuItem.addActionListener(new BookmarkHandler(csv.getValue("url")));
            menu.add(menuItem);
         }
         csv.close();
      }
      catch(IOException ioe) {
         ioe.printStackTrace(System.err);
      }

      menuBar.add(menu);

      // help menu
      menu = new JMenu("Tools");
      //menu.setIcon(getImageIcon("file.gif"));

      menuItem = new JMenuItem("Java Console", getImageIcon("file.gif"));
      menuItem.addActionListener(new JavaConsole());
      menu.add(menuItem);

      menuBar.add(menu);

      menu = new JMenu("Help");
      menuItem = new JMenuItem("Documentation", getImageIcon("file.gif"));
      menu.add(menuItem);

      menuItem = new JMenuItem("About", getImageIcon("file.gif"));
      menu.add(menuItem);

      menuBar.add(menu);

      frame.setJMenuBar(menuBar);
 
      progressBar.setPreferredSize(new Dimension(200, 40));
      progressBar.setStringPainted(true);

      statusBar = new JPanel(new MyLayout());
      statusBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
      lblStatus.setEditable(false);
      statusBar.add(lblStatus);
      statusBar.add(progressBar);

      frame.getContentPane().add(stopButton);
      frame.getContentPane().add(refreshButton);
      frame.getContentPane().add(homeButton);
      frame.getContentPane().add(backButton);
      frame.getContentPane().add(nextButton);
      frame.getContentPane().add(txtURL);

      currentURL = home_page;

      Context ctx = getContext();
      tabCtrl = new JTabbedPane();
      jfxPanel = ctx.jfxPanel;
      //jfxPanel.setScene(scene);
      contextVec.add(ctx);
      tabCtrl.addChangeListener(new TabChangeListener());
      Platform.runLater(new Runnable() {
         public void run() {
            ctx.jfxPanel.setScene(getNewScene(home_page_title, home_page));
            createScene();
            ctx.engine = engine;
            ctx.view = view;
            ctx.scene = scene;
            tabCtrl.addTab(home_page_title, getImageIcon("file.gif"), ctx.jfxPanel);
            txtURL.setText(home_page);
         }
      });
      
      frame.getContentPane().add(tabCtrl);
      frame.getContentPane().add(statusBar);

      loadURL(home_page);

      try {
         props = new Properties();
         props.load(new FileInputStream("web_browser.properties"));

         if(url == "") {
            home_page = currentURL = props.getProperty("home.page");
            home_page_title = currentURL = props.getProperty("home.page.title");
         }

         lblStatus.setText("Welcome...");
      }
      catch(IOException ioe) {
         ioe.printStackTrace(System.err);
      }
    }

    private void createScene() {
        Platform.runLater(new Runnable() {
            @Override public void run() {

                //scene = getNewScene("Google", home_page);//new Scene(view);
                if(view == null) view = new WebView();
                if(engine == null) engine = view.getEngine();
                engine.setUserAgent("Matt Web Browser: " + VERSION);
                engine.setJavaScriptEnabled(true);
                engine.setOnAlert(
                   new EventHandler<WebEvent<String>>() {
                      public void handle(WebEvent<String> ev) {
                         String message = ev.getData();
                         JOptionPane.showMessageDialog(frame,
                                                       message,
                                                       message,
                                                       JOptionPane.INFORMATION_MESSAGE);
                      }
                   });

                engine.setConfirmHandler(
                   new Callback<String,Boolean>() {
                      public Boolean call(String message) {
                         int ret;
                         ret = JOptionPane.showConfirmDialog(frame,
                                                             message,
                                                             message,
                                                             JOptionPane.YES_NO_OPTION);
                         if(ret == JOptionPane.YES_OPTION) 
                            return new Boolean(true);
                         else 
                            return new Boolean(false);
                      }
                   });


                engine.setPromptHandler(
                   new Callback<PromptData,String>() {
                      public String call(PromptData message) {
                         String ret = JOptionPane.showInputDialog(frame,
                                                                  message.getMessage(),
                                                                  message.getMessage(),
                                                                  JOptionPane.QUESTION_MESSAGE);
                         return ret;
                      }
                   });


                engine.titleProperty().addListener(new ChangeListener<String>() {
                    @Override
                    public void changed(ObservableValue<? extends String> observable, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable() {
                            @Override public void run() {
                                int index = tabCtrl.getSelectedIndex();
                                String temp = "";
                                if(newValue != null) {
                                    temp = new String(newValue);
                                }
                                if(index >= 0) {
                                   if(temp.equals("")) {
                                      temp = "Unknown";
                                   }
                                   if(oldValue != null) {
                                      temp = oldValue;
                                   }
                                   tabCtrl.setTitleAt(index, temp);
                                }
                            }
                        });
                    }
                });

                engine.setOnStatusChanged(new EventHandler<WebEvent<String>>() {
                    @Override public void handle(final WebEvent<String> event) {
                        SwingUtilities.invokeLater(new Runnable() {
                            @Override public void run() {
                                lblStatus.setText(event.getData());
                            }
                        });
                    }
                });

                engine.locationProperty().addListener(new ChangeListener<String>() {
                    @Override
                    public void changed(ObservableValue<? extends String> ov, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable() {
                            @Override public void run() {
                               currentURL = newValue;
                               debug("CLICK: " + currentURL);
                               txtURL.setText(newValue);
                            }
                        });
                    }
                });

                engine.getLoadWorker().workDoneProperty().addListener(new ChangeListener<Number>() {
                    @Override
                    public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, final Number newValue) {
                        SwingUtilities.invokeLater(new Runnable() {
                            @Override public void run() {
                                progressBar.setValue(newValue.intValue());
                            }
                        });
                    }
                });

                engine.getLoadWorker()
                        .exceptionProperty()
                        .addListener(new ChangeListener<Throwable>() {

                            public void changed(ObservableValue<? extends Throwable> o, Throwable old, final Throwable value) {
                                if (engine.getLoadWorker().getState() == javafx.concurrent.Worker.State.FAILED) {
                                    SwingUtilities.invokeLater(new Runnable() {
                                        @Override public void run() {
                                            JOptionPane.showMessageDialog(
                                                    panel,
                                                    (value != null) ?
                                                    engine.getLocation() + "\n" + value.getMessage() :
                                                    engine.getLocation() + "\nUnexpected error.",
                                                    "Loading error...",
                                                    JOptionPane.ERROR_MESSAGE);
                                        }
                                    });
                                }
                            }
                        });

                        engine.setCreatePopupHandler(new Callback<PopupFeatures, WebEngine>() { // todo should create a new tab.
                        @Override public WebEngine call(PopupFeatures popupFeatures) {
                              System.out.println("Popup: " + popupFeatures);
                              return engine; // hard to know what this really should be...
                           }
                        });


                //scene = getNewScene("Google", home_page);//new Scene(view);
                //jfxPanel.setScene(scene);
            }
        });
    }

    public void loadURL(String the_url) {
        Platform.runLater(new Runnable() {
            @Override public void run() {
System.err.println("the_url=[" + the_url + "]");
                String currentURL = toURL(the_url);
System.err.println("currentURL=[" + currentURL + "]");
                if(engine != null) {
                   engine.load(currentURL);
                }
            }
        });
    }

    private static String toURL(String str) {
       if(str.indexOf("http://") != 0) {
          if(str.indexOf("https://") != 0) {
             return "http://" + str;
          }
       }
       return str;
    }

    public void run() {
        frame.setPreferredSize(new Dimension(1024, 600));
        frame.addWindowListener(new java.awt.event.WindowAdapter() {
           public void windowClosing(java.awt.event.WindowEvent windowEvent) {
              winCount--;
              if(winCount <= 0) {
                 System.exit(0);
              }
           }
        });

        initComponents();

        frame.pack();
        frame.setVisible(true);
        frame.setExtendedState(frame.getExtendedState()|JFrame.MAXIMIZED_BOTH);
    }

    public static void main(String[] args) {
       //SwingUtilities.invokeLater(new WebBrowser2());
       new WebBrowser2().run();
       //Application.launch(args);
    }
}
