/**
 *
 * SIMPLE WEB BROWSER USING JAVA FX
 *
 * @author Matthew W. Coan
 * @version Fri Aug 22 11:35:54 EDT 2014
 *
 */

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import javafx.application.*;
import javafx.beans.value.*;
import static javafx.concurrent.Worker.State.FAILED;
import javafx.embed.swing.*;
import javafx.event.*;
import javafx.scene.*;
import javafx.scene.web.*;
import javafx.util.*;
import org.w3c.dom.*;
import javax.swing.*;
import javafx.application.*;
import javafx.geometry.*;
import javafx.scene.control.*;
import javafx.scene.paint.*;
import javafx.scene.layout.*;
import javafx.scene.paint.*;
import javafx.stage.*;


public class WebBrowser2 extends Application implements LayoutManager, ActionListener {
   public static final int WIDTH = 640;
   public static final int HEIGHT = 480;
   public static final String VERSION = "V1.0.0a";

   public class TabChangeListener implements javax.swing.event.ChangeListener {
      public void stateChanged(javax.swing.event.ChangeEvent e) {
/*
         int index = tabCtrl.getSelectedIndex();
         if(index >= 0 && index < tabCtrl.getTabCount()) {
            Context ctx = contextVec.get(index);
            jfxPanel = ctx.jfxPanel;
         }
*/
      }
   }


   public class Context {
      JFXPanel jfxPanel; 
   }

   private Stage primaryStage = null;
   private Scene scene = null;
   private Vector< Context > contextVec = new Vector< Context >();
   private JFXPanel jfxPanel;
   private WebEngine engine;
   private JFrame frame = null;
   private JPanel panel = new JPanel(new BorderLayout());
   private JTextField lblStatus = new JTextField();
   private javafx.scene.control.TextField txtURL = null;
   private JProgressBar progressBar = new JProgressBar();
   private String currentURL = null;
   private JFXPanel statusBar = null;
   private JScrollPane scrollPane = null;
   private JButton stopButton = null;
   private JButton refreshButton = null;
   private JButton homeButton = null;
   private JButton backButton = null;
   private JButton nextButton = null;
   private TabPane tabCtrl = null;
   private JMenuItem newWindowMenuItem = null;
   private JMenuItem newTabMenuItem = null;
   private JMenuItem quitMenuItem = null;
   private JMenuBar menuBar = null;
   private JMenu menu, submenu = null;
   private JMenuItem menuItem = null;
   private JMenuItem gtkItem = null;
   private JMenuItem winItem = null;
   private JMenuItem unixItem = null;
   private JMenuItem javaItem = null;
   private Properties props = null;
   private Stack< String > backStack = new Stack< String >();
   private Stack< String > forwardStack = new Stack< String >();
   private static int winCount = 1;
   private String url = "http://www.google.com/";
   private String google_redirect = "http://www.google.com/url?";
   private String home_page = "http://www.google.com/";
   private JMenu bookmark_menu = null;
   private WebView view = null;
   private Group root = null;

   public void debug(String str) {
      System.err.println(str);
   }

   public boolean is_unique(String value) {
      boolean ret = true;
      if(value != null) {
         if(backStack != null && backStack.size() > 0) {
            if(backStack.peek().equals(value)) {
               ret = false;
            }
         }
         if(forwardStack != null && forwardStack.size() > 0) {
            if(forwardStack.peek().equals(value)) {
               ret = false;
            }
         }
      }
      return ret;
   }

   public class BookmarkAction implements ActionListener {
      public void actionPerformed(java.awt.event.ActionEvent e) {
         try {
            FileOutputStream fout = new FileOutputStream("bookmarks.txt", true);
            PrintStream pout = new PrintStream(fout);
            String title = frame.getTitle();
            pout.println("\"" + currentURL + "\",\"" + title + "\"");
            pout.flush();
            fout.close();
            JMenuItem bookmark = new JMenuItem(title);
            bookmark.addActionListener(new BookmarkHandler(currentURL));
            bookmark_menu.add(bookmark);
         }
         catch(IOException ioe) {
            ioe.printStackTrace(System.err);
         }
      }
   }

   public class BookmarkHandler implements ActionListener {
      private String url;

      public BookmarkHandler(String url) {
         this.url = url;
      }

      public void actionPerformed(java.awt.event.ActionEvent e) {
         if(is_unique(currentURL)) {
            debug("BOOKMARK PUSH: " + currentURL);
            backStack.push(currentURL);
         }
         debug("BOOKBARK: " + url);
         currentURL = url;
         forwardStack.clear();
         lblStatus.setText("connecting...");
         loadURL(url); 
         lblStatus.setText("done...");
      }
   }

   public void actionPerformed(java.awt.event.ActionEvent e) {
       if(e.getSource().equals(txtURL)) {

         if(is_unique(currentURL)) {
            debug("ENTER PUSH: " + currentURL);
            backStack.push(currentURL);
         }

         currentURL = txtURL.getText();

         debug("ENTER: " + currentURL);

         if(currentURL.length() == 0) {
            return;
         }

         lblStatus.setText("get: " + currentURL);

         try {
            lblStatus.setText("connecting...");
            loadURL(currentURL);
            lblStatus.setText("done...");
         }
         catch(Exception ex) {
            lblStatus.setText("connection error...");
            JOptionPane.showMessageDialog(frame, 
                                          "Connection error...",
                                          "Connection error...",
                                          JOptionPane.ERROR_MESSAGE);
         }
      }
      else if(e.getSource().equals(refreshButton)) {
         lblStatus.setText("connecting...");
         loadURL(currentURL);
         lblStatus.setText("done...");
      }
      else if(e.getSource().equals(homeButton)) {
         if(is_unique(currentURL)) {
            debug("HOME PUSH: " + currentURL);
            backStack.push(currentURL);
         }
         forwardStack.clear();
         currentURL = props.getProperty("home.page");
         debug("HOME: " + currentURL);
         lblStatus.setText("connecting...");
         loadURL(currentURL);
         txtURL.setText(currentURL);
         lblStatus.setText("done...");
      }
      else if(e.getSource().equals(backButton)) {
         if(backStack.size() > 0) {
            if(is_unique(currentURL)) {
               debug("BACK PUSH: " + currentURL);
               forwardStack.push(currentURL);
            }
            currentURL = backStack.pop();
            while(backStack.size() > 0 
                  && (currentURL.equals(engine.getLocation()) 
                      || currentURL.indexOf(google_redirect) == 0)) {
               currentURL = backStack.pop();
               if(currentURL == null) break;
            }
            debug("BACK: " + currentURL);
            lblStatus.setText("connecting...");
            loadURL(currentURL);
            lblStatus.setText("done...");
            txtURL.setText(currentURL);
         }
      }
      else if(e.getSource().equals(nextButton)) {
         if(forwardStack.size() > 0) {
            if(is_unique(currentURL)) {
               debug("NEXT PUSH: " + currentURL);
               backStack.push(currentURL);
            }
            currentURL = forwardStack.pop();
            if(currentURL.indexOf(google_redirect) == 0) 
               currentURL = forwardStack.pop();
            debug("NEXT: " + currentURL);
            lblStatus.setText("connecting...");
            loadURL(currentURL);
            lblStatus.setText("done...");
            txtURL.setText(currentURL);
         }
      }
      else if(e.getSource().equals(newWindowMenuItem)) {
         winCount++;
         WebBrowser2 browser = new WebBrowser2();
         //new Thread(browser).start();
      }
      else if(e.getSource().equals(newTabMenuItem)) {
         try {
/*
            Context ctx = new Context();
            ctx.jfxPanel = new JFXPanel();
            contextVec.add(ctx);
            tabCtrl.addTab("New Tab", ctx.jfxPanel);
            JFXPanel temp = jfxPanel;
            jfxPanel = ctx.jfxPanel;
            loadURL(home_page);
            jfxPanel = temp;
*/
         }
         catch(Exception ex) {
            ex.printStackTrace(System.err);
            JOptionPane.showMessageDialog(frame, 
                                          "Unable to create new web browser window...", 
                                          "Error...",
                                          JOptionPane.ERROR_MESSAGE);
         }
      }
      else if(e.getSource().equals(gtkItem)) {
         try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            SwingUtilities.updateComponentTreeUI(frame);
            frame.pack();
         }
         catch(Exception ex) { 
            ex.printStackTrace(System.err);
         } 
      }
      else if(e.getSource().equals(winItem)) {
         try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            SwingUtilities.updateComponentTreeUI(frame);
            frame.pack();
         }
         catch(Exception ex) { 
            ex.printStackTrace(System.err);
         } 
      }
      else if(e.getSource().equals(javaItem)) {
         try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            SwingUtilities.updateComponentTreeUI(frame);
            frame.pack();
         }
         catch(Exception ex) { 
            ex.printStackTrace(System.err);
         } 
      }
      else if(e.getSource().equals(unixItem)) {
         try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            SwingUtilities.updateComponentTreeUI(frame);
            frame.pack();
         }
         catch(Exception ex) { 
            ex.printStackTrace(System.err);
         } 
      }
      else if(e.getSource().equals(quitMenuItem)) {
         if(winCount == 1) {
            frame.setVisible(false);
            System.exit(0);
         }
         else {
            winCount--;
            frame.setVisible(false);
            frame.dispose();
         }
      }
   }

   public void addLayoutComponent(String name, Component comp) {
   }

   public void layoutContainer(Container parent) {
      Rectangle dim = parent.getBounds();

      int h = 40;

      //txtURL.setSize(dim.width - 6,  h - 6);
      //txtURL.setLocation(3, h);

      int stat_h = 40;

      //tabCtrl.setSize(dim.width-6, dim.height-(stat_h+80) - 6);
      //tabCtrl.setLocation(3, h*2 - 3);

      int w = dim.width / 5;

      backButton.setLocation(3, 3);
      backButton.setSize(w-6, h-6);

      nextButton.setLocation(w + 3, 3);
      nextButton.setSize(w-6, h-6);

      stopButton.setLocation(w + w + 3, 3);
      stopButton.setSize(w-6, h-6);

      refreshButton.setLocation(w + w + w + 3, 3);
      refreshButton.setSize(w-6, h-6);

      homeButton.setLocation(w + w + w + w + 3, 3);
      homeButton.setSize(w-6, h-6);

      //statusBar.setLocation(3, dim.height - h - 6);
      //statusBar.setSize(dim.width-6, h-6);
   }

/*
   public class MyLayout implements LayoutManager {
      public Dimension minimumLayoutSize(Container parent) {
         return new Dimension(0, 0);
      }

      public Dimension preferredLayoutSize(Container parent) {
         return new Dimension(WIDTH, 40);
      }

      public void removeLayoutComponent(Component comp) {

      }

      public void addLayoutComponent(String name, Component comp) {
      }

      public void layoutContainer(Container parent) {
         Rectangle dim = parent.getBounds();

         progressBar.setLocation(dim.width - 200 + 3, (dim.height - 40) + 6);
         progressBar.setSize(200 - 6, 40 - 6);

         lblStatus.setLocation(3, (dim.height - 40) + 6);
         lblStatus.setSize(dim.width - 200 - 6 , 40 - 6);
      }
   }
*/

   public void removeLayoutComponent(Component comp) {

   }

   public Dimension minimumLayoutSize(Container parent) {
      return new Dimension(WIDTH, HEIGHT);
   }

   public Dimension preferredLayoutSize(Container parent) {
      return new Dimension(WIDTH, HEIGHT);
   }

   private SwingNode getJavaFX(javafx.scene.control.Button button) {
      SwingNode swingNode = new SwingNode();
      StackPane swingPane = new StackPane();
      swingPane.getChildren().add(swingNode);
      return swingNode;
   }

   private void initComponents() {
      jfxPanel = new JFXPanel();

      createScene();

      //txtURL.addActionListener(this);

      ImageIcon img = new ImageIcon("home.gif");
      homeButton = new JButton("Home", img);
      homeButton.addActionListener(this);
      //frame.getContentPane().add(homeButton);

      img = new ImageIcon("back.gif");
      backButton = new JButton("Back", img);
      backButton.addActionListener(this);
      //frame.getContentPane().add(backButton);

      img = new ImageIcon("forward.gif");
      nextButton = new JButton("Forward", img);
      nextButton.addActionListener(this);
      //frame.getContentPane().add(nextButton);

      img = new ImageIcon("stop.gif");
      stopButton = new JButton("Stop", img);
      stopButton.addActionListener(this);
      //frame.getContentPane().add(stopButton);

      img = new ImageIcon("refresh.gif");
      refreshButton = new JButton("Refresh", img);
      refreshButton.addActionListener(this);
      //frame.getContentPane().add(refreshButton);

      frame.getContentPane().setLayout(this);
      frame.getContentPane().add(backButton);
      frame.getContentPane().add(nextButton);
      frame.getContentPane().add(stopButton);
      frame.getContentPane().add(refreshButton);

      menuBar = new JMenuBar();

      // file menu
      menu = new JMenu("File");

      menuBar.add(menu);

      newTabMenuItem = menuItem = new JMenuItem("New Tab");
      newTabMenuItem.addActionListener(this);
      menu.add(newTabMenuItem);

      newWindowMenuItem = menuItem = new JMenuItem("New Window");
      newWindowMenuItem.addActionListener(this);
      menu.add(newWindowMenuItem);

      menuItem = new JMenuItem("Open");
      menu.add(menuItem);

      menuItem = new JMenuItem("Save");
      menu.add(menuItem);

      menuItem = new JMenuItem("Save As");
      menu.add(menuItem);

      menuItem = new JMenuItem("Properties");
      menu.add(menuItem);

      menuItem = new JMenuItem("Close");
      menu.add(menuItem);

      quitMenuItem = new JMenuItem("Exit");
      quitMenuItem.addActionListener(this);
      menu.add(quitMenuItem);

      menuItem = new JMenuItem("View Source");
      menu.add(menuItem);

      // edit menu
      menu = new JMenu("Edit");

      menuItem = new JMenuItem("Cut");
      menu.add(menuItem);

      menuItem = new JMenuItem("Copy");
      menu.add(menuItem);

      menuItem = new JMenuItem("Paste");
      menu.add(menuItem);

      menuItem = new JMenuItem("Find");
      menu.add(menuItem);

      menuBar.add(menu);

      // edit view
      menu = new JMenu("View");

      winItem = new JMenuItem("Windows View");
      winItem.addActionListener(this);

      menu.add(winItem);

      gtkItem = new JMenuItem("GTK View");
      gtkItem.addActionListener(this);
      menu.add(gtkItem);

      unixItem = new JMenuItem("UNIX View");
      unixItem.addActionListener(this);

      menu.add(unixItem);

      javaItem = new JMenuItem("Java View");
      javaItem.addActionListener(this);

      menu.add(javaItem);

      menuBar.add(menu);

      bookmark_menu = menu = new JMenu("Bookmarks");

      menuItem = new JMenuItem("Bookmark Page");
      menuItem.addActionListener(new BookmarkAction());

      menu.add(menuItem);

      try {
         CSVFileReader csv = new CSVFileReader("bookmarks.txt", true);
         csv.open();
         while(csv.readLine()) {
            menuItem = new JMenuItem(csv.getValue("title"));
            menuItem.addActionListener(new BookmarkHandler(csv.getValue("url")));
            menu.add(menuItem);
         }
         csv.close();
      }
      catch(IOException ioe) {
         ioe.printStackTrace(System.err);
      }

      menuBar.add(menu);

      // help menu
      menu = new JMenu("Help");

      menuBar.add(menu);

      menuItem = new JMenuItem("Documentation");

      menu.add(menuItem);

      menuItem = new JMenuItem("About");

      menu.add(menuItem);

      frame.setJMenuBar(menuBar);
 
      progressBar.setPreferredSize(new Dimension(200, 40));
      progressBar.setStringPainted(true);

      statusBar = new JFXPanel();
      statusBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
      lblStatus.setEditable(false);
      statusBar.add(lblStatus);
      statusBar.add(progressBar);

/*
      root.getChildren().add(stopButton);
      root.getChildren().add(refreshButton);
      root.getChildren().add(homeButton);
      root.getChildren().add(backButton);
      root.getChildren().add(nextButton);
      //root.getChildren().add(txtURL);
*/

      Tab tab = new Tab();
      HBox hbox = new HBox();
      hbox.getChildren().add(new javafx.scene.control.Label("Google"));
      hbox.setAlignment(Pos.CENTER);
      tab.setContent(hbox);
      tabCtrl.getTabs().add(tab);

/*
      tabCtrl = new JTabbedPane();
      tabCtrl.addTab("Google", jfxPanel);
      tabCtrl.addChangeListener(new TabChangeListener());
      Context ctx = new Context();
      ctx.jfxPanel = jfxPanel;
      contextVec.add(ctx);
      loadURL(home_page);
*/

      root.getChildren().add(tabCtrl);

      try {
         props = new Properties();
         props.load(new FileInputStream("web_browser.properties"));

         if(url == "") {
            home_page = currentURL = props.getProperty("home.page");
         }

         lblStatus.setText("Welcome...");
      }
      catch(IOException ioe) {
         ioe.printStackTrace(System.err);
      }
    }

    private void createScene() {
        Platform.runLater(new Runnable() {
            @Override public void run() {

                view = new WebView();
                engine = view.getEngine();
                engine.setUserAgent("Matt Web Browser: " + VERSION);
                engine.setJavaScriptEnabled(true);
                engine.setOnAlert(
                   new EventHandler<WebEvent<String>>() {
                      public void handle(WebEvent<String> ev) {
                         String message = ev.getData();
                         JOptionPane.showMessageDialog(frame,
                                                       message,
                                                       message,
                                                       JOptionPane.INFORMATION_MESSAGE);
                      }
                   });

                engine.setConfirmHandler(
                   new Callback<String,Boolean>() {
                      public Boolean call(String message) {
                         int ret;
                         ret = JOptionPane.showConfirmDialog(frame,
                                                             message,
                                                             message,
                                                             JOptionPane.YES_NO_OPTION);
                         if(ret == JOptionPane.YES_OPTION) 
                            return new Boolean(true);
                         else 
                            return new Boolean(false);
                      }
                   });


                engine.setPromptHandler(
                   new Callback<PromptData,String>() {
                      public String call(PromptData message) {
                         String ret = JOptionPane.showInputDialog(frame,
                                                                  message.getMessage(),
                                                                  message.getMessage(),
                                                                  JOptionPane.QUESTION_MESSAGE);
                         return ret;
                      }
                   });


                engine.titleProperty().addListener(new ChangeListener<String>() {
                    @Override
                    public void changed(ObservableValue<? extends String> observable, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable() {
                            @Override public void run() {
                                frame.setTitle(newValue);
                            }
                        });
                    }
                });

                engine.setOnStatusChanged(new EventHandler<WebEvent<String>>() {
                    @Override public void handle(final WebEvent<String> event) {
                        SwingUtilities.invokeLater(new Runnable() {
                            @Override public void run() {
                                lblStatus.setText(event.getData());
                            }
                        });
                    }
                });

                engine.locationProperty().addListener(new ChangeListener<String>() {
                    @Override
                    public void changed(ObservableValue<? extends String> ov, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable() {
                            @Override public void run() {
                               if(is_unique(currentURL)) {
                                  debug("CLICK PUSH: " + currentURL);
                                  backStack.push(currentURL);
                               }
                               currentURL = newValue;
                               debug("CLICK: " + currentURL);
                               txtURL.setText(newValue);
                            }
                        });
                    }
                });

                engine.getLoadWorker().workDoneProperty().addListener(new ChangeListener<Number>() {
                    @Override
                    public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, final Number newValue) {
                        SwingUtilities.invokeLater(new Runnable() {
                            @Override public void run() {
                                progressBar.setValue(newValue.intValue());
                            }
                        });
                    }
                });

                engine.getLoadWorker()
                        .exceptionProperty()
                        .addListener(new ChangeListener<Throwable>() {

                            public void changed(ObservableValue<? extends Throwable> o, Throwable old, final Throwable value) {
                                if (engine.getLoadWorker().getState() == FAILED) {
                                    SwingUtilities.invokeLater(new Runnable() {
                                        @Override public void run() {
                                            JOptionPane.showMessageDialog(
                                                    panel,
                                                    (value != null) ?
                                                    engine.getLocation() + "\n" + value.getMessage() :
                                                    engine.getLocation() + "\nUnexpected error.",
                                                    "Loading error...",
                                                    JOptionPane.ERROR_MESSAGE);
                                        }
                                    });
                                }
                            }
                        });

                //scene = new Scene(root, WIDTH,HEIGHT,javafx.scene.paint.Color.WHITE);
                jfxPanel.setScene(scene);
            }
        });
    }

    public class MyLayout extends Region {
       protected void layoutChildren() {
           double w = getWidth();
           double h = getHeight();
           layoutInArea(tabCtrl,0,w,0,0,h,HPos.CENTER,VPos.CENTER);
       }
 
       protected double computePrefWidth(double height) {
           return WIDTH;
       }
 
       protected double computePrefHeight(double width) {
           return HEIGHT;
       }
    }

    public void loadURL(final String the_url) {
        Platform.runLater(new Runnable() {
            @Override public void run() {
                currentURL = toURL(the_url);
                engine = view.getEngine();
                engine.load(currentURL);
            }
        });
    }

    private static String toURL(String str) {
       if(str.indexOf("http://") != 0) {
          if(str.indexOf("https://") != 0) {
             return "http://" + str;
          }
       }
       return str;
    }

    @Override public void start(Stage primaryStage) {
        primaryStage.setTitle("WebBrowser2 " + VERSION);
        this.primaryStage = primaryStage;

        primaryStage.setTitle("Google"); 
        root = new Group();
        view = new WebView();
        scene = new Scene(root, 400, 250, javafx.scene.paint.Color.WHITE);
        Scene scene2 = new Scene(view);

        BorderPane borderPane = new BorderPane();
        Context ctx = new Context();
        ctx.jfxPanel =  new JFXPanel();
        jfxPanel = ctx.jfxPanel;
        contextVec.add(ctx);

        TabPane tabPane = new TabPane();
        Tab tab = new Tab();
        tab.setText("Google");
        HBox hbox = new HBox();
        jfxPanel = new JFXPanel();
        jfxPanel.setScene(scene2);
        hbox.getChildren().add(new javafx.scene.control.Label("HELLO "));
        //hbox.getChildren().add(jfxPanel);
        hbox.setAlignment(Pos.CENTER);
        tab.setContent(hbox);
        tabPane.getTabs().add(tab);
        currentURL = home_page;
        loadURL(currentURL);

        // bind to take available space

        borderPane.prefHeightProperty().bind(scene.heightProperty());
        borderPane.prefWidthProperty().bind(scene.widthProperty());

/*
        borderPane.setCenter(tabPane);
        root.getChildren().add(borderPane);
        primaryStage.setScene(scene);
        primaryStage.show();
*/

        frame = new JFrame("Google");

/*
        frame.setPreferredSize(new Dimension(1024, 600));
        frame.addWindowListener(new java.awt.event.WindowAdapter() {
           public void windowClosing(java.awt.event.WindowEvent windowEvent) {
              winCount--;
              if(winCount <= 0) {
                 System.exit(0);
              }
           }
        });

        initComponents();

        jfxPanel.add(tabPane);
*/

/*
        primaryStage.setScene(scene);
        primaryStage.show();
*/

        frame.getContentPane().setLayout(this);
        frame.add(jfxPanel);
        frame.pack();
        frame.setVisible(true);
        frame.setExtendedState(frame.getExtendedState()|JFrame.MAXIMIZED_BOTH);
    }

    public static void main(String[] args) {
        //SwingUtilities.invokeLater(new WebBrowser2());
       Application.launch(args);
    }
}
